/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTestBase;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.ui.IWorkbenchPart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CriticalPathTest
extends KernelTestBase {
    private static final int TID_NO = 338;
    private static final String TID = String.valueOf(338);
    private static final String PROCESS = "weston";
    private static final @NonNull String CP_ID = "org.eclipse.linuxtools.tmf.analysis.graph.ui.criticalpath.view.criticalpathview";
    private static final String CRIT_PATH_MAIN_ENTRY = "[weston," + TID + "]";
    private static final String CRIT_PATH_OTHER_ENTRY = "[kworker/u16:0,6]";
    private static final String FOLLOW_FORWARD = "Follow critical path forward";
    private static final String FOLLOW_BACKWARD = "Follow critical path backward";
    private static final @NonNull ITmfTimestamp CPU_TIME0 = TmfTimestamp.fromNanos((long)1412670963793647239L);
    private static final @NonNull ITmfTimestamp CPU_TIME1 = TmfTimestamp.fromNanos((long)1412670963793673139L);
    private SWTBotView fViewBotCfv;
    private SWTBotView fViewBotCp;

    @Override
    @Before
    public void before() {
        try {
            String traceName = Paths.get(FileLocator.toFileURL((URL)CtfTestTrace.ARM_64_BIT_HEADER.getTraceURL()).toURI()).toString();
            SWTBotUtils.openTrace((String)"test", (String)traceName, (String)"org.eclipse.linuxtools.lttng2.kernel.tracetype");
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)"bug446190");
        this.fViewBotCfv = fBot.viewById("org.eclipse.tracecompass.analysis.os.linux.views.controlflow");
        SWTBotUtils.openView((String)CP_ID);
        this.fViewBotCp = fBot.viewById(CP_ID);
        this.fViewBotCp.show();
        this.fViewBotCfv.show();
        this.fViewBotCfv.setFocus();
    }

    @Test
    public void testFull() {
        SWTBotTimeGraph timeGraphCfv = new SWTBotTimeGraph(this.fViewBotCfv.bot());
        SWTBotTree treeCp = this.fViewBotCp.bot().tree();
        final SWTBotTimeGraph timeGraphCp = new SWTBotTimeGraph(this.fViewBotCp.bot());
        Assert.assertNotNull((Object)timeGraphCfv.widget);
        Assert.assertNotNull((Object)treeCp.widget);
        SWTBotTreeItem[] allItems = treeCp.getAllItems();
        int i = 0;
        while (i < allItems.length) {
            Assert.assertEquals((long)0L, (long)allItems[i].getNodes().size());
            ++i;
        }
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)trace);
        SWTBotTimeGraphEntry entry = timeGraphCfv.getEntry(new String[]{trace.getName(), "systemd", "we", PROCESS});
        Assert.assertNotNull((Object)entry);
        entry.select();
        SWTBotMenu menu = entry.contextMenu("Follow weston/" + TID);
        Assert.assertEquals((Object)("Follow weston/" + TID), (Object)menu.getText());
        menu.click();
        fBot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                SWTBotTimeGraphEntry[] entries = timeGraphCp.getEntries();
                return CRIT_PATH_MAIN_ENTRY.equals(entries[0].getEntries()[0].getText());
            }

            public String getFailureMessage() {
                return "Could not find " + CRIT_PATH_MAIN_ENTRY + " in Critical Path view";
            }
        });
        IWorkbenchPart part = this.fViewBotCp.getViewReference().getPart(false);
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, CPU_TIME0));
        SWTBotTimeGraphEntry critPathEntry = timeGraphCp.getEntry(new String[]{trace.getHostId(), CRIT_PATH_MAIN_ENTRY});
        critPathEntry.select();
        ICondition timeGraphIsReadyCondition = ConditionHelpers.timeGraphIsReadyCondition((AbstractTimeGraphView)((AbstractTimeGraphView)part), (TmfTimeRange)new TmfTimeRange(CPU_TIME1, CPU_TIME1), (ITmfTimestamp)CPU_TIME1);
        this.fViewBotCp.toolbarButton(FOLLOW_FORWARD).click();
        fBot.waitUntil(timeGraphIsReadyCondition);
        fBot.waitUntil(ConditionHelpers.timeGraphSelectionContains((SWTBotTimeGraph)timeGraphCp, (int)0, (String)CRIT_PATH_MAIN_ENTRY));
        this.fViewBotCp.toolbarButton(FOLLOW_FORWARD).click();
        fBot.waitUntil(timeGraphIsReadyCondition);
        fBot.waitUntil(ConditionHelpers.timeGraphSelectionContains((SWTBotTimeGraph)timeGraphCp, (int)0, (String)CRIT_PATH_OTHER_ENTRY));
        this.fViewBotCp.toolbarButton(FOLLOW_BACKWARD).click();
        fBot.waitUntil(timeGraphIsReadyCondition);
        fBot.waitUntil(ConditionHelpers.timeGraphSelectionContains((SWTBotTimeGraph)timeGraphCp, (int)0, (String)CRIT_PATH_MAIN_ENTRY));
    }
}

