/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.module;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class TmfXmlUtils {
    private TmfXmlUtils() {
    }

    public static List<@NonNull Element> getChildElements(Element parent, String elementTag) {
        NodeList nodes = parent.getElementsByTagName(elementTag);
        ArrayList<@NonNull Element> childElements = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            if (node.getParentNode().equals(parent)) {
                childElements.add(node);
            }
            ++i;
        }
        return childElements;
    }

    public static Element getElementInFile(String filePath, @NonNull String elementType, @NonNull String elementId) {
        if (filePath == null) {
            return null;
        }
        Path path = new Path(filePath);
        File file = path.toFile();
        if (!(file != null && file.exists() && file.isFile() && XmlUtils.xmlValidate(file).isOK())) {
            return null;
        }
        try {
            Document doc = XmlUtils.getDocumentFromFile(file);
            NodeList nodes = doc.getElementsByTagName(elementType);
            Element foundNode = null;
            int i = 0;
            while (i < nodes.getLength()) {
                Element node = (Element)nodes.item(i);
                String id = node.getAttribute("id");
                if (id.equals(elementId)) {
                    foundNode = node;
                }
                ++i;
            }
            return foundNode;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ITmfStateValue.Type getTmfStateValueByName(@NonNull String typeName) {
        ITmfStateValue.Type type;
        switch (typeName) {
            case "string": {
                type = ITmfStateValue.Type.STRING;
                break;
            }
            case "int": {
                type = ITmfStateValue.Type.INTEGER;
                break;
            }
            case "long": {
                type = ITmfStateValue.Type.LONG;
                break;
            }
            case "double": {
                type = ITmfStateValue.Type.DOUBLE;
                break;
            }
            case "custom": {
                type = ITmfStateValue.Type.CUSTOM;
                break;
            }
            case "null": {
                type = ITmfStateValue.Type.NULL;
                break;
            }
            default: {
                throw new IllegalArgumentException("The given type name \"" + typeName + "\" does not correspond to any ITmfStateValue.Type");
            }
        }
        return type;
    }

    public static @NonNull TmfStateValue newTmfStateValueFromObject(@Nullable Object objValue) {
        TmfStateValue value = TmfStateValue.nullValue();
        if (objValue instanceof String) {
            value = TmfStateValue.newValueString((String)((String)objValue));
        } else if (objValue instanceof Long) {
            value = TmfStateValue.newValueLong((long)((Long)objValue));
        } else if (objValue instanceof Integer) {
            value = TmfStateValue.newValueInt((int)((Integer)objValue));
        } else if (objValue instanceof Double) {
            value = TmfStateValue.newValueDouble((double)((Double)objValue));
        }
        return value;
    }

    public static @NonNull TmfStateValue newTmfStateValueFromObjectWithForcedType(@Nullable Object objValue, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ITmfStateValue.Type forcedType) {
        if (objValue == null) {
            return TmfStateValue.nullValue();
        }
        TmfStateValue value = TmfStateValue.nullValue();
        if (objValue instanceof String) {
            String fieldString = (String)objValue;
            switch (forcedType) {
                case INTEGER: {
                    value = TmfStateValue.newValueInt((int)Integer.parseInt(fieldString));
                    break;
                }
                case LONG: {
                    value = TmfStateValue.newValueLong((long)Long.parseLong(fieldString));
                    break;
                }
                case DOUBLE: {
                    value = TmfStateValue.newValueDouble((double)Double.parseDouble(fieldString));
                    break;
                }
                case CUSTOM: {
                    throw new IllegalStateException("Custom type cannot be forced");
                }
                default: {
                    value = TmfStateValue.newValueString((String)fieldString);
                    break;
                }
            }
        } else if (objValue instanceof Long) {
            Long fieldLong = (Long)objValue;
            switch (forcedType) {
                case INTEGER: {
                    value = TmfStateValue.newValueInt((int)fieldLong.intValue());
                    break;
                }
                case STRING: {
                    value = TmfStateValue.newValueString((String)fieldLong.toString());
                    break;
                }
                case DOUBLE: {
                    value = TmfStateValue.newValueDouble((double)fieldLong.doubleValue());
                    break;
                }
                case CUSTOM: {
                    throw new IllegalStateException("Custom type cannot be forced");
                }
                default: {
                    value = TmfStateValue.newValueLong((long)fieldLong);
                    break;
                }
            }
        } else if (objValue instanceof Integer) {
            Integer fieldInteger = (Integer)objValue;
            switch (forcedType) {
                case LONG: {
                    value = TmfStateValue.newValueLong((long)fieldInteger.longValue());
                    break;
                }
                case STRING: {
                    value = TmfStateValue.newValueString((String)fieldInteger.toString());
                    break;
                }
                case DOUBLE: {
                    value = TmfStateValue.newValueDouble((double)fieldInteger.doubleValue());
                    break;
                }
                case CUSTOM: {
                    throw new IllegalStateException("Custom type cannot be forced");
                }
                default: {
                    value = TmfStateValue.newValueInt((int)fieldInteger);
                    break;
                }
            }
        } else if (objValue instanceof Double) {
            Double fieldDouble = (Double)objValue;
            switch (forcedType) {
                case LONG: {
                    value = TmfStateValue.newValueLong((long)fieldDouble.longValue());
                    break;
                }
                case STRING: {
                    value = TmfStateValue.newValueString((String)fieldDouble.toString());
                    break;
                }
                case INTEGER: {
                    value = TmfStateValue.newValueInt((int)fieldDouble.intValue());
                    break;
                }
                case CUSTOM: {
                    throw new IllegalStateException("Custom type cannot be forced");
                }
                default: {
                    value = TmfStateValue.newValueDouble((double)fieldDouble);
                }
            }
        }
        return value;
    }

    public static @NonNull Set<@NonNull String> getViewAnalysisIds(Element viewElement) {
        List<Element> heads = TmfXmlUtils.getChildElements(viewElement, "head");
        HashSet<@NonNull String> analysisIds = new HashSet<String>();
        if (!heads.isEmpty()) {
            Element head = heads.get(0);
            List<Element> applicableAnalysis = TmfXmlUtils.getChildElements(head, "analysis");
            for (Element oneAnalysis : applicableAnalysis) {
                analysisIds.add(oneAnalysis.getAttribute("id"));
            }
        }
        return analysisIds;
    }
}

