/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.timegraph;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class XmlTimegraphViewTest {
    private static final String PROJECT_NAME = "test";
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.tmf.core.tests.xmlstub";
    private static final String TRACE_NAME = "testTrace2.xml";
    private static final String ANALYSIS_NAME = "test.xml.conditions";
    private static final String VIEW_NAME = "Xml Timegraph View Test";
    private static SWTWorkbenchBot fBot;

    @Before
    public void before() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 10000L;
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)bot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
        fBot = new SWTWorkbenchBot();
        XmlTimegraphViewTest.loadXmlFile();
        XmlTimegraphViewTest.openTrace();
        XmlTimegraphViewTest.openView(VIEW_NAME);
    }

    private static void loadXmlFile() {
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.CONDITION_FILE.getFile());
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.VALID_TIMEGRAPH_VIEW_ELEMENT_FILE.getFile());
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    private static void openTrace() {
        SWTBotUtils.createProject((String)PROJECT_NAME);
        SWTBotUtils.openTrace((String)PROJECT_NAME, (String)Activator.getAbsolutePath((Path)new Path("test_traces/testTrace2.xml")).toString(), (String)TRACE_TYPE);
        WaitUtils.waitForJobs();
    }

    private static void openView(String viewTitle) {
        SWTBotTreeItem treeItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)PROJECT_NAME);
        treeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTreeItem)treeItem, (String[])new String[]{TRACE_NAME, "Views", ANALYSIS_NAME, viewTitle});
        treeItem.doubleClick();
        WaitUtils.waitForJobs();
    }

    @Test
    public void testData() {
        SWTBotTimeGraph timegraph = XmlTimegraphViewTest.getTimegraph();
        TimeGraphControl widget = (TimeGraphControl)timegraph.widget;
        Assert.assertNotNull((Object)widget);
        Assert.assertEquals((String)"window start time", (long)1L, (long)widget.getTimeDataProvider().getTime0());
        Assert.assertEquals((String)"window end time", (long)7L, (long)widget.getTimeDataProvider().getTime1());
        SWTBotTimeGraphEntry[] entries = timegraph.getEntries();
        Assert.assertEquals((String)"number of entries", (long)1L, (long)entries.length);
        entries = entries[0].getEntries();
        Assert.assertEquals((String)"number of entries", (long)1L, (long)entries.length);
        SWTBotTimeGraphEntry entry = entries[0];
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((String)"name of entries[0]", (Object)"checkpoint", (Object)entry.getText());
    }

    private static SWTBotTimeGraph getTimegraph() {
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph");
        SWTBotTimeGraph timegraph = new SWTBotTimeGraph(viewBot.bot());
        Assert.assertTrue((String)"timegraph visible", (boolean)timegraph.isVisible());
        timegraph.setFocus();
        return timegraph;
    }

    @After
    public void tearDown() {
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }
}

