/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;

public final class ImageHelper {
    private final int[] fPixels;
    private final org.eclipse.swt.graphics.Rectangle fBounds;

    private ImageHelper(int[] pixels, org.eclipse.swt.graphics.Rectangle bounds) {
        if (pixels.length != bounds.height * bounds.width) {
            throw new IllegalArgumentException("Incoherent image");
        }
        this.fPixels = Arrays.copyOf(pixels, pixels.length);
        this.fBounds = bounds;
    }

    public static ImageHelper grabImage(final org.eclipse.swt.graphics.Rectangle rect) {
        return (ImageHelper)UIThreadRunnable.syncExec((Result)new Result<ImageHelper>(){

            public ImageHelper run() {
                try {
                    Robot rb = new Robot();
                    BufferedImage bi = rb.createScreenCapture(new Rectangle(rect.x, rect.y, rect.width, rect.height));
                    return new ImageHelper(bi.getRGB(0, 0, rect.width, rect.height, null, 0, rect.width), rect, null);
                }
                catch (AWTException aWTException) {
                    return new ImageHelper(new int[0], new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0), null);
                }
            }
        });
    }

    public static ImageHelper waitForNewImage(final org.eclipse.swt.graphics.Rectangle bounds, final ImageHelper currentImage) {
        SWTBot bot = new SWTBot();
        final ImageHelper[] newImage = new ImageHelper[1];
        bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return (Boolean)UIThreadRunnable.syncExec((Result)new Result<Boolean>(){

                    public Boolean run() {
                        newImage[0] = ImageHelper.grabImage(bounds);
                        return !newImage[0].equals(currentImage);
                    }
                });
            }

            public String getFailureMessage() {
                return "Image at bounds " + bounds + " did not change";
            }
        });
        bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return (Boolean)UIThreadRunnable.syncExec((Result)new Result<Boolean>(){

                    public Boolean run() {
                        ImageHelper image = ImageHelper.grabImage(bounds);
                        boolean sameImage = image.equals(newImage[0]);
                        newImage[0] = image;
                        return sameImage;
                    }
                });
            }

            public String getFailureMessage() {
                return "Image at bounds " + bounds + " is not stable";
            }
        });
        return newImage[0];
    }

    public org.eclipse.swt.graphics.Rectangle getBounds() {
        return this.fBounds;
    }

    public RGB getPixel(int x, int y) {
        return ImageHelper.getRgbFromRGBPixel(this.fPixels[x + y * this.fBounds.width]);
    }

    public List<RGB> sample(List<Point> samplePoints) {
        for (Point p : samplePoints) {
            if (this.getBounds().contains(p)) continue;
            throw new IllegalArgumentException("Point outside of the image");
        }
        ArrayList<RGB> retVal = new ArrayList<RGB>(samplePoints.size());
        for (Point p : samplePoints) {
            retVal.add(this.getPixel(p.x, p.y));
        }
        return retVal;
    }

    public Multiset<RGB> getHistogram() {
        HashMultiset colors = HashMultiset.create();
        int[] nArray = this.fPixels;
        int n = this.fPixels.length;
        int n2 = 0;
        while (n2 < n) {
            int pixel = nArray[n2];
            RGB pixelColor = ImageHelper.getRgbFromRGBPixel(pixel);
            colors.add((Object)pixelColor);
            ++n2;
        }
        return colors;
    }

    public List<RGB> getPixelRow(int row) {
        ArrayList<RGB> retVal = new ArrayList<RGB>();
        int x = 0;
        while (x < this.getBounds().width) {
            retVal.add(this.getPixel(x, row));
            ++x;
        }
        return retVal;
    }

    public List<RGB> getPixelColumn(int col) {
        ArrayList<RGB> retVal = new ArrayList<RGB>();
        int y = 0;
        while (y < this.getBounds().height) {
            retVal.add(this.getPixel(col, y));
            ++y;
        }
        return retVal;
    }

    public ImageHelper diff(ImageHelper other) {
        if (other.getBounds().width != this.fBounds.width && other.getBounds().height != this.fBounds.height) {
            throw new IllegalArgumentException("Different sized images");
        }
        int[] fBuffer = new int[this.fPixels.length];
        int i = 0;
        while (i < this.fPixels.length) {
            RGB local = ImageHelper.getRgbFromRGBPixel(this.fPixels[i]);
            RGB otherPixel = ImageHelper.getRgbFromRGBPixel(other.fPixels[i]);
            byte r = (byte)(local.red - otherPixel.red);
            byte g = (byte)(local.green - otherPixel.green);
            byte b = (byte)(local.blue - otherPixel.blue);
            fBuffer[i] = r << 16 + g << 8 + b;
            ++i;
        }
        return new ImageHelper(fBuffer, this.getBounds());
    }

    public void writePng(File outputFile) throws IOException {
        BufferedImage image = new BufferedImage(this.fBounds.width, this.fBounds.height, 1);
        image.setRGB(0, 0, this.fBounds.width, this.fBounds.height, this.fPixels, 0, this.fBounds.width);
        ImageIO.write((RenderedImage)image, "png", outputFile);
    }

    private static RGB getRgbFromRGBPixel(int pixel) {
        return new RGB(pixel >> 16 & 0xFF, pixel >> 8 & 0xFF, pixel & 0xFF);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fBounds == null ? 0 : this.fBounds.hashCode());
        result = 31 * result + Arrays.hashCode(this.fPixels);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageHelper other = (ImageHelper)obj;
        if (this.fBounds == null ? other.fBounds != null : !this.fBounds.equals((Object)other.fBounds)) {
            return false;
        }
        return Arrays.equals(this.fPixels, other.fPixels);
    }

    public static RGB adjustExpectedColor(final RGB original) {
        if (!SWTUtils.isMac()) {
            return original;
        }
        final boolean[] painted = new boolean[1];
        final Shell shell = (Shell)UIThreadRunnable.syncExec((Result)new Result<Shell>(){

            public Shell run() {
                Shell s = new Shell(Display.getDefault());
                s.setSize(100, 100);
                Color color = new Color((Device)Display.getDefault(), original);
                s.setBackground(color);
                s.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        painted[0] = true;
                    }
                });
                s.open();
                return s;
            }
        });
        new SWTBot().waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return painted[0];
            }

            public String getFailureMessage() {
                return "Shell was not painted";
            }
        });
        return (RGB)UIThreadRunnable.syncExec((Result)new Result<RGB>(){

            public RGB run() {
                shell.update();
                RGB rgb = ImageHelper.grabImage(shell.getBounds()).getPixel(50, 50);
                shell.close();
                return rgb;
            }
        });
    }

    /* synthetic */ ImageHelper(int[] nArray, org.eclipse.swt.graphics.Rectangle rectangle, ImageHelper imageHelper) {
        this(nArray, rectangle);
    }
}

