/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.keyboard.Keyboard;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.MessageFormat;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.NewExperimentOperation;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.handlers.IHandlerService;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.junit.Assert;

public final class SWTBotUtils {
    private static final String WINDOW_MENU = "Window";
    private static final String PREFERENCES_MENU_ITEM = "Preferences";
    private static boolean fPrintedEnvironment = false;
    private static Logger log = Logger.getLogger(SWTBotUtils.class);
    private static final String TRACING_PERSPECTIVE_ID = "org.eclipse.linuxtools.tmf.ui.perspective";

    private SWTBotUtils() {
    }

    public static void delay(long waitTimeMillis) {
        try {
            Thread.sleep(waitTimeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void createProject(final String projectName) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IProject project = TmfProjectRegistry.createProject((String)projectName, null, (IProgressMonitor)new NullProgressMonitor());
                Assert.assertNotNull((Object)project);
            }
        });
        WaitUtils.waitForJobs();
    }

    public static void deleteProject(String projectName, boolean deleteResources, SWTWorkbenchBot bot) {
        WaitUtils.waitForJobs();
        try {
            ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        WaitUtils.waitForJobs();
        SWTBotUtils.closeSecondaryShells(bot);
        WaitUtils.waitForJobs();
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
            return;
        }
        SWTBotView projectViewBot = bot.viewById("org.eclipse.ui.navigator.ProjectExplorer");
        projectViewBot.setFocus();
        SWTBotTree treeBot = projectViewBot.bot().tree();
        SWTBotTreeItem treeItem = treeBot.getTreeItem(projectName);
        SWTBotMenu contextMenu = treeItem.contextMenu("Delete");
        contextMenu.click();
        if (deleteResources) {
            bot.shell("Delete Resources").setFocus();
            SWTBotCheckBox checkBox = bot.checkBox();
            bot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)checkBox));
            checkBox.click();
        }
        SWTBotButton okButton = bot.button("OK");
        bot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)okButton));
        okButton.click();
        WaitUtils.waitForJobs();
    }

    public static void deleteProject(String projectName, SWTWorkbenchBot bot) {
        SWTBotUtils.deleteProject(projectName, true, bot);
    }

    public static void createExperiment(SWTWorkbenchBot bot, String projectName, final @NonNull String expName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        final TmfExperimentFolder expFolder = tmfProject.getExperimentsFolder();
        Assert.assertNotNull((Object)expFolder);
        NewExperimentOperation operation = new NewExperimentOperation(expFolder, expName);
        operation.run((IProgressMonitor)new NullProgressMonitor());
        bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                TmfExperimentElement experiment = expFolder.getExperiment(expName);
                return experiment != null;
            }

            public String getFailureMessage() {
                return "Experiment (" + expName + ") couldn't be created";
            }
        });
    }

    public static void focusMainWindow(SWTBotShell[] shellBots) {
        SWTBotShell mainShell = SWTBotUtils.getMainShell(shellBots);
        if (mainShell != null) {
            mainShell.activate();
        }
    }

    private static SWTBotShell getMainShell(SWTBotShell[] shellBots) {
        SWTBotShell mainShell = null;
        SWTBotShell[] sWTBotShellArray = shellBots;
        int n = shellBots.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotShell shellBot = sWTBotShellArray[n2];
            if (shellBot.getText().toLowerCase().contains("eclipse")) {
                mainShell = shellBot;
            }
            ++n2;
        }
        return mainShell;
    }

    public static void closeSecondaryShells(SWTWorkbenchBot bot) {
        SWTBotShell[] shells = bot.shells();
        SWTBotShell mainShell = SWTBotUtils.getMainShell(shells);
        if (mainShell == null) {
            return;
        }
        Arrays.stream(shells).filter(shell -> shell != mainShell).filter(s -> !((Shell)s.widget).isDisposed()).filter(AbstractSWTBot::isVisible).peek(shell -> log.debug((Object)MessageFormat.format((String)"Closing lingering shell with title {0}", (Object[])new Object[]{shell.getText()}))).forEach(SWTBotShell::close);
    }

    public static void closeView(String title, SWTWorkbenchBot bot) {
        List openViews = bot.views();
        for (SWTBotView view : openViews) {
            if (!view.getTitle().equalsIgnoreCase(title)) continue;
            view.close();
            bot.waitUntil(ConditionHelpers.ViewIsClosed(view));
        }
    }

    public static void closeViewById(String viewId, SWTWorkbenchBot bot) {
        SWTBotView view = bot.viewById(viewId);
        view.close();
        bot.waitUntil(ConditionHelpers.ViewIsClosed(view));
    }

    public static void switchToTracingPerspective() {
        SWTBotUtils.switchToPerspective(TRACING_PERSPECTIVE_ID);
    }

    public static void switchToPerspective(final String id) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                try {
                    PlatformUI.getWorkbench().showPerspective(id, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (WorkbenchException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        });
    }

    public static void initialize() {
        SWTBotUtils.failIfUIThread();
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        UIThreadRunnable.syncExec(() -> {
            SWTBotUtils.printEnvironment();
            SWTBotUtils.focusMainWindow(bot.shells());
            Shell shell = (Shell)sWTWorkbenchBot.activeShell().widget;
            if (shell.getParent() == null) {
                SWTBotUtils.makeShellFullyVisible(shell);
            }
        });
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue("SWITCH_TO_PERSPECTIVE", "never");
    }

    private static void printEnvironment() {
        String gtkVersion;
        if (fPrintedEnvironment) {
            return;
        }
        Rectangle bounds = Display.getDefault().getBounds();
        System.out.println("Display size: " + bounds.width + "x" + bounds.height);
        String osVersion = System.getProperty("os.version");
        if (osVersion != null) {
            System.out.println("OS version=" + osVersion);
        }
        if ((gtkVersion = System.getProperty("org.eclipse.swt.internal.gtk.version")) != null) {
            String ubuntuMenuProxy;
            System.out.println("GTK version=" + gtkVersion);
            String gtkTheme = System.getProperty("org.eclipse.swt.internal.gtk.theme");
            System.out.println("GTK theme=" + (gtkTheme == null ? "unknown" : gtkTheme));
            String overlayScrollbar = System.getenv("LIBOVERLAY_SCROLLBAR");
            if (overlayScrollbar != null) {
                System.out.println("LIBOVERLAY_SCROLLBAR=" + overlayScrollbar);
            }
            if ((ubuntuMenuProxy = System.getenv("UBUNTU_MENUPROXY")) != null) {
                System.out.println("UBUNTU_MENUPROXY=" + ubuntuMenuProxy);
            }
        }
        System.out.println("Time zone: " + TimeZone.getDefault().getDisplayName());
        fPrintedEnvironment = true;
    }

    private static void failIfUIThread() {
        if (Display.getCurrent() != null && Display.getCurrent().getThread() == Thread.currentThread()) {
            Assert.fail((String)"SWTBot test needs to run in a non-UI thread. Make sure that \"Run in UI thread\" is unchecked in your launch configuration or that useUIThread is set to false in the pom.xml");
        }
    }

    private static void makeShellFullyVisible(Shell shell) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Point absCoord = shell.toDisplay(0, 0);
        Point shellSize = shell.getSize();
        Point newLocation = new Point(absCoord.x, absCoord.y);
        newLocation.x = Math.max(0, Math.min(absCoord.x, displayBounds.width - shellSize.x));
        newLocation.y = Math.max(0, Math.min(absCoord.y, displayBounds.height - shellSize.y));
        if (!newLocation.equals((Object)absCoord)) {
            shell.setLocation(newLocation);
        }
    }

    public static void openTrace(String projectName, String tracePath, String traceType) {
        SWTBotUtils.openTrace(projectName, tracePath, traceType, true);
    }

    public static void openTrace(final String projectName, final String tracePath, final String traceType, boolean delay) {
        IStatus status = (IStatus)UIThreadRunnable.syncExec((Result)new Result<IStatus>(){

            public IStatus run() {
                try {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    TmfTraceFolder destinationFolder = TmfProjectRegistry.getProject((IProject)project, (boolean)true).getTracesFolder();
                    return TmfOpenTraceHelper.openTraceFromPath((TmfTraceFolder)destinationFolder, (String)tracePath, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)traceType);
                }
                catch (CoreException e) {
                    return new Status(4, "", e.getMessage(), (Throwable)e);
                }
            }
        });
        if (!status.isOK()) {
            Assert.fail((String)status.getMessage());
        }
        if (delay) {
            SWTBotUtils.delay(1000L);
            WaitUtils.waitForJobs();
        }
    }

    public static SWTBotEditor activateEditor(SWTWorkbenchBot bot, String editorName) {
        Matcher matcher = WidgetMatcherFactory.withPartName((String)editorName);
        SWTBotEditor editorBot = bot.editor(matcher);
        IEditorPart iep = ((IEditorReference)editorBot.getReference()).getEditor(true);
        final TmfEventsEditor tmfEd = (TmfEventsEditor)iep;
        editorBot.show();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                tmfEd.setFocus();
            }
        });
        WaitUtils.waitForJobs();
        SWTBotUtils.activeEventsEditor(bot);
        Assert.assertNotNull((Object)tmfEd);
        return editorBot;
    }

    public static TmfEventsEditor openEditor(SWTWorkbenchBot bot, String projectName, IPath elementPath) {
        SWTBotView projectExplorerView = bot.viewById("org.eclipse.ui.navigator.ProjectExplorer");
        projectExplorerView.setFocus();
        SWTBot projectExplorerBot = projectExplorerView.bot();
        SWTBotTree tree = projectExplorerBot.tree();
        projectExplorerBot.waitUntil(ConditionHelpers.IsTreeNodeAvailable(projectName, tree));
        SWTBotTreeItem treeItem = tree.getTreeItem(projectName);
        treeItem.expand();
        SWTBotTreeItem tracesNode = SWTBotUtils.getTraceProjectItem(projectExplorerBot, treeItem, "Traces");
        tracesNode.expand();
        SWTBotTreeItem currentItem = tracesNode;
        String[] stringArray = elementPath.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            currentItem = SWTBotUtils.getTraceProjectItem(projectExplorerBot, currentItem, segment);
            currentItem.doubleClick();
            ++n2;
        }
        SWTBotEditor editor = bot.editorByTitle(elementPath.toString());
        IEditorPart editorPart = ((IEditorReference)editor.getReference()).getEditor(false);
        Assert.assertTrue((boolean)(editorPart instanceof TmfEventsEditor));
        return (TmfEventsEditor)editorPart;
    }

    public static SWTBotTreeItem getTraceProjectItem(SWTBot bot, SWTBotTreeItem parentItem, String ... path) {
        SWTBotTreeItem item = parentItem;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            item = SWTBotUtils.getTraceProjectItem(bot, item, name);
            ++n2;
        }
        return item;
    }

    public static SWTBotTreeItem getTraceProjectItem(SWTBot bot, SWTBotTreeItem parentItem, String name) {
        ConditionHelpers.ProjectElementHasChild condition = new ConditionHelpers.ProjectElementHasChild(parentItem, name);
        bot.waitUntil((ICondition)condition);
        return condition.getItem();
    }

    public static SWTBotTreeItem selectTracesFolder(SWTWorkbenchBot bot, String projectName) {
        SWTBotTreeItem projectTreeItem = SWTBotUtils.selectProject(bot, projectName);
        projectTreeItem.select();
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.getTraceProjectItem((SWTBot)bot, projectTreeItem, "Traces");
        tracesFolderItem.select();
        return tracesFolderItem;
    }

    public static void clearTracesFolder(SWTWorkbenchBot bot, String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject((IProject)project, (boolean)false);
        final TmfTraceFolder tracesFolder = tmfProject.getTracesFolder();
        if (tracesFolder == null) {
            return;
        }
        try {
            for (TmfTraceElement traceElement : tracesFolder.getTraces()) {
                traceElement.delete(null);
            }
            final IFolder resource = tracesFolder.getResource();
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource visitedResource) throws CoreException {
                    if (visitedResource != resource) {
                        visitedResource.delete(true, null);
                    }
                    return true;
                }
            }, 1, 0);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        bot.waitUntil((ICondition)new DefaultCondition(){
            private int fTraceNb = 0;

            public boolean test() throws Exception {
                List traces = tracesFolder.getTraces();
                this.fTraceNb = traces.size();
                return this.fTraceNb == 0;
            }

            public String getFailureMessage() {
                return "Traces Folder not empty (" + this.fTraceNb + ")";
            }
        });
    }

    public static void clearTracesFolderUI(SWTWorkbenchBot bot, String projectName) {
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder(bot, projectName);
        tracesFolder.contextMenu().menu(new String[]{"Clear"}).click();
        String CONFIRM_CLEAR_DIALOG_TITLE = "Confirm Clear";
        bot.waitUntil(Conditions.shellIsActive((String)CONFIRM_CLEAR_DIALOG_TITLE));
        SWTBotShell shell = bot.shell(CONFIRM_CLEAR_DIALOG_TITLE);
        shell.bot().button("Yes").click();
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        bot.waitWhile(ConditionHelpers.treeItemHasChildren(tracesFolder));
    }

    public static void clearExperimentFolder(SWTWorkbenchBot bot, String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject((IProject)project, (boolean)false);
        final TmfExperimentFolder expFolder = tmfProject.getExperimentsFolder();
        if (expFolder == null) {
            return;
        }
        expFolder.getExperiments().forEach(experiment -> {
            IFolder resource = experiment.getResource();
            try {
                experiment.closeEditors();
                IPath path = resource.getLocation();
                if (path != null) {
                    experiment.deleteSupplementaryFolder();
                }
                resource.delete(true, null);
            }
            catch (CoreException e) {
                Assert.fail((String)e.getMessage());
            }
        });
        bot.waitUntil((ICondition)new DefaultCondition(){
            private int fExperimentNb = 0;

            public boolean test() throws Exception {
                List experiments = expFolder.getExperiments();
                this.fExperimentNb = experiments.size();
                return this.fExperimentNb == 0;
            }

            public String getFailureMessage() {
                return "Experiment Folder not empty (" + this.fExperimentNb + ")";
            }
        });
    }

    public static SWTBotTreeItem selectProject(SWTWorkbenchBot bot, String projectName) {
        SWTBotView projectExplorerBot = bot.viewByTitle("Project Explorer");
        projectExplorerBot.show();
        projectExplorerBot.bot().waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)projectExplorerBot.bot().tree()));
        SWTBotTreeItem treeItem = projectExplorerBot.bot().tree().getTreeItem(projectName);
        treeItem.select();
        return treeItem;
    }

    public static void openView(String id) {
        SWTBotUtils.openView(id, null);
    }

    public static void openView(final String id, final @Nullable String secondaryId) {
        final PartInitException[] res = new PartInitException[1];
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                try {
                    if (secondaryId == null) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(id);
                    } else {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(id, secondaryId, 1);
                    }
                }
                catch (PartInitException e) {
                    res[0] = e;
                }
            }
        });
        if (res[0] != null) {
            Assert.fail((String)res[0].getMessage());
        }
        WaitUtils.waitForJobs();
    }

    public static void maximizeTable(final SWTBotTable tableBot) {
        final AtomicBoolean controlResized = new AtomicBoolean();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ((Table)tableBot.widget).addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        ((Table)tableBot.widget).removeControlListener((ControlListener)this);
                        controlResized.set(true);
                    }
                });
            }
        });
        try {
            tableBot.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((String)"CTRL+"), KeyStroke.getInstance((String)"M")});
        }
        catch (ParseException e) {
            Assert.fail();
        }
        new SWTBot().waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return controlResized.get();
            }

            public String getFailureMessage() {
                return "Control was not resized";
            }
        });
    }

    public static Rectangle getBoundsToDisplay(AbstractSWTBot<?> bot) {
        if (bot.widget instanceof Control) {
            final Control control = (Control)NonNullUtils.checkNotNull((Object)((Control)bot.widget));
            return (Rectangle)UIThreadRunnable.syncExec((Result)new Result<Rectangle>(){

                public Rectangle run() {
                    Point location = control.toDisplay(0, 0);
                    Point size = control.getSize();
                    return new Rectangle(location.x, location.y, size.x, size.y);
                }
            });
        }
        throw new IllegalArgumentException(bot + " is not a Control widget");
    }

    public static Rectangle getCellBounds(final Table table, final int row, final int col) {
        return (Rectangle)UIThreadRunnable.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                TableItem item = table.getItem(row);
                Rectangle bounds = item.getBounds(col);
                Point p = table.toDisplay(bounds.x, bounds.y);
                Rectangle rect = new Rectangle(p.x, p.y, bounds.width, bounds.height);
                return rect;
            }
        });
    }

    public static SWTBotTreeItem getTreeItem(SWTBot bot, SWTBotTree tree, String ... nodeNames) {
        if (nodeNames.length == 0) {
            return null;
        }
        bot.waitUntil(ConditionHelpers.IsTreeNodeAvailable(nodeNames[0], tree));
        SWTBotTreeItem currentNode = tree.getTreeItem(nodeNames[0]);
        return SWTBotUtils.getTreeItem(bot, currentNode, Arrays.copyOfRange(nodeNames, 1, nodeNames.length));
    }

    public static SWTBotTreeItem getTreeItem(SWTBot bot, SWTBotTreeItem treeItem, String ... nodeNames) {
        if (nodeNames.length == 0) {
            return treeItem;
        }
        SWTBotTreeItem currentNode = treeItem;
        int i = 0;
        while (i < nodeNames.length) {
            SWTBotTreeItem newNode;
            bot.waitUntil(ConditionHelpers.treeItemHasChildren(treeItem));
            currentNode.expand();
            String nodeName = nodeNames[i];
            try {
                bot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable(nodeName, currentNode));
            }
            catch (TimeoutException e) {
                currentNode.collapse();
                currentNode.expand();
                bot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable(nodeName, currentNode));
            }
            currentNode = newNode = currentNode.getNode(nodeName);
            ++i;
        }
        return currentNode;
    }

    public static void pressShortcut(Keyboard keyboard, KeyStroke ... keys) {
        Control focusControl = (Control)UIThreadRunnable.syncExec((Result)new Result<Control>(){

            public Control run() {
                return Display.getCurrent().getFocusControl();
            }
        });
        SWTBotUtils.pressShortcut(focusControl, () -> keyboard.pressShortcut(keys), keys);
    }

    public static void pressShortcut(AbstractSWTBotControl<?> bot, KeyStroke ... keys) {
        SWTBotUtils.pressShortcut((Control)bot.widget, () -> {
            AbstractSWTBot abstractSWTBot = bot.pressShortcut(keys);
        }, keys);
    }

    private static void pressShortcut(Control control, Runnable pressShortcut, final KeyStroke ... keys) {
        final AtomicInteger keysPressed = new AtomicInteger();
        final AtomicInteger keysReleased = new AtomicInteger();
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                keysPressed.incrementAndGet();
            }

            public void keyReleased(KeyEvent e) {
                keysReleased.incrementAndGet();
            }
        };
        UIThreadRunnable.syncExec(() -> control.addKeyListener(keyListener));
        pressShortcut.run();
        new SWTBot().waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return keysPressed.get() > 0 && keysPressed.get() == keysReleased.get();
            }

            public String getFailureMessage() {
                return "key press " + Arrays.toString(keys) + " not detected";
            }
        });
        UIThreadRunnable.syncExec(() -> control.removeKeyListener(keyListener));
    }

    public static void pressShortcutGoToTreeTop(Keyboard keyboard) {
        if (SWTUtils.isMac()) {
            SWTBotUtils.pressShortcut(keyboard, Keystrokes.ALT, Keystrokes.UP);
        } else {
            SWTBotUtils.pressShortcut(keyboard, Keystrokes.HOME);
        }
    }

    public static SWTBotEditor activeEventsEditor(SWTWorkbenchBot workbenchBot) {
        ConditionHelpers.ActiveEventsEditor condition = new ConditionHelpers.ActiveEventsEditor(workbenchBot, null);
        workbenchBot.waitUntil((ICondition)condition);
        return condition.getActiveEditor();
    }

    public static SWTBotEditor activeEventsEditor(SWTWorkbenchBot workbenchBot, String editorTitle) {
        ConditionHelpers.ActiveEventsEditor condition = new ConditionHelpers.ActiveEventsEditor(workbenchBot, editorTitle);
        workbenchBot.waitUntil((ICondition)condition);
        return condition.getActiveEditor();
    }

    public static SWTBotShell openPreferences(SWTBot bot) {
        if (SWTUtils.isMac()) {
            try {
                bot.activeShell().pressShortcut(new KeyStroke[]{KeyStroke.getInstance((String)"COMMAND+"), KeyStroke.getInstance((String)",")});
            }
            catch (ParseException e) {
                Assert.fail();
            }
        } else {
            bot.menu(WINDOW_MENU).menu(PREFERENCES_MENU_ITEM).click();
        }
        bot.waitUntil(Conditions.shellIsActive((String)PREFERENCES_MENU_ITEM));
        return bot.activeShell();
    }

    public static void pressOKishButtonInPreferences(SWTBot bot) {
        SWTBotUtils.anyButtonOf(bot, "Apply and Close", "OK").click();
    }

    public static SWTBotButton anyButtonOf(SWTBot bot, String ... texts) {
        Matcher anyOf = org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory.anyOf((Iterable)Lists.transform(Arrays.asList(texts), text -> org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory.withMnemonic((String)text)));
        List<Matcher> matchers = Arrays.asList(org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory.widgetOfType(Button.class), anyOf, org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory.withStyle((int)8, (String)"SWT.PUSH"));
        return new SWTBotButton((Button)bot.widget(org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory.allOf(matchers), 0), (SelfDescribing)org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory.allOf(matchers));
    }

    public static void maximize(@NonNull IViewPart view) {
        Assert.assertNotNull((Object)view);
        IWorkbenchPartSite site = view.getSite();
        Assert.assertNotNull((Object)site);
        @Nullable Object handlerServiceObject = site.getService(IHandlerService.class);
        Assert.assertTrue((boolean)(handlerServiceObject instanceof IHandlerService));
        IHandlerService handlerService = (IHandlerService)handlerServiceObject;
        try {
            handlerService.executeCommand("org.eclipse.ui.window.maximizePart", null);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static int getTreeCheckedItemCount(final SWTBotTree tree) {
        return (Integer)UIThreadRunnable.syncExec((Result)new IntResult(){

            public Integer run() {
                int checked = 0;
                TreeItem[] treeItemArray = ((Tree)tree.widget).getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    checked += this.getChecked(item);
                    ++n2;
                }
                return checked;
            }

            private int getChecked(TreeItem item) {
                int total = 0;
                if (item.getChecked()) {
                    ++total;
                }
                TreeItem[] treeItemArray = item.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem child = treeItemArray[n2];
                    total += this.getChecked(child);
                    ++n2;
                }
                return total;
            }
        });
    }

    public static void applyTimeGraphFilter(SWTBotView viewBot, List<String[]> filterItems, boolean checkSubTree) {
        String FILTER_ACTION = "Show View Filters";
        String FILTER_DIALOG_TITLE = "Filter";
        String UNCHECK_ALL = "Uncheck all";
        String CHECK_SUBTREE = "Check subtree";
        String OK_BUTTON = "OK";
        SWTBotToolbarButton filterButton = viewBot.toolbarButton("Show View Filters");
        filterButton.click();
        SWTBotShell shell = viewBot.bot().shell("Filter").activate();
        SWTBot bot = shell.bot();
        SWTBotTree treeBot = bot.tree();
        bot.button("Uncheck all").click();
        for (String[] filterItem : filterItems) {
            SWTBotTreeItem item = SWTBotUtils.getTreeItem(bot, treeBot, filterItem);
            if (checkSubTree) {
                item.select();
                bot.button("Check subtree").click();
                continue;
            }
            item.check();
        }
        bot.button("OK").click();
    }

    public static <E> void waitUntil(Predicate<E> predicate, E argument, String failureMessage) {
        WaitUtils.waitUntil(predicate, argument, (String)failureMessage, (long)SWTBotPreferences.TIMEOUT);
    }
}

