/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.widgets.timegraph.widgets;

import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.junit.Assert;
import org.junit.Test;

public class FormatTimeUtilsTest {
    @Test
    public void testFormatTimeCalendar() {
        String calendarTime = Utils.formatTime((long)37935447675L, (Utils.TimeFormat)Utils.TimeFormat.CALENDAR, (Utils.Resolution)Utils.Resolution.NANOSEC);
        Assert.assertTrue((boolean)calendarTime.endsWith("37.935447675"));
    }

    @Test
    public void testFormatTimeRelative() {
        String relativeNs = Utils.formatTime((long)5L, (Utils.TimeFormat)Utils.TimeFormat.RELATIVE, (Utils.Resolution)Utils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"0.000000005s (5 ns)", (Object)relativeNs);
        String relativeUs = Utils.formatTime((long)15000L, (Utils.TimeFormat)Utils.TimeFormat.RELATIVE, (Utils.Resolution)Utils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"0.000015000s (15 \u00b5s)", (Object)relativeUs);
        String relativeMs = Utils.formatTime((long)250000000L, (Utils.TimeFormat)Utils.TimeFormat.RELATIVE, (Utils.Resolution)Utils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"0.250000000s (250 ms)", (Object)relativeMs);
        String relativeSeconds = Utils.formatTime((long)3123456000L, (Utils.TimeFormat)Utils.TimeFormat.RELATIVE, (Utils.Resolution)Utils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"3.123456000s", (Object)relativeSeconds);
        String relativeMinutes = Utils.formatTime((long)120000000000L, (Utils.TimeFormat)Utils.TimeFormat.RELATIVE, (Utils.Resolution)Utils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"120.000000000s", (Object)relativeMinutes);
        relativeMinutes = Utils.formatTime((long)138000000000L, (Utils.TimeFormat)Utils.TimeFormat.RELATIVE, (Utils.Resolution)Utils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"138.000000000s", (Object)relativeMinutes);
        String relativeHours = Utils.formatTime((long)3600000000000L, (Utils.TimeFormat)Utils.TimeFormat.RELATIVE, (Utils.Resolution)Utils.Resolution.NANOSEC);
        Assert.assertEquals((Object)"3600.000000000s", (Object)relativeHours);
    }
}

