/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage.KernelMemoryAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.memory.MemoryUsageTreeModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernelmemoryusage.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.FilterTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.AbstractTreeXyDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

@NonNullByDefault
public class KernelMemoryUsageDataProvider
extends AbstractTreeXyDataProvider<KernelMemoryAnalysisModule, MemoryUsageTreeModel> {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage";
    private static final int TOTAL_TID = -2;
    private @Nullable KernelAnalysisModule fKernelModule;
    private final Map<String, String> fProcessNameMap = new HashMap<String, String>();

    public static @Nullable KernelMemoryUsageDataProvider create(ITmfTrace trace) {
        KernelMemoryAnalysisModule module = (KernelMemoryAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelMemoryAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.core.kernelmemory");
        if (module != null) {
            module.schedule();
            return new KernelMemoryUsageDataProvider(trace, module);
        }
        return null;
    }

    private KernelMemoryUsageDataProvider(ITmfTrace trace, KernelMemoryAnalysisModule module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
    }

    protected @Nullable Map<String, IYModel> getYModels(ITmfStateSystem ss, SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        long[] xValues = filter.getTimesRequested();
        long currentEnd = ss.getCurrentEndTime();
        double[] totalKernelMemoryValues = new double[xValues.length];
        Map<Integer, double[]> selectedSeries = this.initSeries(filter);
        int i2 = 0;
        while (i2 < xValues.length) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            long time = xValues[i2];
            if (time >= ss.getStartTime() && time <= currentEnd) {
                List list = ss.getSubAttributes(-1, false);
                List kernelState = ss.queryFullState(time);
                for (Integer n : list) {
                    long value = KernelMemoryUsageDataProvider.extractValue(((ITmfStateInterval)kernelState.get(n)).getValue());
                    int n2 = i2;
                    totalKernelMemoryValues[n2] = totalKernelMemoryValues[n2] + (double)value;
                    double[] selectedThreadValues = selectedSeries.get(n);
                    if (selectedThreadValues == null) continue;
                    selectedThreadValues[i2] = value;
                }
            }
            ++i2;
        }
        List endState = ss.queryFullState(Long.min(filter.getEnd(), currentEnd));
        double d = KernelMemoryUsageDataProvider.extractTotalValueShift(ss, endState);
        Arrays.setAll(totalKernelMemoryValues, i -> totalKernelMemoryValues[i] + d);
        for (Map.Entry entry : selectedSeries.entrySet()) {
            int n = ss.optQuarkRelative(((Integer)entry.getKey()).intValue(), new String[]{"lowestMemory"});
            if (n == -2) continue;
            double[] threadValues = (double[])entry.getValue();
            long shift = KernelMemoryUsageDataProvider.extractValue(((ITmfStateInterval)endState.get(n)).getValue());
            Arrays.setAll(threadValues, i -> threadValues[i] - (double)shift);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String total = String.valueOf(this.getTrace().getName()) + ":total";
        builder.put((Object)total, (Object)new YModel(total, totalKernelMemoryValues));
        for (Map.Entry entry : selectedSeries.entrySet()) {
            String selectedThreadName = String.valueOf(this.getTrace().getName()) + ':' + ss.getAttributeName(((Integer)entry.getKey()).intValue());
            builder.put((Object)selectedThreadName, (Object)new YModel(selectedThreadName, (double[])entry.getValue()));
        }
        return builder.build();
    }

    private Map<Integer, double[]> initSeries(SelectionTimeQueryFilter filter) {
        int length = filter.getTimesRequested().length;
        return Maps.toMap((Iterable)this.getSelectedQuarks(filter), k -> new double[length]);
    }

    private static double extractTotalValueShift(ITmfStateSystem ss, List<ITmfStateInterval> endState) {
        double totalKernelMemoryValuesShift = 0.0;
        List threadQuarkList = ss.getQuarks(new String[]{"*", "lowestMemory"});
        for (Integer threadQuark : threadQuarkList) {
            ITmfStateInterval lowestMemoryInterval = endState.get(threadQuark);
            Object val = lowestMemoryInterval.getValue();
            totalKernelMemoryValuesShift -= (double)KernelMemoryUsageDataProvider.extractValue(val);
        }
        return totalKernelMemoryValuesShift;
    }

    private static long extractValue(@Nullable Object val) {
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return 0L;
    }

    protected List<MemoryUsageTreeModel> getTree(ITmfStateSystem ss, TimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        long end;
        long start = filter.getStart();
        if (start == (end = filter.getEnd())) {
            return Collections.emptyList();
        }
        boolean filtered = false;
        if (filter instanceof FilterTimeQueryFilter) {
            filtered = ((FilterTimeQueryFilter)filter).isFiltered();
        }
        ArrayList<MemoryUsageTreeModel> nodes = new ArrayList<MemoryUsageTreeModel>();
        List memoryStates = ss.queryFullState(Long.max(start, ss.getStartTime()));
        List threadQuarkList = ss.getSubAttributes(-1, false);
        long totalId = this.getId(-1);
        nodes.add(new MemoryUsageTreeModel(totalId, -1L, -2, this.getTrace().getName()));
        for (Integer threadQuark : threadQuarkList) {
            ITmfStateInterval threadMemoryInterval = (ITmfStateInterval)memoryStates.get(threadQuark);
            if (filtered && threadMemoryInterval.getEndTime() >= end) continue;
            String tidString = ss.getAttributeName(threadQuark.intValue());
            String procname = this.getProcessName(tidString);
            long id = this.getId(threadQuark);
            nodes.add(new MemoryUsageTreeModel(id, totalId, KernelMemoryUsageDataProvider.parseTid(tidString), procname));
        }
        return nodes;
    }

    private static int parseTid(String tidString) {
        try {
            return Integer.parseInt(tidString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private String getProcessName(String tid) {
        String execName = this.fProcessNameMap.get(tid);
        if (execName != null) {
            return execName;
        }
        if (tid.equals("other")) {
            this.fProcessNameMap.put(tid, tid);
            return tid;
        }
        KernelAnalysisModule kernelModule = this.fKernelModule;
        if (kernelModule == null) {
            kernelModule = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)this.getTrace(), KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        }
        if (kernelModule == null) {
            return tid;
        }
        this.fKernelModule = kernelModule;
        execName = KernelThreadInformationProvider.getExecutableName(kernelModule, Integer.parseInt(tid));
        if (execName == null) {
            return tid;
        }
        this.fProcessNameMap.put(tid, execName);
        return execName;
    }

    public String getId() {
        return ID;
    }

    protected boolean isCacheable() {
        return false;
    }

    protected String getTitle() {
        return Objects.requireNonNull(Messages.KernelMemoryUsageDataProvider_title);
    }
}

