/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ControlFlowEntry
extends TimeGraphEntry {
    private final @NonNull ITmfTrace fTrace;
    private final int fThreadId;
    private int fParentThreadId;
    private final int fThreadQuark;
    private long fSchedulingPosition;

    public ControlFlowEntry(int quark, @NonNull ITmfTrace trace, String execName, int threadId, int parentThreadId, long startTime, long endTime) {
        super(execName, startTime, endTime);
        this.fTrace = trace;
        this.fThreadId = threadId;
        this.fParentThreadId = parentThreadId;
        this.fThreadQuark = quark;
        this.fSchedulingPosition = Long.MAX_VALUE;
    }

    public int getThreadId() {
        return this.fThreadId;
    }

    public @NonNull ITmfTrace getTrace() {
        return this.fTrace;
    }

    public int getParentThreadId() {
        return this.fParentThreadId;
    }

    public void setParentThreadId(int ptid) {
        this.fParentThreadId = ptid;
    }

    public int getThreadQuark() {
        return this.fThreadQuark;
    }

    public boolean matches(@NonNull Pattern pattern) {
        if (pattern.matcher(this.getName()).find()) {
            return true;
        }
        if (pattern.matcher(Integer.toString(this.fThreadId)).find()) {
            return true;
        }
        if (pattern.matcher(Integer.toString(this.fParentThreadId)).find()) {
            return true;
        }
        if (pattern.matcher(Integer.toString(this.fThreadQuark)).find()) {
            return true;
        }
        return pattern.matcher(FormatTimeUtils.formatTime((long)this.getStartTime(), (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.CALENDAR, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC)).find();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + '(' + this.getName() + '[' + this.fThreadId + "])";
    }

    public long getSchedulingPosition() {
        return this.fSchedulingPosition;
    }

    public void setSchedulingPosition(long schedulingPosition) {
        this.fSchedulingPosition = schedulingPosition;
    }
}

