/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.filters;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ActiveThreadsFilter
extends ViewerFilter {
    private final @NonNull List<Range<Long>> fCpuRanges;
    private @NonNull Map<ITmfTrace, Set<Integer>> fCachedOnCpusThreadForTimeRange = new HashMap<ITmfTrace, Set<Integer>>();
    private @NonNull Map<ITmfTrace, Set<Integer>> fCachedActiveThreadForTimeRange = new HashMap<ITmfTrace, Set<Integer>>();
    private TmfTimeRange fCachedTimeRange;
    private boolean fEnabled = false;
    private boolean fCpuRangesBasedFiltering = false;
    private final @Nullable ITmfTrace fTrace;

    public ActiveThreadsFilter(List<Range<Long>> cpuRanges, boolean cpuRangesBasedFiltering, @Nullable ITmfTrace trace) {
        this.fCpuRanges = cpuRanges != null ? ImmutableList.copyOf(cpuRanges) : new ArrayList<Range<Long>>();
        this.fCpuRangesBasedFiltering = cpuRangesBasedFiltering;
        this.fTrace = trace;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean isCpuRangesBased() {
        return this.fCpuRangesBasedFiltering;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    public @NonNull List<Range<Long>> getCpuRanges() {
        return this.fCpuRanges;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.fEnabled || !(element instanceof ControlFlowEntry)) {
            return true;
        }
        ControlFlowEntry cfe = (ControlFlowEntry)((Object)element);
        ITmfTrace trace = cfe.getTrace();
        Set<Integer> onCpusThreadForTimeRange = this.fCachedOnCpusThreadForTimeRange.get(trace);
        Set<Integer> activeThreadForTimeRange = this.fCachedActiveThreadForTimeRange.get(trace);
        if (this.fCpuRangesBasedFiltering && onCpusThreadForTimeRange != null && onCpusThreadForTimeRange.contains(cfe.getThreadId())) {
            return true;
        }
        if (activeThreadForTimeRange != null && activeThreadForTimeRange.contains(cfe.getThreadId())) {
            return true;
        }
        for (TimeGraphEntry child : cfe.getChildren()) {
            if (!this.select(viewer, (Object)cfe, child)) continue;
            return true;
        }
        return false;
    }

    private static @NonNull Set<Integer> getOnCpuThreads(List<Range<Long>> cpuRanges, TmfTimeRange winRange, @NonNull ITmfTrace trace) {
        if (cpuRanges == null || cpuRanges.isEmpty()) {
            return new HashSet<Integer>();
        }
        long beginTS = winRange.getStartTime().getValue();
        long endTS = winRange.getEndTime().getValue();
        KernelAnalysisModule kernelAnalysisModule = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (kernelAnalysisModule == null) {
            return new HashSet<Integer>();
        }
        @NonNull HashSet<@NonNull Long> cpus = new HashSet<Long>();
        for (Range<Long> range : cpuRanges) {
            Long minimum = (Long)range.lowerEndpoint();
            Long maximum = (Long)range.upperEndpoint();
            Long i = minimum;
            while (i <= maximum) {
                cpus.add(i);
                i = i + 1L;
            }
        }
        HashSet set = KernelThreadInformationProvider.getThreadsOfCpus((KernelAnalysisModule)kernelAnalysisModule, cpus, (long)beginTS, (long)endTS);
        if (set == null) {
            set = new HashSet();
        }
        return set;
    }

    private static @NonNull Set<Integer> getActiveThreads(TmfTimeRange winRange, @NonNull ITmfTrace trace) {
        KernelAnalysisModule kernelModule = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        long beginTS = winRange.getStartTime().getValue();
        long endTS = winRange.getEndTime().getValue();
        if (kernelModule == null) {
            return new HashSet<Integer>();
        }
        HashSet set = KernelThreadInformationProvider.getActiveThreadsForRange((KernelAnalysisModule)kernelModule, (long)beginTS, (long)endTS);
        if (set == null) {
            set = new HashSet();
        }
        return set;
    }

    public void updateData(long beginTS, long endTS) {
        TmfTimeRange timeRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)beginTS), TmfTimestamp.fromNanos((long)endTS));
        ITmfTrace parentTrace = this.fTrace;
        if (parentTrace == null) {
            return;
        }
        if (this.fEnabled && (this.fCachedTimeRange == null || !this.fCachedTimeRange.equals((Object)timeRange))) {
            this.fCachedTimeRange = timeRange;
            for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)parentTrace)) {
                if (this.fCpuRangesBasedFiltering) {
                    Set<Integer> onCpusThreadForTimeRange = ActiveThreadsFilter.getOnCpuThreads(this.fCpuRanges, timeRange, trace);
                    this.fCachedOnCpusThreadForTimeRange.put(trace, onCpusThreadForTimeRange);
                    continue;
                }
                Set<Integer> activeThreadForTimeRange = ActiveThreadsFilter.getActiveThreads(timeRange, trace);
                this.fCachedActiveThreadForTimeRange.put(trace, activeThreadForTimeRange);
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.fCpuRanges, this.fCpuRangesBasedFiltering, this.fEnabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ActiveThreadsFilter other = (ActiveThreadsFilter)((Object)obj);
        return Objects.equals(this.fCpuRanges, other.fCpuRanges) && this.fCpuRangesBasedFiltering == other.fCpuRangesBasedFiltering && this.fEnabled == other.fEnabled;
    }
}

