/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;

public class TmfEventType
implements ITmfEventType {
    private final @NonNull String fTypeId;
    private final ITmfEventField fRootField;

    public TmfEventType() {
        this("TmfType", null);
    }

    public TmfEventType(@NonNull String typeId, ITmfEventField root) {
        this.fTypeId = typeId;
        this.fRootField = root;
    }

    public TmfEventType(@NonNull ITmfEventType type) {
        this.fTypeId = type.getName();
        this.fRootField = type.getRootField();
    }

    @Override
    public String getName() {
        return this.fTypeId;
    }

    @Override
    public ITmfEventField getRootField() {
        return this.fRootField;
    }

    @Override
    public Collection<String> getFieldNames() {
        return this.fRootField != null ? this.fRootField.getFieldNames() : Collections.EMPTY_SET;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fTypeId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfEventType)) {
            return false;
        }
        TmfEventType other = (TmfEventType)obj;
        return this.fTypeId.equals(other.fTypeId);
    }

    public String toString() {
        return "TmfEventType [fTypeId=" + this.fTypeId + "]";
    }
}

