/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.timestamp;

import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.math.SaturatedArithmetic;
import org.eclipse.tracecompass.internal.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.internal.tmf.core.timestamp.TmfSecondTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampDelta;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;

public abstract class TmfTimestamp
implements ITmfTimestamp {
    public static final @NonNull ITmfTimestamp ZERO = new TmfTimestamp(){

        @Override
        public long getValue() {
            return 0L;
        }

        @Override
        public int getScale() {
            return 0;
        }

        @Override
        public @NonNull ITmfTimestamp normalize(long offset, int scale) {
            if (offset == 0L) {
                return this;
            }
            return 1.create(offset, scale);
        }

        @Override
        public int compareTo(ITmfTimestamp ts) {
            return Long.compare(0L, ts.getValue());
        }
    };
    public static final @NonNull ITmfTimestamp BIG_BANG = new TmfTimestamp(){

        @Override
        public long getValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public int getScale() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int compareTo(ITmfTimestamp other) {
            if (this.equals(other)) {
                return 0;
            }
            return -1;
        }

        @Override
        public ITmfTimestamp normalize(long offset, int scale) {
            return this;
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }
    };
    public static final @NonNull ITmfTimestamp BIG_CRUNCH = new TmfTimestamp(){

        @Override
        public long getValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public int getScale() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int compareTo(ITmfTimestamp other) {
            if (this.equals(other)) {
                return 0;
            }
            return 1;
        }

        @Override
        public ITmfTimestamp normalize(long offset, int scale) {
            return this;
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }
    };
    protected static final long[] SCALING_FACTORS = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public static @NonNull ITmfTimestamp fromNanos(long value) {
        return new TmfNanoTimestamp(value);
    }

    public static @NonNull ITmfTimestamp fromMicros(long value) {
        return TmfTimestamp.create(value, -6);
    }

    public static @NonNull ITmfTimestamp fromMillis(long value) {
        return TmfTimestamp.create(value, -3);
    }

    public static @NonNull ITmfTimestamp fromSeconds(long value) {
        return new TmfSecondTimestamp(value);
    }

    public static @NonNull ITmfTimestamp create(ByteBuffer bufferIn) {
        return TmfTimestamp.create(bufferIn.getLong(), bufferIn.getInt());
    }

    public static @NonNull ITmfTimestamp create(long value, int scale) {
        if (scale == -9) {
            return TmfTimestamp.fromNanos(value);
        }
        if (scale == 0) {
            return TmfTimestamp.fromSeconds(value);
        }
        if (value == 0L) {
            return ZERO;
        }
        return TmfTimestamp.createOther(value, scale);
    }

    public static void serialize(ByteBuffer bufferOut, ITmfTimestamp ts) {
        bufferOut.putLong(ts.getValue());
        bufferOut.putInt(ts.getScale());
    }

    private static @NonNull ITmfTimestamp createOther(long value, int scale) {
        return new Impl(value, scale);
    }

    @Override
    public ITmfTimestamp normalize(long offset, int scale) {
        long value = this.getValue();
        if (this.getScale() == scale && offset == 0L) {
            return this;
        }
        if (value == 0L) {
            return TmfTimestamp.create(offset, scale);
        }
        if (this.getScale() != scale) {
            int scaleDiff = Math.abs(this.getScale() - scale);
            if (scaleDiff >= SCALING_FACTORS.length) {
                value = this.getScale() < scale ? 0L : (value > 0L ? Long.MAX_VALUE : Long.MIN_VALUE);
            } else {
                long scalingFactor = SCALING_FACTORS[scaleDiff];
                value = this.getScale() < scale ? (value /= scalingFactor) : SaturatedArithmetic.multiply((long)scalingFactor, (long)value);
            }
        }
        value = SaturatedArithmetic.add((long)value, (long)offset);
        return TmfTimestamp.create(value, scale);
    }

    @Override
    public ITmfTimestamp getDelta(ITmfTimestamp ts) {
        int scale = this.getScale();
        ITmfTimestamp nts = ts.normalize(0L, scale);
        long value = this.getValue() - nts.getValue();
        return new TmfTimestampDelta(value, scale);
    }

    @Override
    public boolean intersects(TmfTimeRange range) {
        return this.compareTo(range.getStartTime()) >= 0 && this.compareTo(range.getEndTime()) <= 0;
    }

    @Override
    public int compareTo(ITmfTimestamp ts) {
        ITmfTimestamp smallerScale;
        ITmfTimestamp nts;
        long value = this.getValue();
        int scale = this.getScale();
        if (BIG_BANG.equals(ts)) {
            return 1;
        }
        if (BIG_CRUNCH.equals(ts)) {
            return -1;
        }
        if (this == ts || TmfTimestamp.isIdentical(this, ts)) {
            return 0;
        }
        if (scale == ts.getScale()) {
            if (ts.getValue() == Long.MIN_VALUE) {
                return 1;
            }
            long delta = SaturatedArithmetic.add((long)this.getValue(), (long)(-ts.getValue()));
            return Long.compare(delta, 0L);
        }
        ITmfTimestamp largerScale = scale > ts.getScale() ? this : ts;
        if (TmfTimestamp.hasSaturated(largerScale, nts = largerScale.normalize(0L, (smallerScale = scale < ts.getScale() ? this : ts).getScale()))) {
            if (smallerScale.getScale() == scale) {
                return Long.compare(0L, nts.getValue());
            }
            return Long.compare(nts.getValue(), 0L);
        }
        if (smallerScale.getScale() == scale) {
            return Long.compare(value, nts.getValue());
        }
        return Long.compare(nts.getValue(), smallerScale.getValue());
    }

    private static boolean hasSaturated(ITmfTimestamp ts, ITmfTimestamp nts) {
        return nts.getValue() == 0L && ts.getValue() != 0L || !TmfTimestamp.isIdentical(ts, nts) && (nts.getValue() == Long.MAX_VALUE || nts.getValue() == Long.MIN_VALUE);
    }

    private static boolean isIdentical(ITmfTimestamp ts, ITmfTimestamp nts) {
        return ts.getValue() == nts.getValue() && ts.getScale() == nts.getScale();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long value = this.getValue();
        result = 31 * result + (int)(value ^ value >>> 32);
        result = 31 * result + this.getScale();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof ITmfTimestamp)) {
            return false;
        }
        ITmfTimestamp ts = (ITmfTimestamp)other;
        if (this.getScale() == ts.getScale()) {
            return this.getValue() == ts.getValue();
        }
        return this.compareTo(ts) == 0;
    }

    public String toString() {
        return this.toString(TmfTimestampFormat.getDefaulTimeFormat());
    }

    @Override
    public String toString(TmfTimestampFormat format) {
        try {
            return format.format(this.toNanos());
        }
        catch (ArithmeticException e) {
            return format.format(0L);
        }
    }

    private static final class Impl
    extends TmfTimestamp {
        private final long fValue;
        private final int fScale;

        public Impl(long value, int scale) {
            this.fValue = value;
            this.fScale = scale;
        }

        @Override
        public long getValue() {
            return this.fValue;
        }

        @Override
        public int getScale() {
            return this.fScale;
        }
    }
}

