/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ILoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IUstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.LoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.TraceInfo;

public class UstProviderInfo
extends TraceInfo
implements IUstProviderInfo {
    private int fPid = 0;
    private final List<IBaseEventInfo> fEvents = new ArrayList<IBaseEventInfo>();
    private final List<ILoggerInfo> fLoggers = new ArrayList<ILoggerInfo>();

    public UstProviderInfo(String name) {
        super(name);
    }

    public UstProviderInfo(UstProviderInfo other) {
        super(other);
        this.fPid = other.fPid;
        for (IBaseEventInfo event : other.fEvents) {
            if (event instanceof BaseEventInfo) {
                this.fEvents.add(new BaseEventInfo((BaseEventInfo)event));
                continue;
            }
            this.fEvents.add(event);
        }
        for (ILoggerInfo logger : other.fLoggers) {
            if (logger instanceof LoggerInfo) {
                this.fLoggers.add(new LoggerInfo((LoggerInfo)logger));
                continue;
            }
            this.fLoggers.add(logger);
        }
    }

    @Override
    public int getPid() {
        return this.fPid;
    }

    @Override
    public void setPid(int pid) {
        this.fPid = pid;
    }

    @Override
    public IBaseEventInfo[] getEvents() {
        return this.fEvents.toArray(new IBaseEventInfo[this.fEvents.size()]);
    }

    @Override
    public void setEvents(List<IBaseEventInfo> events) {
        this.fEvents.clear();
        for (IBaseEventInfo eventInfo : events) {
            this.fEvents.add(eventInfo);
        }
    }

    @Override
    public void addEvent(IBaseEventInfo event) {
        this.fEvents.add(event);
    }

    @Override
    public List<ILoggerInfo> getLoggers() {
        return new ArrayList<ILoggerInfo>(this.fLoggers);
    }

    @Override
    public void setLoggers(List<ILoggerInfo> loggers) {
        this.fLoggers.clear();
        for (ILoggerInfo logger : loggers) {
            this.fLoggers.add(logger);
        }
    }

    @Override
    public void addLogger(ILoggerInfo logger) {
        this.fLoggers.add(logger);
    }

    @Override
    public void addLoggers(List<ILoggerInfo> loggers) {
        this.fLoggers.addAll(loggers);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.fEvents.hashCode();
        result = 31 * result + this.fLoggers.hashCode();
        result = 31 * result + this.fPid;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UstProviderInfo other = (UstProviderInfo)obj;
        if (!this.fEvents.equals(other.fEvents)) {
            return false;
        }
        if (!this.fLoggers.equals(other.fLoggers)) {
            return false;
        }
        return this.fPid == other.fPid;
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[UstProviderInfo(");
        output.append(super.toString());
        output.append(",PID=");
        output.append(this.fPid);
        output.append(",Events=");
        if (this.fEvents.isEmpty()) {
            output.append("None");
        } else {
            for (IBaseEventInfo event : this.fEvents) {
                output.append(event.toString());
            }
        }
        output.append(",Loggers=");
        if (this.fLoggers.isEmpty()) {
            output.append("None");
        } else {
            for (ILoggerInfo logger : this.fLoggers) {
                output.append(logger.toString());
            }
        }
        output.append(")]");
        return output.toString();
    }
}

