/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.ITmfPinnable;

public class PinTmfViewAction
extends Action {
    private static final ImageDescriptor PIN_VIEW = Activator.getDefault().getImageDescripterFromPath("icons/elcl16/pin_view.gif");
    private static final ImageDescriptor UNPINNED_VIEW = Activator.getDefault().getImageDescripterFromPath("icons/elcl16/unpinned_view.gif");
    private final ITmfPinnable fPinnable;
    private ITmfTrace fPinnedTrace = null;

    public PinTmfViewAction() {
        super(Messages.TmfView_PinActionNameText, 2);
        this.fPinnable = null;
        this.setId("org.eclipse.linuxtools.tmf.ui.views.PinTmfViewAction");
        this.setImageDescriptor(PIN_VIEW);
    }

    public PinTmfViewAction(ITmfPinnable pinnable) {
        super(Messages.TmfView_PinActionNameText, 4);
        this.fPinnable = pinnable;
        this.setId("org.eclipse.linuxtools.tmf.ui.views.PinTmfViewAction");
        this.setImageDescriptor(UNPINNED_VIEW);
        this.setMenuCreator(new IMenuCreator(){
            Menu menu = null;

            public void dispose() {
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                }
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public Menu getMenu(Control parent) {
                if (this.menu != null) {
                    this.menu.dispose();
                }
                this.menu = new Menu(parent);
                @NonNull Set openedTraces = TmfTraceManager.getInstance().getOpenedTraces();
                for (final ITmfTrace trace : openedTraces) {
                    Action action = new Action(NLS.bind((String)Messages.TmfView_PinToActionText, (Object)TmfTraceManager.getInstance().getTraceUniqueName(trace)), 8){

                        public void runWithEvent(Event event) {
                            if (this.isChecked()) {
                                PinTmfViewAction.this.fPinnable.setPinned(trace);
                                PinTmfViewAction.this.setPinnedTrace(trace);
                            }
                        }
                    };
                    action.setChecked(trace.equals(PinTmfViewAction.this.fPinnedTrace));
                    new ActionContributionItem((IAction)action).fill(this.menu, -1);
                }
                return this.menu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
        });
    }

    public void run() {
        if (this.fPinnable == null) {
            return;
        }
        if (this.fPinnedTrace == null) {
            ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
            if (trace != null) {
                this.fPinnable.setPinned(trace);
                this.setPinnedTrace(trace);
            }
        } else {
            this.fPinnable.setPinned(null);
            this.setPinnedTrace(null);
        }
    }

    public boolean isPinned() {
        if (this.fPinnable == null) {
            return super.isChecked();
        }
        return this.fPinnedTrace != null;
    }

    public void setPinnedTrace(ITmfTrace trace) {
        if (this.fPinnable == null) {
            this.setChecked(trace != null);
            return;
        }
        this.fPinnedTrace = trace;
        if (trace == null) {
            this.setText(Messages.TmfView_PinActionNameText);
            this.setImageDescriptor(UNPINNED_VIEW);
        } else {
            this.setText(Messages.TmfView_UnpinActionText);
            this.setImageDescriptor(PIN_VIEW);
        }
    }
}

