/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.IXYPresentationProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.RGBColor;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.XYPresentationProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfChartTimeStampFormat;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartTooltipProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.swtchart.IBarSeries;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;

public abstract class TmfCommonXAxisChartViewer
extends TmfXYChartViewer {
    private static final String DIRTY_UNDERFLOW_ERROR = "Dirty underflow error";
    private static final double DEFAULT_MAXY = Double.MIN_VALUE;
    private static final double DEFAULT_MINY = Double.MAX_VALUE;
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(TmfCommonXAxisChartViewer.class);
    private static final int DEFAULT_SERIES_WIDTH = 1;
    private final double fResolution;
    private final AtomicInteger fDirty = new AtomicInteger();
    private final Map<ITmfTrace, IXYPresentationProvider> fXYPresentationProvider;
    private UpdateThread fUpdateThread;
    private int fOverrideNbPoints = 0;

    public TmfCommonXAxisChartViewer(Composite parent, TmfXYChartSettings settings) {
        super(parent, settings.getTitle(), settings.getXLabel(), settings.getYLabel());
        this.getSwtChart().getTitle().setVisible(false);
        this.getSwtChart().getLegend().setPosition(1024);
        this.getSwtChart().getAxisSet().getXAxes()[0].getTitle().setVisible(false);
        this.fResolution = settings.getResolution();
        this.setTooltipProvider(new TmfCommonXLineChartTooltipProvider(this));
        this.fXYPresentationProvider = new HashMap<ITmfTrace, IXYPresentationProvider>();
    }

    @Override
    public void loadTrace(ITmfTrace trace) {
        super.loadTrace(trace);
        this.fXYPresentationProvider.putIfAbsent(trace, (IXYPresentationProvider)new XYPresentationProvider());
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.fDirty.get() != 0;
    }

    public synchronized void setNbPoints(int nbPoints) {
        if (nbPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative");
        }
        this.fOverrideNbPoints = nbPoints;
        this.updateContent();
    }

    protected ITmfXYDataProvider initializeDataProvider(@NonNull ITmfTrace trace) {
        throw new UnsupportedOperationException("This needs to be implemented concrete classes");
    }

    protected IXYPresentationProvider getPresentationProvider() {
        return Objects.requireNonNull(this.fXYPresentationProvider.get(this.getTrace()));
    }

    protected @NonNull TimeQueryFilter createQueryFilter(long start, long end, int nb) {
        return new TimeQueryFilter(start, end, nb);
    }

    public @NonNull IYAppearance getSeriesAppearance(@NonNull String seriesName) {
        return this.getPresentationProvider().getAppearance(seriesName, "line", 1);
    }

    protected synchronized void cancelUpdate() {
        if (this.fUpdateThread != null) {
            this.fUpdateThread.cancel();
        }
    }

    @Override
    protected void updateContent() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        this.cancelUpdate();
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog parentScope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:ContentUpdateRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            this.fDirty.incrementAndGet();
            TmfCommonXAxisChartViewer.getDisplay().asyncExec(() -> {
                if (!trace.equals(this.getTrace())) {
                    return;
                }
                Throwable throwable = null;
                Object var4_5 = null;
                try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:CreatingUpdateThread", new Object[0]).setParentScope(parentScope).build();){
                    this.newUpdateThread(trace, scope);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void clearContent() {
        this.getSwtChart().getAxisSet().getXAxis(0).getTick().setFormat(null);
        super.clearContent();
    }

    private @NonNull String getViewerId() {
        return this.getClass().getName();
    }

    private synchronized void newUpdateThread(@NonNull ITmfTrace trace, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TraceCompassLogUtils.FlowScopeLog fScope) {
        if (this.getSwtChart().isDisposed()) {
            return;
        }
        int numRequests = this.fOverrideNbPoints != 0 ? this.fOverrideNbPoints : (int)Math.min(this.getWindowEndTime() - this.getWindowStartTime() + 1L, (long)((double)this.getSwtChart().getPlotArea().getBounds().width * this.fResolution));
        this.fUpdateThread = new UpdateThread(trace, numRequests, fScope);
        this.fUpdateThread.start();
    }

    @Override
    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        this.cancelUpdate();
        super.traceClosed(signal);
        if (signal != null) {
            this.fXYPresentationProvider.remove(signal.getTrace());
        }
    }

    private class UpdateThread
    extends Thread {
        private final ITmfTrace fTrace;
        private final IProgressMonitor fMonitor;
        private final int fNumRequests;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull TraceCompassLogUtils.FlowScopeLog fScope;

        public UpdateThread(ITmfTrace trace, @NonNull int numRequests, TraceCompassLogUtils.FlowScopeLog log) {
            super("Line chart update");
            this.fTrace = trace;
            this.fNumRequests = numRequests;
            this.fMonitor = new NullProgressMonitor();
            this.fScope = log;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:UpdateThread", new Object[]{"numRequests=", this.fNumRequests}).setParentScope(this.fScope).build();
                try {
                    ITmfXYDataProvider dataProvider = null;
                    Throwable throwable2 = null;
                    Object var6_9 = null;
                    try (TraceCompassLogUtils.FlowScopeLog scopeDp = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:InitializeDataProvider", new Object[0]).setParentScope(this.fScope).build();){
                        dataProvider = TmfCommonXAxisChartViewer.this.initializeDataProvider(this.fTrace);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                    if (dataProvider == null) {
                        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)"Data provider for this viewer is not available", (Object[])new Object[0]);
                        return;
                    }
                    try {
                        TimeQueryFilter filter = TmfCommonXAxisChartViewer.this.createQueryFilter(TmfCommonXAxisChartViewer.this.getWindowStartTime(), TmfCommonXAxisChartViewer.this.getWindowEndTime(), this.fNumRequests);
                        this.updateData(dataProvider, filter, this.fMonitor);
                    }
                    finally {
                        if (TmfCommonXAxisChartViewer.this.fDirty.decrementAndGet() < 0) {
                            Activator.getDefault().logError(TmfCommonXAxisChartViewer.DIRTY_UNDERFLOW_ERROR, new Throwable());
                        }
                    }
                    this.updateThreadFinished(this);
                    return;
                }
                finally {
                    if (scope == null) return;
                    scope.close();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }

        public void cancel() {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"CommonXLineChart:UpdateThreadCanceled", (Object[])new Object[0]);
            this.fMonitor.setCanceled(true);
        }

        private void updateData(@NonNull ITmfXYDataProvider dataProvider, @NonNull TimeQueryFilter filters, IProgressMonitor monitor) {
            boolean isComplete = false;
            do {
                ITmfResponse.Status status;
                TmfModelResponse response;
                ITmfCommonXAxisModel model;
                if ((model = (ITmfCommonXAxisModel)(response = dataProvider.fetchXY(filters, monitor)).getModel()) != null) {
                    this.updateDisplay(model, monitor);
                }
                if ((status = response.getStatus()) == ITmfResponse.Status.COMPLETED) {
                    isComplete = true;
                    continue;
                }
                if (status == ITmfResponse.Status.FAILED || status == ITmfResponse.Status.CANCELLED) {
                    TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)response.getStatusMessage(), (Object[])new Object[0]);
                    isComplete = true;
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.INFO, (String)e.getMessage(), (Object[])new Object[0]);
                }
            } while (!isComplete);
        }

        private void updateDisplay(ITmfCommonXAxisModel model, IProgressMonitor monitor) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TmfCommonXAxisChart:UpdateDisplayRequested", new Object[0]).setCategory(TmfCommonXAxisChartViewer.this.getViewerId()).build();){
                ITmfCommonXAxisModel seriesValues = model;
                TmfCommonXAxisChartViewer.this.fDirty.incrementAndGet();
                Display.getDefault().asyncExec(() -> {
                    TmfChartTimeStampFormat tmfChartTimeStampFormat = new TmfChartTimeStampFormat(TmfCommonXAxisChartViewer.this.getTimeOffset());
                    try {
                        Throwable throwable = null;
                        Object var6_7 = null;
                        try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TmfCommonXAxisChart:UpdateDisplay", new Object[0]).setParentScope(scope).build();){
                            if (!this.fTrace.equals(TmfCommonXAxisChartViewer.this.getTrace())) {
                                if (TmfCommonXAxisChartViewer.this.fDirty.decrementAndGet() < 0) {
                                    Activator.getDefault().logError(TmfCommonXAxisChartViewer.DIRTY_UNDERFLOW_ERROR, new Throwable());
                                }
                                return;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        if (TmfCommonXAxisChartViewer.this.fDirty.decrementAndGet() < 0) {
                            Activator.getDefault().logError(TmfCommonXAxisChartViewer.DIRTY_UNDERFLOW_ERROR, new Throwable());
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private double[] extractXValuesToDisplay(ITmfCommonXAxisModel model) {
            long[] xValuesRequested = model.getXAxis();
            double[] xValuesToDisplay = new double[xValuesRequested.length];
            long offset = TmfCommonXAxisChartViewer.this.getTimeOffset();
            int i = 0;
            while (i < xValuesRequested.length) {
                xValuesToDisplay[i] = xValuesRequested[i] - offset;
                ++i;
            }
            return xValuesToDisplay;
        }

        private @NonNull ISeries createSWTSeriesFromModel(IYModel yModel) {
            ISeriesSet seriesSet = TmfCommonXAxisChartViewer.this.getSwtChart().getSeriesSet();
            String seriesName = yModel.getName();
            IYAppearance appearance = TmfCommonXAxisChartViewer.this.getSeriesAppearance(seriesName);
            String type = appearance.getType();
            RGBColor rgb = appearance.getColor();
            Color color = new Color((Device)Display.getDefault(), rgb.getRed(), rgb.getGreen(), rgb.getBlue());
            if (type.equals("bar")) {
                IBarSeries barSeries = (IBarSeries)seriesSet.createSeries(ISeries.SeriesType.BAR, seriesName);
                barSeries.enableStack(true);
                barSeries.setBarColor(color);
                barSeries.setBarPadding(0);
                barSeries.setVisible(true);
                return barSeries;
            }
            ILineSeries lineSeries = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, seriesName);
            boolean isScatter = "scatter".equals(type);
            lineSeries.enableArea("area".equals(type));
            lineSeries.setLineStyle(LineStyle.valueOf((String)appearance.getStyle()));
            lineSeries.setSymbolType(isScatter ? ILineSeries.PlotSymbolType.DIAMOND : ILineSeries.PlotSymbolType.NONE);
            lineSeries.setLineColor(color);
            lineSeries.setVisible(true);
            lineSeries.setLineWidth(appearance.getWidth());
            return lineSeries;
        }

        private synchronized void updateThreadFinished(UpdateThread thread) {
            if (thread == TmfCommonXAxisChartViewer.this.fUpdateThread) {
                TmfCommonXAxisChartViewer.this.fUpdateThread = null;
            }
        }
    }
}

