/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.memory.MemoryUsageTreeModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.FilterTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.AbstractTreeXyDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.UstMemoryAnalysisModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

@NonNullByDefault
public class UstMemoryUsageDataProvider
extends AbstractTreeXyDataProvider<UstMemoryAnalysisModule, MemoryUsageTreeModel> {
    public static final String ID = "org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.UstMemoryUsageDataProvider";

    public static @Nullable UstMemoryUsageDataProvider create(ITmfTrace trace) {
        UstMemoryAnalysisModule module = (UstMemoryAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, UstMemoryAnalysisModule.class, (String)"org.eclipse.linuxtools.lttng2.ust.analysis.memory");
        if (module != null) {
            module.schedule();
            return new UstMemoryUsageDataProvider(trace, module);
        }
        return null;
    }

    private UstMemoryUsageDataProvider(ITmfTrace trace, UstMemoryAnalysisModule module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
    }

    protected @Nullable Map<String, IYModel> getYModels(ITmfStateSystem ss, SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        long[] xValues = filter.getTimesRequested();
        long currentEnd = ss.getCurrentEndTime();
        Map<Integer, IYModel> models = this.initYModels(ss, filter);
        for (ITmfStateInterval interval : ss.query2D(models.keySet(), UstMemoryUsageDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)currentEnd))) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            IYModel model = models.get(interval.getAttribute());
            Object value = interval.getValue();
            if (model == null || !(value instanceof Number)) continue;
            int from = Arrays.binarySearch(xValues, interval.getStartTime());
            from = from >= 0 ? from : -1 - from;
            int to = Arrays.binarySearch(xValues, interval.getEndTime());
            to = to >= 0 ? to + 1 : -1 - to;
            Arrays.fill(model.getData(), from, to, ((Number)value).doubleValue());
        }
        return Maps.uniqueIndex(models.values(), IYModel::getName);
    }

    private Map<Integer, IYModel> initYModels(ITmfStateSystem ss, SelectionTimeQueryFilter filter) {
        HashMap<Integer, IYModel> selectedSeries = new HashMap<Integer, IYModel>();
        int length = filter.getTimesRequested().length;
        for (Integer tidQuark : this.getSelectedQuarks(filter)) {
            int memoryAttribute = ss.optQuarkRelative(tidQuark.intValue(), new String[]{"Memory"});
            if (memoryAttribute == -2) continue;
            String name = String.valueOf(this.getTrace().getName()) + ':' + ss.getAttributeName(tidQuark.intValue());
            selectedSeries.put(memoryAttribute, (IYModel)new YModel(name, new double[length]));
        }
        return selectedSeries;
    }

    protected List<MemoryUsageTreeModel> getTree(ITmfStateSystem ss, TimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        boolean filtered = false;
        if (filter instanceof FilterTimeQueryFilter) {
            filtered = ((FilterTimeQueryFilter)filter).isFiltered();
        }
        List nameFullState = ss.queryFullState(ss.getCurrentEndTime());
        List activeFullState = ss.queryFullState(Long.max(filter.getStart(), ss.getStartTime()));
        List tidQuarks = ss.getSubAttributes(-1, false);
        ImmutableList.Builder builder = ImmutableList.builder();
        long rootId = this.getId(-1);
        builder.add((Object)new MemoryUsageTreeModel(rootId, -1L, -1, this.getTrace().getName()));
        Iterator iterator = tidQuarks.iterator();
        while (iterator.hasNext()) {
            int quark = (Integer)iterator.next();
            int memoryAttribute = ss.optQuarkRelative(quark, new String[]{"Memory"});
            int procNameQuark = ss.optQuarkRelative(quark, new String[]{"Procname"});
            if (memoryAttribute == -2 || procNameQuark == -2) continue;
            ITmfStateInterval threadMemoryInterval = (ITmfStateInterval)activeFullState.get(memoryAttribute);
            if (filtered && threadMemoryInterval.getEndTime() >= filter.getEnd()) continue;
            String name = String.valueOf(((ITmfStateInterval)nameFullState.get(procNameQuark)).getValue());
            int tid = Integer.parseInt(ss.getAttributeName(quark));
            Long id = this.getId(quark);
            builder.add((Object)new MemoryUsageTreeModel(id.longValue(), rootId, tid, name));
        }
        return builder.build();
    }

    public String getId() {
        return ID;
    }

    protected boolean isCacheable() {
        return true;
    }

    protected String getTitle() {
        return Objects.requireNonNull(Messages.MemoryUsageDataProvider_Title);
    }
}

