/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.counters.ui;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.counters.ui.CounterChartViewer;
import org.eclipse.tracecompass.analysis.counters.ui.CounterTreeViewer;
import org.eclipse.tracecompass.internal.analysis.counters.ui.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.ILegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ICheckboxTreeViewerListener;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.XYChartLegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CounterView
extends TmfChartView {
    public static final String ID = "org.eclipse.tracecompass.analysis.counters.ui.view.counters";
    public static final String VIEW_TITLE = "Counters";

    public CounterView() {
        super(VIEW_TITLE);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TmfViewer tree = this.getLeftChildViewer();
        TmfXYChartViewer chart = this.getChartViewer();
        if (tree instanceof CounterTreeViewer && chart instanceof CounterChartViewer) {
            XYChartLegendImageProvider legendImageProvider = new XYChartLegendImageProvider((TmfCommonXAxisChartViewer)chart);
            CounterTreeViewer counterTree = (CounterTreeViewer)tree;
            counterTree.setTreeListener((ICheckboxTreeViewerListener)((CounterChartViewer)chart));
            counterTree.setLegendImageProvider((ILegendImageProvider)legendImageProvider);
        }
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.getCumulativeAction());
    }

    protected TmfXYChartViewer createChartViewer(Composite parent) {
        return new CounterChartViewer(parent, new TmfXYChartSettings(null, null, null, 1.0));
    }

    protected @NonNull TmfViewer createLeftChildViewer(Composite parent) {
        CounterTreeViewer treeViewer = new CounterTreeViewer(parent);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            treeViewer.traceSelected(signal);
        }
        return treeViewer;
    }

    private Action getCumulativeAction() {
        Action action = new Action(Messages.CounterView_CumulativeAction_Text, 2){
            private boolean isCumulative;
            {
                this.isCumulative = false;
            }

            public void run() {
                this.isCumulative ^= true;
                this.setToolTipText(this.isCumulative ? Messages.CounterView_CumulativeAction_DifferentialTooltipText : Messages.CounterView_CumulativeAction_CumulativeTooltipText);
                TmfXYChartViewer chart = CounterView.this.getChartViewer();
                if (chart instanceof CounterChartViewer) {
                    ((CounterChartViewer)chart).toggleCumulative();
                }
            }
        };
        action.setToolTipText(Messages.CounterView_CumulativeAction_CumulativeTooltipText);
        action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tracecompass.tmf.ui", (String)"icons/elcl16/sigma.gif"));
        return action;
    }
}

