/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.registry.LinuxStyle;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class ControlFlowPresentationProvider
extends TimeGraphPresentationProvider {
    private static final Map<Integer, StateItem> STATE_MAP;
    private static final List<StateItem> STATE_LIST;
    private static final StateItem[] STATE_TABLE;
    private Integer fAverageCharacterWidth = null;

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)ProcessStatus.UNKNOWN.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.UNKNOWN));
        builder.put((Object)ProcessStatus.RUN.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.USERMODE));
        builder.put((Object)ProcessStatus.RUN_SYTEMCALL.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.SYSCALL));
        builder.put((Object)ProcessStatus.INTERRUPTED.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.INTERRUPTED));
        builder.put((Object)ProcessStatus.WAIT_BLOCKED.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.WAIT_BLOCKED));
        builder.put((Object)ProcessStatus.WAIT_CPU.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.WAIT_FOR_CPU));
        builder.put((Object)ProcessStatus.WAIT_UNKNOWN.getStateValue().unboxInt(), (Object)ControlFlowPresentationProvider.createState(LinuxStyle.WAIT_UNKNOWN));
        STATE_MAP = builder.build();
        STATE_LIST = ImmutableList.copyOf(STATE_MAP.values());
        STATE_TABLE = STATE_LIST.toArray(new StateItem[STATE_LIST.size()]);
    }

    private static StateItem createState(LinuxStyle style) {
        return new StateItem(style.toMap());
    }

    public ControlFlowPresentationProvider() {
        super(Messages.ControlFlowView_stateTypeName);
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            int status = ((TimeEvent)event).getValue();
            return STATE_LIST.indexOf(ControlFlowPresentationProvider.getMatchingState(status));
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public String getEventName(ITimeEvent event) {
        TimeEvent ev;
        if (event instanceof TimeEvent && (ev = (TimeEvent)event).hasValue()) {
            return ControlFlowPresentationProvider.getMatchingState(ev.getValue()).getStateString();
        }
        return Messages.ControlFlowView_multipleStates;
    }

    private static StateItem getMatchingState(int status) {
        return STATE_MAP.getOrDefault(status, STATE_MAP.get(ProcessStatus.WAIT_UNKNOWN.getStateValue().unboxInt()));
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (!(event instanceof TimeEvent && ((TimeEvent)event).hasValue() && event.getEntry() instanceof ControlFlowEntry)) {
            return retMap;
        }
        ControlFlowEntry entry = (ControlFlowEntry)event.getEntry();
        ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)entry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ssq == null) {
            return retMap;
        }
        int status = ((TimeEvent)event).getValue();
        if (status == ProcessStatus.RUN_SYTEMCALL.getStateValue().unboxInt()) {
            int syscallQuark = ssq.optQuarkRelative(entry.getThreadQuark(), new String[]{"System_call"});
            if (syscallQuark == -2) {
                return retMap;
            }
            try {
                ITmfStateInterval value = ssq.querySingleState(event.getTime(), syscallQuark);
                if (!value.getStateValue().isNull()) {
                    ITmfStateValue state = value.getStateValue();
                    retMap.put(Messages.ControlFlowView_attributeSyscallName, state.toString());
                }
            }
            catch (TimeRangeException e) {
                Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
        }
        return retMap;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        LinkedHashMap<String, String> retMap = super.getEventHoverToolTipInfo(event, hoverTime);
        if (retMap == null) {
            retMap = new LinkedHashMap<String, String>();
        }
        if (!(event instanceof TimeEvent && ((TimeEvent)event).hasValue() && event.getEntry() instanceof ControlFlowEntry)) {
            return retMap;
        }
        ControlFlowEntry entry = (ControlFlowEntry)event.getEntry();
        ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)entry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ssq == null) {
            return retMap;
        }
        try {
            ITmfStateInterval interval;
            ITmfStateValue value;
            int currentCpuRqQuark = ssq.optQuarkRelative(entry.getThreadQuark(), new String[]{"Current_cpu_rq"});
            if (currentCpuRqQuark != -2 && (value = (interval = ssq.querySingleState(hoverTime, currentCpuRqQuark)).getStateValue()).getType() == ITmfStateValue.Type.INTEGER) {
                retMap.put(Messages.ControlFlowView_attributeCpuName, String.valueOf(value.unboxInt()));
            }
        }
        catch (StateValueTypeException | TimeRangeException e) {
            Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return retMap;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (this.fAverageCharacterWidth == null) {
            this.fAverageCharacterWidth = gc.getFontMetrics().getAverageCharWidth();
        }
        if (bounds.width <= this.fAverageCharacterWidth) {
            return;
        }
        if (!(event instanceof TimeEvent)) {
            return;
        }
        ControlFlowEntry entry = (ControlFlowEntry)event.getEntry();
        ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)entry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ss == null) {
            return;
        }
        int status = ((TimeEvent)event).getValue();
        if (status != ProcessStatus.RUN_SYTEMCALL.getStateValue().unboxInt()) {
            return;
        }
        int syscallQuark = ss.optQuarkRelative(entry.getThreadQuark(), new String[]{"System_call"});
        if (syscallQuark == -2) {
            return;
        }
        try {
            ITmfStateInterval value = ss.querySingleState(event.getTime(), syscallQuark);
            if (!value.getStateValue().isNull()) {
                ITmfStateValue state = value.getStateValue();
                gc.setForeground(gc.getDevice().getSystemColor(1));
                int beginIndex = 0;
                ITmfTrace trace = entry.getTrace();
                if (trace instanceof IKernelTrace) {
                    IKernelAnalysisEventLayout layout = ((IKernelTrace)trace).getKernelEventLayout();
                    beginIndex = layout.eventSyscallEntryPrefix().length();
                }
                Utils.drawText((GC)gc, (String)state.toString().substring(beginIndex), (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
            }
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }
}

