/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.registry.LinuxStyle;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesEntry;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITmfTimeGraphDrawingHelper;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class ResourcesPresentationProvider
extends TimeGraphPresentationProvider {
    private long fLastThreadId = -1L;
    private Color fColorWhite;
    private Color fColorGray;
    private Integer fAverageCharWidth;
    private static final Map<Integer, StateItem> STATE_MAP;
    private static final List<StateItem> STATE_LIST;
    private static final StateItem[] STATE_TABLE;

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)0, (Object)ResourcesPresentationProvider.createState(LinuxStyle.IDLE));
        builder.put((Object)2, (Object)ResourcesPresentationProvider.createState(LinuxStyle.USERMODE));
        builder.put((Object)4, (Object)ResourcesPresentationProvider.createState(LinuxStyle.SYSCALL));
        builder.put((Object)16, (Object)ResourcesPresentationProvider.createState(LinuxStyle.INTERRUPTED));
        builder.put((Object)8, (Object)ResourcesPresentationProvider.createState(LinuxStyle.SOFT_IRQ));
        builder.put((Object)1, (Object)ResourcesPresentationProvider.createState(LinuxStyle.SOFT_IRQ_RAISED));
        STATE_MAP = builder.build();
        STATE_LIST = ImmutableList.copyOf(STATE_MAP.values());
        STATE_TABLE = STATE_LIST.toArray(new StateItem[STATE_LIST.size()]);
    }

    private static StateItem createState(LinuxStyle style) {
        int rgbInt = (Integer)style.toMap().getOrDefault(ITimeEventStyleStrings.fillColor(), 0);
        RGB color = new RGB(rgbInt >> 24 & 0xFF, rgbInt >> 16 & 0xFF, rgbInt >> 8 & 0xFF);
        return new StateItem(color, style.getLabel());
    }

    private static StateItem getEventState(TimeEvent event) {
        if (event.hasValue()) {
            ResourcesEntry entry = (ResourcesEntry)event.getEntry();
            int value = event.getValue();
            if (entry.getType() == ResourcesEntry.Type.CPU) {
                return STATE_MAP.get(value);
            }
            if (entry.getType() == ResourcesEntry.Type.IRQ) {
                return STATE_MAP.get(16);
            }
            if (entry.getType() == ResourcesEntry.Type.SOFT_IRQ) {
                if (value == 1) {
                    return STATE_MAP.get(1);
                }
                return STATE_MAP.get(8);
            }
        }
        return null;
    }

    public int getStateTableIndex(ITimeEvent event) {
        StateItem state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return STATE_LIST.indexOf(state);
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public String getEventName(ITimeEvent event) {
        StateItem state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.getStateString();
        }
        if (event instanceof NullTimeEvent) {
            return null;
        }
        return Messages.ResourcesView_multipleStates;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            TimeEvent tcEvent = (TimeEvent)event;
            ResourcesEntry entry = (ResourcesEntry)event.getEntry();
            if (tcEvent.hasValue()) {
                ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)entry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
                if (ss == null) {
                    return retMap;
                }
                if (entry.getType().equals((Object)ResourcesEntry.Type.IRQ) || entry.getType().equals((Object)ResourcesEntry.Type.SOFT_IRQ)) {
                    int cpu = tcEvent.getValue();
                    if (cpu >= 0) {
                        retMap.put(Messages.ResourcesView_attributeCpuName, String.valueOf(cpu));
                    }
                } else if (entry.getType().equals((Object)ResourcesEntry.Type.CPU)) {
                    int status = tcEvent.getValue();
                    if (status == 16) {
                        int cpu = entry.getId();
                        try {
                            List fullState = ss.queryFullState(event.getTime());
                            List irqQuarks = ss.getQuarks(new String[]{"CPUs", Integer.toString(cpu), "IRQs", "*"});
                            Iterator iterator = irqQuarks.iterator();
                            while (iterator.hasNext()) {
                                int irqQuark = (Integer)iterator.next();
                                ITmfStateInterval value = (ITmfStateInterval)fullState.get(irqQuark);
                                if (value.getStateValue().isNull()) continue;
                                String irq = ss.getAttributeName(irqQuark);
                                retMap.put(Messages.ResourcesView_attributeIrqName, irq);
                                break;
                            }
                        }
                        catch (StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
                        }
                        catch (StateSystemDisposedException e) {}
                    } else if (status == 8) {
                        int cpu = entry.getId();
                        try {
                            List fullState = ss.queryFullState(event.getTime());
                            List softIrqQuarks = ss.getQuarks(new String[]{"CPUs", Integer.toString(cpu), "Soft_IRQs", "*"});
                            Iterator iterator = softIrqQuarks.iterator();
                            while (iterator.hasNext()) {
                                int softIrqQuark = (Integer)iterator.next();
                                ITmfStateInterval value = (ITmfStateInterval)fullState.get(softIrqQuark);
                                if (value.getStateValue().isNull()) continue;
                                String softIrq = ss.getAttributeName(softIrqQuark);
                                retMap.put(Messages.ResourcesView_attributeSoftIrqName, softIrq);
                                break;
                            }
                        }
                        catch (StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
                        }
                        catch (StateSystemDisposedException e) {}
                    } else if (status == 2 || status == 4) {
                        try {
                            retMap.put(Messages.ResourcesView_attributeHoverTime, FormatTimeUtils.formatTime((long)hoverTime, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.CALENDAR, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC));
                            int cpuQuark = entry.getQuark();
                            int currentThreadQuark = ss.getQuarkRelative(cpuQuark, new String[]{"Current_thread"});
                            ITmfStateInterval interval = ss.querySingleState(hoverTime, currentThreadQuark);
                            if (!interval.getStateValue().isNull()) {
                                ITmfStateValue value = interval.getStateValue();
                                int currentThreadId = value.unboxInt();
                                retMap.put(Messages.ResourcesView_attributeTidName, Integer.toString(currentThreadId));
                                int execNameQuark = ss.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "Exec_name"});
                                interval = ss.querySingleState(hoverTime, execNameQuark);
                                if (!interval.getStateValue().isNull()) {
                                    value = interval.getStateValue();
                                    retMap.put(Messages.ResourcesView_attributeProcessName, value.unboxStr());
                                }
                                if (status == 4) {
                                    int syscallQuark = ss.optQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "System_call"});
                                    if (syscallQuark == -2) {
                                        return retMap;
                                    }
                                    interval = ss.querySingleState(hoverTime, syscallQuark);
                                    if (!interval.getStateValue().isNull()) {
                                        value = interval.getStateValue();
                                        retMap.put(Messages.ResourcesView_attributeSyscallName, value.unboxStr());
                                    }
                                }
                            }
                        }
                        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
                        }
                        catch (StateSystemDisposedException stateSystemDisposedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return retMap;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (this.fColorGray == null) {
            this.fColorGray = gc.getDevice().getSystemColor(15);
        }
        if (this.fColorWhite == null) {
            this.fColorWhite = gc.getDevice().getSystemColor(1);
        }
        if (this.fAverageCharWidth == null) {
            this.fAverageCharWidth = gc.getFontMetrics().getAverageCharWidth();
        }
        ITmfTimeGraphDrawingHelper drawingHelper = this.getDrawingHelper();
        if (bounds.width <= this.fAverageCharWidth) {
            return;
        }
        if (!(event instanceof TimeEvent)) {
            return;
        }
        TimeEvent tcEvent = (TimeEvent)event;
        if (!tcEvent.hasValue()) {
            return;
        }
        ResourcesEntry entry = (ResourcesEntry)event.getEntry();
        if (!entry.getType().equals((Object)ResourcesEntry.Type.CPU)) {
            return;
        }
        int status = tcEvent.getValue();
        if (status != 2 && status != 4) {
            return;
        }
        ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)entry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ss == null) {
            return;
        }
        long time = event.getTime();
        try {
            while (time < event.getTime() + event.getDuration()) {
                int cpuQuark = entry.getQuark();
                int currentThreadQuark = ss.getQuarkRelative(cpuQuark, new String[]{"Current_thread"});
                ITmfStateInterval tidInterval = ss.querySingleState(time, currentThreadQuark);
                long startTime = Math.max(tidInterval.getStartTime(), event.getTime());
                int x = Math.max(drawingHelper.getXForTime(startTime), bounds.x);
                if (x < bounds.x + bounds.width) {
                    if (!tidInterval.getStateValue().isNull()) {
                        int width;
                        ITmfStateValue value = tidInterval.getStateValue();
                        int currentThreadId = value.unboxInt();
                        long endTime = Math.min(tidInterval.getEndTime() + 1L, event.getTime() + event.getDuration());
                        int xForEndTime = drawingHelper.getXForTime(endTime);
                        if (xForEndTime > bounds.x && (width = Math.min(xForEndTime, bounds.x + bounds.width) - x - 1) > 0) {
                            String attribute = null;
                            int beginIndex = 0;
                            if (status == 2 && (long)currentThreadId != this.fLastThreadId) {
                                attribute = "Exec_name";
                            } else if (status == 4) {
                                attribute = "System_call";
                                ITmfTrace trace = entry.getTrace();
                                if (trace instanceof IKernelTrace) {
                                    IKernelAnalysisEventLayout layout = ((IKernelTrace)trace).getKernelEventLayout();
                                    beginIndex = layout.eventSyscallEntryPrefix().length();
                                }
                            }
                            if (attribute != null) {
                                int quark = ss.optQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), attribute});
                                if (quark == -2) {
                                    return;
                                }
                                ITmfStateInterval interval = ss.querySingleState(time, quark);
                                if (!interval.getStateValue().isNull()) {
                                    value = interval.getStateValue();
                                    gc.setForeground(this.fColorWhite);
                                    int drawn = Utils.drawText((GC)gc, (String)value.unboxStr().substring(beginIndex), (int)(x + 1), (int)bounds.y, (int)width, (int)bounds.height, (boolean)true, (boolean)true);
                                    if (drawn > 0 && status == 2) {
                                        this.fLastThreadId = currentThreadId;
                                    }
                                }
                            }
                            if (xForEndTime < bounds.x + bounds.width) {
                                gc.setForeground(this.fColorGray);
                                gc.drawLine(xForEndTime, bounds.y + 1, xForEndTime, bounds.y + bounds.height - 2);
                            }
                        }
                    }
                    time = Math.max(tidInterval.getEndTime() + 1L, drawingHelper.getTimeAtX(x + 1));
                    continue;
                }
                break;
            }
        }
        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    public void postDrawEntry(ITimeGraphEntry entry, Rectangle bounds, GC gc) {
        this.fLastThreadId = -1L;
    }
}

