/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowView;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesView;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTestBase;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramView;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ImportAndReadKernelSmokeTest
extends KernelTestBase {
    private static final @NonNull Set<Map.Entry<String, Set<String>>> EXPECTED_ANALYSES;
    private ITmfEvent fDesired1;
    private ITmfEvent fDesired2;

    static {
        HashMap<String, Set<Object>> map = new HashMap<String, Set<Object>>();
        map.put("Input/Output", Collections.emptySet());
        map.put("Tmf Statistics", (Set<Object>)ImmutableSet.of((Object)"org.eclipse.linuxtools.tmf.statistics.totals", (Object)"org.eclipse.linuxtools.tmf.statistics.types"));
        map.put("Active Thread", Collections.singleton("org.eclipse.tracecompass.analysis.os.linux.kernel.tid"));
        map.put("Linux Kernel", Collections.singleton("org.eclipse.tracecompass.analysis.os.linux.kernel"));
        map.put("Context switch", Collections.emptySet());
        map.put("Kernel memory usage", Collections.emptySet());
        map.put("CPU usage", Collections.singleton("org.eclipse.tracecompass.analysis.os.linux.cpuusage"));
        map.put("XML Futex Contention Analysis", Collections.emptySet());
        map.put("XML IRQ Analysis", Collections.emptySet());
        EXPECTED_ANALYSES = map.entrySet();
    }

    @Test
    public void test() {
        CtfTmfTrace trace = CtfTmfTestTraceUtils.getSyntheticTrace();
        try {
            Matcher matcher = WidgetMatcherFactory.withPartName((String)trace.getName());
            IEditorPart iep = ((IEditorReference)fBot.editor(matcher).getReference()).getEditor(true);
            final TmfEventsEditor tmfEd = (TmfEventsEditor)iep;
            this.fDesired1 = ImportAndReadKernelSmokeTest.getEvent(trace, 100);
            this.fDesired2 = ImportAndReadKernelSmokeTest.getEvent(trace, 10000);
            UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

                public void run() {
                    tmfEd.setFocus();
                    tmfEd.selectionChanged(new SelectionChangedEvent((ISelectionProvider)tmfEd, (ISelection)new StructuredSelection((Object)ImportAndReadKernelSmokeTest.this.fDesired1)));
                }
            });
            this.testHV(ImportAndReadKernelSmokeTest.getViewPart("Histogram"));
            ImportAndReadKernelSmokeTest.testCFV((ControlFlowView)ImportAndReadKernelSmokeTest.getViewPart("Control Flow"));
            ImportAndReadKernelSmokeTest.testRV((ResourcesView)ImportAndReadKernelSmokeTest.getViewPart("Resources"));
            ImportAndReadKernelSmokeTest.testStateSystemExplorer(trace.getPath());
        }
        finally {
            trace.dispose();
        }
    }

    private static void testCFV(ControlFlowView vp) {
        Assert.assertNotNull((Object)vp);
    }

    private void testHV(IViewPart vp) {
        SWTBotView hvBot = new SWTWorkbenchBot().viewById("org.eclipse.linuxtools.tmf.ui.views.histogram");
        List hvTools = hvBot.getToolbarButtons();
        for (SWTBotToolbarButton hvTool : hvTools) {
            if (!hvTool.getToolTipText().toLowerCase().contains("lost")) continue;
            hvTool.click();
        }
        HistogramView hv = (HistogramView)vp;
        TmfSelectionRangeUpdatedSignal signal = new TmfSelectionRangeUpdatedSignal((Object)hv, this.fDesired1.getTimestamp());
        TmfSelectionRangeUpdatedSignal signal2 = new TmfSelectionRangeUpdatedSignal((Object)hv, this.fDesired2.getTimestamp());
        hvBot.close();
        hv = (HistogramView)UIThreadRunnable.syncExec(() -> {
            try {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.tmf.ui.views.histogram");
            }
            catch (PartInitException partInitException) {
                return null;
            }
        });
        Assert.assertNotNull((Object)hv);
        hvBot = new SWTWorkbenchBot().viewById("org.eclipse.linuxtools.tmf.ui.views.histogram");
        hv.updateTimeRange(100000L);
        WaitUtils.waitForJobs();
        hv.selectionRangeUpdated(signal);
        hv.broadcast((TmfSignal)signal);
        WaitUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
        hv.updateTimeRange(1000000000L);
        WaitUtils.waitForJobs();
        hv.selectionRangeUpdated(signal2);
        hv.broadcast((TmfSignal)signal2);
        WaitUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
        Assert.assertNotNull((Object)hv);
    }

    private static void testRV(ResourcesView vp) {
        Assert.assertNotNull((Object)vp);
    }

    private static CtfTmfEvent getEvent(CtfTmfTrace trace, int rank) {
        ITmfContext ctx = trace.seekEvent(0L);
        int i = 0;
        while (i < rank) {
            trace.getNext(ctx);
            ++i;
        }
        return trace.getNext(ctx);
    }

    private static IViewPart getViewPart(final String viewTile) {
        final IViewPart[] vps = new IViewPart[1];
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IViewReference[] viewRefs;
                IViewReference[] iViewReferenceArray = viewRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
                int n = viewRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    IViewPart vp = viewRef.getView(true);
                    if (vp.getTitle().equals(viewTile)) {
                        vps[0] = vp;
                        return;
                    }
                    ++n2;
                }
            }
        });
        return vps[0];
    }

    private static void testStateSystemExplorer(String tracePath) {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.openView((String)"org.eclipse.tracecompass.analysis.os.linux.views.cpuusage");
        SWTBotView cpuUsageBot = bot.viewById("org.eclipse.tracecompass.analysis.os.linux.views.cpuusage");
        SWTBotUtils.openView((String)"org.eclipse.linuxtools.tmf.ui.views.ssvisualizer");
        SWTBotView sseBot = bot.viewByTitle("State System Explorer");
        sseBot.show();
        Assert.assertTrue((String)"Wrong state systems", (boolean)ImportAndReadKernelSmokeTest.getSsNames(sseBot).containsAll(EXPECTED_ANALYSES));
        sseBot.close();
        SWTBotUtils.openView((String)"org.eclipse.linuxtools.tmf.ui.views.ssvisualizer");
        sseBot = bot.viewByTitle("State System Explorer");
        sseBot.show();
        Assert.assertTrue((String)"Wrong state systems", (boolean)ImportAndReadKernelSmokeTest.getSsNames(sseBot).containsAll(EXPECTED_ANALYSES));
        bot.closeAllEditors();
        bot.waitUntil(Conditions.treeHasRows((SWTBotTree)sseBot.bot().tree(), (int)0));
        SWTBotUtils.openTrace((String)"test", (String)tracePath, (String)"org.eclipse.linuxtools.lttng2.kernel.tracetype");
        Assert.assertTrue((String)("Wrong state systems: expected: " + EXPECTED_ANALYSES + ", actual: " + ImportAndReadKernelSmokeTest.getSsNames(sseBot)), (boolean)ImportAndReadKernelSmokeTest.getSsNames(sseBot).containsAll(EXPECTED_ANALYSES));
        sseBot.close();
        cpuUsageBot.close();
    }

    private static @NonNull Set< @NonNull Map.Entry<String, Set<String>>> getSsNames(SWTBotView bot) {
        SWTBotTimeGraph timeGraph = new SWTBotTimeGraph(bot.bot());
        SWTBotTimeGraphEntry trace = timeGraph.getEntry(new String[]{"synthetic-trace"});
        SWTBotTimeGraphEntry[] modules = trace.getEntries();
        HashMap modulesToStateSystems = new HashMap();
        SWTBotTimeGraphEntry[] sWTBotTimeGraphEntryArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTimeGraphEntry module = sWTBotTimeGraphEntryArray[n2];
            HashSet<String> stateSystems = new HashSet<String>();
            SWTBotTimeGraphEntry[] sWTBotTimeGraphEntryArray2 = module.getEntries();
            int n3 = sWTBotTimeGraphEntryArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                SWTBotTimeGraphEntry stateSystem = sWTBotTimeGraphEntryArray2[n4];
                stateSystems.add(stateSystem.getText());
                ++n4;
            }
            modulesToStateSystems.put(module.getText(), stateSystems);
            ++n2;
        }
        return modulesToStateSystems.entrySet();
    }
}

