/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.packet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ethernet2.EthernetIIPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class BadPacketTest {
    private ByteBuffer fEthernetPacket;

    @Before
    public void initialize() {
        this.fEthernetPacket = ByteBuffer.allocate(8);
        this.fEthernetPacket.order(ByteOrder.BIG_ENDIAN);
        this.fEthernetPacket.put((byte)52);
        this.fEthernetPacket.put((byte)103);
        this.fEthernetPacket.put((byte)12);
        this.fEthernetPacket.put((byte)-46);
        this.fEthernetPacket.put((byte)-111);
        this.fEthernetPacket.put((byte)81);
        this.fEthernetPacket.put((byte)16);
        this.fEthernetPacket.put((byte)-8);
        this.fEthernetPacket.flip();
    }

    @Test(expected=BadPacketException.class)
    public void PacketExceptionTest() throws BadPacketException, IOException, BadPcapFileException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapFile dummy = new PcapFile(trace.getPath());){
            ByteBuffer packet = this.fEthernetPacket;
            if (packet != null) {
                new EthernetIIPacket(dummy, null, packet);
            }
            Assert.fail((String)"PacketExceptionTest has failed!");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

