/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.model;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment.TmfXmlPatternSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stubs.PatternSegmentFactoryStub;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XmlSegmentTest {
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace5.xml";
    ITmfTrace fTrace;
    XmlPatternAnalysis fModule;

    @Before
    public void setUp() throws TmfAnalysisException {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
        @NonNull XmlPatternAnalysis module = XmlUtilsTest.initializePatternModule(TmfXmlTestFiles.CONSUMING_FSM_TEST);
        module.setTrace(trace);
        module.schedule();
        module.waitForCompletion();
        this.fTrace = trace;
        this.fModule = module;
    }

    @After
    public void cleanUp() {
        this.fTrace.dispose();
        this.fModule.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testMappingGroup() {
        XmlPatternAnalysis module = this.fModule;
        Assert.assertNotNull((Object)module);
        @Nullable @NonNull ISegmentStore ss = module.getSegmentStore();
        Assert.assertNotNull((Object)ss);
        Assert.assertEquals((String)"Segment store size", (long)1L, (long)ss.size());
        Object segment = ss.toArray()[0];
        Assert.assertTrue((boolean)(segment instanceof TmfXmlPatternSegment));
        XmlUtilsTest.testPatternSegmentData(PatternSegmentFactoryStub.TEST_3, (TmfXmlPatternSegment)segment);
    }
}

