/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.stateprovider.XmlStateSystemModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class XmlProviderTestBase {
    private ITmfTrace fTrace;
    private TmfAbstractAnalysisModule fModule;

    @Before
    public void setupTest() {
        CtfTmfTrace trace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)this.getTestTrace());
        this.fTrace = trace;
        Document doc = this.getXmlFile().getXmlDocument();
        Assert.assertNotNull((Object)doc);
        NodeList analysisNodes = doc.getElementsByTagName(this.getAnalysisNodeName());
        Element node = (Element)analysisNodes.item(0);
        switch (this.getAnalysisNodeName()) {
            case "pattern": {
                this.fModule = new XmlPatternAnalysis();
                ((XmlPatternAnalysis)this.fModule).setXmlFile(this.getXmlFile().getFile().toPath());
                break;
            }
            case "stateProvider": {
                this.fModule = new XmlStateSystemModule();
                ((XmlStateSystemModule)this.fModule).setXmlFile(this.getXmlFile().getFile().toPath());
                break;
            }
            default: {
                Assert.fail();
            }
        }
        String moduleId = node.getAttribute("id");
        Assert.assertNotNull((Object)moduleId);
        this.fModule.setId(moduleId);
        try {
            this.fModule.setTrace((ITmfTrace)trace);
            this.fModule.schedule();
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)("Cannot set trace " + e.getMessage()));
        }
    }

    @After
    public void cleanup() {
        this.fModule.dispose();
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)this.getTestTrace());
    }

    protected abstract @NonNull String getAnalysisNodeName();

    protected abstract TmfXmlTestFiles getXmlFile();

    protected abstract @NonNull CtfTestTrace getTestTrace();

    protected ITmfTrace getTrace() {
        return this.fTrace;
    }

    @Test
    public void testStateSystem() {
        Assert.assertTrue((boolean)(this.fModule instanceof ITmfAnalysisModuleWithStateSystems));
        Assert.assertTrue((boolean)this.fModule.waitForCompletion((IProgressMonitor)new NullProgressMonitor()));
        ITmfStateSystem ss = ((ITmfAnalysisModuleWithStateSystems)this.fModule).getStateSystem(this.fModule.getId());
        Assert.assertNotNull((Object)ss);
        List quarks = ss.getQuarks(new String[]{"*"});
        Assert.assertFalse((boolean)quarks.isEmpty());
    }

    protected TmfAbstractAnalysisModule getModule() {
        return this.fModule;
    }
}

