/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.latency;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBotAssert;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency.PatternScatterGraphView;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.latency.PatternLatencyViewTestBase;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.swtchart.Chart;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.Range;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class PatternScatterChartViewTest
extends PatternLatencyViewTestBase {
    private static final String VIEW_ID = "org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.scattergraph";
    private static final String VIEW_TITLE = "Latency vs Time";
    private Chart fScatterChart;

    private void setChart() {
        SWTBotView viewBot = fBot.viewById(VIEW_ID);
        final IViewReference viewReference = viewBot.getViewReference();
        IViewPart viewPart = (IViewPart)UIThreadRunnable.syncExec((Result)new Result<IViewPart>(){

            public IViewPart run() {
                return viewReference.getView(true);
            }
        });
        Assert.assertNotNull((Object)viewPart);
        if (!(viewPart instanceof PatternScatterGraphView)) {
            Assert.fail((String)"Could not instanciate view");
        }
        this.fScatterChart = (Chart)viewBot.bot().widget(WidgetOfType.widgetOfType(Chart.class));
        Assert.assertNotNull((Object)this.fScatterChart);
    }

    @Test
    public void testWithTrace() {
        this.setChart();
        WaitUtils.waitForJobs();
        Chart scatterChart = this.fScatterChart;
        Assert.assertNotNull((Object)scatterChart);
        fBot.waitUntil(ConditionHelpers.numberOfSeries((Chart)scatterChart, (int)1));
        SWTBotChart chartBot = new SWTBotChart(scatterChart);
        SWTBotAssert.assertVisible((AbstractSWTBot)chartBot);
        Range range = scatterChart.getAxisSet().getXAxes()[0].getRange();
        Assert.assertEquals((double)1.0E8, (double)(range.upper - range.lower), (double)0.0);
        ISeriesSet seriesSet = this.fScatterChart.getSeriesSet();
        Assert.assertNotNull((Object)seriesSet);
        ISeries[] series = seriesSet.getSeries();
        Assert.assertNotNull((Object)series);
        Assert.assertEquals((long)1L, (long)series.length);
        Assert.assertTrue((series[0].getXSeries().length > 0 ? 1 : 0) != 0);
    }

    @Override
    protected String getViewId() {
        return VIEW_ID;
    }

    @Override
    protected String getViewTitle() {
        return VIEW_TITLE;
    }

    private static class SWTBotChart
    extends AbstractSWTBotControl<Chart> {
        public SWTBotChart(Chart w) throws WidgetNotFoundException {
            super((Control)w);
        }
    }
}

