/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis.requirements;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAnalysisEventFieldRequirement;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AnalysisEventFieldRequirementTest {
    private static final @NonNull String EVENT1 = "abc";
    private static final @NonNull String EVENT2 = "def";
    private static final @NonNull String EVENT3 = "ghi";
    private static final @NonNull String EVENT1_FIELD1 = "mno";
    private static final @NonNull String EVENT1_FIELD2 = "pqr";
    private static final @NonNull String EVENT2_FIELD1 = "stu";
    private static final @NonNull String EVENT2_FIELD2 = "vwx";
    private static final @NonNull String EVENT_FIELD = "bla";
    private final @NonNull TmfTrace trace = new TraceWithEvents();

    @After
    public void cleanup() {
        this.trace.dispose();
    }

    @Test
    public void testOptionalRequirements() {
        TmfAnalysisEventFieldRequirement req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1));
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2));
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement("", (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2));
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)NonNullUtils.checkNotNull((Object)Collections.EMPTY_LIST));
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement("", (Collection)NonNullUtils.checkNotNull((Object)Collections.EMPTY_LIST));
        Assert.assertTrue((boolean)req.test((Object)this.trace));
    }

    @Test
    public void testMandatoryRequirements() {
        TmfAnalysisEventFieldRequirement req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT3, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertFalse((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2, (Object)EVENT_FIELD), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertFalse((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement("", (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement("", (Collection)ImmutableSet.of((Object)EVENT2_FIELD1), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertFalse((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)NonNullUtils.checkNotNull((Object)Collections.EMPTY_LIST));
        Assert.assertTrue((boolean)req.test((Object)this.trace));
    }

    @Test
    public void testAtLeastOneRequirements() {
        TmfAnalysisEventFieldRequirement req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT3, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertFalse((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2, (Object)EVENT_FIELD), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement("", (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT2_FIELD2), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement("", (Collection)ImmutableSet.of((Object)EVENT2_FIELD1), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertFalse((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)NonNullUtils.checkNotNull((Object)Collections.EMPTY_LIST), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
    }

    @Test
    public void testAllOrNothingRequirements() {
        TmfAnalysisEventFieldRequirement req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT3, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT1_FIELD2, (Object)EVENT_FIELD), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertFalse((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement("", (Collection)ImmutableSet.of((Object)EVENT1_FIELD1, (Object)EVENT2_FIELD2), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertFalse((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement("", (Collection)ImmutableSet.of((Object)EVENT1_FIELD1), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)NonNullUtils.checkNotNull((Object)Collections.EMPTY_LIST), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)this.trace));
    }

    @Test
    public void testNoPreDefinedEvents() {
        TmfTraceStub traceNoEvents = new TmfTraceStub();
        TmfAnalysisEventFieldRequirement req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertTrue((boolean)req.test((Object)traceNoEvents));
        req = new TmfAnalysisEventFieldRequirement(EVENT1, (Collection)ImmutableSet.of((Object)EVENT1_FIELD1), TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
        Assert.assertTrue((boolean)req.test((Object)traceNoEvents));
        traceNoEvents.dispose();
    }

    private static class TraceWithEvents
    extends TmfTraceStub
    implements ITmfTraceWithPreDefinedEvents {
        private TraceWithEvents() {
        }

        public @NonNull Set<? extends @NonNull ITmfEventType> getContainedEventTypes() {
            return ImmutableSet.of((Object)new ITmfEventType(){

                public @NonNull String getName() {
                    return AnalysisEventFieldRequirementTest.EVENT1;
                }

                public ITmfEventField getRootField() {
                    return null;
                }

                public Collection<String> getFieldNames() {
                    return ImmutableSet.of((Object)AnalysisEventFieldRequirementTest.EVENT1_FIELD1, (Object)AnalysisEventFieldRequirementTest.EVENT1_FIELD2);
                }
            }, (Object)new ITmfEventType(){

                public @NonNull String getName() {
                    return AnalysisEventFieldRequirementTest.EVENT2;
                }

                public ITmfEventField getRootField() {
                    return null;
                }

                public Collection<String> getFieldNames() {
                    return ImmutableSet.of((Object)AnalysisEventFieldRequirementTest.EVENT1_FIELD1, (Object)AnalysisEventFieldRequirementTest.EVENT1_FIELD2);
                }
            }, (Object)new ITmfEventType(){

                public @NonNull String getName() {
                    return AnalysisEventFieldRequirementTest.EVENT2;
                }

                public ITmfEventField getRootField() {
                    return null;
                }

                public Collection<String> getFieldNames() {
                    return ImmutableSet.of((Object)AnalysisEventFieldRequirementTest.EVENT2_FIELD1, (Object)AnalysisEventFieldRequirementTest.EVENT2_FIELD2);
                }
            });
        }
    }
}

