/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.analysis;

import java.io.File;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestStateSystemProvider;

@NonNullByDefault
public class TestStateSystemModule
extends TmfStateSystemAnalysisModule {
    private final boolean fOnDisk;
    private boolean fThrottleEvents = false;
    private @Nullable TestStateSystemProvider fProvider = null;
    private Function<ITmfEvent, ITmfEvent> fRequestAction = e -> e;

    public TestStateSystemModule() {
        this(false);
    }

    public TestStateSystemModule(boolean onDisk) {
        this.fOnDisk = onDisk;
    }

    protected ITmfStateProvider createStateProvider() {
        TestStateSystemProvider provider;
        this.fProvider = provider = new TestStateSystemProvider((ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace()));
        boolean throttle = this.fThrottleEvents;
        provider.setThrottling(throttle);
        return provider;
    }

    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return this.fOnDisk ? TmfStateSystemAnalysisModule.StateSystemBackendType.FULL : TmfStateSystemAnalysisModule.StateSystemBackendType.INMEM;
    }

    public String getBackendName() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.INMEM.name();
    }

    public void setPerEventSignalling(boolean throttleEvent) {
        this.fThrottleEvents = throttleEvent;
        TestStateSystemProvider provider = this.fProvider;
        if (provider != null) {
            provider.setThrottling(throttleEvent);
        }
    }

    public void signalNextEvent() {
        TestStateSystemProvider provider = this.fProvider;
        if (provider != null) {
            provider.signalNextEvent();
        }
    }

    public @Nullable File getSsFile() {
        return super.getSsFile();
    }

    public void setRequestAction(Function<ITmfEvent, ITmfEvent> requestAction) {
        this.fRequestAction = requestAction;
    }

    protected @NonNull ITmfEventRequest createEventRequest(@NonNull ITmfStateProvider stateProvider, @NonNull TmfTimeRange timeRange, int nbRead) {
        return new TestStateSystemRequest(stateProvider, timeRange, nbRead, this.fRequestAction);
    }

    private class TestStateSystemRequest
    extends TmfStateSystemAnalysisModule.StateSystemEventRequest {
        private final Function<ITmfEvent, ITmfEvent> fAction;

        public TestStateSystemRequest(ITmfStateProvider sp, TmfTimeRange timeRange, int index, Function<ITmfEvent, ITmfEvent> requestAction) {
            super((TmfStateSystemAnalysisModule)TestStateSystemModule.this, sp, timeRange, index);
            this.fAction = requestAction;
        }

        public void handleData(ITmfEvent event) {
            ITmfEvent ev = (ITmfEvent)NonNullUtils.checkNotNull((Object)this.fAction.apply(event));
            super.handleData(ev);
        }
    }
}

