/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class CollapseEventsInTableTest {
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String COLLAPSE_TRACE_NAME = "syslog_collapse";
    private static final String COLLAPSE_TRACE_PATH = "testfiles/syslog_collapse";
    private static final String COLLAPSE_TRACE_TYPE = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static File fTestFile = null;
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(COLLAPSE_TRACE_PATH), null);
        try {
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            fTestFile = new File(uri);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            Assert.fail();
        }
        Assume.assumeTrue((boolean)fTestFile.exists());
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "MMM d HH:mm:ss");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", "");
        TmfTimestampFormat.updateDefaultFormats();
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("Welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void tearDown() {
        fLogger.removeAllAppenders();
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "HH:mm:ss");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", "SSS SSS SSS");
        TmfTimestampFormat.updateDefaultFormats();
    }

    @Test
    public void test() {
        SWTBotUtils.createProject(TRACE_PROJECT_NAME);
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, fTestFile.getAbsolutePath(), COLLAPSE_TRACE_TYPE);
        SWTBotEditor editorBot = SWTBotUtils.activateEditor(fBot, fTestFile.getName());
        SWTBotTable tableBot = editorBot.bot().table();
        SWTBotUtils.maximize(editorBot.getReference(), tableBot);
        tableBot.click(1, 0);
        SWTBotMenu menuBot = tableBot.contextMenu("Collapse Events");
        menuBot.click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled(tableBot, "7/22", 1, 1));
        String cell = tableBot.cell(1, 1);
        Assert.assertEquals((String)"filterString", (Object)"7/22", (Object)cell);
        cell = tableBot.cell(7, 0);
        Assert.assertEquals((String)"1st repeatCount", (Object)"+14", (Object)cell);
        cell = tableBot.cell(7, 1);
        Assert.assertEquals((String)"1st Timestamp", (Object)"Jan 1 06:06:06", (Object)cell);
        cell = tableBot.cell(7, 2);
        Assert.assertEquals((String)"1st Host", (Object)"HostF", (Object)cell);
        cell = tableBot.cell(7, 3);
        Assert.assertEquals((String)"1st Logger", (Object)"LoggerF", (Object)cell);
        cell = tableBot.cell(7, 4);
        Assert.assertEquals((String)"1st File", (Object)"SourceFile", (Object)cell);
        cell = tableBot.cell(7, 5);
        Assert.assertEquals((String)"1st Line", (Object)"9", (Object)cell);
        cell = tableBot.cell(7, 6);
        Assert.assertEquals((String)"1st Message", (Object)"Message F", (Object)cell);
        cell = tableBot.cell(8, 0);
        Assert.assertEquals((String)"2nd repeatCount", (Object)"+1", (Object)cell);
        cell = tableBot.cell(8, 1);
        Assert.assertEquals((String)"2nd Timestamp", (Object)"Jan 1 06:06:21", (Object)cell);
        cell = tableBot.cell(8, 2);
        Assert.assertEquals((String)"2nd Host", (Object)"HostF", (Object)cell);
        cell = tableBot.cell(8, 3);
        Assert.assertEquals((String)"2nd Logger", (Object)"LoggerF", (Object)cell);
        cell = tableBot.cell(8, 4);
        Assert.assertEquals((String)"2nd File", (Object)"SourceFile", (Object)cell);
        cell = tableBot.cell(8, 5);
        Assert.assertEquals((String)"2nd Line", (Object)"10", (Object)cell);
        cell = tableBot.cell(8, 6);
        Assert.assertEquals((String)"2nd Message", (Object)"Message D", (Object)cell);
        menuBot = tableBot.contextMenu("Clear Filters");
        menuBot.click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled(tableBot, "Jan 1 01:01:01", 1, 1));
        Assert.assertEquals((String)"Timestamp", (Object)"Jan 1 01:01:01", (Object)tableBot.cell(1, 1));
        SWTBotUtils.maximize(editorBot.getReference(), tableBot);
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject(TRACE_PROJECT_NAME, fBot);
    }
}

