/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.views;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ImageHelper;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.StubPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.TimeGraphViewStub;
import org.eclipse.ui.IWorkbenchPart;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TimeGraphViewTest {
    private static final Logger fLogger = Logger.getRootLogger();
    private static final RGB BLACK = new RGB(0, 0, 0);
    private static final int MIN_FILE_SIZE = 1000;
    private static final String SHOW_LEGEND = "Show Legend";
    private static final String LEGEND_NAME = "States Transition Visualizer";
    private static final String OK_BUTTON = "OK";
    private static final String EXPORT_MENU = "Export...";
    private static final String EXTENSION = ".png";
    private static final String REFERENCE_LOC = "reference";
    private static final String SKINNY_LOC = "skinny";
    private static final String RESET_LOC = "reset";
    private SWTBotView fViewBot;
    private TmfTraceStub fTrace;
    private Rectangle fBounds;
    private final ICondition fTimeGraphIsDirty = new ConditionHelper(this){

        public boolean test() throws Exception {
            SWTBotView viewBot = fViewBot;
            if (viewBot == null) {
                return false;
            }
            return this.getView().isDirty();
        }
    };

    private static void resetViews() {
        SWTBotUtils.switchToTracingPerspective();
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        bot.closeAllEditors();
        SWTBotUtils.closeView("welcome", bot);
    }

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        TimeGraphViewTest.resetViews();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new NullAppender());
    }

    @Before
    public void before() throws TmfTraceException {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        bot.closeAllEditors();
        for (SWTBotView viewBot : bot.views()) {
            viewBot.close();
        }
        SWTBotUtils.openView("org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.timegraph.stub");
        this.fViewBot = bot.viewById("org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.timegraph.stub");
        this.fViewBot.show();
        this.fTrace = new TmfTraceStub(){

            public @NonNull String getName() {
                return "Stub";
            }

            public TmfContext seekEvent(ITmfLocation location) {
                return new TmfContext();
            }
        };
        this.fTrace.setStartTime(TmfTimestamp.fromNanos((long)0L));
        this.fTrace.setEndTime(TmfTimestamp.fromNanos((long)180L));
        TmfTraceStub trace = this.fTrace;
        trace.initialize(null, "", ITmfEvent.class);
        Assert.assertNotNull((Object)trace);
        SWTBotTimeGraph tgBot = new SWTBotTimeGraph(this.fViewBot.bot());
        this.fViewBot.bot().waitUntil((ICondition)new TgConditionHelper(t -> tgBot.getEntries().length == 0));
        this.fBounds = this.getBounds();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        this.fViewBot.bot().waitUntil((ICondition)new TgConditionHelper(t -> tgBot.getEntries().length >= 2));
        this.resetTimeRange(bot);
        bot.waitUntil((ICondition)new TgConditionHelper(t -> this.fViewBot.bot().slider().getThumb() > 1));
    }

    private void resetTimeRange(SWTWorkbenchBot bot) {
        TmfTimeRange fullTimeRange = this.fTrace.getTimeRange();
        TmfTimeRange smallerRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)20L), TmfTimestamp.fromNanos((long)100L));
        TmfWindowRangeUpdatedSignal signal = new TmfWindowRangeUpdatedSignal((Object)this, smallerRange);
        TimeGraphViewStub view = this.getView();
        bot.waitUntil((ICondition)new TgConditionHelper(t -> {
            if (smallerRange.equals((Object)view.getWindowRange())) {
                return true;
            }
            TmfSignalManager.dispatchSignal((TmfSignal)signal);
            return false;
        }));
        bot.waitUntil((ICondition)new TgConditionHelper(t -> {
            if (fullTimeRange.equals((Object)view.getWindowRange())) {
                return true;
            }
            this.fViewBot.toolbarButton("Reset the Time Scale to Default").click();
            return false;
        }));
    }

    private Rectangle getBounds() {
        Rectangle bounds = (Rectangle)UIThreadRunnable.syncExec(() -> {
            Control control = (Control)this.fViewBot.getWidget();
            Rectangle ctrlRelativeBounds = control.getBounds();
            Point res = control.toDisplay(new Point(0, 0));
            ctrlRelativeBounds.x = res.x;
            ctrlRelativeBounds.y = res.y;
            return ctrlRelativeBounds;
        });
        return bounds;
    }

    private TimeGraphViewStub getView() {
        IWorkbenchPart part = this.fViewBot.getViewReference().getPart(true);
        Assert.assertTrue((String)part.getClass().getCanonicalName(), (boolean)(part instanceof TimeGraphViewStub));
        TimeGraphViewStub stubView = (TimeGraphViewStub)part;
        return stubView;
    }

    @After
    public void after() {
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotShell legendShell = bot.shell(LEGEND_NAME);
        SWTBot legendBot = legendShell.bot();
        int i = 0;
        while (i < StubPresentationProvider.STATES.length) {
            legendBot.button(i).click();
            ++i;
        }
        legendBot.button(OK_BUTTON).click();
        TmfTraceStub trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceClosedSignal((Object)this, (ITmfTrace)trace));
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.fViewBot.close();
        bot.waitUntil(ConditionHelpers.ViewIsClosed(this.fViewBot));
        this.fTrace.dispose();
    }

    @AfterClass
    public static void afterClass() {
        TimeGraphViewTest.resetViews();
        fLogger.removeAllAppenders();
    }

    @Ignore
    @Test
    public void testLegendArrow() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.resetTimeRange(bot);
        Rectangle bounds = this.fBounds;
        ImageHelper ref = ImageHelper.grabImage(bounds);
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        SWTBotShell legendShell = bot.shell(LEGEND_NAME);
        legendShell.activate();
        SWTBot legendBot = legendShell.bot();
        legendBot.scale(5).setValue(100);
        legendShell.bot().button(OK_BUTTON).click();
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange(bot);
        ImageHelper skinny = ImageHelper.waitForNewImage(bounds, ref);
        ImageHelper delta = ref.diff(skinny);
        Set<RGB> changedValues = TimeGraphViewTest.getTop3ColorSet(delta);
        Assert.assertTrue((String)("Color of \"\"LASER\"\" did not get change despite change of width, " + Multisets.copyHighestCountFirst(delta.getHistogram()).entrySet()), (boolean)changedValues.contains(new RGB(255, 255, 128)));
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        legendShell = bot.shell(LEGEND_NAME);
        legendBot = legendShell.bot();
        legendBot.button(5).click();
        legendBot.button(OK_BUTTON).click();
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange(bot);
        ImageHelper reset = ImageHelper.waitForNewImage(bounds, skinny);
        delta = ref.diff(reset);
        Set<RGB> result = TimeGraphViewTest.getFilteredColorSetOfImage(delta, 50);
        Assert.assertEquals(Collections.singleton(BLACK), result);
    }

    @Ignore
    @Test
    public void testLegend() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.resetTimeRange(bot);
        Rectangle bounds = this.fBounds;
        ImageHelper ref = ImageHelper.grabImage(bounds);
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        SWTBotShell legendShell = bot.shell(LEGEND_NAME);
        legendShell.activate();
        SWTBot legendBot = legendShell.bot();
        legendBot.scale(2).setValue(25);
        legendShell.bot().button(OK_BUTTON).click();
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange(bot);
        ImageHelper skinny = ImageHelper.waitForNewImage(bounds, ref);
        ImageHelper delta = ref.diff(skinny);
        Set<RGB> changedValues = TimeGraphViewTest.getFilteredColorSetOfImage(delta, 0);
        Assert.assertTrue((String)("Color of \"HAIR\" did not get change despite change of width, " + Multisets.copyHighestCountFirst(delta.getHistogram())), (boolean)changedValues.contains(new RGB(255, 255, 129)));
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        legendShell = bot.shell(LEGEND_NAME);
        legendBot = legendShell.bot();
        legendBot.button(2).click();
        legendBot.button(OK_BUTTON).click();
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange(bot);
        ImageHelper reset = ImageHelper.waitForNewImage(bounds, skinny);
        delta = ref.diff(reset);
        Set<RGB> result = TimeGraphViewTest.getFilteredColorSetOfImage(delta, 50);
        Assert.assertEquals(Collections.singleton(BLACK), result);
    }

    @Test
    public void testExport() throws IOException {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.resetTimeRange(bot);
        File ref = File.createTempFile(REFERENCE_LOC, EXTENSION);
        File skinny = File.createTempFile(SKINNY_LOC, EXTENSION);
        File reset = File.createTempFile(RESET_LOC, EXTENSION);
        ref.deleteOnExit();
        skinny.deleteOnExit();
        reset.deleteOnExit();
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{ref.getAbsolutePath()});
        this.fViewBot.viewMenu(EXPORT_MENU).click();
        ImageHelper refImage = ImageHelper.fromFile(ref);
        bot.waitUntil((ICondition)new FileWritten(ref, 1000));
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        SWTBotShell legendShell = bot.shell(LEGEND_NAME);
        legendShell.activate();
        SWTBot legendBot = legendShell.bot();
        legendBot.scale(2).setValue(50);
        legendShell.bot().button(OK_BUTTON).click();
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange(bot);
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{skinny.getAbsolutePath()});
        this.fViewBot.viewMenu(EXPORT_MENU).click();
        ImageHelper skinnyImage = ImageHelper.fromFile(skinny);
        bot.waitUntil((ICondition)new FileWritten(skinny, 1000));
        ImageHelper delta = refImage.diff(skinnyImage);
        Set<RGB> changedValues = TimeGraphViewTest.getTop3ColorSet(delta);
        Assert.assertTrue((String)("Color of \"HAIR\" did not get change despite change of width, " + Multisets.copyHighestCountFirst(delta.getHistogram())), (boolean)changedValues.contains(new RGB(255, 255, 129)));
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        legendShell = bot.shell(LEGEND_NAME);
        legendBot = legendShell.bot();
        legendBot.button(2).click();
        legendBot.button(OK_BUTTON).click();
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange(bot);
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{reset.getAbsolutePath()});
        this.fViewBot.viewMenu(EXPORT_MENU).click();
        bot.waitUntil((ICondition)new FileWritten(reset, 1000));
        ImageHelper resetImage = ImageHelper.fromFile(reset);
        delta = refImage.diff(resetImage);
        Set<RGB> result = TimeGraphViewTest.getFilteredColorSetOfImage(delta, 20);
        Assert.assertEquals(Collections.singleton(BLACK), result);
    }

    private static @NonNull Set<RGB> getTop3ColorSet(ImageHelper source) {
        ImmutableSet histogramByCount = Multisets.copyHighestCountFirst(source.getHistogram()).entrySet();
        return histogramByCount.stream().limit(3L).map(Multiset.Entry::getElement).collect(Collectors.toSet());
    }

    private static Set<RGB> getFilteredColorSetOfImage(ImageHelper source, int pixelThreshold) {
        ImmutableSet histogramByCount = Multisets.copyHighestCountFirst(source.getHistogram()).entrySet();
        Set<RGB> result = StreamSupport.stream(histogramByCount.spliterator(), false).filter(entry -> entry.getCount() > pixelThreshold).map(entry -> (RGB)entry.getElement()).filter(rgb -> rgb.red > 3 || rgb.green > 3 || rgb.blue > 3 || rgb.equals((Object)BLACK)).collect(Collectors.toSet());
        return result;
    }

    private abstract class ConditionHelper
    implements ICondition {
        private ConditionHelper() {
        }

        public final String getFailureMessage() {
            return null;
        }

        public final void init(SWTBot bot) {
        }
    }

    class FileWritten
    extends ConditionHelper {
        private File fFile;
        private int fAmount;

        public FileWritten(File file, int amount) {
            this.fFile = file;
            this.fAmount = amount;
        }

        public boolean test() throws Exception {
            return this.fFile.length() >= (long)this.fAmount;
        }
    }

    private class TgConditionHelper
    extends ConditionHelper {
        private final Predicate<Object> fTestLogic;

        public TgConditionHelper(Predicate<Object> testLogic) {
            Assert.assertNotNull(testLogic);
            this.fTestLogic = testLogic;
        }

        public final boolean test() throws Exception {
            if (!TimeGraphViewTest.this.fTimeGraphIsDirty.test()) {
                return true;
            }
            return this.fTestLogic.test(null);
        }
    }
}

