/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowView;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ITimeGraphEntryActiveProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public final class ControlFlowCheckActiveProvider
implements ITimeGraphEntryActiveProvider {
    String fLabel;
    String fTooltip;
    private TmfTimeRange fRange = null;
    private ThreadStatusDataProvider fProvider = null;
    private @NonNull Set<Long> fActive = Collections.emptySet();

    public ControlFlowCheckActiveProvider(String label, String tooltip) {
        this.fLabel = label;
        this.fTooltip = tooltip;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public String getTooltip() {
        return this.fTooltip;
    }

    public boolean isActive(ITimeGraphEntry element) {
        if (element instanceof ControlFlowEntry) {
            ControlFlowEntry cfe = (ControlFlowEntry)element;
            TmfTraceManager traceManager = TmfTraceManager.getInstance();
            TmfTraceContext traceContext = traceManager.getCurrentTraceContext();
            TmfTimeRange range = traceContext.getSelectionRange();
            if (Objects.equals(range.getStartTime(), range.getEndTime())) {
                range = traceContext.getWindowRange();
            }
            Set<Long> ids = this.getActiveIds(cfe, range);
            return ids.contains(cfe.getModel().getId());
        }
        return false;
    }

    private Set<Long> getActiveIds(ControlFlowEntry cfe, TmfTimeRange range) {
        ThreadStatusDataProvider dataProvider = ControlFlowView.getProvider(cfe);
        if (range.equals((Object)this.fRange) && dataProvider.equals(this.fProvider)) {
            return this.fActive;
        }
        TimeQueryFilter filter = new TimeQueryFilter(range.getStartTime().toNanos(), range.getEndTime().toNanos(), 2);
        TmfModelResponse response = dataProvider.fetchTree(filter, null);
        List model = (List)response.getModel();
        if (model == null) {
            return Collections.emptySet();
        }
        this.fRange = range;
        this.fActive = Sets.newHashSet((Iterable)Iterables.transform((Iterable)model, thread -> thread.getId()));
        return this.fActive;
    }
}

