/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.TmfTreeCompositeDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfTreeXYCompositeDataProvider<M extends ITmfTreeDataModel, P extends ITmfTreeXYDataProvider<M>>
extends TmfTreeCompositeDataProvider<M, P>
implements ITmfTreeXYDataProvider<M> {
    private final String fTitle;

    public TmfTreeXYCompositeDataProvider(List<P> providers, String title, String id) {
        super(providers, id);
        this.fTitle = title;
    }

    public static @Nullable ITmfTreeXYDataProvider<ITmfTreeDataModel> create(Collection<ITmfTrace> traces, String title, String id) {
        ArrayList<@NonNull ITmfTreeXYDataProvider> providers = new ArrayList<ITmfTreeXYDataProvider>();
        for (ITmfTrace child : traces) {
            ITmfTreeXYDataProvider provider = DataProviderManager.getInstance().getDataProvider(child, id, ITmfTreeXYDataProvider.class);
            if (provider == null) continue;
            providers.add(provider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ITmfTreeXYDataProvider)providers.get(0);
        }
        return new TmfTreeXYCompositeDataProvider(providers, title, id);
    }

    @Override
    public TmfModelResponse<ITmfXyModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        List providers = this.getProviders();
        boolean allCommon = Iterables.all(providers, ITmfCommonXAxisModel.class::isInstance);
        if (allCommon) {
            return this.getCommonXResponse(filter, monitor, providers);
        }
        return this.getXyResponse(filter, monitor, providers);
    }

    private TmfModelResponse<ITmfXyModel> getXyResponse(TimeQueryFilter filter, @Nullable IProgressMonitor monitor, List<P> providers) {
        boolean isComplete = true;
        ImmutableMap.Builder series = ImmutableMap.builder();
        for (ITmfTreeXYDataProvider dataProvider : providers) {
            TmfModelResponse<ITmfXyModel> response = dataProvider.fetchXY(filter, monitor);
            isComplete &= response.getStatus() == ITmfResponse.Status.COMPLETED;
            ITmfXyModel model = response.getModel();
            if (model != null) {
                series.putAll(model.getData());
            }
            if (monitor == null || !monitor.isCanceled()) continue;
            return TmfXyResponseFactory.createCancelledResponse(CommonStatusMessage.TASK_CANCELLED);
        }
        return TmfXyResponseFactory.create(this.fTitle, (Map<String, ISeriesModel>)series.build(), isComplete);
    }

    private TmfModelResponse<ITmfXyModel> getCommonXResponse(TimeQueryFilter filter, @Nullable IProgressMonitor monitor, List<P> providers) {
        boolean isComplete = true;
        ImmutableMap.Builder series = ImmutableMap.builder();
        for (ITmfTreeXYDataProvider dataProvider : providers) {
            TmfModelResponse<ITmfXyModel> response = dataProvider.fetchXY(filter, monitor);
            isComplete &= response.getStatus() == ITmfResponse.Status.COMPLETED;
            ITmfCommonXAxisModel model = (ITmfCommonXAxisModel)response.getModel();
            if (model != null) {
                series.putAll(model.getYData());
            }
            if (monitor == null || !monitor.isCanceled()) continue;
            return TmfXyResponseFactory.createCancelledResponse(CommonStatusMessage.TASK_CANCELLED);
        }
        return TmfXyResponseFactory.create(this.fTitle, filter.getTimesRequested(), (Map<String, IYModel>)series.build(), isComplete);
    }
}

