/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets;

import com.google.common.collect.Iterables;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.math.SaturatedArithmetic;
import org.eclipse.tracecompass.internal.tmf.ui.util.LineClipper;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphColorListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider2;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTreeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphViewerFilterListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTreeExpansionEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProviderConverter;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITmfTimeGraphDrawingHelper;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphBaseControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphScale;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class TimeGraphControl
extends TimeGraphBaseControl
implements FocusListener,
KeyListener,
MouseMoveListener,
MouseListener,
MouseWheelListener,
MouseTrackListener,
TraverseListener,
ISelectionProvider,
MenuDetectListener,
ITmfTimeGraphDrawingHelper,
ITimeGraphColorListener,
Listener {
    public static final int ALL_LEVELS = -1;
    private static final int DRAG_MARGIN = 5;
    private static final int DRAG_NONE = 0;
    private static final int DRAG_TRACE_ITEM = 1;
    private static final int DRAG_SPLIT_LINE = 2;
    private static final int DRAG_ZOOM = 3;
    private static final int DRAG_SELECTION = 4;
    private static final int CUSTOM_ITEM_HEIGHT = -1;
    private static final double ZOOM_FACTOR = 1.5;
    private static final double ZOOM_IN_FACTOR = 0.8;
    private static final double ZOOM_OUT_FACTOR = 1.25;
    private static final int SNAP_WIDTH = 3;
    private static final int ARROW_HOVER_MAX_DIST = 5;
    private static final double ARROW_RATIO = Math.sqrt(3.0) / 2.0;
    private static final int NO_STATUS = -1;
    private static final int STATUS_WITHOUT_CURSOR_TIME = -2;
    private static final int MAX_LABEL_LENGTH = 256;
    private static final int PPI = 72;
    private static final int DPI = Display.getDefault().getDPI().y;
    private static final int VERTICAL_ZOOM_DELAY = 400;
    private static final String PREFERRED_WIDTH = "width";
    private LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Color[] fEventColorMap = null;
    private ITimeDataProvider fTimeProvider;
    private ITableLabelProvider fLabelProvider;
    private IStatusLineManager fStatusLineManager = null;
    private Tree fTree = null;
    private TimeGraphScale fTimeGraphScale = null;
    private boolean fIsInFocus = false;
    private boolean fMouseOverSplitLine = false;
    private int fGlobalItemHeight = -1;
    private int fHeightAdjustment = 0;
    private int fMaxItemHeight = 0;
    private Map<Integer, Font> fFonts = new HashMap<Integer, Font>();
    private boolean fBlendSubPixelEvents = false;
    private int fMinimumItemWidth = 0;
    private int fTopIndex = 0;
    private int fDragState = 0;
    private boolean fDragBeginMarker = false;
    private int fDragButton;
    private int fDragX0 = 0;
    private int fDragX = 0;
    private boolean fHasNamespaceFocus = false;
    private long fDragTime0 = 0L;
    private int fIdealNameSpace = 0;
    private boolean fAutoResizeColumns = true;
    private long fTime0bak;
    private long fTime1bak;
    private ITimeGraphPresentationProvider fTimeGraphProvider = null;
    private ItemData fItemData = null;
    private List<IMarkerEvent> fMarkers = null;
    private boolean fMarkersVisible = true;
    private List<SelectionListener> fSelectionListeners;
    private List<ITimeGraphTimeListener> fDragSelectionListeners;
    private final List<ISelectionChangedListener> fSelectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private final List<ITimeGraphTreeListener> fTreeListeners = new ArrayList<ITimeGraphTreeListener>();
    private final List<ITimeGraphViewerFilterListener> fViewerFilterListeners = new ArrayList<ITimeGraphViewerFilterListener>();
    private final List<MenuDetectListener> fTimeGraphEntryMenuListeners = new ArrayList<MenuDetectListener>();
    private final List<MenuDetectListener> fTimeEventMenuListeners = new ArrayList<MenuDetectListener>();
    private final Cursor fDragCursor = Display.getDefault().getSystemCursor(21);
    private final Cursor fResizeCursor = Display.getDefault().getSystemCursor(19);
    private final Cursor fWaitCursor = Display.getDefault().getSystemCursor(1);
    private final Cursor fZoomCursor = Display.getDefault().getSystemCursor(9);
    private final Set<@NonNull ViewerFilter> fFilters = new LinkedHashSet<ViewerFilter>();
    private MenuDetectEvent fPendingMenuDetectEvent = null;
    private boolean fGridLinesVisible = true;
    private Color fGridLineColor = Display.getDefault().getSystemColor(15);
    private boolean fHideArrows = false;
    private int fAutoExpandLevel = -1;
    private Map.Entry<ITimeGraphEntry, Integer> fVerticalZoomAlignEntry = null;
    private long fVerticalZoomAlignTime = 0L;
    private int fBorderWidth = 0;
    private int fHeaderHeight = 0;
    private boolean fFirstHeightWarning = true;

    public TimeGraphControl(Composite parent, TimeGraphColorScheme colors) {
        super(parent, colors, 0x20040000);
        this.fItemData = new ItemData();
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        this.addMouseWheelListener(this);
        this.addTraverseListener(this);
        this.addKeyListener(this);
        this.addMenuDetectListener(this);
        this.addListener(37, this);
        this.addDisposeListener(e -> {
            this.fResourceManager.dispose();
            for (Font font : this.fFonts.values()) {
                font.dispose();
            }
        });
    }

    public void setTimeGraphProvider(ITimeGraphPresentationProvider timeGraphProvider) {
        this.fTimeGraphProvider = timeGraphProvider;
        if (timeGraphProvider instanceof ITimeGraphPresentationProvider2) {
            ((ITimeGraphPresentationProvider2)timeGraphProvider).setDrawingHelper(this);
            ((ITimeGraphPresentationProvider2)timeGraphProvider).addColorListener(this);
        }
        StateItem[] stateItems = this.fTimeGraphProvider.getStateTable();
        this.colorSettingsChanged(stateItems);
    }

    public ITimeGraphPresentationProvider getTimeGraphProvider() {
        return this.fTimeGraphProvider;
    }

    public ITimeDataProvider getTimeDataProvider() {
        return this.fTimeProvider;
    }

    public Color[] getEventColorMap() {
        return this.fEventColorMap;
    }

    public void setTimeProvider(ITimeDataProvider timeProvider) {
        this.fTimeProvider = timeProvider;
        this.redraw();
    }

    public void setLabelProvider(ITableLabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
        this.redraw();
    }

    public ITableLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    public void setStatusLineManager(IStatusLineManager statusLineManager) {
        if (this.fStatusLineManager != null && statusLineManager == null) {
            this.fStatusLineManager.setMessage("");
        }
        this.fStatusLineManager = statusLineManager;
    }

    public void setTree(Tree tree) {
        this.fTree = tree;
    }

    public Tree getTree() {
        return this.fTree;
    }

    public void setColumns(String[] columnNames) {
        TreeColumn[] treeColumnArray = this.fTree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.dispose();
            ++n2;
        }
        ControlListener controlListener = new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (TimeGraphControl.this.fAutoResizeColumns && ((TreeColumn)e.widget).getWidth() < (Integer)e.widget.getData(TimeGraphControl.PREFERRED_WIDTH)) {
                    TimeGraphControl.this.fAutoResizeColumns = false;
                }
                TimeGraphControl.this.redraw();
            }

            public void controlMoved(ControlEvent e) {
                TimeGraphControl.this.redraw();
            }
        };
        String[] stringArray = columnNames;
        int n3 = columnNames.length;
        n = 0;
        while (n < n3) {
            String columnName = stringArray[n];
            TreeColumn column = new TreeColumn(this.fTree, 16384);
            column.setMoveable(true);
            column.setText(columnName);
            column.pack();
            column.setData(PREFERRED_WIDTH, (Object)column.getWidth());
            column.addControlListener(controlListener);
            ++n;
        }
    }

    public void setTimeGraphScale(TimeGraphScale timeGraphScale) {
        this.fTimeGraphScale = timeGraphScale;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this.fSelectionListeners == null) {
            this.fSelectionListeners = new ArrayList<SelectionListener>();
        }
        this.fSelectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.fSelectionListeners != null) {
            this.fSelectionListeners.remove(listener);
        }
    }

    public void fireSelectionChanged() {
        if (this.fSelectionListeners != null) {
            for (SelectionListener listener : this.fSelectionListeners) {
                listener.widgetSelected(null);
            }
        }
        if (this.fSelectionChangedListeners != null) {
            for (ISelectionChangedListener listener : this.fSelectionChangedListeners) {
                listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
            }
        }
    }

    public void fireDefaultSelection() {
        if (this.fSelectionListeners != null) {
            for (SelectionListener listener : this.fSelectionListeners) {
                listener.widgetDefaultSelected(null);
            }
        }
    }

    public void addDragSelectionListener(ITimeGraphTimeListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this.fDragSelectionListeners == null) {
            this.fDragSelectionListeners = new ArrayList<ITimeGraphTimeListener>();
        }
        this.fDragSelectionListeners.add(listener);
    }

    public void removeDragSelectionListener(ITimeGraphTimeListener listener) {
        if (this.fDragSelectionListeners != null) {
            this.fDragSelectionListeners.remove(listener);
        }
    }

    public void fireDragSelectionChanged(long start, long end) {
        long endTime;
        long beginTime;
        if (start > end) {
            beginTime = end;
            endTime = start;
        } else {
            beginTime = start;
            endTime = end;
        }
        if (this.fDragSelectionListeners != null) {
            for (ITimeGraphTimeListener listener : this.fDragSelectionListeners) {
                listener.timeSelected(new TimeGraphTimeEvent(this, beginTime, endTime));
            }
        }
    }

    public ITimeGraphEntry[] getTraces() {
        return this.fItemData.getEntries();
    }

    public void refreshData() {
        this.fItemData.refreshData();
        this.redraw();
    }

    public void refreshData(ITimeGraphEntry[] traces) {
        this.fItemData.refreshData(traces);
        this.redraw();
    }

    public void refreshArrows(List<ILinkEvent> events) {
        this.fItemData.refreshArrows(events);
    }

    public List<ILinkEvent> getArrows() {
        return Collections.unmodifiableList(this.fItemData.fLinks);
    }

    boolean ensureVisibleItem(int idx, boolean redraw) {
        boolean changed = false;
        int index = idx;
        if (index < 0) {
            index = 0;
            while (index < this.fItemData.fExpandedItems.length) {
                if (this.fItemData.fExpandedItems[index].fSelected) break;
                ++index;
            }
        }
        if (index >= this.fItemData.fExpandedItems.length) {
            return changed;
        }
        if (index < this.fTopIndex) {
            this.setTopIndex(index);
            if (redraw) {
                this.redraw();
            }
            changed = true;
        } else {
            int page = this.countPerPage();
            if (index >= this.fTopIndex + page) {
                this.setTopIndex(index - page + 1);
                if (redraw) {
                    this.redraw();
                }
                changed = true;
            }
        }
        return changed;
    }

    public void setTopIndex(int idx) {
        int index = Math.min(idx, this.fItemData.fExpandedItems.length - this.countPerPage());
        this.fTopIndex = index = Math.max(0, index);
        this.redraw();
    }

    public void setElementPosition(ITimeGraphEntry entry, int y) {
        Item item = (Item)this.fItemData.fItemMap.get(entry);
        if (item == null || item.fExpandedIndex == -1) {
            return;
        }
        int index = item.fExpandedIndex;
        Rectangle itemRect = this.getItemRect(this.getClientArea(), index);
        int delta = itemRect.y + itemRect.height - y;
        int topIndex = this.getItemIndexAtY(delta);
        if (topIndex != -1) {
            this.setTopIndex(topIndex);
        } else if (delta < 0) {
            this.setTopIndex(0);
        } else {
            this.setTopIndex(this.getExpandedElementCount());
        }
    }

    public void setAutoExpandLevel(int level) {
        this.fAutoExpandLevel = level;
    }

    public int getAutoExpandLevel() {
        return this.fAutoExpandLevel;
    }

    public boolean getExpandedState(ITimeGraphEntry entry) {
        Item item = (Item)this.fItemData.fItemMap.get(entry);
        return item != null ? item.fExpanded : false;
    }

    public void setExpandedState(ITimeGraphEntry entry, boolean expanded) {
        Item item = this.fItemData.findItem(entry);
        if (item != null && item.fExpanded != expanded) {
            item.fExpanded = expanded;
            this.fItemData.updateExpandedItems();
            this.redraw();
        }
    }

    public void setExpandedState(Iterable<ITimeGraphEntry> entries, boolean expanded) {
        for (ITimeGraphEntry entry : entries) {
            Item item = this.fItemData.findItem(entry);
            if (item == null) continue;
            item.fExpanded = expanded;
        }
        this.fItemData.updateExpandedItems();
        this.redraw();
    }

    private void setExpandedState(ITimeGraphEntry entry, int level, boolean expanded) {
        this.setExpandedStateInt(entry, level, expanded);
        this.redraw();
    }

    private void setExpandedStateLevel(ITimeGraphEntry entry) {
        int level = this.findExpandedLevel(entry);
        if (level >= 0) {
            this.setExpandedStateInt(entry, level, true);
            this.redraw();
        }
    }

    private int findExpandedLevel(ITimeGraphEntry entry) {
        SearchNode root;
        LinkedList<SearchNode> queue = new LinkedList<SearchNode>();
        SearchNode node = root = new SearchNode(entry, 0);
        queue.add(root);
        while (!queue.isEmpty()) {
            node = (SearchNode)queue.remove();
            if (node.entry.hasChildren() && !this.getExpandedState(node.entry)) {
                return node.level;
            }
            for (ITimeGraphEntry iTimeGraphEntry : node.entry.getChildren()) {
                if (!iTimeGraphEntry.hasChildren()) continue;
                SearchNode n = new SearchNode(iTimeGraphEntry, node.level + 1);
                queue.add(n);
            }
        }
        return -1;
    }

    private void setExpandedStateInt(ITimeGraphEntry entry, int aLevel, boolean expanded) {
        Item item;
        int level = aLevel;
        if (level > 0 || level < 0) {
            --level;
            if (entry.hasChildren()) {
                for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
                    this.setExpandedStateInt(iTimeGraphEntry, level, expanded);
                }
            }
        }
        if ((item = this.fItemData.findItem(entry)) != null && item.fExpanded != expanded) {
            item.fExpanded = expanded;
            this.fItemData.updateExpandedItems();
            this.fireTreeEvent(item.fEntry, item.fExpanded);
        }
    }

    public void collapseAll() {
        Item[] itemArray = this.fItemData.fItems;
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            item.fExpanded = false;
            ++n2;
        }
        this.fItemData.updateExpandedItems();
        this.redraw();
    }

    public void expandAll() {
        Item[] itemArray = this.fItemData.fItems;
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            item.fExpanded = true;
            ++n2;
        }
        this.fItemData.updateExpandedItems();
        this.redraw();
    }

    public void addTreeListener(ITimeGraphTreeListener listener) {
        if (!this.fTreeListeners.contains(listener)) {
            this.fTreeListeners.add(listener);
        }
    }

    public void removeTreeListener(ITimeGraphTreeListener listener) {
        if (this.fTreeListeners.contains(listener)) {
            this.fTreeListeners.remove(listener);
        }
    }

    public void fireTreeEvent(ITimeGraphEntry entry, boolean expanded) {
        TimeGraphTreeExpansionEvent event = new TimeGraphTreeExpansionEvent(this, entry);
        for (ITimeGraphTreeListener listener : this.fTreeListeners) {
            if (expanded) {
                listener.treeExpanded(event);
                continue;
            }
            listener.treeCollapsed(event);
        }
    }

    public void addViewerFilterListener(ITimeGraphViewerFilterListener listener) {
        if (!this.fViewerFilterListeners.contains(listener)) {
            this.fViewerFilterListeners.add(listener);
        }
    }

    public void removeViewerFilterListener(ITimeGraphViewerFilterListener listener) {
        if (this.fViewerFilterListeners.contains(listener)) {
            this.fViewerFilterListeners.remove(listener);
        }
    }

    private void fireFiltersAdded(@NonNull Iterable<ViewerFilter> filters) {
        for (ITimeGraphViewerFilterListener listener : this.fViewerFilterListeners) {
            listener.filtersAdded(filters);
        }
    }

    private void fireFiltersChanged(@NonNull Iterable<ViewerFilter> filters) {
        for (ITimeGraphViewerFilterListener listener : this.fViewerFilterListeners) {
            listener.filtersChanged(filters);
        }
    }

    private void fireFiltersRemoved(@NonNull Iterable<ViewerFilter> filters) {
        for (ITimeGraphViewerFilterListener listener : this.fViewerFilterListeners) {
            listener.filtersRemoved(filters);
        }
    }

    public void addTimeGraphEntryMenuListener(MenuDetectListener listener) {
        if (!this.fTimeGraphEntryMenuListeners.contains(listener)) {
            this.fTimeGraphEntryMenuListeners.add(listener);
        }
    }

    public void removeTimeGraphEntryMenuListener(MenuDetectListener listener) {
        if (this.fTimeGraphEntryMenuListeners.contains(listener)) {
            this.fTimeGraphEntryMenuListeners.remove(listener);
        }
    }

    private void fireMenuEventOnTimeGraphEntry(MenuDetectEvent event) {
        for (MenuDetectListener listener : this.fTimeGraphEntryMenuListeners) {
            listener.menuDetected(event);
        }
    }

    public void addTimeEventMenuListener(MenuDetectListener listener) {
        if (!this.fTimeEventMenuListeners.contains(listener)) {
            this.fTimeEventMenuListeners.add(listener);
        }
    }

    public void removeTimeEventMenuListener(MenuDetectListener listener) {
        if (this.fTimeEventMenuListeners.contains(listener)) {
            this.fTimeEventMenuListeners.remove(listener);
        }
    }

    private void fireMenuEventOnTimeEvent(MenuDetectEvent event) {
        for (MenuDetectListener listener : this.fTimeEventMenuListeners) {
            listener.menuDetected(event);
        }
    }

    public boolean setFocus() {
        if (this.fTimeProvider != null && this.fTimeProvider.getNameSpace() > 0) {
            this.fHasNamespaceFocus = true;
        }
        return super.setFocus();
    }

    public ISelection getSelection() {
        ITimeGraphEntry entry = this.getSelectedTrace();
        if (entry != null && this.fTimeProvider != null) {
            long selectedTime = this.fTimeProvider.getSelectionBegin();
            ITimeEvent event = Utils.findEvent(entry, selectedTime, 0);
            if (event == null) {
                return new StructuredSelection((Object)entry);
            }
            return new StructuredSelection(new Object[]{entry, event});
        }
        return StructuredSelection.EMPTY;
    }

    public ISelection getSelectionTrace() {
        ITimeGraphEntry entry = this.getSelectedTrace();
        if (entry != null) {
            return new StructuredSelection((Object)entry);
        }
        return StructuredSelection.EMPTY;
    }

    public void selectTrace(int n) {
        if (n != 1 && n != -1) {
            return;
        }
        boolean changed = false;
        int lastSelection = -1;
        int i = 0;
        while (i < this.fItemData.fExpandedItems.length) {
            Item item = this.fItemData.fExpandedItems[i];
            if (item.fSelected) {
                lastSelection = i;
                if (1 == n && i < this.fItemData.fExpandedItems.length - 1) {
                    item.fSelected = false;
                    item = this.fItemData.fExpandedItems[i + 1];
                    item.fSelected = true;
                    changed = true;
                    break;
                }
                if (-1 != n || i <= 0) break;
                item.fSelected = false;
                item = this.fItemData.fExpandedItems[i - 1];
                item.fSelected = true;
                changed = true;
                break;
            }
            ++i;
        }
        if (lastSelection < 0 && this.fItemData.fExpandedItems.length > 0) {
            Item item = this.fItemData.fExpandedItems[0];
            item.fSelected = true;
            changed = true;
        }
        if (changed) {
            this.ensureVisibleItem(-1, false);
            this.redraw();
            this.fireSelectionChanged();
        }
    }

    public void selectEvent(int n, boolean extend) {
        if (this.fTimeProvider == null) {
            return;
        }
        ITimeGraphEntry entry = this.getSelectedTrace();
        if (entry == null) {
            return;
        }
        long time = this.fTimeProvider.getSelectionEnd();
        if (n > 0) {
            time = Math.min(Utils.nextChange(entry, time), this.fTimeProvider.getMaxTime());
        } else if (n < 0) {
            time = Math.max(Utils.prevChange(entry, time), this.fTimeProvider.getMinTime());
        }
        if (extend) {
            this.fTimeProvider.setSelectionRangeNotify(this.fTimeProvider.getSelectionBegin(), time, true);
        } else {
            this.fTimeProvider.setSelectedTimeNotify(time, true);
        }
        this.fireSelectionChanged();
        this.updateStatusLine(-2);
    }

    public void selectNextEvent(boolean extend) {
        this.selectEvent(1, extend);
        this.fTimeProvider.setStartFinishTimeNotify(this.fTimeProvider.getTime0(), this.fTimeProvider.getTime1());
    }

    public void selectPrevEvent(boolean extend) {
        this.selectEvent(-1, extend);
        this.fTimeProvider.setStartFinishTimeNotify(this.fTimeProvider.getTime0(), this.fTimeProvider.getTime1());
    }

    public void selectNextTrace() {
        this.selectTrace(1);
    }

    public void selectPrevTrace() {
        this.selectTrace(-1);
    }

    public void horizontalScroll(boolean left) {
        long time0 = this.fTimeProvider.getTime0();
        long time1 = this.fTimeProvider.getTime1();
        long timeMin = this.fTimeProvider.getMinTime();
        long timeMax = this.fTimeProvider.getMaxTime();
        long range = time1 - time0;
        if (range <= 0L) {
            return;
        }
        long increment = Math.max(1L, range / 4L);
        if (left) {
            time0 = Math.max(time0 - increment, timeMin);
            time1 = time0 + range;
        } else {
            time1 = Math.min(time1 + increment, timeMax);
            time0 = time1 - range;
        }
        this.fTimeProvider.setStartFinishTimeNotify(time0, time1);
    }

    public void zoom(boolean zoomIn) {
        int globalX = this.getDisplay().getCursorLocation().x;
        Point p = this.toControl(globalX, 0);
        int nameSpace = this.fTimeProvider.getNameSpace();
        int timeSpace = this.fTimeProvider.getTimeSpace();
        int xPos = Math.max(nameSpace, Math.min(nameSpace + timeSpace, p.x));
        long time0 = this.fTimeProvider.getTime0();
        long time1 = this.fTimeProvider.getTime1();
        long interval = time1 - time0;
        if (interval == 0L) {
            interval = 1L;
        }
        long newInterval = zoomIn ? Math.max(Math.round((double)interval * 0.8), this.fTimeProvider.getMinTimeInterval()) : (long)Math.ceil((double)interval * 1.25);
        long center = time0 + Math.round((double)(xPos - nameSpace) / (double)timeSpace * (double)interval);
        long newTime0 = center - Math.round((double)newInterval * (double)(center - time0) / (double)interval);
        newTime0 = Math.max(this.fTimeProvider.getMinTime(), Math.min(newTime0, this.fTimeProvider.getMaxTime() - newInterval));
        long newTime1 = newTime0 + newInterval;
        this.fTimeProvider.setStartFinishTimeNotify(newTime0, newTime1);
    }

    public void zoomIn() {
        long min;
        long time0;
        long time1;
        long prevTime0 = this.fTimeProvider.getTime0();
        long prevTime1 = this.fTimeProvider.getTime1();
        long prevRange = prevTime1 - prevTime0;
        if (prevRange == 0L) {
            return;
        }
        ITimeDataProvider provider = this.fTimeProvider;
        long selTime = (provider.getSelectionEnd() + provider.getSelectionBegin()) / 2L;
        if (selTime < prevTime0 || selTime > prevTime1) {
            selTime = (prevTime0 + prevTime1) / 2L;
        }
        if ((time1 = selTime + (long)((double)(prevTime1 - selTime) / 1.5)) - (time0 = selTime - (long)((double)(selTime - prevTime0) / 1.5)) < (min = this.fTimeProvider.getMinTimeInterval())) {
            time0 = selTime - (selTime - prevTime0) * min / prevRange;
            time1 = time0 + min;
        }
        this.fTimeProvider.setStartFinishTimeNotify(time0, time1);
    }

    public void zoomOut() {
        long time0;
        long newInterval;
        long prevTime0 = this.fTimeProvider.getTime0();
        long prevTime1 = this.fTimeProvider.getTime1();
        ITimeDataProvider provider = this.fTimeProvider;
        long selTime = (provider.getSelectionEnd() + provider.getSelectionBegin()) / 2L;
        if (selTime < prevTime0 || selTime > prevTime1) {
            selTime = (prevTime0 + prevTime1) / 2L;
        }
        if (prevTime1 - prevTime0 <= 1L) {
            newInterval = 2L;
            time0 = selTime - 1L;
        } else {
            newInterval = (long)Math.ceil((double)(prevTime1 - prevTime0) * 1.5);
            time0 = selTime - (long)Math.ceil((double)(selTime - prevTime0) * 1.5);
        }
        time0 = Math.max(this.fTimeProvider.getMinTime(), Math.min(time0, this.fTimeProvider.getMaxTime() - newInterval));
        long time1 = time0 + newInterval;
        this.fTimeProvider.setStartFinishTimeNotify(time0, time1);
    }

    public void verticalZoom(boolean zoomIn) {
        if (zoomIn) {
            ++this.fHeightAdjustment;
        } else {
            --this.fHeightAdjustment;
            this.fHeightAdjustment = Math.max(this.fHeightAdjustment, 1 - this.fMaxItemHeight);
        }
        this.fItemData.refreshData();
        this.redraw();
    }

    public void resetVerticalZoom() {
        this.fHeightAdjustment = 0;
        this.fItemData.refreshData();
        this.redraw();
    }

    public void setGridLinesVisible(boolean visible) {
        this.fGridLinesVisible = visible;
    }

    public boolean getGridLinesVisible() {
        return this.fGridLinesVisible;
    }

    public void setGridLineColor(Color color) {
        this.fGridLineColor = color;
    }

    public Color getGridLineColor() {
        return this.fGridLineColor;
    }

    public void setMarkers(List<IMarkerEvent> markers) {
        this.fMarkers = markers;
    }

    public List<IMarkerEvent> getMarkers() {
        return this.fMarkers;
    }

    public void setMarkersVisible(boolean visible) {
        this.fMarkersVisible = visible;
    }

    public boolean getMarkersVisible() {
        return this.fMarkersVisible;
    }

    public void hideArrows(boolean hideArrows) {
        this.fHideArrows = hideArrows;
    }

    public void followArrowFwd(boolean extend) {
        ITimeGraphEntry trace = this.getSelectedTrace();
        if (trace == null) {
            return;
        }
        long selectedTime = this.fTimeProvider.getSelectionEnd();
        for (ILinkEvent link : this.fItemData.fLinks) {
            if (link.getEntry() != trace || link.getTime() != selectedTime) continue;
            this.selectItem(link.getDestinationEntry(), false);
            if (link.getDuration() != 0L) {
                if (extend) {
                    this.fTimeProvider.setSelectionRangeNotify(this.fTimeProvider.getSelectionBegin(), link.getTime() + link.getDuration(), true);
                } else {
                    this.fTimeProvider.setSelectedTimeNotify(link.getTime() + link.getDuration(), true);
                }
                this.fTimeProvider.setStartFinishTimeNotify(this.fTimeProvider.getTime0(), this.fTimeProvider.getTime1());
            }
            this.fireSelectionChanged();
            this.updateStatusLine(-2);
            return;
        }
        this.selectNextEvent(extend);
    }

    public void followArrowBwd(boolean extend) {
        ITimeGraphEntry trace = this.getSelectedTrace();
        if (trace == null) {
            return;
        }
        long selectedTime = this.fTimeProvider.getSelectionEnd();
        for (ILinkEvent link : this.fItemData.fLinks) {
            if (link.getDestinationEntry() != trace || link.getTime() + link.getDuration() != selectedTime) continue;
            this.selectItem(link.getEntry(), false);
            if (link.getDuration() != 0L) {
                if (extend) {
                    this.fTimeProvider.setSelectionRangeNotify(this.fTimeProvider.getSelectionBegin(), link.getTime(), true);
                } else {
                    this.fTimeProvider.setSelectedTimeNotify(link.getTime(), true);
                }
                this.fTimeProvider.setStartFinishTimeNotify(this.fTimeProvider.getTime0(), this.fTimeProvider.getTime1());
            }
            this.fireSelectionChanged();
            this.updateStatusLine(-2);
            return;
        }
        this.selectPrevEvent(extend);
    }

    public ITimeGraphEntry getSelectedTrace() {
        ITimeGraphEntry trace = null;
        int idx = this.getSelectedIndex();
        if (idx >= 0) {
            trace = this.fItemData.fExpandedItems[idx].fEntry;
        }
        return trace;
    }

    public int getSelectedIndex() {
        int idx = -1;
        int i = 0;
        while (i < this.fItemData.fExpandedItems.length) {
            Item item = this.fItemData.fExpandedItems[i];
            if (item.fSelected) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }

    boolean toggle(int idx) {
        Item item;
        boolean toggled = false;
        if (idx >= 0 && idx < this.fItemData.fExpandedItems.length && (item = this.fItemData.fExpandedItems[idx]).fHasChildren) {
            item.fExpanded = !item.fExpanded;
            this.fItemData.updateExpandedItems();
            this.redraw();
            toggled = true;
            this.fireTreeEvent(item.fEntry, item.fExpanded);
        }
        return toggled;
    }

    protected int getItemIndexAtY(int y) {
        int ySum = 0;
        if (y < 0) {
            int idx = this.fTopIndex - 1;
            while (idx >= 0) {
                if (y >= (ySum -= this.fItemData.fExpandedItems[idx].fItemHeight)) {
                    return idx;
                }
                --idx;
            }
        } else {
            int idx = this.fTopIndex;
            while (idx < this.fItemData.fExpandedItems.length) {
                if (y < (ySum += this.fItemData.fExpandedItems[idx].fItemHeight)) {
                    return idx;
                }
                ++idx;
            }
        }
        return -1;
    }

    boolean isOverSplitLine(int x) {
        if (x < 0 || this.fTimeProvider == null) {
            return false;
        }
        int nameWidth = this.fTimeProvider.getNameSpace();
        return Math.abs(x - nameWidth) <= 3;
    }

    boolean isOverTimeSpace(int x, int y) {
        Point size = this.getSize();
        return x >= this.fTimeProvider.getNameSpace() && x < size.x && y >= 0 && y < size.y;
    }

    public ITimeGraphEntry getEntry(Point pt) {
        int idx = this.getItemIndexAtY(pt.y);
        return idx >= 0 ? this.fItemData.fExpandedItems[idx].fEntry : null;
    }

    protected ILinkEvent getArrow(Point pt) {
        if (this.fHideArrows) {
            return null;
        }
        ILinkEvent linkEvent = null;
        double minDistance = Double.MAX_VALUE;
        Rectangle clientArea = this.getClientArea();
        for (ILinkEvent event : this.fItemData.fLinks) {
            int y2;
            int x2;
            int y1;
            int x1;
            double d;
            Rectangle rect = this.getArrowRectangle(clientArea, event);
            if (rect == null || !(minDistance > (d = Utils.distance(pt.x, pt.y, x1 = rect.x, y1 = rect.y, x2 = x1 + rect.width, y2 = y1 + rect.height)))) continue;
            minDistance = d;
            linkEvent = event;
        }
        if (minDistance <= 5.0) {
            return linkEvent;
        }
        return null;
    }

    @Override
    public int getXForTime(long time) {
        if (this.fTimeProvider == null) {
            return -1;
        }
        long time0 = this.fTimeProvider.getTime0();
        long time1 = this.fTimeProvider.getTime1();
        int width = this.getSize().x;
        int nameSpace = this.fTimeProvider.getNameSpace();
        double pixelsPerNanoSec = width - nameSpace <= 1 ? 0.0 : (double)(width - nameSpace - 1) / (double)(time1 - time0);
        int x = SaturatedArithmetic.add((int)(this.getBounds().x + nameSpace), (int)((int)((double)(time - time0) * pixelsPerNanoSec)));
        return x;
    }

    @Override
    public long getTimeAtX(int coord) {
        if (this.fTimeProvider == null) {
            return -1L;
        }
        long hitTime = -1L;
        Point size = this.getSize();
        long time0 = this.fTimeProvider.getTime0();
        long time1 = this.fTimeProvider.getTime1();
        int nameWidth = this.fTimeProvider.getNameSpace();
        int x = coord - nameWidth;
        int timeWidth = size.x - nameWidth - 1;
        if (x >= 0 && size.x >= nameWidth) {
            hitTime = time1 - time0 > (long)timeWidth ? time0 + (long)Math.ceil((double)(time1 - time0) * ((double)x / (double)timeWidth)) : time0 + (long)Math.floor((double)(time1 - time0) * ((double)x / (double)timeWidth));
        }
        return hitTime;
    }

    void selectItem(int idx, boolean addSelection) {
        this.selectItem(idx, addSelection, true);
    }

    void selectItem(int idx, boolean addSelection, boolean reveal) {
        boolean changed = false;
        if (addSelection) {
            if (idx >= 0 && idx < this.fItemData.fExpandedItems.length) {
                Item item = this.fItemData.fExpandedItems[idx];
                changed = !item.fSelected;
                item.fSelected = true;
            }
        } else {
            int i = 0;
            while (i < this.fItemData.fExpandedItems.length) {
                Item item = this.fItemData.fExpandedItems[i];
                if (i == idx && !item.fSelected || idx == -1 && item.fSelected) {
                    changed = true;
                }
                item.fSelected = i == idx;
                ++i;
            }
        }
        if (reveal) {
            changed |= this.ensureVisibleItem(idx, true);
        }
        if (changed) {
            this.redraw();
        }
    }

    public void selectItem(ITimeGraphEntry entry, boolean addSelection) {
        int idx = this.fItemData.findItemIndex(entry);
        this.selectItem(idx, addSelection);
    }

    public void selectItem(ITimeGraphEntry entry, boolean addSelection, boolean reveal) {
        int idx = this.fItemData.findItemIndex(entry);
        this.selectItem(idx, addSelection, reveal);
    }

    public int countPerPage() {
        int height = this.getSize().y;
        int count = 0;
        int ySum = 0;
        int idx = this.fTopIndex;
        while (idx < this.fItemData.fExpandedItems.length) {
            if ((ySum += this.fItemData.fExpandedItems[idx].fItemHeight) >= height) {
                return count;
            }
            ++count;
            ++idx;
        }
        idx = this.fTopIndex - 1;
        while (idx >= 0) {
            if ((ySum += this.fItemData.fExpandedItems[idx].fItemHeight) >= height) {
                return count;
            }
            ++count;
            --idx;
        }
        return count;
    }

    public int getTopIndex() {
        return this.fTopIndex;
    }

    public int getExpandedElementCount() {
        return this.fItemData.fExpandedItems.length;
    }

    public ITimeGraphEntry[] getExpandedElements() {
        ArrayList<ITimeGraphEntry> elements = new ArrayList<ITimeGraphEntry>();
        Item[] itemArray = this.fItemData.fExpandedItems;
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            elements.add(item.fEntry);
            ++n2;
        }
        return elements.toArray(new ITimeGraphEntry[0]);
    }

    public ITimeGraphEntry getExpandedElement(int index) {
        if (index < 0 || index >= this.fItemData.fExpandedItems.length) {
            return null;
        }
        return this.fItemData.fExpandedItems[index].fEntry;
    }

    public Rectangle getItemBounds(ITimeGraphEntry entry) {
        int idx = this.fItemData.findItemIndex(entry);
        if (idx >= 0) {
            return this.getItemRect(this.getClientArea(), idx);
        }
        return null;
    }

    Rectangle getNameRect(Rectangle bounds, int idx, int nameWidth) {
        Rectangle rect = this.getItemRect(bounds, idx);
        rect.width = nameWidth;
        return rect;
    }

    Rectangle getStatesRect(Rectangle bounds, int idx, int nameWidth) {
        Rectangle rect = this.getItemRect(bounds, idx);
        rect.x += nameWidth;
        rect.width -= nameWidth;
        return rect;
    }

    Rectangle getItemRect(Rectangle bounds, int idx) {
        int i;
        int ySum = 0;
        if (idx >= this.fTopIndex) {
            i = this.fTopIndex;
            while (i < idx) {
                ySum += this.fItemData.fExpandedItems[i].fItemHeight;
                ++i;
            }
        } else {
            i = this.fTopIndex - 1;
            while (i >= idx) {
                ySum -= this.fItemData.fExpandedItems[i].fItemHeight;
                --i;
            }
        }
        int y = bounds.y + ySum;
        int height = this.fItemData.fExpandedItems[idx].fItemHeight;
        return new Rectangle(bounds.x, y, bounds.width, height);
    }

    @Override
    void paint(Rectangle bounds, PaintEvent e) {
        GC gc = e.gc;
        if (bounds.width < 2 || bounds.height < 2 || this.fTimeProvider == null) {
            return;
        }
        this.fIdealNameSpace = 0;
        int nameSpace = this.fTimeProvider.getNameSpace();
        this.drawBackground(bounds, nameSpace, gc);
        this.drawGridLines(bounds, gc);
        this.drawMarkers(bounds, this.fTimeProvider, this.fMarkers, false, nameSpace, gc);
        this.drawItems(bounds, this.fTimeProvider, this.fItemData.fExpandedItems, this.fTopIndex, nameSpace, gc);
        this.drawMarkers(bounds, this.fTimeProvider, this.fMarkers, true, nameSpace, gc);
        this.drawLinks(bounds, this.fTimeProvider, this.fItemData.fLinks, nameSpace, gc);
        this.fTimeGraphProvider.postDrawControl(bounds, gc);
        int alpha = gc.getAlpha();
        gc.setAlpha(100);
        long time0 = this.fTimeProvider.getTime0();
        long time1 = this.fTimeProvider.getTime1();
        long selectionBegin = this.fTimeProvider.getSelectionBegin();
        long selectionEnd = this.fTimeProvider.getSelectionEnd();
        double pixelsPerNanoSec = bounds.width - nameSpace <= 1 ? 0.0 : (double)(bounds.width - nameSpace - 1) / (double)(time1 - time0);
        int x0 = SaturatedArithmetic.add((int)(bounds.x + nameSpace), (int)((int)((double)(selectionBegin - time0) * pixelsPerNanoSec)));
        int x1 = SaturatedArithmetic.add((int)(bounds.x + nameSpace), (int)((int)((double)(selectionEnd - time0) * pixelsPerNanoSec)));
        if (this.fDragState != 4) {
            gc.setForeground(this.getColorScheme().getColor(68));
            if (x0 >= nameSpace && x0 < bounds.x + bounds.width) {
                gc.drawLine(x0, bounds.y, x0, bounds.y + bounds.height);
            }
            if (x1 != x0 && x1 >= nameSpace && x1 < bounds.x + bounds.width) {
                gc.drawLine(x1, bounds.y, x1, bounds.y + bounds.height);
            }
        }
        if (selectionBegin != 0L && selectionEnd != 0L && this.fDragState != 4) {
            x0 = Math.max(nameSpace, Math.min(bounds.x + bounds.width, x0));
            x1 = Math.max(nameSpace, Math.min(bounds.x + bounds.width, x1));
            gc.setBackground(this.getColorScheme().getBkColor(false, false, true));
            if (x1 - x0 > 1) {
                gc.fillRectangle(new Rectangle(x0 + 1, bounds.y, x1 - x0 - 1, bounds.height));
            } else if (x0 - x1 > 1) {
                gc.fillRectangle(new Rectangle(x1 + 1, bounds.y, x0 - x1 - 1, bounds.height));
            }
        }
        if (this.fDragState == 3 || this.fDragState == 4) {
            gc.setBackground(this.getColorScheme().getBkColor(false, false, true));
            if (this.fDragX0 < this.fDragX) {
                gc.fillRectangle(new Rectangle(this.fDragX0, bounds.y, this.fDragX - this.fDragX0, bounds.height));
            } else if (this.fDragX0 > this.fDragX) {
                gc.fillRectangle(new Rectangle(this.fDragX, bounds.y, this.fDragX0 - this.fDragX, bounds.height));
            }
        }
        if (2 == this.fDragState || this.fDragState == 0 && this.fMouseOverSplitLine && this.fTimeProvider.getNameSpace() > 0) {
            gc.setBackground(this.getColorScheme().getColor(44));
        } else {
            gc.setBackground(this.getColorScheme().getColor(42));
        }
        gc.fillRectangle(bounds.x + nameSpace - 3, bounds.y, 3, bounds.height);
        if (3 == this.fDragState && Math.max(this.fDragX, this.fDragX0) > nameSpace) {
            gc.setForeground(this.getColorScheme().getColor(39));
            gc.drawLine(this.fDragX0, bounds.y, this.fDragX0, bounds.y + bounds.height - 1);
            if (this.fDragX != this.fDragX0) {
                gc.drawLine(this.fDragX, bounds.y, this.fDragX, bounds.y + bounds.height - 1);
            }
        } else if (4 == this.fDragState && Math.max(this.fDragX, this.fDragX0) > nameSpace) {
            gc.setForeground(this.getColorScheme().getColor(68));
            gc.drawLine(this.fDragX0, bounds.y, this.fDragX0, bounds.y + bounds.height - 1);
            if (this.fDragX != this.fDragX0) {
                gc.drawLine(this.fDragX, bounds.y, this.fDragX, bounds.y + bounds.height - 1);
            }
        }
        gc.setAlpha(alpha);
    }

    protected void drawBackground(Rectangle bounds, int nameSpace, GC gc) {
        gc.setBackground(this.getColorScheme().getBkColor(false, false, true));
        this.drawBackground(gc, bounds.x, bounds.y, nameSpace, bounds.height);
        gc.setBackground(this.getColorScheme().getColor(32));
        this.drawBackground(gc, bounds.x + nameSpace, bounds.y, bounds.width - nameSpace, bounds.height);
        int i = this.fTopIndex;
        while (i < this.fItemData.fExpandedItems.length) {
            Rectangle itemRect = this.getItemRect(bounds, i);
            if (itemRect.y >= bounds.y + bounds.height) break;
            Item item = this.fItemData.fExpandedItems[i];
            if (!item.fEntry.hasTimeEvents()) {
                gc.setBackground(this.getColorScheme().getBkColorGroup(item.fSelected, this.fIsInFocus));
                gc.fillRectangle(itemRect);
            } else if (item.fSelected) {
                gc.setBackground(this.getColorScheme().getBkColor(true, this.fIsInFocus, true));
                gc.fillRectangle(itemRect.x, itemRect.y, nameSpace, itemRect.height);
                gc.setBackground(this.getColorScheme().getBkColor(true, this.fIsInFocus, false));
                gc.fillRectangle(nameSpace, itemRect.y, itemRect.width - nameSpace, itemRect.height);
            }
            Rectangle nameRect = new Rectangle(itemRect.x, itemRect.y, nameSpace, itemRect.height);
            this.drawName(item, nameRect, gc);
            if (item.fEntry.hasTimeEvents()) {
                Rectangle rect = new Rectangle(nameSpace, itemRect.y, itemRect.width - nameSpace, itemRect.height);
                this.drawMidLine(rect, gc);
            }
            ++i;
        }
    }

    public void drawGridLines(Rectangle bounds, GC gc) {
        if (!this.fGridLinesVisible) {
            return;
        }
        gc.setForeground(this.fGridLineColor);
        gc.setAlpha(this.fGridLineColor.getAlpha());
        for (int x : this.fTimeGraphScale.getTickList()) {
            gc.drawLine(x, bounds.y, x, bounds.y + bounds.height);
        }
        gc.setAlpha(255);
    }

    protected void drawMarkers(Rectangle bounds, ITimeDataProvider timeProvider, List<IMarkerEvent> markers, boolean foreground, int nameSpace, GC gc) {
        if (!this.fMarkersVisible || markers == null || markers.isEmpty()) {
            return;
        }
        gc.setClipping(new Rectangle(nameSpace, 0, bounds.width - nameSpace, bounds.height));
        int i = 0;
        while (i < markers.size()) {
            IMarkerEvent marker = markers.get(i);
            if (marker.isForeground() == foreground) {
                this.drawMarker(marker, bounds, timeProvider, nameSpace, gc);
            }
            ++i;
        }
        gc.setClipping(null);
    }

    protected void drawMarker(IMarkerEvent marker, Rectangle bounds, ITimeDataProvider timeProvider, int nameSpace, GC gc) {
        Rectangle rect = Utils.clone(bounds);
        if (marker.getEntry() != null) {
            int index = this.fItemData.findItemIndex(marker.getEntry());
            if (index == -1) {
                return;
            }
            rect = this.getStatesRect(bounds, index, nameSpace);
            if (rect.y < 0 || rect.y > bounds.height) {
                return;
            }
        }
        int x0 = this.getXForTime(marker.getTime());
        int x1 = this.getXForTime(marker.getTime() + marker.getDuration());
        if (x0 > bounds.width || x1 < nameSpace) {
            return;
        }
        rect.x = Math.max(nameSpace, Math.min(bounds.width, x0));
        rect.width = Math.max(1, Math.min(bounds.width, x1) - rect.x);
        Color color = this.getColorScheme().getColor(marker.getColor());
        gc.setBackground(color);
        gc.setAlpha(color.getAlpha());
        gc.fillRectangle(rect);
        gc.setAlpha(255);
        String label = marker.getLabel();
        if (label != null && marker.getEntry() != null) {
            label = label.substring(0, Math.min(label.indexOf(10) != -1 ? label.indexOf(10) : label.length(), 256));
            gc.setForeground(color);
            Utils.drawText(gc, label, rect.x - gc.textExtent((String)label).x, rect.y, true);
        }
    }

    public void drawItems(Rectangle bounds, ITimeDataProvider timeProvider, Item[] items, int topIndex, int nameSpace, GC gc) {
        int bottomIndex = Integer.min(topIndex + this.countPerPage() + 1, items.length);
        int i = topIndex;
        while (i < bottomIndex) {
            Item item = items[i];
            this.drawItem(item, bounds, timeProvider, i, nameSpace, gc);
            ++i;
        }
    }

    protected void drawItem(Item item, Rectangle bounds, ITimeDataProvider timeProvider, int i, int nameSpace, GC gc) {
        double pixelsPerNanoSec;
        Rectangle itemRect = this.getItemRect(bounds, i);
        if (itemRect.y >= bounds.y + bounds.height) {
            return;
        }
        ITimeGraphEntry entry = item.fEntry;
        long time0 = timeProvider.getTime0();
        long time1 = timeProvider.getTime1();
        long selectedTime = this.fTimeProvider.getSelectionEnd();
        Rectangle rect = new Rectangle(nameSpace, itemRect.y, itemRect.width - nameSpace, itemRect.height);
        if (rect.isEmpty() || time1 <= time0) {
            this.fTimeGraphProvider.postDrawEntry(entry, rect, gc);
            return;
        }
        boolean selected = item.fSelected;
        double d = pixelsPerNanoSec = rect.width <= 1 ? 0.0 : (double)(rect.width - 1) / (double)(time1 - time0);
        if (item.fEntry.hasTimeEvents()) {
            gc.setClipping(new Rectangle(nameSpace, 0, bounds.width - nameSpace, bounds.height));
            this.fillSpace(rect, gc, selected);
            int margins = TimeGraphControl.getMarginForHeight(rect.height);
            int height = rect.height - margins;
            int topMargin = (margins + 1) / 2;
            Rectangle stateRect = new Rectangle(rect.x, rect.y + topMargin, rect.width, height);
            this.setFontForHeight(height, gc);
            long maxDuration = timeProvider.getTimeSpace() == 0 ? Long.MAX_VALUE : 1L * (time1 - time0) / (long)timeProvider.getTimeSpace();
            Iterator iterator = entry.getTimeEventsIterator(time0, time1, maxDuration);
            int lastX = -1;
            while (iterator.hasNext()) {
                boolean timeSelected;
                ITimeEvent event = (ITimeEvent)iterator.next();
                int x = SaturatedArithmetic.add((int)rect.x, (int)((int)((double)(event.getTime() - time0) * pixelsPerNanoSec)));
                int xEnd = SaturatedArithmetic.add((int)rect.x, (int)((int)((double)(event.getTime() + event.getDuration() - time0) * pixelsPerNanoSec)));
                if (x >= rect.x + rect.width || xEnd < rect.x) continue;
                xEnd = Math.min(rect.x + rect.width, xEnd);
                stateRect.x = Math.max(rect.x, x);
                stateRect.width = Math.max(0, xEnd - stateRect.x + 1);
                if (stateRect.x == lastX) {
                    --stateRect.width;
                    if (stateRect.width > 0) {
                        gc.setForeground(Display.getDefault().getSystemColor(2));
                        gc.drawPoint(stateRect.x, stateRect.y - 2);
                        ++stateRect.x;
                    }
                }
                boolean bl = timeSelected = selectedTime >= event.getTime() && selectedTime < event.getTime() + event.getDuration();
                if (!this.drawState(this.getColorScheme(), event, stateRect, gc, selected, timeSelected)) continue;
                lastX = stateRect.x;
            }
            gc.setClipping(null);
        }
        this.fTimeGraphProvider.postDrawEntry(entry, rect, gc);
    }

    public void drawLinks(Rectangle bounds, ITimeDataProvider timeProvider, List<ILinkEvent> links, int nameSpace, GC gc) {
        if (this.fHideArrows) {
            return;
        }
        gc.setClipping(new Rectangle(nameSpace, 0, bounds.width - nameSpace, bounds.height));
        int i = 0;
        while (i < links.size()) {
            this.drawLink(links.get(i), bounds, timeProvider, nameSpace, gc);
            ++i;
        }
        gc.setClipping(null);
    }

    protected void drawLink(ILinkEvent event, Rectangle bounds, ITimeDataProvider timeProvider, int nameSpace, GC gc) {
        this.drawArrow(this.getColorScheme(), event, this.getArrowRectangle(bounds, event), gc);
    }

    private @Nullable Rectangle getArrowRectangle(Rectangle bounds, ILinkEvent event) {
        int srcIndex = this.fItemData.findItemIndex(event.getEntry());
        int destIndex = this.fItemData.findItemIndex(event.getDestinationEntry());
        if (srcIndex == -1 || destIndex == -1) {
            return null;
        }
        Rectangle src = this.getStatesRect(bounds, srcIndex, this.fTimeProvider.getNameSpace());
        Rectangle dst = this.getStatesRect(bounds, destIndex, this.fTimeProvider.getNameSpace());
        int x0 = this.getXForTime(event.getTime());
        int x1 = this.getXForTime(event.getTime() + event.getDuration());
        int limit = 0x1FFFFF;
        x0 = Math.max(-2097151, Math.min(x0, 0x1FFFFF));
        x1 = Math.max(-2097151, Math.min(x1, 0x1FFFFF));
        int y0 = src.y + src.height / 2;
        int y1 = dst.y + dst.height / 2;
        return LineClipper.clip(bounds, x0, y0, x1, y1);
    }

    protected boolean drawArrow(TimeGraphColorScheme colors, ITimeEvent event, Rectangle rect, GC gc) {
        boolean visible;
        if (rect == null) {
            return false;
        }
        int colorIdx = this.fTimeGraphProvider.getStateTableIndex(event);
        if (colorIdx < 0) {
            return false;
        }
        boolean bl = visible = rect.height != 0 || rect.width != 0;
        if (visible) {
            Color stateColor = null;
            stateColor = colorIdx < this.fEventColorMap.length ? this.fEventColorMap[colorIdx] : Display.getDefault().getSystemColor(2);
            gc.setForeground(stateColor);
            gc.setBackground(stateColor);
            gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
            TimeGraphControl.drawArrowHead(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, gc);
        }
        this.fTimeGraphProvider.postDrawEvent(event, rect, gc);
        return visible;
    }

    private static void drawArrowHead(int x0, int y0, int x1, int y1, GC gc) {
        int factor = 10;
        double cos = 0.951;
        double sin = 0.309;
        long lenx = x1 - x0;
        long leny = y1 - y0;
        double len = Math.sqrt(lenx * lenx + leny * leny);
        double dx = (double)((long)factor * lenx) / len;
        double dy = (double)((long)factor * leny) / len;
        int end1X = (int)Math.round((double)x1 - (dx * cos + dy * -sin));
        int end1Y = (int)Math.round((double)y1 - (dx * sin + dy * cos));
        int end2X = (int)Math.round((double)x1 - (dx * cos + dy * sin));
        int end2Y = (int)Math.round((double)y1 - (dx * -sin + dy * cos));
        int[] arrow = new int[]{x1, y1, end1X, end1Y, end2X, end2Y, x1, y1};
        gc.fillPolygon(arrow);
    }

    protected void drawName(Item item, Rectangle bounds, GC gc) {
        if (this.fTimeProvider.getNameSpace() == 0) {
            return;
        }
        boolean hasTimeEvents = item.fEntry.hasTimeEvents();
        if (hasTimeEvents) {
            gc.setClipping(bounds);
        }
        int height = bounds.height - TimeGraphControl.getMarginForHeight(bounds.height);
        this.setFontForHeight(height, gc);
        String name = this.fLabelProvider == null ? item.fName : this.fLabelProvider.getColumnText((Object)item.fEntry, 0);
        Rectangle rect = Utils.clone(bounds);
        rect.y += (bounds.height - gc.stringExtent((String)name).y) / 2;
        TreeColumn[] columns = this.fTree.getColumns();
        int idealNameSpace = 0;
        int i = 0;
        while (i < columns.length) {
            int columnIndex = this.fTree.getColumnOrder()[i];
            TreeColumn column = columns[columnIndex];
            rect.width = column.getWidth();
            gc.setClipping(rect.x, bounds.y, Math.min(rect.width, bounds.x + bounds.width - rect.x - 3), bounds.height);
            int width = 4;
            if (i == 0) {
                Image img;
                width += item.fLevel * 9;
                if (item.fHasChildren) {
                    gc.setBackground(this.getColorScheme().getColor(44));
                    int arrowHeightHint = height < 4 ? height : (height < 6 ? height - 1 : height - 2);
                    int arrowHalfHeight = Math.max(1, Math.min(arrowHeightHint, (int)Math.round(7.0 / ARROW_RATIO))) / 2;
                    int arrowHalfWidth = (Math.max(1, Math.min(7, (int)Math.round((double)arrowHeightHint * ARROW_RATIO))) + 1) / 2;
                    int x1 = bounds.x + width + 1;
                    int x2 = x1 + 2 * arrowHalfWidth;
                    int midy = bounds.y + bounds.height / 2;
                    int y1 = midy - arrowHalfHeight;
                    int y2 = midy + arrowHalfHeight;
                    if (!item.fExpanded) {
                        gc.fillPolygon(new int[]{x1, y1, x2, midy, x1, y2});
                    } else {
                        int midx = x1 + arrowHalfWidth;
                        gc.fillPolygon(new int[]{x1, y1, x2, y1, midx, y2});
                    }
                }
                width += 13;
                Image image = this.fLabelProvider != null ? this.fLabelProvider.getColumnImage((Object)item.fEntry, columnIndex) : (img = columnIndex == 0 ? this.fTimeGraphProvider.getItemImage(item.fEntry) : null);
                if (img != null) {
                    int imgHeight = img.getImageData().height;
                    int imgWidth = img.getImageData().width;
                    int dstHeight = Math.min(bounds.height, imgHeight);
                    int dstWidth = dstHeight * imgWidth / imgHeight;
                    int x = width;
                    int y = bounds.y + (bounds.height - dstHeight) / 2;
                    gc.drawImage(img, 0, 0, imgWidth, imgHeight, x, y, dstWidth, dstHeight);
                    width += imgWidth + 4;
                }
            } else if (this.fLabelProvider == null) break;
            String label = this.fLabelProvider != null ? this.fLabelProvider.getColumnText((Object)item.fEntry, columnIndex) : (columnIndex == 0 ? item.fName : "");
            gc.setForeground(this.getColorScheme().getFgColor(item.fSelected, this.fIsInFocus));
            Rectangle textRect = new Rectangle(rect.x + width, rect.y, rect.width - width, rect.height);
            int textWidth = Utils.drawText(gc, label, textRect, true);
            width += textWidth + 4;
            if (textWidth > 0) {
                idealNameSpace = rect.x + width;
            }
            if (columns.length == 1) {
                this.drawMidLine(new Rectangle(bounds.x + width, bounds.y, bounds.x + bounds.width, bounds.height), gc);
            }
            if (this.fAutoResizeColumns && width > column.getWidth()) {
                column.setData(PREFERRED_WIDTH, (Object)width);
                column.setWidth(width);
            }
            gc.setForeground(this.getColorScheme().getColor(61));
            if (i < columns.length - 1) {
                int x = rect.x + rect.width - 1;
                gc.drawLine(x, bounds.y, x, bounds.y + bounds.height);
            }
            rect.x += rect.width;
            ++i;
        }
        this.fIdealNameSpace = Math.max(this.fIdealNameSpace, idealNameSpace);
        gc.setClipping(null);
    }

    protected boolean drawState(TimeGraphColorScheme colors, ITimeEvent event, Rectangle rect, GC gc, boolean selected, boolean timeSelected) {
        int colorIdx = this.fTimeGraphProvider.getStateTableIndex(event);
        if (colorIdx < 0 && colorIdx != -2) {
            return false;
        }
        boolean visible = rect.width != 0;
        rect.width = Math.max(1, rect.width);
        Color black = Display.getDefault().getSystemColor(2);
        gc.setForeground(black);
        Map<String, Object> styleMap = this.fTimeGraphProvider.getEventStyle(event);
        float heightFactor = ((Float)styleMap.getOrDefault(ITimeEventStyleStrings.heightFactor(), Float.valueOf(1.0f))).floatValue();
        if ((double)heightFactor > 1.0 || heightFactor < 0.0f) {
            if (this.fFirstHeightWarning) {
                TraceCompassLog.getLogger(this.getClass()).warning("Heightfactor out of range : " + heightFactor + " for event " + event.toString() + " - clamping results");
                this.fFirstHeightWarning = false;
            }
            heightFactor = Math.max(0.0f, Math.min(1.0f, heightFactor));
        }
        int height = (int)((float)rect.height * heightFactor);
        Rectangle drawRect = new Rectangle(rect.x, rect.y + (rect.height - height) / 2, rect.width, height);
        if (colorIdx == -2) {
            if (visible) {
                gc.drawLine(drawRect.x, drawRect.y, drawRect.x + drawRect.width - 1, drawRect.y);
                gc.drawLine(drawRect.x, drawRect.y + drawRect.height - 1, drawRect.x + drawRect.width - 1, drawRect.y + drawRect.height - 1);
                if (drawRect.width == 1) {
                    gc.drawPoint(drawRect.x, drawRect.y - 2);
                }
            }
            this.fTimeGraphProvider.postDrawEvent(event, drawRect, gc);
            return false;
        }
        Color stateColor = null;
        stateColor = colorIdx < this.fEventColorMap.length ? this.fEventColorMap[colorIdx] : black;
        boolean reallySelected = timeSelected && selected;
        gc.setBackground(stateColor);
        if (visible) {
            int prevAlpha = gc.getAlpha();
            int alpha = (Integer)styleMap.getOrDefault(ITimeEventStyleStrings.fillColor(), 255) & 0xFF;
            gc.setAlpha(alpha);
            gc.fillRectangle(drawRect);
            gc.setAlpha(prevAlpha);
        } else if (this.fBlendSubPixelEvents) {
            gc.setAlpha(128);
            gc.fillRectangle(drawRect);
            gc.setAlpha(255);
        }
        if (reallySelected) {
            gc.drawLine(drawRect.x, drawRect.y - 1, drawRect.x + drawRect.width - 1, drawRect.y - 1);
            gc.drawLine(drawRect.x, drawRect.y + drawRect.height, drawRect.x + drawRect.width - 1, drawRect.y + drawRect.height);
        }
        if (!visible) {
            gc.drawPoint(drawRect.x, drawRect.y - 2);
        }
        this.fTimeGraphProvider.postDrawEvent(event, drawRect, gc);
        return visible;
    }

    protected void fillSpace(Rectangle rect, GC gc, boolean selected) {
    }

    private void drawMidLine(Rectangle rect, GC gc) {
        gc.setForeground(this.getColorScheme().getColor(61));
        int midy = rect.y + rect.height / 2;
        gc.drawLine(rect.x, midy, rect.x + rect.width, midy);
    }

    private static int getMarginForHeight(int height) {
        int MARGIN_THRESHOLD = 4;
        int PREFERRED_HEIGHT = 13;
        boolean MIN_MARGIN = true;
        int MAX_MARGIN = 6;
        return height <= 4 ? 0 : Math.max(Math.min(height - 13, 6), 1);
    }

    private void setFontForHeight(int pixels, GC gc) {
        int height = Math.max(pixels * 72 / DPI, 1);
        Font font = this.fFonts.get(height);
        if (font == null) {
            FontData fontData = gc.getFont().getFontData()[0];
            fontData.setHeight(height);
            font = new Font(gc.getDevice(), fontData);
            this.fFonts.put(height, font);
        }
        gc.setFont(font);
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.detail == 16 || e.detail == 8) {
            e.doit = true;
        }
    }

    public void keyPressed(KeyEvent e) {
        ITimeGraphEntry entry;
        int idx = -1;
        if (this.fItemData.fExpandedItems.length == 0) {
            return;
        }
        if (0x1000007 == e.keyCode) {
            idx = 0;
        } else if (0x1000008 == e.keyCode) {
            idx = this.fItemData.fExpandedItems.length - 1;
        } else if (0x1000002 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            } else if (idx < this.fItemData.fExpandedItems.length - 1) {
                ++idx;
            }
        } else if (0x1000001 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            } else if (idx > 0) {
                --idx;
            }
        } else if (0x1000003 == e.keyCode && this.fDragState == 0) {
            boolean extend = (e.stateMask & 0x20000) != 0;
            this.selectPrevEvent(extend);
        } else if (0x1000004 == e.keyCode && this.fDragState == 0) {
            boolean extend = (e.stateMask & 0x20000) != 0;
            this.selectNextEvent(extend);
        } else if (0x1000006 == e.keyCode) {
            int page = this.countPerPage();
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            }
            if ((idx += page) >= this.fItemData.fExpandedItems.length) {
                idx = this.fItemData.fExpandedItems.length - 1;
            }
        } else if (0x1000005 == e.keyCode) {
            int page = this.countPerPage();
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            }
            if ((idx -= page) < 0) {
                idx = 0;
            }
        } else if (13 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx >= 0) {
                if (this.fItemData.fExpandedItems[idx].fHasChildren) {
                    this.toggle(idx);
                } else {
                    this.fireDefaultSelection();
                }
            }
            idx = -1;
        } else if ((e.character == '+' || e.character == '=') && (e.stateMask & 0x40000) != 0) {
            this.fVerticalZoomAlignEntry = this.getVerticalZoomAlignSelection();
            this.verticalZoom(true);
            if (this.fVerticalZoomAlignEntry != null) {
                this.setElementPosition(this.fVerticalZoomAlignEntry.getKey(), this.fVerticalZoomAlignEntry.getValue());
            }
        } else if (e.character == '-' && (e.stateMask & 0x40000) != 0) {
            this.fVerticalZoomAlignEntry = this.getVerticalZoomAlignSelection();
            this.verticalZoom(false);
            if (this.fVerticalZoomAlignEntry != null) {
                this.setElementPosition(this.fVerticalZoomAlignEntry.getKey(), this.fVerticalZoomAlignEntry.getValue());
            }
        } else if (e.character == '0' && (e.stateMask & 0x40000) != 0) {
            this.fVerticalZoomAlignEntry = this.getVerticalZoomAlignSelection();
            this.resetVerticalZoom();
            if (this.fVerticalZoomAlignEntry != null) {
                this.setElementPosition(this.fVerticalZoomAlignEntry.getKey(), this.fVerticalZoomAlignEntry.getValue());
            }
        } else if ((e.character == '+' || e.character == '=') && (e.stateMask & 0x40000) == 0) {
            if (this.fHasNamespaceFocus) {
                ITimeGraphEntry entry2 = this.getSelectedTrace();
                this.setExpandedState(entry2, 0, true);
            } else {
                this.zoomIn();
            }
        } else if (e.character == '-' && (e.stateMask & 0x40000) == 0) {
            if (this.fHasNamespaceFocus) {
                ITimeGraphEntry entry3 = this.getSelectedTrace();
                if (entry3 != null && entry3.hasChildren()) {
                    this.setExpandedState(entry3, -1, false);
                }
            } else {
                this.zoomOut();
            }
        } else if (e.character == '*' && (e.stateMask & 0x40000) == 0 && this.fHasNamespaceFocus && (entry = this.getSelectedTrace()) != null && entry.hasChildren()) {
            this.setExpandedStateLevel(entry);
        }
        if (idx >= 0) {
            this.selectItem(idx, false);
            this.fireSelectionChanged();
        }
        int x = this.toControl((Point)e.display.getCursorLocation()).x;
        this.updateCursor(x, e.stateMask | e.keyCode);
    }

    public void keyReleased(KeyEvent e) {
        int x = this.toControl((Point)e.display.getCursorLocation()).x;
        this.updateCursor(x, e.stateMask & ~e.keyCode);
    }

    public void focusGained(FocusEvent e) {
        this.fIsInFocus = true;
        this.redraw();
        this.updateStatusLine(-2);
    }

    public void focusLost(FocusEvent e) {
        this.fIsInFocus = false;
        if (this.fDragState != 0) {
            this.setCapture(false);
            this.fDragState = 0;
        }
        this.redraw();
        this.updateStatusLine(-1);
    }

    public boolean isInFocus() {
        return this.fIsInFocus;
    }

    public void waitCursor(boolean waitInd) {
        if (waitInd) {
            this.setCursor(this.fWaitCursor);
        } else {
            this.setCursor(null);
        }
    }

    private void updateCursor(int x, int stateMask) {
        if (this.getCursor() == this.fWaitCursor) {
            return;
        }
        Cursor cursor = null;
        if (this.fDragState != 2) {
            if (this.fDragState == 4) {
                cursor = this.fResizeCursor;
            } else if (this.fDragState == 1) {
                cursor = this.fDragCursor;
            } else if (this.fDragState == 3) {
                cursor = this.fZoomCursor;
            } else if ((stateMask & SWT.MODIFIER_MASK) == 262144) {
                cursor = this.fDragCursor;
            } else if ((stateMask & SWT.MODIFIER_MASK) == 131072) {
                cursor = this.fResizeCursor;
            } else if (!this.isOverSplitLine(x)) {
                long selectionBegin = this.fTimeProvider.getSelectionBegin();
                long selectionEnd = this.fTimeProvider.getSelectionEnd();
                int xBegin = this.getXForTime(selectionBegin);
                int xEnd = this.getXForTime(selectionEnd);
                if (Math.abs(x - xBegin) < 3 || Math.abs(x - xEnd) < 3) {
                    cursor = this.fResizeCursor;
                }
            }
        }
        if (this.getCursor() != cursor) {
            this.setCursor(cursor);
        }
    }

    public void updateStatusLine() {
        this.updateStatusLine(-2);
    }

    private void updateStatusLine(int x) {
        ITimeDataProvider tdp = this.fTimeGraphScale.getTimeProvider();
        if (this.fStatusLineManager == null || tdp == null || tdp.getTime0() == tdp.getTime1()) {
            return;
        }
        long cursorTime = -1L;
        long selectionBeginTime = 0L;
        long selectionEndTime = 0L;
        if ((x >= 0 || x == -2) && this.fDragState == 0) {
            long time;
            if (x != -2 && (time = this.getTimeAtX(x)) >= 0L) {
                if (tdp instanceof ITimeDataProviderConverter) {
                    time = ((ITimeDataProviderConverter)tdp).convertTime(time);
                }
                cursorTime = time;
            }
            selectionBeginTime = tdp.getSelectionBegin();
            selectionEndTime = tdp.getSelectionEnd();
        } else if (this.fDragState == 4 || this.fDragState == 3) {
            long time;
            long time0 = this.fDragBeginMarker ? this.getTimeAtX(this.fDragX0) : this.fDragTime0;
            long l = time = this.fDragBeginMarker ? this.fDragTime0 : this.getTimeAtX(this.fDragX);
            if (tdp instanceof ITimeDataProviderConverter) {
                time0 = ((ITimeDataProviderConverter)tdp).convertTime(time0);
                time = ((ITimeDataProviderConverter)tdp).convertTime(time);
            }
            cursorTime = time;
            selectionBeginTime = time0;
            selectionEndTime = time;
        }
        String message = TimeGraphControl.buildStatusMessage(cursorTime, selectionBeginTime, selectionEndTime, tdp.getTimeFormat().convert(), FormatTimeUtils.Resolution.NANOSEC);
        this.fStatusLineManager.setMessage(message);
    }

    private static String buildStatusMessage(long cursorTime, long selectionBeginTime, long selectionEndTime, FormatTimeUtils.TimeFormat tf, FormatTimeUtils.Resolution res) {
        StringBuilder message = new StringBuilder();
        if (cursorTime >= 0L) {
            message.append(NLS.bind((String)"T: {0}{1}     ", (Object[])new Object[]{tf == FormatTimeUtils.TimeFormat.CALENDAR ? String.valueOf(FormatTimeUtils.formatDate(cursorTime)) + ' ' : "", FormatTimeUtils.formatTime(cursorTime, tf, res)}));
        }
        message.append(NLS.bind((String)"T1: {0}{1}", (Object[])new Object[]{tf == FormatTimeUtils.TimeFormat.CALENDAR ? String.valueOf(FormatTimeUtils.formatDate(selectionBeginTime)) + ' ' : "", FormatTimeUtils.formatTime(selectionBeginTime, tf, res)}));
        if (selectionBeginTime != selectionEndTime) {
            message.append(NLS.bind((String)"     T2: {0}{1}     \u0394: {2}", (Object[])new Object[]{tf == FormatTimeUtils.TimeFormat.CALENDAR ? String.valueOf(FormatTimeUtils.formatDate(selectionEndTime)) + ' ' : "", FormatTimeUtils.formatTime(selectionEndTime, tf, res), FormatTimeUtils.formatDelta(selectionEndTime - selectionBeginTime, tf, res)}));
        }
        return message.toString();
    }

    public void mouseMove(MouseEvent e) {
        if (this.fTimeProvider == null) {
            return;
        }
        Point size = this.getSize();
        if (1 == this.fDragState) {
            int nameWidth = this.fTimeProvider.getNameSpace();
            if (e.x > nameWidth && size.x > nameWidth && this.fDragX != e.x) {
                long time0;
                long maxTime;
                this.fDragX = e.x;
                double pixelsPerNanoSec = size.x - nameWidth <= 1 ? 0.0 : (double)(size.x - nameWidth - 1) / (double)(this.fTime1bak - this.fTime0bak);
                long timeDelta = (long)(pixelsPerNanoSec == 0.0 ? 0.0 : (double)(this.fDragX - this.fDragX0) / pixelsPerNanoSec);
                long time1 = this.fTime1bak - timeDelta;
                if (time1 > (maxTime = this.fTimeProvider.getMaxTime())) {
                    time1 = maxTime;
                }
                if ((time0 = time1 - (this.fTime1bak - this.fTime0bak)) < this.fTimeProvider.getMinTime()) {
                    time0 = this.fTimeProvider.getMinTime();
                    time1 = time0 + (this.fTime1bak - this.fTime0bak);
                }
                this.fTimeProvider.setStartFinishTimeNotify(time0, time1);
            }
        } else if (2 == this.fDragState) {
            this.fDragX = e.x;
            this.fTimeProvider.setNameSpace(e.x);
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(this, this.getTimeViewAlignmentInfo()));
        } else if (4 == this.fDragState) {
            if (this.fDragBeginMarker) {
                this.fDragX0 = Math.min(Math.max(e.x, this.fTimeProvider.getNameSpace()), size.x - 1);
            } else {
                this.fDragX = Math.min(Math.max(e.x, this.fTimeProvider.getNameSpace()), size.x - 1);
            }
            this.redraw();
            this.fTimeGraphScale.setDragRange(this.fDragX0, this.fDragX);
            this.fireDragSelectionChanged(this.getTimeAtX(this.fDragX0), this.getTimeAtX(this.fDragX));
        } else if (3 == this.fDragState) {
            this.fDragX = Math.min(Math.max(e.x, this.fTimeProvider.getNameSpace()), size.x - 1);
            this.redraw();
            this.fTimeGraphScale.setDragRange(this.fDragX0, this.fDragX);
        } else if (this.fDragState == 0) {
            boolean mouseOverSplitLine = this.isOverSplitLine(e.x);
            if (this.fMouseOverSplitLine != mouseOverSplitLine) {
                this.redraw();
            }
            this.fMouseOverSplitLine = mouseOverSplitLine;
        }
        this.fHasNamespaceFocus = e.x < this.fTimeProvider.getNameSpace();
        this.updateCursor(e.x, e.stateMask);
        this.updateStatusLine(e.x);
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this.fTimeProvider == null) {
            return;
        }
        if (1 == e.button && (e.stateMask & SWT.BUTTON_MASK) == 0) {
            if (this.isOverSplitLine(e.x) && this.fTimeProvider.getNameSpace() != 0) {
                this.fTimeProvider.setNameSpace(this.fIdealNameSpace);
                boolean mouseOverSplitLine = this.isOverSplitLine(e.x);
                if (this.fMouseOverSplitLine != mouseOverSplitLine) {
                    this.redraw();
                }
                this.fMouseOverSplitLine = mouseOverSplitLine;
                TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(this, this.getTimeViewAlignmentInfo()));
                return;
            }
            int idx = this.getItemIndexAtY(e.y);
            if (idx >= 0) {
                this.selectItem(idx, false);
                this.fireDefaultSelection();
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        int idx;
        int nameSpace;
        if (this.fDragState != 0) {
            return;
        }
        if (1 == e.button && (e.stateMask & SWT.MODIFIER_MASK) == 0 && (nameSpace = this.fTimeProvider.getNameSpace()) != 0 && this.isOverSplitLine(e.x)) {
            this.fDragState = 2;
            this.fDragButton = e.button;
            this.fDragX0 = this.fDragX = e.x;
            this.redraw();
            this.updateCursor(e.x, e.stateMask);
            return;
        }
        if (this.fTimeProvider == null || this.fTimeProvider.getTime0() == this.fTimeProvider.getTime1() || this.getSize().x - this.fTimeProvider.getNameSpace() <= 0) {
            return;
        }
        if (1 == e.button && ((e.stateMask & SWT.MODIFIER_MASK) == 0 || (e.stateMask & SWT.MODIFIER_MASK) == 131072)) {
            int nameSpace2 = this.fTimeProvider.getNameSpace();
            idx = this.getItemIndexAtY(e.y);
            if (idx >= 0) {
                Item item = this.fItemData.fExpandedItems[idx];
                if (item.fHasChildren && e.x < nameSpace2 && e.x < 4 + (item.fLevel + 1) * 9) {
                    this.toggle(idx);
                    return;
                }
                this.selectItem(idx, false);
                this.fireSelectionChanged();
            } else {
                this.selectItem(idx, false);
                this.fireSelectionChanged();
            }
            long hitTime = this.getTimeAtX(e.x);
            if (hitTime >= 0L) {
                this.setCapture(true);
                this.fDragState = 4;
                this.fDragBeginMarker = false;
                this.fDragButton = e.button;
                this.fDragX0 = this.fDragX = e.x;
                this.fDragTime0 = this.getTimeAtX(this.fDragX0);
                long selectionBegin = this.fTimeProvider.getSelectionBegin();
                long selectionEnd = this.fTimeProvider.getSelectionEnd();
                int xBegin = this.getXForTime(selectionBegin);
                int xEnd = this.getXForTime(selectionEnd);
                if ((e.stateMask & SWT.MODIFIER_MASK) == 131072) {
                    long time = this.getTimeAtX(e.x);
                    if (Math.abs(time - selectionBegin) < Math.abs(time - selectionEnd)) {
                        this.fDragBeginMarker = true;
                        this.fDragX = xEnd;
                        this.fDragX0 = e.x;
                        this.fDragTime0 = selectionEnd;
                    } else {
                        this.fDragX0 = xBegin;
                        this.fDragTime0 = selectionBegin;
                    }
                } else {
                    long time = this.getTimeAtX(e.x);
                    if (Math.abs(e.x - xBegin) < 3 && Math.abs(time - selectionBegin) <= Math.abs(time - selectionEnd)) {
                        this.fDragBeginMarker = true;
                        this.fDragX = xEnd;
                        this.fDragX0 = e.x;
                        this.fDragTime0 = selectionEnd;
                    } else if (Math.abs(e.x - xEnd) < 3 && Math.abs(time - selectionEnd) <= Math.abs(time - selectionBegin)) {
                        this.fDragX0 = xBegin;
                        this.fDragTime0 = selectionBegin;
                    }
                }
                this.fTime0bak = this.fTimeProvider.getTime0();
                this.fTime1bak = this.fTimeProvider.getTime1();
                this.redraw();
                this.updateCursor(e.x, e.stateMask);
                this.fTimeGraphScale.setDragRange(this.fDragX0, this.fDragX);
            }
        } else if (2 == e.button || 1 == e.button && (e.stateMask & SWT.MODIFIER_MASK) == 262144) {
            long hitTime = this.getTimeAtX(e.x);
            if (hitTime > 0L) {
                this.setCapture(true);
                this.fDragState = 1;
                this.fDragButton = e.button;
                this.fDragX0 = this.fDragX = e.x;
                this.fTime0bak = this.fTimeProvider.getTime0();
                this.fTime1bak = this.fTimeProvider.getTime1();
                this.updateCursor(e.x, e.stateMask);
            }
        } else if (3 == e.button) {
            if (e.x >= this.fTimeProvider.getNameSpace()) {
                this.setCapture(true);
                this.fDragX0 = this.fDragX = Math.min(Math.max(e.x, this.fTimeProvider.getNameSpace()), this.getSize().x - 1);
                this.fDragTime0 = this.getTimeAtX(this.fDragX0);
                this.fDragState = 3;
                this.fDragButton = e.button;
                this.redraw();
                this.updateCursor(e.x, e.stateMask);
                this.fTimeGraphScale.setDragRange(this.fDragX0, this.fDragX);
            } else {
                idx = this.getItemIndexAtY(e.y);
                this.selectItem(idx, false);
                this.fireSelectionChanged();
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        long time;
        if (this.fPendingMenuDetectEvent != null && e.button == 3) {
            if (this.fDragState == 3 && this.isInDragZoomMargin()) {
                time = this.getTimeAtX(this.fDragX0);
                this.fTimeProvider.setSelectionRangeNotify(time, time, false);
                int idx = this.getItemIndexAtY(e.y);
                this.selectItem(idx, false);
                this.fireSelectionChanged();
            }
            this.menuDetected(this.fPendingMenuDetectEvent);
        }
        if (this.fDragState != 0) {
            this.setCapture(false);
            if (e.button == this.fDragButton && 1 == this.fDragState) {
                this.fDragState = 0;
                if (this.fDragX != this.fDragX0) {
                    this.fTimeProvider.notifyStartFinishTime();
                }
            } else if (e.button == this.fDragButton && 2 == this.fDragState) {
                this.fDragState = 0;
                this.redraw();
            } else if (e.button == this.fDragButton && 4 == this.fDragState) {
                this.fDragState = 0;
                if (this.fDragX == this.fDragX0) {
                    time = this.getTimeAtX(e.x);
                    this.fTimeProvider.setSelectedTimeNotify(time, false);
                } else {
                    long time0 = this.fDragBeginMarker ? this.getTimeAtX(this.fDragX0) : this.fDragTime0;
                    long time1 = this.fDragBeginMarker ? this.fDragTime0 : this.getTimeAtX(this.fDragX);
                    this.fTimeProvider.setSelectionRangeNotify(time0, time1, false);
                }
                this.redraw();
                this.fTimeGraphScale.setDragRange(-1, -1);
            } else if (e.button == this.fDragButton && 3 == this.fDragState) {
                this.fDragState = 0;
                int nameWidth = this.fTimeProvider.getNameSpace();
                if (Math.max(this.fDragX, this.fDragX0) > nameWidth && !this.isInDragZoomMargin()) {
                    long time1;
                    long time0 = this.getTimeAtX(this.fDragX0);
                    if (time0 < (time1 = this.getTimeAtX(this.fDragX))) {
                        this.fTimeProvider.setStartFinishTimeNotify(time0, time1);
                    } else {
                        this.fTimeProvider.setStartFinishTimeNotify(time1, time0);
                    }
                } else {
                    this.redraw();
                }
                this.fTimeGraphScale.setDragRange(-1, -1);
            }
        }
        this.updateCursor(e.x, e.stateMask);
        this.updateStatusLine(e.x);
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        if (this.fMouseOverSplitLine) {
            this.fMouseOverSplitLine = false;
            this.redraw();
        }
        this.updateStatusLine(-2);
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseScrolled(MouseEvent e) {
        if (this.fDragState != 0 || e.count == 0) {
            return;
        }
        Point size = this.getSize();
        Rectangle bounds = new Rectangle(0, 0, size.x, size.y);
        if (!bounds.contains(e.x, e.y)) {
            return;
        }
        boolean horizontalZoom = false;
        boolean horizontalScroll = false;
        boolean verticalZoom = false;
        boolean verticalScroll = false;
        if ((e.stateMask & SWT.MODIFIER_MASK) == 393216) {
            verticalZoom = true;
        } else if (e.x < this.fTimeProvider.getNameSpace()) {
            verticalScroll = true;
        } else if ((e.stateMask & SWT.MODIFIER_MASK) == 262144) {
            horizontalZoom = true;
        } else if ((e.stateMask & SWT.MODIFIER_MASK) == 131072) {
            horizontalScroll = true;
        } else {
            verticalScroll = true;
        }
        if (verticalZoom) {
            this.fVerticalZoomAlignEntry = this.getVerticalZoomAlignCursor(e.y);
            this.verticalZoom(e.count > 0);
            if (this.fVerticalZoomAlignEntry != null) {
                this.setElementPosition(this.fVerticalZoomAlignEntry.getKey(), this.fVerticalZoomAlignEntry.getValue());
            }
        } else if (horizontalZoom && this.fTimeProvider.getTime0() != this.fTimeProvider.getTime1()) {
            this.zoom(e.count > 0);
        } else if (horizontalScroll) {
            this.horizontalScroll(e.count > 0);
        } else if (verticalScroll) {
            this.setTopIndex(this.getTopIndex() - e.count);
        }
    }

    private Map.Entry<ITimeGraphEntry, Integer> getVerticalZoomAlignSelection() {
        Map.Entry<ITimeGraphEntry, Integer> alignEntry = this.getVerticalZoomAlignOngoing();
        if (alignEntry != null) {
            return alignEntry;
        }
        int index = this.getSelectedIndex();
        if (index == -1 || index >= this.getExpandedElementCount()) {
            return new AbstractMap.SimpleEntry<Object, Integer>(null, 0);
        }
        Rectangle bounds = this.getClientArea();
        Rectangle itemRect = this.getItemRect(bounds, index);
        if (itemRect.y < bounds.y || itemRect.y > bounds.y + bounds.height) {
            return new AbstractMap.SimpleEntry<Object, Integer>(null, 0);
        }
        ITimeGraphEntry entry = this.getExpandedElement(index);
        int y = itemRect.y + itemRect.height / 2;
        return new AbstractMap.SimpleEntry<ITimeGraphEntry, Integer>(entry, y);
    }

    private Map.Entry<ITimeGraphEntry, Integer> getVerticalZoomAlignCursor(int y) {
        Map.Entry<ITimeGraphEntry, Integer> alignEntry = this.getVerticalZoomAlignOngoing();
        if (alignEntry != null) {
            return alignEntry;
        }
        int index = this.getItemIndexAtY(y);
        if (index == -1) {
            index = this.getExpandedElementCount() - 1;
        }
        ITimeGraphEntry entry = this.getExpandedElement(index);
        return new AbstractMap.SimpleEntry<ITimeGraphEntry, Integer>(entry, y);
    }

    private Map.Entry<ITimeGraphEntry, Integer> getVerticalZoomAlignOngoing() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis < this.fVerticalZoomAlignTime + 400L) {
            this.fVerticalZoomAlignTime = currentTimeMillis;
            return this.fVerticalZoomAlignEntry;
        }
        this.fVerticalZoomAlignTime = currentTimeMillis;
        return null;
    }

    public void handleEvent(Event event) {
        if (event.type == 37) {
            event.doit = false;
        }
    }

    public int getBorderWidth() {
        return this.fBorderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.fBorderWidth = borderWidth;
    }

    public int getHeaderHeight() {
        return this.fHeaderHeight;
    }

    public void setHeaderHeight(int headerHeight) {
        this.fHeaderHeight = headerHeight;
    }

    public int getItemHeight() {
        return this.fGlobalItemHeight;
    }

    public void setItemHeight(int rowHeight) {
        this.fGlobalItemHeight = rowHeight;
        Item[] itemArray = this.fItemData.fItems;
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            item.fItemHeight = rowHeight;
            ++n2;
        }
    }

    public boolean setItemHeight(ITimeGraphEntry entry, int rowHeight) {
        Item item = this.fItemData.findItem(entry);
        if (item != null) {
            item.fItemHeight = rowHeight;
            return true;
        }
        return false;
    }

    public void setMinimumItemWidth(int width) {
        this.fMinimumItemWidth = width;
    }

    public int getMinimumItemWidth() {
        return this.fMinimumItemWidth;
    }

    public void setBlendSubPixelEvents(boolean blend) {
        this.fBlendSubPixelEvents = blend;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null && !this.fSelectionChangedListeners.contains(listener)) {
            this.fSelectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.fSelectionChangedListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        Object ob;
        if (selection instanceof IStructuredSelection && (ob = ((IStructuredSelection)selection).getFirstElement()) instanceof ITimeGraphEntry) {
            this.selectItem((ITimeGraphEntry)ob, false);
        }
    }

    public void addFilter(@NonNull ViewerFilter filter) {
        this.fFilters.add(filter);
        this.fireFiltersAdded(Collections.singleton(filter));
    }

    public void changeFilter(@NonNull ViewerFilter filter) {
        this.fireFiltersChanged(Collections.singleton(filter));
    }

    public void removeFilter(@NonNull ViewerFilter filter) {
        this.fFilters.remove(filter);
        this.fireFiltersRemoved(Collections.singleton(filter));
    }

    public @NonNull ViewerFilter[] getFilters() {
        return (ViewerFilter[])Iterables.toArray(this.fFilters, ViewerFilter.class);
    }

    public void setFilters(@NonNull ViewerFilter[] filters) {
        this.fFilters.clear();
        if (filters != null) {
            List<@NonNull ViewerFilter> filtersList = Arrays.asList(filters);
            this.fFilters.addAll(filtersList);
            this.fireFiltersChanged(filtersList);
        }
    }

    @Override
    public void colorSettingsChanged(StateItem[] stateItems) {
        if (this.fEventColorMap != null) {
            Color[] colorArray = this.fEventColorMap;
            int n = this.fEventColorMap.length;
            int n2 = 0;
            while (n2 < n) {
                Color color = colorArray[n2];
                this.fResourceManager.destroyColor(color.getRGB());
                ++n2;
            }
        }
        if (stateItems != null) {
            this.fEventColorMap = new Color[stateItems.length];
            int i = 0;
            while (i < stateItems.length) {
                this.fEventColorMap[i] = this.fResourceManager.createColor(stateItems[i].getStateColor());
                ++i;
            }
        } else {
            this.fEventColorMap = new Color[0];
        }
        this.redraw();
    }

    public void menuDetected(MenuDetectEvent e) {
        int idx;
        if (this.fTimeProvider == null) {
            return;
        }
        boolean pendingEventCallback = this.fPendingMenuDetectEvent != null;
        Point p = this.toControl(e.x, e.y);
        if (e.detail == 0 && this.isOverTimeSpace(p.x, p.y)) {
            if (this.fPendingMenuDetectEvent == null) {
                this.fPendingMenuDetectEvent = e;
                e.doit = false;
                return;
            }
            this.fPendingMenuDetectEvent = null;
            if (this.fDragState != 3 || !this.isInDragZoomMargin()) {
                e.doit = false;
                return;
            }
        } else if (this.fDragState != 0) {
            e.doit = false;
            return;
        }
        if ((idx = this.getItemIndexAtY(p.y)) >= 0 && idx < this.fItemData.fExpandedItems.length) {
            ITimeEvent event;
            Item item = this.fItemData.fExpandedItems[idx];
            ITimeGraphEntry entry = item.fEntry;
            e.doit = true;
            e.data = entry;
            this.fireMenuEventOnTimeGraphEntry(e);
            Menu menu = this.getMenu();
            if (pendingEventCallback && e.doit && menu != null) {
                menu.setVisible(true);
            }
            if (entry.hasTimeEvents() && (event = Utils.findEvent(entry, this.getTimeAtX(p.x), 2)) != null) {
                e.doit = true;
                e.data = event;
                this.fireMenuEventOnTimeEvent(e);
                menu = this.getMenu();
                if (pendingEventCallback && e.doit && menu != null) {
                    menu.setVisible(true);
                }
            }
        }
    }

    public void performAlign(int offset) {
        this.fTimeProvider.setNameSpace(offset);
    }

    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        return new TmfTimeViewAlignmentInfo(this.getShell(), this.toDisplay(0, 0), this.fTimeProvider.getNameSpace());
    }

    private boolean isInDragZoomMargin() {
        return Math.abs(this.fDragX - this.fDragX0) < 5;
    }

    private class Item {
        private boolean fExpanded;
        private int fExpandedIndex;
        private boolean fSelected;
        private boolean fHasChildren;
        private int fItemHeight;
        private final int fLevel;
        private final List<Item> fChildren;
        private final String fName;
        private final ITimeGraphEntry fEntry;

        public Item(ITimeGraphEntry entry, String name, int level) {
            this.fEntry = entry;
            this.fName = name;
            this.fLevel = level;
            this.fChildren = new ArrayList<Item>();
        }

        public String toString() {
            return this.fName;
        }
    }

    private class ItemData {
        private Map<ITimeGraphEntry, Item> fItemMap = new LinkedHashMap<ITimeGraphEntry, Item>();
        private Item[] fExpandedItems = new Item[0];
        private Item[] fItems = new Item[0];
        private ITimeGraphEntry[] fRootEntries = new ITimeGraphEntry[0];
        private List<ILinkEvent> fLinks = new ArrayList<ILinkEvent>();

        public Item findItem(ITimeGraphEntry entry) {
            return this.fItemMap.get(entry);
        }

        public int findItemIndex(ITimeGraphEntry entry) {
            Item item = this.fItemMap.get(entry);
            if (item == null) {
                return -1;
            }
            return item.fExpandedIndex;
        }

        public void refreshData() {
            ITimeGraphEntry selection = TimeGraphControl.this.getSelectedTrace();
            LinkedHashMap<ITimeGraphEntry, Item> itemMap = new LinkedHashMap<ITimeGraphEntry, Item>();
            TimeGraphControl.this.fMaxItemHeight = 0;
            int i = 0;
            while (i < this.fRootEntries.length) {
                ITimeGraphEntry entry = this.fRootEntries[i];
                this.refreshData(itemMap, null, 0, entry);
                ++i;
            }
            this.fItemMap = itemMap;
            this.fItems = this.fItemMap.values().toArray(new Item[0]);
            this.updateExpandedItems();
            if (selection != null) {
                Item[] itemArray = this.fExpandedItems;
                int n = this.fExpandedItems.length;
                int n2 = 0;
                while (n2 < n) {
                    Item item = itemArray[n2];
                    if (item.fEntry == selection) {
                        item.fSelected = true;
                        break;
                    }
                    ++n2;
                }
            }
        }

        private void refreshData(Map<ITimeGraphEntry, Item> itemMap, Item parent, int level, ITimeGraphEntry entry) {
            Item item = new Item(entry, entry.getName(), level);
            if (parent != null) {
                parent.fChildren.add(item);
            }
            if (TimeGraphControl.this.fGlobalItemHeight == -1) {
                item.fItemHeight = TimeGraphControl.this.fTimeGraphProvider.getItemHeight(entry);
            } else {
                item.fItemHeight = TimeGraphControl.this.fGlobalItemHeight;
            }
            TimeGraphControl.this.fMaxItemHeight = Math.max(TimeGraphControl.this.fMaxItemHeight, item.fItemHeight);
            item.fItemHeight = Math.max(1, item.fItemHeight + TimeGraphControl.this.fHeightAdjustment);
            itemMap.put(entry, item);
            if (entry.hasChildren()) {
                Item oldItem = this.fItemMap.get(entry);
                if (oldItem != null && oldItem.fHasChildren && level == oldItem.fLevel && entry.getParent() == oldItem.fEntry.getParent()) {
                    item.fExpanded = oldItem.fExpanded;
                } else {
                    item.fExpanded = TimeGraphControl.this.fAutoExpandLevel == -1 || level < TimeGraphControl.this.fAutoExpandLevel;
                }
                item.fHasChildren = true;
                for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
                    this.refreshData(itemMap, item, level + 1, iTimeGraphEntry);
                }
            }
        }

        public void updateExpandedItems() {
            Item[] itemArray = this.fItems;
            int n = this.fItems.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                item.fExpandedIndex = -1;
                ++n2;
            }
            ArrayList<Item> expandedItemList = new ArrayList<Item>();
            int i = 0;
            while (i < this.fRootEntries.length) {
                ITimeGraphEntry entry = this.fRootEntries[i];
                Item item = this.findItem(entry);
                this.refreshExpanded(expandedItemList, item);
                ++i;
            }
            this.fExpandedItems = expandedItemList.toArray(new Item[0]);
            TimeGraphControl.this.fTopIndex = Math.min(TimeGraphControl.this.fTopIndex, Math.max(0, this.fExpandedItems.length - 1));
        }

        private void refreshExpanded(List<Item> expandedItemList, Item item) {
            boolean display = true;
            for (ViewerFilter filter : TimeGraphControl.this.fFilters) {
                if (filter.select(null, (Object)item.fEntry.getParent(), (Object)item.fEntry)) continue;
                display = false;
                break;
            }
            if (display) {
                item.fExpandedIndex = expandedItemList.size();
                expandedItemList.add(item);
                if (item.fHasChildren && item.fExpanded) {
                    for (Item child : item.fChildren) {
                        this.refreshExpanded(expandedItemList, child);
                    }
                }
            }
        }

        public void refreshData(ITimeGraphEntry[] entries) {
            this.fRootEntries = entries == null ? null : Arrays.copyOf(entries, entries.length);
            this.refreshData();
        }

        public void refreshArrows(List<ILinkEvent> events) {
            this.fLinks = events != null ? events : new ArrayList<ILinkEvent>();
        }

        public ITimeGraphEntry[] getEntries() {
            return this.fRootEntries;
        }
    }

    private class SearchNode {
        ITimeGraphEntry entry;
        int level;

        SearchNode(ITimeGraphEntry e, int l) {
            this.entry = e;
            this.level = l;
        }
    }
}

