/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.ITmfGraphVisitor;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathModule;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.ICriticalPathProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfGraphStatistics;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfGraphVisitor;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.CriticalPathBaseEntry;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.CriticalPathEntry;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.CriticalPathLegend;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.CriticalPathPresentationProvider;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeLinkEvent;

public class CriticalPathView
extends AbstractTimeGraphView {
    public static final String ID = "org.eclipse.linuxtools.tmf.analysis.graph.ui.criticalpath.view.criticalpathview";
    private static final double NANOINV = 1.0E-9;
    private static final String COLUMN_PROCESS = Messages.getMessage(Messages.CriticalFlowView_columnProcess);
    private static final String COLUMN_ELAPSED = Messages.getMessage(Messages.CriticalFlowView_columnElapsed);
    private static final String COLUMN_PERCENT = Messages.getMessage(Messages.CriticalFlowView_columnPercent);
    private static final String[] COLUMN_NAMES = new String[]{COLUMN_PROCESS, COLUMN_ELAPSED, COLUMN_PERCENT};
    private static final String[] FILTER_COLUMN_NAMES = new String[]{COLUMN_PROCESS};
    private final Table<ITmfTrace, Object, List<ILinkEvent>> fLinks = HashBasedTable.create();
    private final Table<ITmfTrace, Object, TmfGraphStatistics> fObjectStatistics = HashBasedTable.create();
    private final CriticalPathContentProvider fContentProvider = new CriticalPathContentProvider();
    private TmfGraphStatistics fStats = new TmfGraphStatistics();
    private static final IGraphWorker DEFAULT_WORKER = new IGraphWorker(){

        public String getHostId() {
            return "default";
        }
    };

    public CriticalPathView() {
        super(ID, (TimeGraphPresentationProvider)new CriticalPathPresentationProvider());
        this.setTreeColumns(COLUMN_NAMES);
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setTreeLabelProvider(new CriticalPathTreeLabelProvider());
        this.setTimeGraphContentProvider(this.fContentProvider);
        this.setEntryComparator(new CriticalPathEntryComparator());
        this.setLegendProvider((shell, presentationProvider) -> {
            int n = new CriticalPathLegend(shell, presentationProvider).open();
        });
    }

    private static CriticalPathPresentationProvider.State getMatchingState(TmfEdge.EdgeType type) {
        CriticalPathPresentationProvider.State state = CriticalPathPresentationProvider.State.UNKNOWN;
        switch (type) {
            case RUNNING: {
                state = CriticalPathPresentationProvider.State.RUNNING;
                break;
            }
            case PREEMPTED: {
                state = CriticalPathPresentationProvider.State.PREEMPTED;
                break;
            }
            case TIMER: {
                state = CriticalPathPresentationProvider.State.TIMER;
                break;
            }
            case BLOCK_DEVICE: {
                state = CriticalPathPresentationProvider.State.BLOCK_DEVICE;
                break;
            }
            case INTERRUPTED: {
                state = CriticalPathPresentationProvider.State.INTERRUPTED;
                break;
            }
            case NETWORK: {
                state = CriticalPathPresentationProvider.State.NETWORK;
                break;
            }
            case USER_INPUT: {
                state = CriticalPathPresentationProvider.State.USER_INPUT;
                break;
            }
            case IPI: {
                state = CriticalPathPresentationProvider.State.IPI;
                break;
            }
            case EPS: 
            case UNKNOWN: 
            case DEFAULT: 
            case BLOCKED: {
                break;
            }
        }
        return state;
    }

    protected void buildEntryList(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, @NonNull IProgressMonitor monitor) {
    }

    protected @Nullable List<ITimeEvent> getEventList(TimeGraphEntry entry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        return null;
    }

    protected @Nullable List<ILinkEvent> getLinkList(long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        return this.fContentProvider.getLinkList(startTime, endTime);
    }

    @TmfSignalHandler
    public void analysisStarted(TmfStartAnalysisSignal signal) {
        if (!(signal.getAnalysisModule() instanceof CriticalPathModule)) {
            return;
        }
        CriticalPathModule module = (CriticalPathModule)signal.getAnalysisModule();
        Object obj = module.getParameter("workerid");
        if (obj == null) {
            return;
        }
        if (!(obj instanceof IGraphWorker)) {
            throw new IllegalStateException("Wrong type for critical path module parameter workerid expected IGraphWorker got " + obj.getClass().getSimpleName());
        }
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new IllegalStateException("Trace is null");
        }
        IGraphWorker worker = (IGraphWorker)obj;
        CriticalPathBaseEntry tge = new CriticalPathBaseEntry(worker, module);
        List<CriticalPathBaseEntry> list = Collections.singletonList(tge);
        this.putEntryList(trace, list);
        this.refresh();
    }

    private void setStartEndTime(CriticalPathModule module) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new IllegalStateException("The trace should not be null when we have a critical path to display");
        }
        long start = trace.getStartTime().toNanos();
        long end = trace.getEndTime().toNanos();
        TmfGraph graph = module.getCriticalPath();
        if (graph == null) {
            return;
        }
        TmfVertex head = graph.getHead();
        if (head != null) {
            start = Math.min(start, head.getTs());
            for (IGraphWorker w : graph.getWorkers()) {
                TmfVertex tail = graph.getTail(w);
                if (tail == null) continue;
                end = Math.max(end, tail.getTs());
            }
        }
        this.setStartTime(start);
        this.setEndTime(end);
    }

    protected void fillLocalToolBar(@Nullable IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        if (manager == null) {
            return;
        }
        Action followArrowBwdAction = this.getTimeGraphViewer().getFollowArrowBwdAction();
        followArrowBwdAction.setText(Messages.CriticalPathView_followArrowBwdText);
        followArrowBwdAction.setToolTipText(Messages.CriticalPathView_followArrowBwdText);
        manager.appendToGroup("additions", (IAction)followArrowBwdAction);
        Action followArrowFwdAction = this.getTimeGraphViewer().getFollowArrowFwdAction();
        followArrowFwdAction.setText(Messages.CriticalPathView_followArrowFwdText);
        followArrowFwdAction.setToolTipText(Messages.CriticalPathView_followArrowFwdText);
        manager.appendToGroup("additions", (IAction)followArrowFwdAction);
    }

    private class CriticalPathContentProvider
    implements ITimeGraphContentProvider {
        private final Lock fSyncLock = new ReentrantLock();
        private final Map<Object, Map<Object, CriticalPathEntry>> workerMaps = new HashMap<Object, Map<Object, CriticalPathEntry>>();
        private final Map<Object, List<TimeGraphEntry>> workerEntries = new HashMap<Object, List<TimeGraphEntry>>();
        private @Nullable Object fCurrentObject;
        private @Nullable BuildThread fBuildThread = null;

        private CriticalPathContentProvider() {
        }

        public ITimeGraphEntry[] getElements(@Nullable Object inputElement) {
            Object first;
            List list;
            ITimeGraphEntry[] ret = new ITimeGraphEntry[]{};
            if (inputElement instanceof List && !(list = (List)inputElement).isEmpty() && (first = list.get(0)) instanceof CriticalPathBaseEntry) {
                IGraphWorker worker = ((CriticalPathBaseEntry)((Object)first)).getWorker();
                ret = this.getWorkerEntries(worker);
            }
            return ret;
        }

        private ITimeGraphEntry[] getWorkerEntries(IGraphWorker worker) {
            this.fCurrentObject = worker;
            List<TimeGraphEntry> entries = this.workerEntries.get(worker);
            ITmfTrace trace = CriticalPathView.this.getTrace();
            if (entries == null) {
                this.buildEntryList(worker);
                entries = this.workerEntries.get(worker);
            } else if (trace != null) {
                TmfGraphStatistics stats = (TmfGraphStatistics)CriticalPathView.this.fObjectStatistics.get((Object)trace, (Object)worker);
                if (stats == null) {
                    stats = new TmfGraphStatistics();
                    TmfGraph graph = this.getGraph(trace);
                    if (graph != null) {
                        stats.computeGraphStatistics(graph, worker);
                    }
                }
                CriticalPathView.this.fStats = stats;
            }
            return entries == null ? new ITimeGraphEntry[]{} : entries.toArray(new ITimeGraphEntry[entries.size()]);
        }

        private void buildEntryList(IGraphWorker worker) {
            ITmfTrace trace = CriticalPathView.this.getTrace();
            if (trace == null) {
                return;
            }
            TmfGraph graph = this.getGraph(trace);
            if (graph == null) {
                return;
            }
            HashMap rootList = new HashMap();
            CriticalPathView.this.fLinks.remove((Object)trace, (Object)worker);
            TmfVertex vertex = graph.getHead();
            CriticalPathView.this.fStats = new TmfGraphStatistics();
            CriticalPathView.this.fStats.computeGraphStatistics(graph, worker);
            CriticalPathView.this.fObjectStatistics.put((Object)trace, (Object)worker, (Object)CriticalPathView.this.fStats);
            HashMap hostEntries = new HashMap();
            CriticalPathEntry defaultParent = new CriticalPathEntry("default", trace, CriticalPathView.this.getStartTime(), CriticalPathView.this.getEndTime(), DEFAULT_WORKER);
            graph.scanLineTraverse(vertex, (ITmfGraphVisitor)new HorizontalLinksVisitor(defaultParent, hostEntries, graph, trace, rootList));
            this.workerMaps.put(worker, rootList);
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(hostEntries.values());
            if (defaultParent.hasChildren()) {
                list.add((Object)defaultParent);
            }
            this.workerEntries.put(worker, list);
        }

        private @Nullable TmfGraph getGraph(ITmfTrace trace) {
            ICriticalPathProvider module = (ICriticalPathProvider)Iterables.getFirst((Iterable)TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ICriticalPathProvider.class), null);
            if (module == null) {
                throw new IllegalStateException("View requires an analysis module");
            }
            TmfGraph graph = module.getCriticalPath();
            return graph;
        }

        public @Nullable List<ILinkEvent> getLinkList(long startTime, long endTime) {
            Object current = this.fCurrentObject;
            if (current == null) {
                return null;
            }
            ITmfTrace trace = CriticalPathView.this.getTrace();
            if (trace == null) {
                return null;
            }
            List links = (List)CriticalPathView.this.fLinks.get((Object)trace, current);
            if (links != null) {
                return this.getLinksInRange(links, startTime, endTime);
            }
            ICriticalPathProvider module = (ICriticalPathProvider)Iterables.getFirst((Iterable)TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ICriticalPathProvider.class), null);
            if (module == null) {
                throw new IllegalStateException("View requires an analysis module");
            }
            TmfGraph graph = module.getCriticalPath();
            if (graph == null) {
                return null;
            }
            Map<Object, CriticalPathEntry> entryMap = this.workerMaps.get(current);
            if (entryMap == null) {
                return null;
            }
            TmfVertex vertex = graph.getHead();
            ArrayList<ILinkEvent> graphLinks = new ArrayList<ILinkEvent>();
            graph.scanLineTraverse(vertex, (ITmfGraphVisitor)new VerticalLinksVisitor(graph, graphLinks, entryMap));
            CriticalPathView.this.fLinks.put((Object)trace, current, graphLinks);
            return this.getLinksInRange(graphLinks, startTime, endTime);
        }

        private List<ILinkEvent> getLinksInRange(List<ILinkEvent> allLinks, long startTime, long endTime) {
            ArrayList<ILinkEvent> linksInRange = new ArrayList<ILinkEvent>();
            for (ILinkEvent link : allLinks) {
                if ((link.getTime() < startTime || link.getTime() > endTime) && (link.getTime() + link.getDuration() < startTime || link.getTime() + link.getDuration() > endTime)) continue;
                linksInRange.add(link);
            }
            return linksInRange;
        }

        public void dispose() {
            this.fSyncLock.lock();
            try {
                BuildThread buildThread = this.fBuildThread;
                if (buildThread != null) {
                    buildThread.cancel();
                }
            }
            finally {
                this.fSyncLock.unlock();
            }
        }

        public void inputChanged(@Nullable Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
            if (!(newInput instanceof List)) {
                return;
            }
            List list = (List)newInput;
            if (list.isEmpty()) {
                return;
            }
            Object first = list.get(0);
            if (!(first instanceof CriticalPathBaseEntry)) {
                return;
            }
            CriticalPathModule module = ((CriticalPathBaseEntry)((Object)first)).getModule();
            this.fSyncLock.lock();
            try {
                BuildThread buildThread = this.fBuildThread;
                if (buildThread != null) {
                    buildThread.cancel();
                }
                buildThread = new BuildThread(module);
                buildThread.start();
                this.fBuildThread = buildThread;
            }
            finally {
                this.fSyncLock.unlock();
            }
        }

        public ITimeGraphEntry @Nullable [] getChildren(@Nullable Object parentElement) {
            if (parentElement instanceof CriticalPathEntry) {
                List children = ((CriticalPathEntry)((Object)parentElement)).getChildren();
                return (ITimeGraphEntry[])children.toArray(new TimeGraphEntry[children.size()]);
            }
            return null;
        }

        public @Nullable ITimeGraphEntry getParent(@Nullable Object element) {
            if (element instanceof CriticalPathEntry) {
                return ((CriticalPathEntry)((Object)element)).getParent();
            }
            return null;
        }

        public boolean hasChildren(@Nullable Object element) {
            if (element instanceof CriticalPathEntry) {
                return ((CriticalPathEntry)((Object)element)).hasChildren();
            }
            return false;
        }

        private class BuildThread
        extends Thread {
            private final CriticalPathModule fModule;
            private final IProgressMonitor fMonitor;

            public BuildThread(CriticalPathModule module) {
                super("Critical path view build");
                this.fModule = module;
                this.fMonitor = new NullProgressMonitor();
            }

            @Override
            public void run() {
                try {
                    CriticalPathModule module = this.fModule;
                    module.schedule();
                    if (module.waitForCompletion(this.fMonitor)) {
                        CriticalPathView.this.setStartEndTime(module);
                        CriticalPathView.this.refresh();
                    }
                }
                finally {
                    CriticalPathContentProvider.this.fSyncLock.lock();
                    CriticalPathContentProvider.this.fBuildThread = null;
                    CriticalPathContentProvider.this.fSyncLock.unlock();
                }
            }

            public void cancel() {
                this.fMonitor.setCanceled(true);
            }
        }

        private final class HorizontalLinksVisitor
        extends TmfGraphVisitor {
            private final CriticalPathEntry fDefaultParent;
            private final Map<String, CriticalPathEntry> fHostEntries;
            private final TmfGraph fGraph;
            private final ITmfTrace fTrace;
            private final HashMap<Object, CriticalPathEntry> fRootList;

            private HorizontalLinksVisitor(CriticalPathEntry defaultParent, Map<String, CriticalPathEntry> hostEntries, TmfGraph graph, ITmfTrace trace, HashMap<Object, CriticalPathEntry> rootList) {
                this.fDefaultParent = defaultParent;
                this.fHostEntries = hostEntries;
                this.fGraph = graph;
                this.fTrace = trace;
                this.fRootList = rootList;
            }

            public void visitHead(TmfVertex node) {
                IGraphWorker owner = this.fGraph.getParentOf(node);
                if (owner == null) {
                    return;
                }
                if (this.fRootList.containsKey(owner)) {
                    return;
                }
                TmfVertex first = this.fGraph.getHead(owner);
                TmfVertex last = this.fGraph.getTail(owner);
                if (first == null || last == null) {
                    return;
                }
                CriticalPathView.this.setStartTime(Math.min(CriticalPathView.this.getStartTime(), first.getTs()));
                CriticalPathView.this.setEndTime(Math.max(CriticalPathView.this.getEndTime(), last.getTs()));
                CriticalPathEntry parent = this.fDefaultParent;
                String host = owner.getHostId();
                if (!this.fHostEntries.containsKey(host)) {
                    this.fHostEntries.put(host, new CriticalPathEntry(host, this.fTrace, CriticalPathView.this.getStartTime(), CriticalPathView.this.getEndTime(), owner));
                }
                parent = (CriticalPathEntry)((Object)NonNullUtils.checkNotNull((Object)((Object)this.fHostEntries.get(host))));
                CriticalPathEntry entry = new CriticalPathEntry(NonNullUtils.nullToEmptyString((Object)owner), this.fTrace, CriticalPathView.this.getStartTime(), CriticalPathView.this.getEndTime(), owner);
                parent.addChild(entry);
                this.fRootList.put(owner, entry);
            }

            public void visit(TmfEdge link, boolean horizontal) {
                if (horizontal) {
                    IGraphWorker parent = this.fGraph.getParentOf(link.getVertexFrom());
                    CriticalPathEntry entry = this.fRootList.get(parent);
                    TimeEvent ev = new TimeEvent((ITimeGraphEntry)entry, link.getVertexFrom().getTs(), link.getDuration(), CriticalPathView.getMatchingState(link.getType()).ordinal());
                    entry.addEvent((ITimeEvent)ev);
                }
            }
        }

        private final class VerticalLinksVisitor
        extends TmfGraphVisitor {
            private final TmfGraph fGraph;
            private final List<ILinkEvent> fGraphLinks;
            private final Map<Object, CriticalPathEntry> fEntryMap;

            private VerticalLinksVisitor(TmfGraph graph, List<ILinkEvent> graphLinks, Map<Object, CriticalPathEntry> entryMap) {
                this.fGraph = graph;
                this.fGraphLinks = graphLinks;
                this.fEntryMap = entryMap;
            }

            public void visitHead(TmfVertex node) {
            }

            public void visit(TmfVertex node) {
            }

            public void visit(TmfEdge link, boolean horizontal) {
                if (!horizontal) {
                    IGraphWorker parentFrom = this.fGraph.getParentOf(link.getVertexFrom());
                    IGraphWorker parentTo = this.fGraph.getParentOf(link.getVertexTo());
                    CriticalPathEntry entryFrom = this.fEntryMap.get(parentFrom);
                    CriticalPathEntry entryTo = this.fEntryMap.get(parentTo);
                    TimeLinkEvent lk = new TimeLinkEvent((ITimeGraphEntry)entryFrom, (ITimeGraphEntry)entryTo, link.getVertexFrom().getTs(), link.getVertexTo().getTs() - link.getVertexFrom().getTs(), CriticalPathView.getMatchingState(link.getType()).ordinal());
                    this.fGraphLinks.add((ILinkEvent)lk);
                }
            }
        }
    }

    private class CriticalPathEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private CriticalPathEntryComparator() {
        }

        @Override
        public int compare(@Nullable ITimeGraphEntry o1, @Nullable ITimeGraphEntry o2) {
            int result = 0;
            if (o1 instanceof CriticalPathEntry && o2 instanceof CriticalPathEntry) {
                CriticalPathEntry entry1 = (CriticalPathEntry)o1;
                CriticalPathEntry entry2 = (CriticalPathEntry)o2;
                result = -1 * CriticalPathView.this.fStats.getSum(entry1.getWorker()).compareTo(CriticalPathView.this.fStats.getSum(entry2.getWorker()));
            }
            return result;
        }
    }

    private class CriticalPathTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private CriticalPathTreeLabelProvider() {
        }

        public String getColumnText(@Nullable Object element, int columnIndex) {
            if (element == null) {
                return "";
            }
            CriticalPathEntry entry = (CriticalPathEntry)((Object)element);
            if (columnIndex == 0) {
                return NonNullUtils.nullToEmptyString((Object)entry.getName());
            }
            if (columnIndex == 1) {
                Long sum = CriticalPathView.this.fStats.getSum(entry.getWorker());
                String value = String.format("%.9f", (double)sum.longValue() * 1.0E-9);
                return NonNullUtils.nullToEmptyString((Object)value);
            }
            if (columnIndex == 2) {
                Double percent = CriticalPathView.this.fStats.getPercent(entry.getWorker());
                String value = String.format("%.2f", percent * 100.0);
                return NonNullUtils.nullToEmptyString((Object)value);
            }
            return "";
        }
    }
}

