/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class SharedDocumentAdapter
implements ISharedDocumentAdapter {
    public static IDocumentProvider getDocumentProvider(IEditorInput input) {
        return DocumentProviderRegistry.getDefault().getDocumentProvider(input);
    }

    @Override
    public void connect(IDocumentProvider provider, IEditorInput documentKey) throws CoreException {
        provider.connect((Object)documentKey);
    }

    @Override
    public void disconnect(IDocumentProvider provider, IEditorInput documentKey) {
        provider.disconnect((Object)documentKey);
    }

    @Override
    public IEditorInput getDocumentKey(Object element) {
        IFile file = this.getFile(element);
        if (file != null && file.exists()) {
            return new FileEditorInput(file);
        }
        return null;
    }

    private IFile getFile(Object element) {
        IResourceProvider rp;
        IResource resource;
        if (element instanceof IResourceProvider && (resource = (rp = (IResourceProvider)element).getResource()) instanceof IFile) {
            return (IFile)resource;
        }
        IFile file = (IFile)Utilities.getAdapter(element, IFile.class);
        if (file != null) {
            return file;
        }
        resource = (IResource)Utilities.getAdapter(element, IResource.class);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    protected void saveDocument(IDocumentProvider provider, IEditorInput documentKey, IDocument document, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        try {
            provider.aboutToChange((Object)documentKey);
            provider.saveDocument(monitor, (Object)documentKey, document, overwrite);
        }
        finally {
            provider.changed((Object)documentKey);
        }
    }

    @Override
    public void disconnect(Object element) {
        IEditorInput input = this.getDocumentKey(element);
        if (input == null) {
            return;
        }
        IDocumentProvider provider = SharedDocumentAdapter.getDocumentProvider(input);
        if (provider == null) {
            return;
        }
        this.disconnect(provider, input);
    }
}

