/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.interval;

import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;

public class HTInterval
implements IHTInterval {
    private final long fStart;
    private final long fEnd;
    public static final IHTIntervalReader<HTInterval> INTERVAL_READER = buffer -> new HTInterval(buffer.getLong(), buffer.getLong());

    public HTInterval(long start, long end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        this.fStart = start;
        this.fEnd = end;
    }

    @Override
    public long getStart() {
        return this.fStart;
    }

    @Override
    public long getEnd() {
        return this.fEnd;
    }

    public String toString() {
        return new StringJoiner(", ", "[", "]").add(String.valueOf(this.fStart)).add(String.valueOf(this.fEnd)).toString();
    }

    @Override
    public int getSizeOnDisk() {
        return 16;
    }

    @Override
    public void writeSegment(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putLong(this.fStart);
        buffer.putLong(this.fEnd);
    }

    public int hashCode() {
        return Objects.hash(this.fStart, this.fEnd);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HTInterval other = (HTInterval)obj;
        return this.fStart == other.fStart && this.fEnd == other.fEnd;
    }
}

