/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SegmentStoreScatterDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfXYDataProvider {
    private final ISegmentStoreProvider fProvider;

    public static @Nullable SegmentStoreScatterDataProvider create(ITmfTrace trace, @Nullable ISegmentStoreProvider provider) {
        if (provider == null) {
            return null;
        }
        if (provider instanceof IAnalysisModule) {
            ((IAnalysisModule)provider).schedule();
            return new SegmentStoreScatterDataProvider(trace, provider);
        }
        return null;
    }

    private SegmentStoreScatterDataProvider(ITmfTrace trace, ISegmentStoreProvider provider) {
        super(trace);
        this.fProvider = provider;
    }

    public TmfModelResponse<ITmfXyModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        ISegmentStoreProvider provider = this.fProvider;
        if (!(provider instanceof IAnalysisModule)) {
            return TmfXyResponseFactory.createFailedResponse((String)Messages.SegmentStoreDataProvider_SegmentMustBeAnIAnalysisModule);
        }
        if (!((IAnalysisModule)provider).waitForCompletion()) {
            return TmfXyResponseFactory.createFailedResponse((String)CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        ISegmentStore<ISegment> segStore = provider.getSegmentStore();
        if (segStore == null) {
            return TmfXyResponseFactory.createFailedResponse((String)Messages.SegmentStoreDataProvider_SegmentNotAvailable);
        }
        long start = filter.getStart();
        long end = filter.getEnd();
        long pixelSize = Math.max(1L, (end - start) / (long)filter.getTimesRequested().length);
        Iterable intersectingElements = segStore.getIntersectingElements(start, end, SegmentComparators.INTERVAL_START_COMPARATOR);
        Iterable<ISegment> displayData = this.compactList(start, intersectingElements, pixelSize);
        ArrayList<Long> xSeries = new ArrayList<Long>();
        ArrayList<Double> yValues = new ArrayList<Double>();
        for (ISegment segment : displayData) {
            if (monitor != null && monitor.isCanceled()) {
                return TmfXyResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
            }
            xSeries.add(segment.getStart());
            yValues.add(Double.valueOf(segment.getLength()));
        }
        YModel yModel = new YModel(Objects.requireNonNull(Messages.SegmentStoreDataProvider_Duration), Objects.requireNonNull(Doubles.toArray(yValues)));
        ImmutableMap ySeries = ImmutableMap.of((Object)Objects.requireNonNull(Messages.SegmentStoreDataProvider_Duration), (Object)yModel);
        return TmfXyResponseFactory.create((String)Objects.requireNonNull(Messages.SegmentStoreScatterGraphViewer_title), (long[])Objects.requireNonNull(Longs.toArray(xSeries)), (Map)ySeries, (boolean)true);
    }

    private Iterable<ISegment> compactList(long startTime, Iterable<@NonNull ISegment> iterableToCompact, long pixelSize) {
        return () -> new SegmentStoreIterator(startTime, iterableToCompact, pixelSize);
    }

    private class SegmentStoreIterator
    implements Iterator<ISegment> {
        private @Nullable ISegment fLast = null;
        private @Nullable ISegment fNext = null;
        private final Iterator<@NonNull ISegment> fIterator;
        private final long fStartTime;
        private final long fPixelSize;

        public SegmentStoreIterator(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull long startTime, Iterable<ISegment> iterableToCompact, long pixelSize) {
            this.fStartTime = startTime;
            this.fIterator = Objects.requireNonNull(iterableToCompact.iterator());
            this.fPixelSize = Math.max(1L, pixelSize);
        }

        @Override
        public @NonNull ISegment next() {
            if (this.hasNext()) {
                this.fLast = this.fNext;
                this.fNext = null;
                return Objects.requireNonNull(this.fLast);
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            if (this.fLast == null) {
                if (this.fIterator.hasNext()) {
                    this.fLast = this.fIterator.next();
                    if (this.fLast.getStart() >= this.fStartTime) {
                        this.fNext = this.fLast;
                    }
                } else {
                    return false;
                }
            }
            ISegment prev = this.fLast;
            while (this.fNext == null && this.fIterator.hasNext()) {
                ISegment tmp = this.fIterator.next();
                if (tmp.getStart() < this.fStartTime || this.overlaps(prev, tmp)) continue;
                this.fNext = tmp;
            }
            return this.fNext != null;
        }

        private boolean overlaps(ISegment last, ISegment next) {
            long timePerPix = this.fPixelSize;
            long start = last.getStart();
            long pixelStart = this.fStartTime;
            long pixelDuration = start - pixelStart;
            long startPixBoundL = pixelDuration / timePerPix * timePerPix + pixelStart;
            long startPixBoundR = startPixBoundL + timePerPix;
            long currentStart = next.getStart();
            if (currentStart >= startPixBoundL && currentStart <= startPixBoundR) {
                long length = last.getLength();
                long lengthNext = next.getLength();
                long lengthLow = length / timePerPix * timePerPix;
                long lengthHigh = lengthLow + timePerPix;
                return lengthNext >= lengthLow && lengthNext <= lengthHigh;
            }
            return false;
        }
    }
}

