/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ToolChainManager
implements IToolChainManager {
    private Map<String, IConfigurationElement> providerElements;
    private Map<String, IToolChainProvider> providers;
    private Map<List<String>, IToolChain> toolChains;

    private void init() {
        if (this.providerElements == null) {
            this.providerElements = new HashMap<String, IConfigurationElement>();
            this.providers = new HashMap<String, IToolChainProvider>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint typesPoint = registry.getExtensionPoint("org.eclipse.cdt.core.toolChainProvider");
            IConfigurationElement[] iConfigurationElementArray = typesPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String id = element.getAttribute("id");
                this.providerElements.put(id, element);
                ++n2;
            }
            this.toolChains = new HashMap<List<String>, IToolChain>();
            for (IConfigurationElement element : this.providerElements.values()) {
                try {
                    IToolChainProvider provider = (IToolChainProvider)element.createExecutableExtension("class");
                    this.providers.put(element.getAttribute("id"), provider);
                    provider.init(this);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
        }
    }

    private List<String> getId(IToolChain toolChain) {
        ArrayList<String> id = new ArrayList<String>(3);
        id.add(toolChain.getProvider().getId());
        id.add(toolChain.getId());
        id.add(toolChain.getVersion());
        return id;
    }

    @Override
    public void addToolChain(IToolChain toolChain) {
        this.toolChains.put(this.getId(toolChain), toolChain);
    }

    @Override
    public void removeToolChain(IToolChain toolChain) {
        this.toolChains.remove(this.getId(toolChain));
    }

    @Override
    public IToolChainProvider getProvider(String providerId) throws CoreException {
        IConfigurationElement element;
        this.init();
        IToolChainProvider provider = this.providers.get(providerId);
        if (provider == null && (element = this.providerElements.get(providerId)) != null) {
            provider = (IToolChainProvider)element.createExecutableExtension("class");
            this.providers.put(providerId, provider);
        }
        return provider;
    }

    @Override
    public IToolChain getToolChain(String providerId, String id, String version) throws CoreException {
        this.init();
        ArrayList<String> tid = new ArrayList<String>(3);
        tid.add(providerId);
        tid.add(id);
        tid.add(version);
        IToolChain toolChain = this.toolChains.get(tid);
        if (toolChain != null) {
            return toolChain;
        }
        IToolChainProvider realProvider = this.providers.get(providerId);
        if (realProvider != null && (toolChain = realProvider.getToolChain(id, version)) != null) {
            this.toolChains.put(this.getId(toolChain), toolChain);
            return toolChain;
        }
        return null;
    }

    @Override
    public Collection<IToolChain> getToolChainsMatching(Map<String, String> properties) {
        this.init();
        ArrayList<IToolChain> tcs = new ArrayList<IToolChain>();
        for (IToolChain toolChain : this.toolChains.values()) {
            boolean matches = true;
            for (Map.Entry<String, String> property : properties.entrySet()) {
                if (property.getValue().equals(toolChain.getProperty(property.getKey()))) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            tcs.add(toolChain);
        }
        if ("x86_64".equals(properties.get("arch"))) {
            HashMap<String, String> properties32 = new HashMap<String, String>(properties);
            properties32.put("arch", "x86");
            tcs.addAll(this.getToolChainsMatching(properties32));
        }
        return tcs;
    }

    @Override
    public Collection<IToolChain> getToolChains(String providerId) {
        this.init();
        ArrayList<IToolChain> tcs = new ArrayList<IToolChain>();
        for (IToolChain toolChain : this.toolChains.values()) {
            if (!toolChain.getProvider().getId().equals(providerId)) continue;
            tcs.add(toolChain);
        }
        return tcs;
    }

    @Override
    public Collection<IToolChain> getToolChains(String providerId, String id) throws CoreException {
        this.init();
        ArrayList<IToolChain> tcs = new ArrayList<IToolChain>();
        for (IToolChain toolChain : this.toolChains.values()) {
            if (!toolChain.getProvider().getId().equals(providerId) || !toolChain.getId().equals(id)) continue;
            tcs.add(toolChain);
        }
        return tcs;
    }
}

