/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;

public final class ByteArrayDataInput
extends DataInput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayDataInput(byte[] bytes) {
        this.reset(bytes);
    }

    public ByteArrayDataInput(byte[] bytes, int offset, int len) {
        this.reset(bytes, offset, len);
    }

    public ByteArrayDataInput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] bytes) {
        this.reset(bytes, 0, bytes.length);
    }

    public int getPosition() {
        return this.pos;
    }

    public void reset(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.pos = offset;
        this.limit = offset + len;
    }

    public boolean eof() {
        return this.pos == this.limit;
    }

    public void skipBytes(int count) {
        this.pos += count;
        assert (this.pos <= this.limit);
    }

    public short readShort() {
        return (short)((this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF);
    }

    public int readInt() {
        assert (this.pos + 4 <= this.limit);
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    public long readLong() {
        assert (this.pos + 8 <= this.limit);
        int i1 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        int i2 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    public int readVInt() {
        this.checkBounds();
        byte b = this.bytes[this.pos++];
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            this.checkBounds();
            b = this.bytes[this.pos++];
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public long readVLong() {
        this.checkBounds();
        byte b = this.bytes[this.pos++];
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            this.checkBounds();
            b = this.bytes[this.pos++];
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public byte readByte() {
        this.checkBounds();
        return this.bytes[this.pos++];
    }

    public void readBytes(byte[] b, int offset, int len) {
        assert (this.pos + len <= this.limit);
        System.arraycopy(this.bytes, this.pos, b, offset, len);
        this.pos += len;
    }

    private boolean checkBounds() {
        assert (this.pos < this.limit);
        return true;
    }
}

