/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.parsers.custom.CustomEventAspects;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEventContent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceContext;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public class CustomTxtTrace
extends TmfTrace
implements ITmfPersistentlyIndexable {
    private static final TmfLongLocation NULL_LOCATION = new TmfLongLocation(-1L);
    private static final int DEFAULT_CACHE_SIZE = 100;
    private static final int MAX_LINES = 100;
    private static final int MAX_CONFIDENCE = 100;
    private final CustomTxtTraceDefinition fDefinition;
    private final ITmfEventField fRootField;
    private BufferedRandomAccessFile fFile;
    private final @NonNull String fTraceTypeId;
    private static final char SEPARATOR = ':';
    private static final String CUSTOM_TXT_TRACE_TYPE_PREFIX = "custom.txt.trace:";
    private static final String LINUX_TOOLS_CUSTOM_TXT_TRACE_TYPE_PREFIX = "org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTxtTrace:";
    private static final String EARLY_TRACE_COMPASS_CUSTOM_TXT_TRACE_TYPE_PREFIX = "org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace:";
    private static int fCheckpointSize = -1;

    public CustomTxtTrace(CustomTxtTraceDefinition definition) {
        this.fDefinition = definition;
        this.fRootField = CustomEventType.getRootField(definition);
        this.fTraceTypeId = CustomTxtTrace.buildTraceTypeId(definition.categoryName, definition.definitionName);
        this.setCacheSize(100);
    }

    public CustomTxtTrace(IResource resource, CustomTxtTraceDefinition definition, String path, int cacheSize) throws TmfTraceException {
        this(definition);
        this.setCacheSize(cacheSize > 0 ? cacheSize : 100);
        this.initTrace(resource, path, CustomTxtEvent.class);
    }

    @Override
    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        super.initTrace(resource, path, eventType);
        this.initFile();
    }

    private void initFile() throws TmfTraceException {
        this.closeFile();
        try {
            this.fFile = new BufferedRandomAccessFile(this.getPath(), "r");
        }
        catch (IOException e) {
            throw new TmfTraceException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.closeFile();
    }

    private void closeFile() {
        if (this.fFile != null) {
            try {
                try {
                    this.fFile.close();
                }
                catch (IOException iOException) {
                    this.fFile = null;
                }
            }
            finally {
                this.fFile = null;
            }
        }
    }

    @Override
    public ITmfTraceIndexer getIndexer() {
        return super.getIndexer();
    }

    @Override
    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return CustomEventAspects.generateAspects(this.fDefinition);
    }

    @Override
    public synchronized TmfContext seekEvent(ITmfLocation location) {
        CustomTxtTraceContext context = new CustomTxtTraceContext(NULL_LOCATION, -1L);
        if (NULL_LOCATION.equals(location) || this.fFile == null) {
            return context;
        }
        try {
            if (location == null) {
                this.fFile.seek(0L);
            } else if (location.getLocationInfo() instanceof Long) {
                this.fFile.seek((Long)location.getLocationInfo());
            }
            long rawPos = this.fFile.getFilePointer();
            String line = this.fFile.getNextLine();
            while (line != null) {
                for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                    Matcher matcher = input.getPattern().matcher(line);
                    if (!matcher.matches()) continue;
                    context.setLocation(new TmfLongLocation(rawPos));
                    context.firstLineMatcher = matcher;
                    context.firstLine = line;
                    context.nextLineLocation = this.fFile.getFilePointer();
                    context.inputLine = input;
                    return context;
                }
                rawPos = this.fFile.getFilePointer();
                line = this.fFile.getNextLine();
            }
            return context;
        }
        catch (FileNotFoundException e) {
            Activator.logError("Error seeking event. File not found: " + this.getPath(), e);
            return context;
        }
        catch (IOException e) {
            Activator.logError("Error seeking event. File: " + this.getPath(), e);
            return context;
        }
    }

    @Override
    public synchronized TmfContext seekEvent(double ratio) {
        if (this.fFile == null) {
            return new CustomTxtTraceContext(NULL_LOCATION, -1L);
        }
        try {
            long pos = Math.round(ratio * (double)this.fFile.length());
            while (pos > 0L) {
                this.fFile.seek(pos - 1L);
                if (this.fFile.read() == 10) break;
                --pos;
            }
            TmfLongLocation location = new TmfLongLocation(pos);
            TmfContext context = this.seekEvent(location);
            context.setRank(-1L);
            return context;
        }
        catch (IOException e) {
            Activator.logError("Error seeking event. File: " + this.getPath(), e);
            return new CustomTxtTraceContext(NULL_LOCATION, -1L);
        }
    }

    @Override
    public synchronized double getLocationRatio(ITmfLocation location) {
        if (this.fFile == null) {
            return 0.0;
        }
        try {
            if (location.getLocationInfo() instanceof Long) {
                return ((Long)location.getLocationInfo()).doubleValue() / (double)this.fFile.length();
            }
        }
        catch (IOException e) {
            Activator.logError("Error seeking event. File: " + this.getPath(), e);
        }
        return 0.0;
    }

    @Override
    public ITmfLocation getCurrentLocation() {
        return null;
    }

    @Override
    public synchronized CustomTxtEvent parseEvent(ITmfContext tmfContext) {
        TmfContext context = this.seekEvent(tmfContext.getLocation());
        return this.parse(context);
    }

    @Override
    public synchronized CustomTxtEvent getNext(ITmfContext context) {
        TmfContext savedContext = new TmfContext(context.getLocation(), context.getRank());
        CustomTxtEvent event = this.parse(context);
        if (event != null) {
            this.updateAttributes(savedContext, event);
            context.increaseRank();
        }
        return event;
    }

    private synchronized CustomTxtEvent parse(ITmfContext tmfContext) {
        if (this.fFile == null) {
            return null;
        }
        if (!(tmfContext instanceof CustomTxtTraceContext)) {
            return null;
        }
        CustomTxtTraceContext context = (CustomTxtTraceContext)tmfContext;
        ITmfLocation location = context.getLocation();
        if (location == null || !(location.getLocationInfo() instanceof Long) || NULL_LOCATION.equals(location)) {
            return null;
        }
        CustomTxtEvent event = this.parseFirstLine(context);
        HashMap<CustomTxtTraceDefinition.InputLine, Integer> countMap = new HashMap<CustomTxtTraceDefinition.InputLine, Integer>();
        CustomTxtTraceDefinition.InputLine currentInput = null;
        if (context.inputLine.childrenInputs != null && context.inputLine.childrenInputs.size() > 0) {
            currentInput = context.inputLine.childrenInputs.get(0);
            countMap.put(currentInput, 0);
        }
        try {
            if (this.fFile.getFilePointer() != context.nextLineLocation) {
                this.fFile.seek(context.nextLineLocation);
            }
            long rawPos = this.fFile.getFilePointer();
            String line = this.fFile.getNextLine();
            while (line != null) {
                boolean processed = false;
                if (currentInput == null) {
                    for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                        Matcher matcher = input.getPattern().matcher(line);
                        if (!matcher.matches()) continue;
                        context.setLocation(new TmfLongLocation(rawPos));
                        context.firstLineMatcher = matcher;
                        context.firstLine = line;
                        context.nextLineLocation = this.fFile.getFilePointer();
                        context.inputLine = input;
                        return event;
                    }
                } else {
                    if ((Integer)NonNullUtils.checkNotNull((Object)((Integer)countMap.get(currentInput))) >= currentInput.getMinCount()) {
                        Matcher matcher;
                        List<CustomTxtTraceDefinition.InputLine> nextInputs = currentInput.getNextInputs(countMap);
                        if (nextInputs.size() == 0 || nextInputs.get(nextInputs.size() - 1).getMinCount() == 0) {
                            for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                                matcher = input.getPattern().matcher(line);
                                if (!matcher.matches()) continue;
                                context.setLocation(new TmfLongLocation(rawPos));
                                context.firstLineMatcher = matcher;
                                context.firstLine = line;
                                context.nextLineLocation = this.fFile.getFilePointer();
                                context.inputLine = input;
                                return event;
                            }
                        }
                        for (CustomTxtTraceDefinition.InputLine input : nextInputs) {
                            CustomTxtTraceDefinition.InputLine inputLine;
                            matcher = input.getPattern().matcher(line);
                            if (!matcher.matches()) continue;
                            event.processGroups(input, matcher);
                            currentInput = input;
                            if (countMap.get(currentInput) == null) {
                                countMap.put(currentInput, 1);
                            } else {
                                countMap.put(currentInput, (Integer)NonNullUtils.checkNotNull((Object)countMap.get(currentInput)) + 1);
                            }
                            Iterator<CustomTxtTraceDefinition.InputLine> iter = countMap.keySet().iterator();
                            while (iter.hasNext()) {
                                inputLine = iter.next();
                                if (inputLine.level <= currentInput.level) continue;
                                iter.remove();
                            }
                            if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                currentInput = currentInput.childrenInputs.get(0);
                                countMap.put(currentInput, 0);
                            } else if ((Integer)NonNullUtils.checkNotNull((Object)countMap.get(currentInput)) >= currentInput.getMaxCount()) {
                                if (currentInput.getNextInputs(countMap).size() > 0) {
                                    if (countMap.get(currentInput = currentInput.getNextInputs(countMap).get(0)) == null) {
                                        countMap.put(currentInput, 0);
                                    }
                                    iter = countMap.keySet().iterator();
                                    while (iter.hasNext()) {
                                        inputLine = iter.next();
                                        if (inputLine.level <= currentInput.level) continue;
                                        iter.remove();
                                    }
                                } else {
                                    currentInput = null;
                                }
                            }
                            processed = true;
                            break;
                        }
                    }
                    if (!processed && currentInput != null) {
                        Matcher matcher = currentInput.getPattern().matcher(line);
                        if (matcher.matches()) {
                            event.processGroups(currentInput, matcher);
                            countMap.put(currentInput, (Integer)NonNullUtils.checkNotNull((Object)countMap.get(currentInput)) + 1);
                            if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                currentInput = currentInput.childrenInputs.get(0);
                                countMap.put(currentInput, 0);
                            } else if ((Integer)NonNullUtils.checkNotNull((Object)countMap.get(currentInput)) >= currentInput.getMaxCount()) {
                                if (currentInput.getNextInputs(countMap).size() > 0) {
                                    if (countMap.get(currentInput = currentInput.getNextInputs(countMap).get(0)) == null) {
                                        countMap.put(currentInput, 0);
                                    }
                                    Iterator<CustomTxtTraceDefinition.InputLine> iter = countMap.keySet().iterator();
                                    while (iter.hasNext()) {
                                        CustomTxtTraceDefinition.InputLine inputLine = iter.next();
                                        if (inputLine.level <= currentInput.level) continue;
                                        iter.remove();
                                    }
                                } else {
                                    currentInput = null;
                                }
                            }
                        }
                        ((StringBuffer)event.getContentValue()).append("\n").append(line);
                    }
                }
                rawPos = this.fFile.getFilePointer();
                line = this.fFile.getNextLine();
            }
        }
        catch (IOException e) {
            Activator.logError("Error seeking event. File: " + this.getPath(), e);
        }
        for (Map.Entry entry : countMap.entrySet()) {
            if ((Integer)entry.getValue() >= ((CustomTxtTraceDefinition.InputLine)entry.getKey()).getMinCount()) continue;
            event = null;
        }
        context.setLocation(NULL_LOCATION);
        return event;
    }

    public List<CustomTxtTraceDefinition.InputLine> getFirstLines() {
        return this.fDefinition.inputs;
    }

    public CustomTxtEvent parseFirstLine(CustomTxtTraceContext context) {
        CustomTxtEventType eventType = new CustomTxtEventType((String)NonNullUtils.checkNotNull((Object)this.fDefinition.definitionName), this.fRootField);
        CustomTxtEvent event = new CustomTxtEvent(this.fDefinition, (ITmfTrace)this, TmfTimestamp.ZERO, (TmfEventType)eventType);
        event.processGroups(context.inputLine, context.firstLineMatcher);
        event.setContent(new CustomEventContent(event, new StringBuffer(context.firstLine)));
        return event;
    }

    public CustomTraceDefinition getDefinition() {
        return this.fDefinition;
    }

    @Override
    public IStatus validate(IProject project, String path) {
        File file = new File(path);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            return new Status(4, "org.eclipse.tracecompass.tmf.core", String.valueOf(Messages.CustomTrace_FileNotFound) + ": " + path);
        }
        int confidence = 0;
        try {
            if (!TmfTraceUtils.isText(file)) {
                return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.tmf.core");
            }
        }
        catch (IOException e) {
            Activator.logError("Error validating file: " + path, e);
            return new Status(4, "org.eclipse.tracecompass.tmf.core", "IOException validating file: " + path, (Throwable)e);
        }
        try {
            Throwable e = null;
            Object var6_9 = null;
            try (BufferedRandomAccessFile rafile = new BufferedRandomAccessFile(path, "r");){
                int lineCount = 0;
                double matches = 0.0;
                String line = rafile.getNextLine();
                while (line != null && lineCount++ < 100) {
                    for (CustomTxtTraceDefinition.InputLine inputLine : this.fDefinition.inputs) {
                        Matcher matcher = inputLine.getPattern().matcher(line);
                        if (!matcher.matches()) continue;
                        int groupCount = matcher.groupCount();
                        matches += 1.0 + (double)groupCount / ((double)groupCount + 1.0);
                        break;
                    }
                    confidence = (int)(100.0 * matches / (double)lineCount);
                    line = rafile.getNextLine();
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.tracecompass.tmf.core", "IOException validating file: " + path, (Throwable)e);
        }
        return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.tmf.core");
    }

    @Override
    public synchronized int getCheckpointSize() {
        if (fCheckpointSize == -1) {
            TmfCheckpoint c = new TmfCheckpoint(TmfTimestamp.ZERO, (ITmfLocation)new TmfLongLocation(0L), 0L);
            ByteBuffer b = ByteBuffer.allocate(1024);
            b.clear();
            c.serialize(b);
            fCheckpointSize = b.position();
        }
        return fCheckpointSize;
    }

    @Override
    public ITmfLocation restoreLocation(ByteBuffer bufferIn) {
        return new TmfLongLocation(bufferIn);
    }

    @Override
    protected ITmfTraceIndexer createIndexer(int interval) {
        return new TmfBTreeTraceIndexer(this, interval);
    }

    @Override
    public String getTraceTypeId() {
        return this.fTraceTypeId;
    }

    public static @NonNull String buildTraceTypeId(String category, String definitionName) {
        return CUSTOM_TXT_TRACE_TYPE_PREFIX + category + ':' + definitionName;
    }

    public static boolean isCustomTraceTypeId(@NonNull String traceTypeId) {
        return traceTypeId.startsWith(CUSTOM_TXT_TRACE_TYPE_PREFIX);
    }

    public static @NonNull String buildCompatibilityTraceTypeId(@NonNull String traceTypeId) {
        if (traceTypeId.startsWith(EARLY_TRACE_COMPASS_CUSTOM_TXT_TRACE_TYPE_PREFIX)) {
            return CUSTOM_TXT_TRACE_TYPE_PREFIX + traceTypeId.substring(EARLY_TRACE_COMPASS_CUSTOM_TXT_TRACE_TYPE_PREFIX.length());
        }
        int index = traceTypeId.lastIndexOf(58);
        if (index != -1 && traceTypeId.startsWith(LINUX_TOOLS_CUSTOM_TXT_TRACE_TYPE_PREFIX)) {
            String definitionName;
            String string = definitionName = index < traceTypeId.length() ? traceTypeId.substring(index + 1) : "";
            if (traceTypeId.contains(String.valueOf(CustomTxtTrace.class.getSimpleName()) + ':') && traceTypeId.indexOf(58) == index) {
                return CustomTxtTrace.buildTraceTypeId("Custom Text", definitionName);
            }
            return CUSTOM_TXT_TRACE_TYPE_PREFIX + traceTypeId.substring(LINUX_TOOLS_CUSTOM_TXT_TRACE_TYPE_PREFIX.length());
        }
        return traceTypeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        if (signal.getTrace() == this) {
            try {
                CustomTxtTrace customTxtTrace = this;
                synchronized (customTxtTrace) {
                    this.initFile();
                }
            }
            catch (TmfTraceException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        }
        super.traceRangeUpdated(signal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized ITmfTimestamp readEnd() {
        try {
            Long pos = this.fFile.length() - 1L;
            while (true) {
                if (pos <= 0L) {
                    return null;
                }
                while (pos > 0L) {
                    this.fFile.seek(pos - 1L);
                    if (this.fFile.read() == 10) break;
                    pos = pos - 1L;
                }
                TmfLongLocation location = new TmfLongLocation(pos);
                TmfContext context = this.seekEvent(location);
                CustomTxtEvent event = this.parseEvent(context);
                context.dispose();
                if (event != null) {
                    return event.getTimestamp();
                }
                pos = pos - 1L;
            }
        }
        catch (IOException e) {
            Activator.logError("Error seeking last event. File: " + this.getPath(), e);
        }
        return null;
    }
}

