/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.core.trace;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Longs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.btf.core.Activator;
import org.eclipse.tracecompass.btf.core.event.BtfEvent;
import org.eclipse.tracecompass.btf.core.event.BtfEventType;
import org.eclipse.tracecompass.btf.core.trace.BtfEventAspects;
import org.eclipse.tracecompass.btf.core.trace.BtfEventTypeFactory;
import org.eclipse.tracecompass.btf.core.trace.BtfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceContext;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public class BtfTrace
extends TmfTrace
implements ITmfPersistentlyIndexable,
ITmfPropertiesProvider {
    private static final int MAX_FIELDS = 7;
    private static final long MICROSECONDS_IN_A_SECOND = 1000000L;
    private static final String VERSION = "#version";
    private static final String CREATOR = "#creator";
    private static final String CREATIONDATE = "#creationDate";
    private static final String INPUTFILE = "#inputFile";
    private static final String TIMESCALE = "#timeScale";
    private static final String ENTITYTYPE = "#entityType";
    private static final String ENTITYTABLE = "#entityTable";
    private static final String ENTITYTYPETABLE = "#entityTypeTable";
    private static final String lCREATIONDATE = "#creationdate";
    private static final String lINPUTFILE = "#inputfile";
    private static final String lTIMESCALE = "#timescale";
    private static final String lENTITYTYPE = "#entitytype";
    private static final String lENTITYTABLE = "#entitytable";
    private static final String lENTITYTYPETABLE = "#entitytypetable";
    private static final TmfLongLocation NULL_LOCATION = new TmfLongLocation(-1L);
    private static final int CACHE_SIZE = 256;
    private static final int MAX_CONFIDENCE = 100;
    private static final int MAX_LINES = 100;
    private static int fCheckpointSize = -1;
    private final @NonNull Map<String, String> fProperties = new HashMap<String, String>();
    private final @NonNull Map<Integer, String> fEntityTable = new TreeMap<Integer, String>();
    private final @NonNull Map<BtfEventType, String> fEntityTypeTable = new HashMap<BtfEventType, String>();
    private final @NonNull Map<Integer, BtfEventType> fEntityTypes = new TreeMap<Integer, BtfEventType>();
    private String fVersion;
    private String fCreator;
    private String fCreationDate;
    private String fInputFile;
    private BtfTimestampFormat fTsFormat = BtfTimestampFormat.NS;
    private File fFile;
    private RandomAccessFile fFileInput;
    private long fDataOffset;
    private long fTsOffset = 0L;

    public BtfTrace() {
        this.setCacheSize(256);
        this.fProperties.put(TIMESCALE, this.fTsFormat.toString());
    }

    private void parseHeader(RandomAccessFile input) throws IOException {
        String line = input.readLine();
        long pos = 0L;
        while (line != null && line.startsWith("#")) {
            String[] tokens = line.split(" ", 2);
            switch (tokens[0].toLowerCase()) {
                case "#version": {
                    this.fVersion = tokens[1];
                    this.fProperties.put(VERSION, this.fVersion);
                    break;
                }
                case "#creator": {
                    this.fCreator = tokens[1];
                    this.fProperties.put(CREATOR, this.fCreator);
                    break;
                }
                case "#creationdate": {
                    this.fCreationDate = tokens[1];
                    this.fProperties.put(CREATIONDATE, this.fCreationDate);
                    try {
                        SimpleDateFormat ISO8601DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
                        Date dateTime = ISO8601DATEFORMAT.parse(this.fCreationDate);
                        this.fTsOffset = dateTime.getTime() * 1000000L;
                    }
                    catch (ParseException e) {
                        Activator.logWarning("Creation date error: " + e.getMessage());
                    }
                    break;
                }
                case "#inputfile": {
                    this.fInputFile = tokens[1];
                    this.fProperties.put(INPUTFILE, this.fInputFile);
                    break;
                }
                case "#timescale": {
                    this.fTsFormat = BtfTimestampFormat.parse(tokens[1]);
                    this.fProperties.put(TIMESCALE, this.fTsFormat.toString());
                    break;
                }
                case "#entitytype": {
                    String[] elements;
                    String tempLine;
                    pos = this.fFileInput.getFilePointer();
                    line = this.fFileInput.readLine();
                    while (line.startsWith("#-")) {
                        tempLine = line.substring(1);
                        elements = tempLine.split(" ", 2);
                        this.fEntityTypes.put(Integer.parseInt(elements[0]), BtfEventTypeFactory.parse(elements[1]));
                        pos = this.fFileInput.getFilePointer();
                        line = this.fFileInput.readLine();
                    }
                    this.fFileInput.seek(pos);
                    this.fProperties.put(ENTITYTYPE, this.fEntityTypes.toString());
                    break;
                }
                case "#entitytable": {
                    String[] elements;
                    String tempLine;
                    pos = this.fFileInput.getFilePointer();
                    line = this.fFileInput.readLine();
                    while (line.startsWith("#-")) {
                        tempLine = line.substring(1);
                        elements = tempLine.split(" ", 2);
                        this.fEntityTable.put(Integer.parseInt(elements[0]), elements[1]);
                        pos = this.fFileInput.getFilePointer();
                        line = this.fFileInput.readLine();
                    }
                    this.fProperties.put(ENTITYTABLE, this.fEntityTable.toString());
                    this.fFileInput.seek(pos);
                    break;
                }
                case "#entitytypetable": {
                    String[] elements;
                    String tempLine;
                    pos = this.fFileInput.getFilePointer();
                    line = this.fFileInput.readLine();
                    while (line.startsWith("#-")) {
                        tempLine = line.substring(1);
                        elements = tempLine.split(" ", 2);
                        this.fEntityTypeTable.put(BtfEventTypeFactory.parse(elements[0]), elements[1]);
                        pos = this.fFileInput.getFilePointer();
                        line = this.fFileInput.readLine();
                    }
                    this.fFileInput.seek(pos);
                    this.fProperties.put(ENTITYTYPETABLE, this.fEntityTypeTable.toString());
                    break;
                }
            }
            this.fDataOffset = input.getFilePointer();
            line = input.readLine();
        }
        this.fTsOffset = (long)((double)this.fTsOffset * this.fTsFormat.getScaleFactor());
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        super.initTrace(resource, path, type);
        this.fFile = new File(path);
        try {
            this.fFileInput = new RandomAccessFile(this.fFile, "r");
            this.parseHeader(this.fFileInput);
        }
        catch (IOException e) {
            throw new TmfTraceException(e.getMessage(), (Throwable)e);
        }
    }

    private void initFile() throws TmfTraceException {
        this.closeFile();
        try {
            this.fFileInput = new BufferedRandomAccessFile(this.getPath(), "r");
        }
        catch (IOException e) {
            throw new TmfTraceException(e.getMessage(), (Throwable)e);
        }
    }

    private void closeFile() {
        if (this.fFileInput != null) {
            try {
                try {
                    this.fFileInput.close();
                }
                catch (IOException iOException) {
                    this.fFileInput = null;
                }
            }
            finally {
                this.fFileInput = null;
            }
        }
    }

    public IStatus validate(IProject project, String path) {
        File file = new File(path);
        if (!file.exists()) {
            return new Status(4, "org.eclipse.tracecompass.btf.core", "File not found: " + path);
        }
        if (!file.isFile()) {
            return new Status(4, "org.eclipse.tracecompass.btf.core", "Not a file. It's a directory: " + path);
        }
        int confidence = 0;
        try {
            if (!TmfTraceUtils.isText((File)file)) {
                return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.btf.core");
            }
        }
        catch (IOException e) {
            Activator.logError("Error validating file: " + path, e);
            return new Status(4, "org.eclipse.tracecompass.btf.core", "IOException validating file: " + path, (Throwable)e);
        }
        try {
            Throwable e = null;
            Object var6_9 = null;
            try (BufferedRandomAccessFile rafile = new BufferedRandomAccessFile(path, "r");){
                int lineCount = 0;
                int matches = 0;
                String line = rafile.getNextLine();
                while (line != null && line.startsWith("#")) {
                    line = rafile.getNextLine();
                }
                while (line != null && lineCount++ < 100) {
                    ITmfEvent event = this.parseLine(0L, line);
                    if (event != null) {
                        ++matches;
                    }
                    confidence = 100 * matches / lineCount;
                    line = rafile.getNextLine();
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            Activator.logError("Error validating file: " + path, e);
            return new Status(4, "org.eclipse.tracecompass.btf.core", "IOException validating file: " + path, (Throwable)e);
        }
        return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.btf.core");
    }

    public ITmfLocation getCurrentLocation() {
        long temp = -1L;
        try {
            temp = this.fFileInput.getFilePointer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new TmfLongLocation(temp);
    }

    public double getLocationRatio(ITmfLocation location) {
        long pos;
        long size = this.fFile.length() - this.fDataOffset;
        try {
            pos = this.fFileInput.getFilePointer() - this.fDataOffset;
        }
        catch (IOException e) {
            pos = 0L;
        }
        return 1.0 / (double)size * (double)pos;
    }

    public ITmfContext seekEvent(ITmfLocation location) {
        TmfContext context = new TmfContext((ITmfLocation)NULL_LOCATION, -1L);
        if (NULL_LOCATION.equals((Object)location) || this.fFile == null) {
            return context;
        }
        try {
            if (location == null) {
                this.fFileInput.seek(this.fDataOffset);
            } else if (location.getLocationInfo() instanceof Long) {
                this.fFileInput.seek((Long)location.getLocationInfo());
            }
            context.setLocation((ITmfLocation)new TmfLongLocation(this.fFileInput.getFilePointer()));
            return context;
        }
        catch (FileNotFoundException e) {
            Activator.logError("Error seeking event. File not found: " + this.getPath(), e);
            return context;
        }
        catch (IOException e) {
            Activator.logError("Error seeking event. File: " + this.getPath(), e);
            return context;
        }
    }

    public ITmfContext seekEvent(double ratio) {
        if (this.fFile == null) {
            return new TmfContext((ITmfLocation)NULL_LOCATION, -1L);
        }
        try {
            long pos = Math.round(ratio * (double)this.fFile.length()) - this.fDataOffset;
            while (pos > 0L) {
                this.fFileInput.seek(pos - 1L);
                if (this.fFileInput.read() == 10) break;
                --pos;
            }
            TmfLongLocation location = new TmfLongLocation(pos);
            ITmfContext context = this.seekEvent((ITmfLocation)location);
            context.setRank(-1L);
            return context;
        }
        catch (IOException e) {
            Activator.logError("Error seeking event. File: " + this.getPath(), e);
            return new CustomTxtTraceContext((ITmfLocation)NULL_LOCATION, -1L);
        }
    }

    public ITmfEvent parseEvent(ITmfContext tmfContext) {
        if (this.fFile == null || !(tmfContext instanceof TmfContext)) {
            return null;
        }
        TmfContext context = (TmfContext)tmfContext;
        ITmfLocation location = context.getLocation();
        if (location == null || !(location.getLocationInfo() instanceof Long) || NULL_LOCATION.equals((Object)location)) {
            return null;
        }
        return this.parseLine(context);
    }

    private ITmfEvent parseLine(TmfContext context) {
        ITmfLocation location = context.getLocation();
        if (location != null) {
            try {
                if (!location.getLocationInfo().equals(this.fFileInput.getFilePointer())) {
                    this.seekEvent(location);
                }
            }
            catch (IOException e1) {
                this.seekEvent(location);
            }
            try {
                String line = this.fFileInput.readLine();
                return this.parseLine(context.getRank(), line);
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        return null;
    }

    private ITmfEvent parseLine(long rank, String line) {
        BtfEventType type;
        if (line == null) {
            return null;
        }
        Object[] tokens = line.split(",", 7);
        if (tokens.length < 7) {
            return null;
        }
        UnmodifiableIterator token = Iterators.forArray((Object[])tokens);
        Long timestamp = Longs.tryParse((String)((String)token.next()));
        if (timestamp == null) {
            return null;
        }
        String source = (String)token.next();
        Long sourceInstance = Longs.tryParse((String)((String)token.next()));
        if (sourceInstance == null) {
            sourceInstance = -1L;
        }
        if ((type = BtfEventTypeFactory.parse((String)token.next())) == null) {
            return null;
        }
        String target = (String)token.next();
        Long targetInstance = Longs.tryParse((String)((String)token.next()));
        if (targetInstance == null) {
            targetInstance = -1L;
        }
        String event = (String)token.next();
        ITmfEventField content = type.generateContent(event, sourceInstance, targetInstance);
        return new BtfEvent((ITmfTrace)this, rank, this.getTimestampTransform().transform(this.fTsFormat.createTimestamp(timestamp + this.fTsOffset)), source, (ITmfEventType)type, type.getDescription(), content, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCheckpointSize() {
        Class<BtfTrace> clazz = BtfTrace.class;
        synchronized (BtfTrace.class) {
            if (fCheckpointSize == -1) {
                TmfCheckpoint c = new TmfCheckpoint(TmfTimestamp.ZERO, (ITmfLocation)new TmfLongLocation(0L), 0L);
                ByteBuffer b = ByteBuffer.allocate(1024);
                b.clear();
                c.serialize(b);
                fCheckpointSize = b.position();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return fCheckpointSize;
        }
    }

    public ITmfLocation restoreLocation(ByteBuffer bufferIn) {
        return new TmfLongLocation(bufferIn);
    }

    protected ITmfTraceIndexer createIndexer(int interval) {
        return new TmfBTreeTraceIndexer((ITmfTrace)this, interval);
    }

    public Map<String, String> getProperties() {
        return ImmutableMap.copyOf(this.fProperties);
    }

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return BtfEventAspects.getAspects();
    }

    public synchronized void dispose() {
        RandomAccessFile raf = this.fFileInput;
        if (raf != null) {
            try {
                raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        if (signal.getTrace() == this) {
            try {
                BtfTrace btfTrace = this;
                synchronized (btfTrace) {
                    this.initFile();
                }
            }
            catch (TmfTraceException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        }
        super.traceRangeUpdated(signal);
    }
}

