/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.doubleclick;

import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.w3c.dom.Node;

public class XMLDoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    protected static final char DOUBLE_QUOTE = '\"';
    protected static final char SINGLE_QUOTE = '\'';
    protected static final char SPACE = ' ';
    protected int fCaretPosition = -1;
    protected int fDoubleClickCount = 0;
    protected Node fNode = null;
    protected IStructuredDocumentRegion fStructuredDocumentRegion = null;
    protected String fStructuredDocumentRegionText = "";
    protected IStructuredModel fStructuredModel = null;
    protected ITextViewer fTextViewer;
    protected ITextRegion fTextRegion = null;

    /*
     * Exception decompiling
     */
    public void doubleClicked(ITextViewer textViewer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 146->150)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Point getWord(String string, int cursor) {
        if (string == null) {
            return null;
        }
        int wordStart = 0;
        int wordEnd = string.length();
        wordStart = string.lastIndexOf(32, cursor - 1);
        int temp = string.lastIndexOf(39, cursor - 1);
        wordStart = Math.max(wordStart, temp);
        temp = string.lastIndexOf(34, cursor - 1);
        wordStart = (wordStart = Math.max(wordStart, temp)) == -1 ? cursor : ++wordStart;
        wordEnd = string.indexOf(32, cursor);
        if (wordEnd == -1) {
            wordEnd = string.length();
        }
        if ((temp = string.indexOf(39, cursor)) == -1) {
            temp = string.length();
        }
        wordEnd = Math.min(wordEnd, temp);
        temp = string.indexOf(34, cursor);
        if (temp == -1) {
            temp = string.length();
        }
        if ((wordEnd = Math.min(wordEnd, temp)) == string.length()) {
            wordEnd = cursor;
        }
        if (wordStart == wordEnd && !this.isQuoted(string)) {
            wordStart = 0;
            wordEnd = string.length();
        }
        return new Point(wordStart, wordEnd);
    }

    protected boolean isQuoted(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        int lastIndex = string.length() - 1;
        char firstChar = string.charAt(0);
        char lastChar = string.charAt(lastIndex);
        return firstChar == '\'' && lastChar == '\'' || firstChar == '\"' && lastChar == '\"';
    }

    protected void processElementAttrEqualsDoubleClicked2Times() {
        int prevRegionOffset = this.fStructuredDocumentRegion.getStartOffset(this.fTextRegion) - 1;
        ITextRegion prevRegion = this.fStructuredDocumentRegion.getRegionAtCharacterOffset(prevRegionOffset);
        int nextRegionOffset = this.fStructuredDocumentRegion.getEndOffset(this.fTextRegion);
        ITextRegion nextRegion = this.fStructuredDocumentRegion.getRegionAtCharacterOffset(nextRegionOffset);
        if (prevRegion != null && prevRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" && nextRegion != null && nextRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
            this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStartOffset(prevRegion), nextRegion.getTextEnd() - prevRegion.getStart());
        }
    }

    protected void processElementAttrNameDoubleClicked2Times() {
        int nextRegionOffset = this.fStructuredDocumentRegion.getEndOffset(this.fTextRegion);
        ITextRegion nextRegion = this.fStructuredDocumentRegion.getRegionAtCharacterOffset(nextRegionOffset);
        if (nextRegion != null) {
            nextRegionOffset = this.fStructuredDocumentRegion.getEndOffset(nextRegion);
            if ((nextRegion = this.fStructuredDocumentRegion.getRegionAtCharacterOffset(nextRegionOffset)) != null && nextRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStartOffset(this.fTextRegion), nextRegion.getTextEnd() - this.fTextRegion.getStart());
            } else {
                this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStart(), this.fStructuredDocumentRegion.getLength());
                this.fDoubleClickCount = 0;
            }
        }
    }

    protected void processElementAttrValueDoubleClicked() {
        String regionText = this.fStructuredDocumentRegion.getText(this.fTextRegion);
        if (this.fDoubleClickCount == 1) {
            Point word = this.getWord(regionText, this.fCaretPosition - this.fStructuredDocumentRegion.getStartOffset(this.fTextRegion));
            if (word.x == word.y) {
                this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStartOffset(this.fTextRegion), regionText.length());
                ++this.fDoubleClickCount;
            } else {
                this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStartOffset(this.fTextRegion) + word.x, word.y - word.x);
            }
        } else if (this.fDoubleClickCount == 2) {
            if (this.isQuoted(regionText)) {
                this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStartOffset(this.fTextRegion), regionText.length());
            } else {
                this.processElementAttrValueDoubleClicked2Times();
            }
        } else if (this.fDoubleClickCount == 3) {
            if (this.isQuoted(regionText)) {
                this.processElementAttrValueDoubleClicked2Times();
            } else {
                this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStart(), this.fStructuredDocumentRegion.getLength());
                this.fDoubleClickCount = 0;
            }
        } else {
            this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStart(), this.fStructuredDocumentRegion.getLength());
            this.fDoubleClickCount = 0;
        }
    }

    protected void processElementAttrValueDoubleClicked2Times() {
        int prevRegionOffset = this.fStructuredDocumentRegion.getStartOffset(this.fTextRegion) - 1;
        ITextRegion prevRegion = this.fStructuredDocumentRegion.getRegionAtCharacterOffset(prevRegionOffset);
        if (prevRegion != null && (prevRegion = this.fStructuredDocumentRegion.getRegionAtCharacterOffset(prevRegionOffset = this.fStructuredDocumentRegion.getStartOffset(prevRegion) - 1)) != null && prevRegion.getType() == "XML_TAG_ATTRIBUTE_NAME") {
            this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStartOffset(prevRegion), this.fTextRegion.getTextEnd() - prevRegion.getStart());
        }
    }

    protected void processElementDoubleClicked() {
        if (this.fTextRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
            this.processElementAttrValueDoubleClicked();
        } else if (this.fDoubleClickCount == 1) {
            this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStart() + this.fTextRegion.getStart(), this.fTextRegion.getTextLength());
        } else if (this.fDoubleClickCount == 2) {
            if (this.fTextRegion.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                this.processElementAttrNameDoubleClicked2Times();
            } else if (this.fTextRegion.getType() == "XML_TAG_ATTRIBUTE_EQUALS") {
                this.processElementAttrEqualsDoubleClicked2Times();
            } else {
                this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStart(), this.fStructuredDocumentRegion.getLength());
                this.fDoubleClickCount = 0;
            }
        } else {
            this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStart(), this.fStructuredDocumentRegion.getLength());
            this.fDoubleClickCount = 0;
        }
    }

    protected void processTextDoubleClicked() {
        if (this.fDoubleClickCount == 1) {
            super.doubleClicked(this.fTextViewer);
            Point selectedRange = this.fTextViewer.getSelectedRange();
            if (selectedRange.x == this.fStructuredDocumentRegion.getStartOffset(this.fTextRegion) && selectedRange.y == this.fTextRegion.getTextLength()) {
                ++this.fDoubleClickCount;
            }
        } else if (this.fDoubleClickCount == 2) {
            if (this.fTextRegion.getType() == "UNDEFINED") {
                this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStart(), this.fStructuredDocumentRegion.getLength());
                this.fDoubleClickCount = 0;
            } else if (this.isQuoted(this.fStructuredDocumentRegion.getFullText(this.fTextRegion))) {
                this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStartOffset(this.fTextRegion) + 1, this.fTextRegion.getTextLength() - 2);
            } else {
                this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStartOffset(this.fTextRegion), this.fTextRegion.getTextLength());
            }
        } else if (this.fDoubleClickCount == 3 && this.isQuoted(this.fStructuredDocumentRegion.getFullText(this.fTextRegion))) {
            this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStartOffset(this.fTextRegion), this.fTextRegion.getTextLength());
        } else if (this.fDoubleClickCount == 3 && this.isQuoted(this.fStructuredDocumentRegionText)) {
            this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStart() + 1, this.fStructuredDocumentRegion.getLength() - 2);
        } else {
            this.fTextViewer.setSelectedRange(this.fStructuredDocumentRegion.getStart(), this.fStructuredDocumentRegion.getLength());
            this.fDoubleClickCount = 0;
        }
    }

    public void setModel(IStructuredModel structuredModel) {
        this.fStructuredModel = structuredModel;
    }

    protected void updateDoubleClickCount(int caretPosition) {
        if (this.fCaretPosition == caretPosition) {
            this.fDoubleClickCount = this.fStructuredDocumentRegion != null ? ++this.fDoubleClickCount : 1;
        } else {
            this.fCaretPosition = caretPosition;
            this.fDoubleClickCount = 1;
        }
    }

    protected void updateStructuredDocumentRegion() {
        this.fStructuredDocumentRegion = this.fStructuredModel.getStructuredDocument().getRegionAtCharacterOffset(this.fCaretPosition);
        this.fStructuredDocumentRegionText = this.fStructuredDocumentRegion != null ? this.fStructuredDocumentRegion.getText() : "";
    }

    protected void updateTextRegion() {
        if (this.fStructuredDocumentRegion != null) {
            this.fTextRegion = this.fStructuredDocumentRegion.getRegionAtCharacterOffset(this.fCaretPosition);
            if (this.fTextRegion == null) {
                this.fTextRegion = this.fStructuredDocumentRegion.getRegionAtCharacterOffset(this.fCaretPosition - 1);
            }
        } else {
            this.fTextRegion = null;
        }
    }
}

