/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioHistoryBuilder;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;

public class TmfXmlScenarioInfo {
    private final int fQuark;
    private final TmfXmlFsm fFsm;
    private final int fStatusQuark;
    private String fActiveState;
    private TmfXmlScenarioHistoryBuilder.ScenarioStatusType fStatus;
    private final Map<@NonNull TmfAttributePool, Integer> fPoolAttributes = new HashMap<TmfAttributePool, Integer>();

    public TmfXmlScenarioInfo(String activeState, TmfXmlScenarioHistoryBuilder.ScenarioStatusType status, int quark, int statusQuark, TmfXmlFsm fsm) {
        this.fActiveState = activeState;
        this.fQuark = quark;
        this.fStatus = status;
        this.fStatusQuark = statusQuark;
        this.fFsm = fsm;
    }

    public void setActiveState(String activeState) {
        this.fActiveState = activeState;
    }

    public void setStatus(TmfXmlScenarioHistoryBuilder.ScenarioStatusType status) {
        this.fStatus = status;
    }

    public int getQuark() {
        return this.fQuark;
    }

    public String getActiveState() {
        return this.fActiveState;
    }

    public TmfXmlScenarioHistoryBuilder.ScenarioStatusType getStatus() {
        return this.fStatus;
    }

    public int getStatusQuark() {
        return this.fStatusQuark;
    }

    public String getFsmId() {
        return this.fFsm.getId();
    }

    public Integer getAttributeFromPool(TmfAttributePool pool) {
        Integer quark = this.fPoolAttributes.get(pool);
        if (quark == null) {
            quark = pool.getAvailable();
            this.fPoolAttributes.put(pool, quark);
        }
        return quark;
    }

    public void recycleAttributes(long ts) {
        this.fPoolAttributes.entrySet().forEach(e -> ((TmfAttributePool)NonNullUtils.checkNotNull((Object)((TmfAttributePool)e.getKey()))).recycle(((Integer)e.getValue()).intValue(), ts));
    }
}

