/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public final class KernelEventHandlerUtils {
    private KernelEventHandlerUtils() {
    }

    public static @Nullable Integer getCpu(ITmfEvent event) {
        return TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
    }

    public static int getCurrentCPUNode(Integer cpuNumber, ITmfStateSystemBuilder ss) {
        return ss.getQuarkRelativeAndAdd(KernelEventHandlerUtils.getNodeCPUs(ss), new String[]{cpuNumber.toString()});
    }

    public static long getTimestamp(ITmfEvent event) {
        return event.getTimestamp().toNanos();
    }

    public static int getCurrentThreadNode(Integer cpuNumber, ITmfStateSystemBuilder ss) {
        int quark = ss.getQuarkRelativeAndAdd(KernelEventHandlerUtils.getCurrentCPUNode(cpuNumber, ss), new String[]{"Current_thread"});
        ITmfStateValue value = ss.queryOngoingState(quark);
        int thread = value.isNull() ? -1 : value.unboxInt();
        return ss.getQuarkRelativeAndAdd(KernelEventHandlerUtils.getNodeThreads(ss), new String[]{Attributes.buildThreadAttributeName(thread, cpuNumber)});
    }

    public static void setProcessToRunning(long timestamp, int currentThreadNode, ITmfStateSystemBuilder ssb) throws TimeRangeException, StateValueTypeException {
        int quark = ssb.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"System_call"});
        ITmfStateValue value = ssb.queryOngoingState(quark).isNull() ? ProcessStatus.RUN.getStateValue() : ProcessStatus.RUN_SYTEMCALL.getStateValue();
        ssb.modifyAttribute(timestamp, value, currentThreadNode);
    }

    public static int getNodeIRQs(int cpuNumber, ITmfStateSystemBuilder ss) {
        return ss.getQuarkAbsoluteAndAdd(new String[]{"CPUs", Integer.toString(cpuNumber), "IRQs"});
    }

    public static int getNodeCPUs(ITmfStateSystemBuilder ss) {
        return ss.getQuarkAbsoluteAndAdd(new String[]{"CPUs"});
    }

    public static int getNodeSoftIRQs(int cpuNumber, ITmfStateSystemBuilder ss) {
        return ss.getQuarkAbsoluteAndAdd(new String[]{"CPUs", Integer.toString(cpuNumber), "Soft_IRQs"});
    }

    public static int getNodeThreads(ITmfStateSystemBuilder ss) {
        return ss.getQuarkAbsoluteAndAdd(new String[]{"Threads"});
    }

    public static void updateCpuStatus(long timestamp, Integer cpuNumber, ITmfStateSystemBuilder ssb) throws StateValueTypeException, TimeRangeException {
        int currentCPUNode = KernelEventHandlerUtils.getCurrentCPUNode(cpuNumber, ssb);
        ITmfStateValue value = KernelEventHandlerUtils.getCpuStatus(ssb, currentCPUNode);
        ssb.modifyAttribute(timestamp, value, currentCPUNode);
    }

    private static ITmfStateValue getCpuStatus(ITmfStateSystemBuilder ssb, int cpuQuark) {
        int irqQuarks = ssb.getQuarkRelativeAndAdd(cpuQuark, new String[]{"IRQs"});
        List irqs = ssb.getSubAttributes(irqQuarks, false);
        for (Integer quark : irqs) {
            ITmfStateValue irqState = ssb.queryOngoingState(quark.intValue());
            if (irqState.isNull()) continue;
            return StateValues.CPU_STATUS_IRQ_VALUE;
        }
        int softIrqQuarks = ssb.getQuarkRelativeAndAdd(cpuQuark, new String[]{"Soft_IRQs"});
        List softIrqs = ssb.getSubAttributes(softIrqQuarks, false);
        TmfStateValue softIrq = TmfStateValue.nullValue();
        for (Integer quark : softIrqs) {
            ITmfStateValue softIrqState = ssb.queryOngoingState(quark.intValue());
            if (softIrqState.unboxInt() <= softIrq.unboxInt()) continue;
            softIrq = softIrqState;
        }
        if (!softIrq.isNull()) {
            return softIrq;
        }
        int currentThreadQuark = ssb.getQuarkRelativeAndAdd(cpuQuark, new String[]{"Current_thread"});
        ITmfStateValue currentThreadState = ssb.queryOngoingState(currentThreadQuark);
        if (currentThreadState.isNull()) {
            return TmfStateValue.nullValue();
        }
        int tid = currentThreadState.unboxInt();
        if (tid == 0) {
            return StateValues.CPU_STATUS_IDLE_VALUE;
        }
        int threadSystemCallQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Threads", Integer.toString(tid), "System_call"});
        return ssb.queryOngoingState(threadSystemCallQuark).isNull() ? StateValues.CPU_STATUS_RUN_USERMODE_VALUE : StateValues.CPU_STATUS_RUN_SYSCALL_VALUE;
    }

    public static ITmfStateValue getAggregate(ITmfStateSystemBuilder ss, String irqType, Integer irqId) {
        TmfStateValue value = TmfStateValue.nullValue();
        for (Integer irqQuark : ss.getQuarks(new String[]{"CPUs", "*", irqType, irqId.toString()})) {
            ITmfStateValue ongoing = ss.queryOngoingState(irqQuark.intValue());
            if (ongoing.unboxInt() <= value.unboxInt()) continue;
            value = ongoing;
        }
        return value;
    }

    public static @Nullable Integer getCpuForIrq(ITmfStateSystemBuilder ss, Integer irqId) {
        for (Integer irqs : ss.getQuarks(new String[]{"CPUs", "*", "IRQs", irqId.toString()})) {
            if (ss.queryOngoingState(irqs.intValue()).isNull()) continue;
            return Integer.parseInt(ss.getAttributeName(ss.getParentAttributeQuark(ss.getParentAttributeQuark(irqs.intValue()))));
        }
        return null;
    }
}

