/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.TreeMultimap;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.SoftIrqLabelProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class ResourcesStatusDataProvider
extends AbstractTimeGraphDataProvider<KernelAnalysisModule, ResourcesEntryModel> {
    public static final @NonNull String ID = "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ResourcesStatusDataProvider";
    private static final String WILDCARD = "*";
    private final Function<@NonNull String, @NonNull String> fSyscallTrim;
    private final CacheLoader<ITmfStateInterval, @Nullable TimeGraphState> fLoader = new CacheLoader<ITmfStateInterval, TimeGraphState>(){

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable TimeGraphState load(ITmfStateInterval interval) {
            String attribute;
            ITmfStateSystem ss = ((KernelAnalysisModule)ResourcesStatusDataProvider.this.getAnalysisModule()).getStateSystem();
            if (ss == null) {
                return null;
            }
            long startTime = interval.getStartTime();
            long duration = interval.getEndTime() - startTime + 1L;
            int status = interval.getStateValue().unboxInt();
            int currentThreadQuark = ss.optQuarkRelative(interval.getAttribute(), new String[]{"Current_thread"});
            if (currentThreadQuark == -2) {
                return new TimeGraphState(startTime, duration, (long)status);
            }
            @NonNull @NonNull Function trim = Function.identity();
            if (status == 2) {
                attribute = "Exec_name";
            } else if (status == 4) {
                attribute = "System_call";
                trim = ResourcesStatusDataProvider.this.fSyscallTrim;
            } else {
                return null;
            }
            long time = startTime;
            try {
                while (time < interval.getEndTime()) {
                    ITmfStateInterval nameInterval;
                    Object label;
                    int currentThreadId;
                    int quark;
                    ITmfStateInterval tidInterval = ss.querySingleState(time, currentThreadQuark);
                    time = Long.max(tidInterval.getStartTime(), time);
                    Object value = tidInterval.getValue();
                    if (value instanceof Integer && (quark = ss.optQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId = ((Integer)value).intValue()), attribute})) != -2 && (label = (nameInterval = ss.querySingleState(time, quark)).getValue()) instanceof String) {
                        return new TimeGraphState(startTime, duration, (long)status, (String)trim.apply((String)label));
                    }
                    time = tidInterval.getEndTime() + 1L;
                }
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
            return new TimeGraphState(startTime, duration, (long)status);
        }
    };
    private final LoadingCache<ITmfStateInterval, @Nullable TimeGraphState> fTimeEventNames = CacheBuilder.newBuilder().maximumSize(1000L).build(this.fLoader);

    protected ResourcesStatusDataProvider(@NonNull ITmfTrace trace, @NonNull KernelAnalysisModule module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
        if (trace instanceof IKernelTrace) {
            IKernelAnalysisEventLayout layout = ((IKernelTrace)trace).getKernelEventLayout();
            int beginIndex = layout.eventSyscallEntryPrefix().length();
            this.fSyscallTrim = sysCall -> sysCall.substring(beginIndex);
        } else {
            this.fSyscallTrim = Function.identity();
        }
    }

    protected @NonNull List<@NonNull ResourcesEntryModel> getTree(@NonNull ITmfStateSystem ss, @NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        long start = ss.getStartTime();
        long end = ss.getCurrentEndTime();
        @NonNull ArrayList<@NonNull ResourcesEntryModel> builder = new ArrayList<ResourcesEntryModel>();
        long traceId = this.getId(-1);
        ResourcesEntryModel resourcesEntryModel = new ResourcesEntryModel(traceId, -1L, this.getTrace().getName(), start, end, -1, ResourcesEntryModel.Type.TRACE);
        builder.add(resourcesEntryModel);
        for (Integer cpuQuark : ss.getQuarks(new String[]{"CPUs", WILDCARD})) {
            @NonNull String cpuName = ss.getAttributeName(cpuQuark.intValue());
            int cpu = Integer.parseInt(cpuName);
            ResourcesEntryModel cpuEntry = new ResourcesEntryModel(this.getId(cpuQuark), traceId, ResourcesStatusDataProvider.computeEntryName(ResourcesEntryModel.Type.CPU, cpu), start, end, cpu, ResourcesEntryModel.Type.CPU);
            builder.add(cpuEntry);
            List irqQuarks = ss.getQuarks(cpuQuark.intValue(), new String[]{"IRQs", WILDCARD});
            this.createInterrupt(ss, start, end, cpuEntry, irqQuarks, ResourcesEntryModel.Type.IRQ, builder);
            List softIrqQuarks = ss.getQuarks(cpuQuark.intValue(), new String[]{"Soft_IRQs", WILDCARD});
            this.createInterrupt(ss, start, end, cpuEntry, softIrqQuarks, ResourcesEntryModel.Type.SOFT_IRQ, builder);
        }
        return ImmutableList.copyOf(builder);
    }

    private void createInterrupt(ITmfStateSystem ssq, long startTime, long endTime, ResourcesEntryModel cpuEntry, List<Integer> irqQuarks, ResourcesEntryModel.Type type, List<ResourcesEntryModel> builder) {
        for (Integer irqQuark : irqQuarks) {
            String resourceName = ssq.getAttributeName(irqQuark.intValue());
            int resourceId = Integer.parseInt(resourceName);
            long irqId = this.getId(irqQuark);
            builder.add(new ResourcesEntryModel(irqId, cpuEntry.getId(), ResourcesStatusDataProvider.computeEntryName(type, resourceId), startTime, endTime, resourceId, type));
            String aggregateIrqtype = type == ResourcesEntryModel.Type.IRQ ? "IRQs" : "Soft_IRQs";
            long aggregateId = this.getId(ssq.optQuarkAbsolute(new String[]{aggregateIrqtype, resourceName}));
            if (!Iterables.any(builder, entry -> entry.getId() == aggregateId)) {
                builder.add(new ResourcesEntryModel(aggregateId, cpuEntry.getParentId(), ResourcesStatusDataProvider.computeEntryName(type, resourceId), startTime, endTime, resourceId, type));
            }
            builder.add(new ResourcesEntryModel(irqId, aggregateId, ResourcesStatusDataProvider.computeEntryName(ResourcesEntryModel.Type.CPU, cpuEntry.getResourceId()), startTime, endTime, cpuEntry.getResourceId(), type));
        }
    }

    private static @NonNull String computeEntryName(ResourcesEntryModel.Type type, int id) {
        if (type == ResourcesEntryModel.Type.SOFT_IRQ) {
            return String.valueOf(type.toString()) + ' ' + id + ' ' + SoftIrqLabelProvider.getSoftIrq(id);
        }
        return String.valueOf(type.toString()) + ' ' + id;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<ITimeGraphRowModel> getRowModel(ITmfStateSystem ss, SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        @NonNull @NonNull BiMap entries = this.getSelectedEntries(filter);
        Collection times = ResourcesStatusDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        for (ITmfStateInterval interval : ss.query2D(entries.values(), times)) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        ArrayList<ITimeGraphRowModel> rows = new ArrayList<ITimeGraphRowModel>();
        for (Map.Entry entry : entries.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            ArrayList<ITimeGraphState> eventList = new ArrayList<ITimeGraphState>();
            for (ITmfStateInterval interval : intervals.get((Object)((Integer)entry.getValue()))) {
                eventList.add(this.createTimeGraphState(interval));
            }
            rows.add((ITimeGraphRowModel)new TimeGraphRowModel(((Long)entry.getKey()).longValue(), eventList));
        }
        if (!ss.waitUntilBuilt(0L)) {
            this.fTimeEventNames.invalidateAll();
        }
        return rows;
    }

    private ITimeGraphState createTimeGraphState(ITmfStateInterval interval) {
        long startTime = interval.getStartTime();
        long duration = interval.getEndTime() - startTime + 1L;
        Object status = interval.getValue();
        if (status instanceof Integer) {
            int s = (Integer)status;
            if (s == 2 || s == 4) {
                return (ITimeGraphState)this.fTimeEventNames.getUnchecked((Object)interval);
            }
            return new TimeGraphState(startTime, duration, (long)s);
        }
        return new TimeGraphState(startTime, duration, Integer.MIN_VALUE);
    }

    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull String getId() {
        return ID;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public TmfModelResponse<Map<String, String>> fetchTooltip(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        ITmfStateSystem ss = ((KernelAnalysisModule)this.getAnalysisModule()).getStateSystem();
        @NonNull Set quarks = this.getSelectedQuarks(filter);
        long start = filter.getStart();
        if (ss == null || quarks.size() != 1 || !((KernelAnalysisModule)this.getAnalysisModule()).isQueryable(start)) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        int quark = (Integer)quarks.iterator().next();
        String attributeName = ss.getAttributeName(quark);
        Integer cpuNumber = Ints.tryParse((String)attributeName);
        String parent = ss.getAttributeName(ss.getParentAttributeQuark(quark));
        if (!parent.equals("CPUs") || cpuNumber == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        try {
            LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>(1);
            List full = ss.queryFullState(start);
            Object object = ((ITmfStateInterval)full.get(quark)).getValue();
            if (object instanceof Integer) {
                int status = (Integer)object;
                if (status == 16) {
                    ResourcesStatusDataProvider.putIrq(ss, attributeName, retMap, full, "IRQs");
                } else if (status == 8) {
                    ResourcesStatusDataProvider.putIrq(ss, attributeName, retMap, full, "Soft_IRQs");
                } else if (status == 2 || status == 4) {
                    ResourcesStatusDataProvider.putCpuTooltip(ss, attributeName, retMap, full, status);
                }
            }
            return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
    }

    private static void putIrq(ITmfStateSystem ss, String attributeName, Map<String, String> retMap, List<ITmfStateInterval> full, String irqs) {
        Iterator iterator = ss.getQuarks(new String[]{"CPUs", attributeName, irqs, WILDCARD}).iterator();
        while (iterator.hasNext()) {
            int irqQuark = (Integer)iterator.next();
            ITmfStateInterval interval = full.get(irqQuark);
            if (interval.getValue() == null) continue;
            String irq = ss.getAttributeName(irqQuark);
            retMap.put(irqs, irq);
            return;
        }
    }

    private static void putCpuTooltip(ITmfStateSystem ss, String attributeName, Map<String, String> retMap, List<ITmfStateInterval> full, int status) {
        int currentThreadQuark = ss.optQuarkAbsolute(new String[]{"CPUs", attributeName, "Current_thread"});
        if (currentThreadQuark == -2) {
            return;
        }
        Object currentThreadObject = full.get(currentThreadQuark).getValue();
        if (currentThreadObject instanceof Number) {
            Object syscall;
            Object processName;
            String currentThread = currentThreadObject.toString();
            retMap.put("Current_thread", currentThread);
            int execNameQuark = ss.optQuarkAbsolute(new String[]{"Threads", currentThread, "Exec_name"});
            if (execNameQuark != -2 && (processName = full.get(execNameQuark).getValue()) instanceof String) {
                retMap.put("Exec_name", (String)processName);
            }
            int syscallQuark = ss.optQuarkAbsolute(new String[]{"Threads", currentThread, "System_call"});
            if (status == 4 && syscallQuark != -2 && (syscall = full.get(syscallQuark).getValue()) instanceof String) {
                retMap.put("System_call", (String)syscall);
            }
        }
    }

    protected boolean isCacheable() {
        return true;
    }
}

