/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density;

import com.google.common.annotations.VisibleForTesting;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.ISegmentStoreDensityViewerDataListener;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.Messages;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density.MouseDragZoomProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density.MouseSelectionProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density.SimpleTooltipProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.table.SegmentStoreContentProvider;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.IImageSave;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public abstract class AbstractSegmentStoreDensityViewer
extends TmfViewer
implements IImageSave {
    private static final Format DENSITY_TIME_FORMATTER = new SubSecondTimeWithUnitFormat();
    private static final RGB BAR_COLOR = new RGB(66, 133, 244);
    private final Chart fChart;
    private final MouseDragZoomProvider fDragZoomProvider;
    private final MouseSelectionProvider fDragProvider;
    private final SimpleTooltipProvider fTooltipProvider;
    private @Nullable ITmfTrace fTrace;
    private @Nullable IAnalysisProgressListener fListener;
    private @Nullable ISegmentStoreProvider fSegmentStoreProvider;
    private Range fCurrentDurationRange = new Range(Double.MIN_VALUE, Double.MAX_VALUE);
    private TmfTimeRange fCurrentTimeRange = TmfTimeRange.NULL_RANGE;
    private final List<ISegmentStoreDensityViewerDataListener> fListeners = new ArrayList<ISegmentStoreDensityViewerDataListener>();
    private int fOverrideNbPoints;

    public AbstractSegmentStoreDensityViewer(Composite parent) {
        super(parent);
        this.fChart = new Chart(parent, 0);
        this.fChart.getLegend().setVisible(false);
        this.fChart.getTitle().setVisible(false);
        this.fChart.getAxisSet().getXAxis(0).getTitle().setText(NonNullUtils.nullToEmptyString((Object)Messages.AbstractSegmentStoreDensityViewer_TimeAxisLabel));
        this.fChart.getAxisSet().getYAxis(0).getTitle().setText(NonNullUtils.nullToEmptyString((Object)Messages.AbstractSegmentStoreDensityViewer_CountAxisLabel));
        this.fChart.getAxisSet().getXAxis(0).getGrid().setStyle(LineStyle.DOT);
        this.fChart.getAxisSet().getYAxis(0).getGrid().setStyle(LineStyle.DOT);
        this.fDragZoomProvider = new MouseDragZoomProvider(this);
        this.fDragZoomProvider.register();
        this.fDragProvider = new MouseSelectionProvider(this);
        this.fDragProvider.register();
        this.fTooltipProvider = new SimpleTooltipProvider(this);
        this.fTooltipProvider.register();
        this.fChart.addDisposeListener(e -> this.internalDispose());
    }

    protected abstract @Nullable ISegmentStoreProvider getSegmentStoreProvider(ITmfTrace var1);

    private static @Nullable ITmfTrace getTrace() {
        return TmfTraceManager.getInstance().getActiveTrace();
    }

    private void updateDisplay(SegmentStoreContentProvider.SegmentStoreWithRange<ISegment> data) {
        IBarSeries series = (IBarSeries)this.fChart.getSeriesSet().createSeries(ISeries.SeriesType.BAR, Messages.AbstractSegmentStoreDensityViewer_SeriesLabel);
        series.setVisible(true);
        series.setBarPadding(0);
        series.setBarColor(new Color((Device)Display.getDefault(), BAR_COLOR));
        int barWidth = 4;
        int width = this.fOverrideNbPoints == 0 ? this.fChart.getPlotArea().getBounds().width / barWidth : this.fOverrideNbPoints;
        double[] xOrigSeries = new double[width];
        double[] yOrigSeries = new double[width];
        Arrays.fill(yOrigSeries, 1.0);
        data.setComparator(SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
        ISegment maxSegment = data.getElement(Long.MIN_VALUE);
        long maxLength = Long.MAX_VALUE;
        if (maxSegment != null) {
            maxLength = maxSegment.getLength();
        }
        double maxFactor = 1.0 / ((double)maxLength + 1.0);
        long minX = Long.MAX_VALUE;
        for (ISegment segment : data) {
            double xBox = (double)segment.getLength() * maxFactor * (double)width;
            int n = (int)xBox;
            yOrigSeries[n] = yOrigSeries[n] + 1.0;
            minX = Math.min(minX, segment.getLength());
        }
        double timeWidth = (double)maxLength / (double)width;
        int i = 0;
        while (i < width) {
            xOrigSeries[i] = (double)i * timeWidth;
            ++i;
        }
        double maxY = Double.MIN_VALUE;
        int i2 = 0;
        while (i2 < width) {
            maxY = Math.max(maxY, yOrigSeries[i2]);
            ++i2;
        }
        if (minX == maxLength) {
            ++maxLength;
            --minX;
        }
        series.setYSeries(yOrigSeries);
        series.setXSeries(xOrigSeries);
        IAxis xAxis = this.fChart.getAxisSet().getXAxis(0);
        xAxis.adjustRange();
        Range range = xAxis.getRange();
        range.lower = (double)minX - range.upper + (double)maxLength;
        xAxis.setRange(range);
        xAxis.getTick().setFormat(DENSITY_TIME_FORMATTER);
        this.fChart.getAxisSet().getYAxis(0).setRange(new Range(0.9, maxY));
        this.fChart.getAxisSet().getYAxis(0).enableLogScale(true);
        this.fChart.redraw();
        new Thread(() -> {
            for (ISegmentStoreDensityViewerDataListener l : this.fListeners) {
                l.chartUpdated();
            }
        }).start();
    }

    public Chart getControl() {
        return this.fChart;
    }

    public void select(Range durationRange) {
        this.fCurrentDurationRange = durationRange;
        TmfTimeRange timeRange = this.fCurrentTimeRange;
        this.computeDataAsync(timeRange, durationRange).thenAccept(data -> {
            List<ISegmentStoreDensityViewerDataListener> list = this.fListeners;
            synchronized (list) {
                if (this.fCurrentTimeRange.equals((Object)timeRange) && this.fCurrentDurationRange.equals(durationRange)) {
                    for (ISegmentStoreDensityViewerDataListener listener : this.fListeners) {
                        listener.selectedDataChanged((Iterable<? extends ISegment>)data);
                    }
                }
            }
        });
    }

    public void zoom(Range durationRange) {
        this.fCurrentDurationRange = durationRange;
        TmfTimeRange timeRange = this.fCurrentTimeRange;
        this.computeDataAsync(timeRange, durationRange).thenAccept(data -> {
            List<ISegmentStoreDensityViewerDataListener> list = this.fListeners;
            synchronized (list) {
                if (this.fCurrentTimeRange.equals((Object)timeRange) && this.fCurrentDurationRange.equals(durationRange)) {
                    this.applyData((SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>)data);
                }
            }
        });
    }

    private CompletableFuture< @Nullable SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>> computeDataAsync(TmfTimeRange timeRange, Range durationRange) {
        return CompletableFuture.supplyAsync(() -> this.computeData(timeRange, durationRange));
    }

    private  @Nullable SegmentStoreContentProvider.SegmentStoreWithRange<ISegment> computeData(TmfTimeRange timeRange, Range durationRange) {
        ISegmentStoreProvider segmentProvider = this.fSegmentStoreProvider;
        if (segmentProvider == null) {
            return null;
        }
        ISegmentStore segStore = segmentProvider.getSegmentStore();
        if (segStore == null) {
            return null;
        }
        if (durationRange.lower > Double.MIN_VALUE || durationRange.upper < Double.MAX_VALUE) {
            Predicate<ISegment> predicate = segment -> (double)segment.getLength() >= range.lower && (double)segment.getLength() <= range.upper;
            return new SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>(segStore, timeRange, predicate);
        }
        return new SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>(segStore, timeRange);
    }

    private void applyData( @Nullable SegmentStoreContentProvider.SegmentStoreWithRange<ISegment> data) {
        if (data != null) {
            data.setComparator(SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
            Display.getDefault().asyncExec(() -> this.updateDisplay(data));
            for (ISegmentStoreDensityViewerDataListener l : this.fListeners) {
                l.viewDataChanged(data);
            }
        }
    }

    @VisibleForTesting
    public void setSegmentProvider(@Nullable ISegmentStoreProvider ssp) {
        this.fSegmentStoreProvider = ssp;
    }

    @TmfSignalHandler
    public void windowRangeUpdated(@Nullable TmfWindowRangeUpdatedSignal signal) {
        if (signal == null) {
            return;
        }
        ITmfTrace trace = AbstractSegmentStoreDensityViewer.getTrace();
        if (trace == null) {
            return;
        }
        this.fSegmentStoreProvider = this.getSegmentStoreProvider(trace);
        this.fCurrentTimeRange = (TmfTimeRange)NonNullUtils.checkNotNull((Object)signal.getCurrentRange());
        this.updateWithRange(this.fCurrentTimeRange);
    }

    @VisibleForTesting
    public void updateWithRange(TmfTimeRange timeRange) {
        this.fCurrentTimeRange = timeRange;
        Range durationRange = this.fCurrentDurationRange = new Range(Double.MIN_VALUE, Double.MAX_VALUE);
        this.computeDataAsync(timeRange, durationRange).thenAccept(data -> {
            List<ISegmentStoreDensityViewerDataListener> list = this.fListeners;
            synchronized (list) {
                if (this.fCurrentTimeRange.equals((Object)timeRange) && this.fCurrentDurationRange.equals(durationRange)) {
                    this.applyData((SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>)data);
                }
            }
        });
    }

    public void refresh() {
        this.fChart.redraw();
    }

    public void dispose() {
        if (!this.fChart.isDisposed()) {
            this.fChart.dispose();
        }
    }

    private void internalDispose() {
        if (this.fSegmentStoreProvider != null && this.fListener != null) {
            this.fSegmentStoreProvider.removeListener(this.fListener);
        }
        this.fDragZoomProvider.deregister();
        this.fTooltipProvider.deregister();
        this.fDragProvider.deregister();
        super.dispose();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = signal.getTrace();
        this.loadTrace(AbstractSegmentStoreDensityViewer.getTrace());
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (this.fTrace != signal.getTrace()) {
            this.fTrace = signal.getTrace();
            this.loadTrace(AbstractSegmentStoreDensityViewer.getTrace());
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        this.fTrace = null;
        this.clearContent();
    }

    protected void loadTrace(@Nullable ITmfTrace trace) {
        ISegmentStoreProvider provider;
        TmfTimeRange windowRange;
        this.clearContent();
        this.fTrace = trace;
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        this.fCurrentTimeRange = windowRange = ctx.getWindowRange();
        if (trace != null && (provider = (this.fSegmentStoreProvider = this.getSegmentStoreProvider(trace))) != null) {
            this.fListener = (segmentProvider, data) -> this.updateWithRange(windowRange);
            provider.addListener(this.fListener);
            if (provider instanceof IAnalysisModule) {
                ((IAnalysisModule)provider).schedule();
            }
        }
        this.zoom(new Range(0.0, 9.223372036854776E18));
    }

    private void clearContent() {
        Chart chart = this.fChart;
        if (!chart.isDisposed()) {
            ISeriesSet set = chart.getSeriesSet();
            ISeries[] series = set.getSeries();
            int i = 0;
            while (i < series.length) {
                set.deleteSeries(series[i].getId());
                ++i;
            }
            IAxis[] iAxisArray = chart.getAxisSet().getAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                axis.setRange(new Range(0.0, 1.0));
                ++n2;
            }
            chart.redraw();
        }
    }

    public synchronized void setNbPoints(int nbPoints) {
        if (nbPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative");
        }
        this.fOverrideNbPoints = nbPoints;
        this.updateWithRange(this.fCurrentTimeRange);
    }

    public void addDataListener(ISegmentStoreDensityViewerDataListener dataListener) {
        this.fListeners.add(dataListener);
    }

    public void removeDataListener(ISegmentStoreDensityViewerDataListener dataListener) {
        this.fListeners.remove(dataListener);
    }
}

