/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests;

import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests.ControlViewSwtBotUtil;
import org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests.ControlViewTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ControlViewExcludeEventsTest
extends ControlViewTest {
    private static final String TEST_STREAM = "CreateSessionTestLTTng2_8.cfg";
    private static final String CREATE_SESSION_UST_EXCLUDE_SCENARIO_NAME = "ExcludeEvent";
    private static final String SESSION_NAME = "mysession";
    private static final String EXCLUDE_EXPRESSION = "foo";
    private static final String PROPERTIES_VIEW = "Properties";
    private static final String EXCLUDE_TREE_ITEM = "Exclude";

    @Override
    protected String getTestStream() {
        return TEST_STREAM;
    }

    @Override
    protected String getSessionName() {
        return SESSION_NAME;
    }

    @Override
    @Test
    public void testTraceSessionTree() {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        this.testConnectToNode();
        this.fProxy.setScenario(CREATE_SESSION_UST_EXCLUDE_SCENARIO_NAME);
        this.testCreateSession();
        this.testEnableUstEventExclude();
        this.testStartStopTracing(TraceSessionState.ACTIVE);
        this.testStartStopTracing(TraceSessionState.INACTIVE);
        this.testPropertiesEventExclude();
        this.testDestroySession();
        this.testDisconnectFromNode();
    }

    protected void testEnableUstEventExclude() {
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        sessionItem.select();
        SWTBotMenu menuBot = sessionItem.contextMenu("Enable Event (default channel)...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Enable Events").activate();
        shell.bot().radioInGroup("UST", "Domain").click();
        SWTBotTree tracepointsTree = shell.bot().treeInGroup("Tracepoint Events");
        SWTBotTreeItem treeItem = tracepointsTree.getTreeItem("All");
        treeItem.check();
        shell.bot().checkBoxInGroup("Select", "Exclude Events").click();
        SWTBotText excludeText = shell.bot().textInGroup("Exclude Events");
        excludeText.setText(EXCLUDE_EXPRESSION);
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)"UST global", (SWTBotTreeItem)sessionItem));
        SWTBotTreeItem ustGlobalDomainItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "UST global"});
        Assert.assertEquals((Object)"UST global", (Object)ustGlobalDomainItem.getText());
        SWTBotTreeItem channelItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "UST global", "channel0"});
        Assert.assertEquals((Object)"channel0", (Object)channelItem.getText());
        SWTBotTreeItem eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "UST global", "channel0", "*"});
        Assert.assertEquals((Object)"*", (Object)eventItem.getText());
        ITraceControlComponent comp = ControlViewSwtBotUtil.getComponent((ITraceControlComponent)this.fNode, "Sessions", this.getSessionName(), "UST global", "channel0", "*");
        Assert.assertNotNull((Object)comp);
        Assert.assertTrue((boolean)(comp instanceof TraceEventComponent));
        TraceEventComponent event = (TraceEventComponent)comp;
        Assert.assertEquals((Object)EXCLUDE_EXPRESSION, (Object)event.getExcludedEvents());
    }

    protected void testPropertiesEventExclude() {
        SWTBotUtils.openView((String)"org.eclipse.ui.views.PropertySheet");
        fBot.viewById("org.eclipse.linuxtools.internal.lttng2.ui.views.control").show();
        SWTBotTreeItem eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "UST global", "channel0", "*"});
        eventItem.select();
        SWTBotView propertiesViewBot = fBot.viewByTitle(PROPERTIES_VIEW);
        propertiesViewBot.show();
        SWTBotTree propertiesViewTree = propertiesViewBot.bot().tree();
        SWTBotTreeItem excludeTreeItem = propertiesViewTree.getTreeItem(EXCLUDE_TREE_ITEM);
        String excludeExpression = excludeTreeItem.cell(1);
        Assert.assertEquals((Object)EXCLUDE_EXPRESSION, (Object)excludeExpression);
        SWTBotUtils.closeView((String)PROPERTIES_VIEW, (SWTWorkbenchBot)fBot);
    }
}

