/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.tracetype.preferences;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TraceTypePreferencePageTest {
    private static final @NonNull String FILTER = "<ROOT><FILTER name=\"test\"><TRACETYPE name=\"Custom XML : testxmlextension\" type=\"custom.xml.trace:Custom XML:testxmlextension\"><MATCHES eventaspect=\"Message\" not=\"false\" regex=\"msg\" tracetypeid=\"custom.xml.trace:Custom XML:testxmlextension\"/></TRACETYPE></FILTER></ROOT>";
    private static final @NonNull String CHECK_SELECTED = "Check selected";
    private static final @NonNull String CHECK_ALL = "Check all";
    private static final @NonNull String UNCHECK_SELECTED = "Uncheck selected";
    private static final @NonNull String UNCHECK_ALL = "Uncheck all";
    private static final Logger fLogger = Logger.getRootLogger();
    private static final String TRACE_PATH = "testfiles/syslog_collapse";
    protected static final String KERNEL_TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    protected static final String KERNEL_PERSPECTIVE_ID = "org.eclipse.linuxtools.lttng2.kernel.ui.perspective";
    protected static final String TRACE_PROJECT_NAME = "test";
    private static SWTWorkbenchBot fBot;

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.createProject(TRACE_PROJECT_NAME);
        WaitUtils.waitForJobs();
        TraceTypePreferencePageTest.setUpTrace();
    }

    private static void setUpTrace() {
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TRACE_PATH), null);
        try {
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            File testFile = new File(uri);
            SWTBotUtils.openTrace(TRACE_PROJECT_NAME, testFile.getAbsolutePath(), KERNEL_TRACE_TYPE);
            Assert.assertNotNull((Object)testFile);
            Assume.assumeTrue((boolean)testFile.exists());
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)"Failed to open the trace");
        }
    }

    @Before
    public void before() {
        TraceTypePreferencePageTest.setTraceTypePreferences(CHECK_ALL, new String[0]);
    }

    @AfterClass
    public static void afterClass() {
        TraceTypePreferencePageTest.setTraceTypePreferences(CHECK_ALL, new String[0]);
        SWTBotUtils.deleteProject(TRACE_PROJECT_NAME, fBot);
        fBot.closeAllEditors();
        fLogger.removeAllAppenders();
    }

    @Test
    public void testPreferencePage() {
        TraceTypePreferencePageTest.openTraceTypePreferences();
        SWTBot bot = fBot.activeShell().bot();
        SWTBotTree treeBot = bot.tree(1);
        bot.button(CHECK_ALL).click();
        int defaultCount = SWTBotUtils.getTreeCheckedItemCount(treeBot);
        bot.button(UNCHECK_ALL).click();
        int checked = SWTBotUtils.getTreeCheckedItemCount(treeBot);
        Assert.assertEquals((long)0L, (long)checked);
        bot.button(CHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount(treeBot);
        Assert.assertEquals((String)CHECK_ALL, (long)defaultCount, (long)checked);
        treeBot.getTreeItem("Custom XML").select();
        bot.button(UNCHECK_ALL).click();
        bot.button(CHECK_SELECTED).click();
        checked = SWTBotUtils.getTreeCheckedItemCount(treeBot);
        Assert.assertEquals((String)CHECK_SELECTED, (long)2L, (long)checked);
        bot.button(CHECK_ALL).click();
        bot.button(UNCHECK_SELECTED).click();
        checked = SWTBotUtils.getTreeCheckedItemCount(treeBot);
        Assert.assertEquals((String)UNCHECK_SELECTED, (long)(defaultCount - 2), (long)checked);
        bot.button(UNCHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount(treeBot);
        Assert.assertEquals((long)0L, (long)checked);
        bot.text(1).setText("Custom XML");
        SWTBotUtils.waitUntil(tree -> tree.visibleRowCount() == 2, treeBot, "Visible row count: Default expected 2, but actual value is " + treeBot.visibleRowCount());
        Assert.assertEquals((String)"Filtered no checked", (long)0L, (long)checked);
        bot.button(CHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount(treeBot);
        Assert.assertEquals((String)"Filtered check all", (long)2L, (long)checked);
        bot.text(1).setText("");
        SWTBotUtils.waitUntil(tree -> tree.visibleRowCount() == defaultCount, treeBot, "Visible row count: Default expected " + defaultCount + ", but actual value is " + treeBot.visibleRowCount());
        bot.button(CHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount(treeBot);
        Assert.assertEquals((String)"Filtered removed all check", (long)defaultCount, (long)checked);
        bot.button("Apply").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)fBot);
    }

    @Test
    public void testSelectTraceType() {
        List<String> menuItems = TraceTypePreferencePageTest.getSelectTraceTypeMenuItems();
        List<String> categories = Arrays.asList("Common Trace Format", "Custom Text", "Custom XML", "Test trace", "", "Manage Custom Parsers...");
        Assert.assertEquals((String)"Test all categories enabled", categories, menuItems);
        TraceTypePreferencePageTest.setTraceTypePreferences(UNCHECK_ALL, "Custom Text");
        menuItems = TraceTypePreferencePageTest.getSelectTraceTypeMenuItems();
        categories = Arrays.asList("Custom Text", "Test trace", "", "Manage Custom Parsers...");
        Assert.assertEquals((String)"Test 1 category enabled", categories, menuItems);
        TraceTypePreferencePageTest.setTraceTypePreferences(CHECK_ALL, new String[0]);
    }

    @Test
    public void testImportTraceTypeOptions() {
        int defaultCount = TmfTraceType.getAvailableTraceTypes().length;
        TraceTypePreferencePageTest.setTraceTypePreferences(UNCHECK_ALL, "Custom Text", "testtxtextension");
        Object[] traceTypeComboItems = TraceTypePreferencePageTest.getTraceTypeComboItems();
        Object[] availableTraceTypes = new String[]{"<Automatic Detection>", "Custom Text : testtxtextension"};
        Assert.assertArrayEquals((String)"Test one trace type enabled", (Object[])availableTraceTypes, (Object[])traceTypeComboItems);
        TraceTypePreferencePageTest.setTraceTypePreferences(CHECK_ALL, new String[0]);
        traceTypeComboItems = TraceTypePreferencePageTest.getTraceTypeComboItems();
        Assert.assertEquals((String)"Test all trace type enabled", (long)(defaultCount + 1), (long)traceTypeComboItems.length);
    }

    @Test
    public void testFiltersView() {
        int defaultCount = TmfTraceType.getAvailableTraceTypes().length;
        SWTBotUtils.openView("org.eclipse.linuxtools.tmf.ui.views.filter");
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.filter");
        TraceTypePreferencePageTest.importFilter(viewBot);
        SWTBot bot = viewBot.bot();
        SWTBotTree tree = bot.tree(0);
        SWTBotTreeItem item = tree.expandNode(new String[]{"FILTER test", "WITH TRACETYPE Custom XML : testxmlextension"});
        item.select();
        SWTBotCombo comboBox = bot.comboBox(0);
        Assert.assertEquals((String)"Combo: number of trace types", (long)defaultCount, (long)comboBox.itemCount());
        TraceTypePreferencePageTest.setTraceTypePreferences(UNCHECK_ALL, "Custom XML", "testxmlextension");
        item = tree.expandNode(new String[]{"FILTER test"});
        item.select();
        item = tree.expandNode(new String[]{"FILTER test", "WITH TRACETYPE Custom XML : testxmlextension"});
        item.select();
        comboBox = bot.comboBox(0);
        Assert.assertEquals((String)"Combo: number of trace types", (long)1L, (long)comboBox.itemCount());
        TraceTypePreferencePageTest.setTraceTypePreferences(UNCHECK_ALL, "Custom Text", "testtxtextension");
        item = tree.expandNode(new String[]{"FILTER test"});
        item.select();
        item = tree.expandNode(new String[]{"FILTER test", "WITH TRACETYPE Custom XML : testxmlextension"});
        item.select();
        comboBox = bot.comboBox(0);
        Assert.assertEquals((String)"Combo: number of trace types", (long)2L, (long)comboBox.itemCount());
    }

    private static void importFilter(SWTBotView viewBot) {
        try {
            File tempFile = File.createTempFile(TRACE_PROJECT_NAME, ".xml");
            FileWriter fw = new FileWriter(tempFile);
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter bw = new BufferedWriter(fw);){
                bw.write(FILTER);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            TmfFileDialogFactory.setOverrideFiles((String[])new String[]{tempFile.getAbsolutePath()});
        }
        catch (IOException e) {
            Assert.fail((String)"Failed to add a filter");
        }
        viewBot.toolbarButton("Import filters").click();
        SWTBotUtils.waitUntil(tree -> tree.rowCount() > 0, viewBot.bot().tree(0), "Failed to import test filter");
    }

    private static void setTraceTypePreferences(@NonNull String button, String ... pathToCheck) {
        TraceTypePreferencePageTest.openTraceTypePreferences();
        SWTBot bot = fBot.activeShell().bot();
        SWTBotTree treeBot = bot.tree(1);
        if (!button.isEmpty()) {
            bot.button(button).click();
        }
        if (pathToCheck.length > 0) {
            SWTBotTreeItem treeItem = treeBot.expandNode(pathToCheck);
            Assert.assertNotNull((String)"Tree item not null", (Object)treeItem);
            treeItem.select();
            bot.button(CHECK_SELECTED).click();
        }
        bot.button("Apply").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)fBot);
    }

    private static List<String> getSelectTraceTypeMenuItems() {
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder(fBot, TRACE_PROJECT_NAME);
        tracesFolder.expand();
        SWTBotTreeItem trace = tracesFolder.getNode("syslog_collapse");
        trace.select();
        List menuItems = trace.contextMenu().menu(new String[]{"Select Trace Type..."}).menuItems();
        return menuItems;
    }

    private static void openTraceTypePreferences() {
        SWTBotShell preferencesShell = SWTBotUtils.openPreferences((SWTBot)fBot);
        SWTBot bot = preferencesShell.bot();
        SWTBotTree tree = bot.tree(0);
        SWTBotTreeItem treeNode = tree.getTreeItem("Tracing");
        treeNode.select();
        treeNode.expand();
        bot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable("Trace Types", treeNode));
        treeNode = treeNode.getNode("Trace Types");
        treeNode.select();
    }

    private static String[] getTraceTypeComboItems() {
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder(fBot, TRACE_PROJECT_NAME);
        SWTBotMenu menu = tracesFolder.contextMenu().menu(new String[]{"Import..."});
        menu.click();
        fBot.waitUntil(Conditions.shellIsActive((String)"Trace Import"));
        SWTBot bot = fBot.activeShell().bot();
        SWTBotCombo combo = bot.comboBox(2);
        String[] items = combo.items();
        bot.button("Cancel").click();
        return items;
    }
}

