/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import com.google.common.collect.Multiset;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCLabel;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCanvas;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ImageHelper;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class FilterColorEditorTest {
    private static final int TIMESTAMP_COLUMN = 1;
    private static final int SOURCE_COLUMN = 2;
    private static final int MESSAGE_COLUMN = 6;
    private static final RGB GREEN = new RGB(0, 255, 0);
    private static final String HIGHLIGHT_COLOR_DEFINITION_ID = "org.eclipse.tracecompass.tmf.ui.color.eventtable.highlight";
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String COLUMN_TRACE = "syslog_collapse";
    private static final String COLUMN_TRACE_PATH = "testfiles/syslog_collapse";
    private static final String COLUMN_TRACE_TYPE = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static File fTestFile = null;
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;
    private SWTBotTable fTableBot;
    private static final int ROW = 8;
    private RGB fForeground;
    private RGB fBackground;
    private static RGB fHighlight;
    private static RGB EXPECTED_GREEN;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(COLUMN_TRACE_PATH), null);
        try {
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            fTestFile = new File(uri);
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
        Assume.assumeTrue((boolean)fTestFile.exists());
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("Welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        fHighlight = ImageHelper.adjustExpectedColor(colorRegistry.get(HIGHLIGHT_COLOR_DEFINITION_ID).getRGB());
        EXPECTED_GREEN = ImageHelper.adjustExpectedColor(GREEN);
    }

    @AfterClass
    public static void tearDown() {
        fLogger.removeAllAppenders();
    }

    @Before
    public void setup() {
        SWTBotUtils.createProject(TRACE_PROJECT_NAME);
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, fTestFile.getAbsolutePath(), COLUMN_TRACE_TYPE);
        SWTBotEditor editorBot = SWTBotUtils.activateEditor(fBot, fTestFile.getName());
        this.fTableBot = editorBot.bot().table();
        this.fBackground = this.fTableBot.backgroundColor().getRGB();
        this.fForeground = this.fTableBot.foregroundColor().getRGB();
        SWTBotUtils.maximize(editorBot.getReference(), this.fTableBot);
    }

    @After
    public void cleanup() {
        SWTBotUtils.deleteProject(TRACE_PROJECT_NAME, fBot);
        WaitUtils.waitForJobs();
    }

    @Test
    public void testHighlight() {
        Rectangle cellBounds = SWTBotUtils.getCellBounds((Table)this.fTableBot.widget, 8, 2);
        ImageHelper before = ImageHelper.grabImage(cellBounds);
        Multiset<RGB> colorBefore = before.getHistogram();
        this.fTableBot.click(0, 2);
        fBot.text().typeText("HostF\n", 100);
        this.fTableBot.select(new int[]{7});
        Multiset<RGB> colorAfter = ImageHelper.waitForNewImage(cellBounds, before).getHistogram();
        Assert.assertTrue((boolean)colorBefore.contains((Object)this.fBackground));
        Assert.assertTrue((boolean)colorBefore.contains((Object)this.fForeground));
        Assert.assertFalse((boolean)colorBefore.contains((Object)fHighlight));
        Assert.assertTrue((boolean)colorAfter.contains((Object)this.fBackground));
        Assert.assertTrue((boolean)colorAfter.contains((Object)this.fForeground));
        Assert.assertTrue((boolean)colorAfter.contains((Object)fHighlight));
        Assert.assertTrue((colorAfter.count((Object)this.fBackground) < colorBefore.count((Object)this.fBackground) ? 1 : 0) != 0);
        Assert.assertTrue((colorAfter.count((Object)fHighlight) > colorBefore.count((Object)fHighlight) ? 1 : 0) != 0);
    }

    @Test
    public void testMultiHighlightMessage() {
        Rectangle cellBounds = SWTBotUtils.getCellBounds((Table)this.fTableBot.widget, 8, 6);
        ImageHelper before = ImageHelper.grabImage(cellBounds);
        this.fTableBot.click(0, 6);
        fBot.text().typeText("e\n", 100);
        this.fTableBot.select(new int[]{7});
        ImageHelper after = ImageHelper.waitForNewImage(cellBounds, before);
        Multiset<RGB> colorBefore = before.getHistogram();
        Multiset<RGB> colorAfter = after.getHistogram();
        Assert.assertTrue((boolean)colorBefore.contains((Object)this.fBackground));
        Assert.assertTrue((boolean)colorBefore.contains((Object)this.fForeground));
        Assert.assertFalse((boolean)colorBefore.contains((Object)fHighlight));
        Assert.assertTrue((boolean)colorAfter.contains((Object)this.fBackground));
        Assert.assertTrue((boolean)colorAfter.contains((Object)this.fForeground));
        Assert.assertTrue((boolean)colorAfter.contains((Object)fHighlight));
        int start = -1;
        ArrayList<Point> intervals = new ArrayList<Point>();
        List<RGB> pixelRow = after.getPixelRow(2);
        int i = 1;
        while (i < pixelRow.size()) {
            RGB prevPixel = pixelRow.get(i - 1);
            RGB pixel = pixelRow.get(i);
            if (prevPixel.equals((Object)this.fBackground) && pixel.equals((Object)fHighlight)) {
                start = i;
            }
            if (prevPixel.equals((Object)fHighlight) && pixel.equals((Object)this.fBackground)) {
                int end = i;
                if (start == -1) {
                    Assert.fail();
                }
                intervals.add(new Point(start, end));
            }
            ++i;
        }
        Assert.assertEquals((long)2L, (long)intervals.size());
    }

    @Test
    public void testSwitchToFilter() {
        Rectangle cellBounds = SWTBotUtils.getCellBounds((Table)this.fTableBot.widget, 8, 1);
        ImageHelper before = ImageHelper.grabImage(cellBounds);
        this.fTableBot.click(0, 1);
        fBot.text().typeText("00\n", 100);
        this.fTableBot.select(new int[]{7});
        ImageHelper afterSearch = ImageHelper.waitForNewImage(cellBounds, before);
        this.fTableBot.click(0, 0);
        fBot.waitUntil(ConditionHelpers.isTableCellFilled(this.fTableBot, "<srch>", 0, 1));
        fBot.waitUntil(ConditionHelpers.isTableCellFilled(this.fTableBot, "22/22", 1, 1));
        cellBounds = SWTBotUtils.getCellBounds((Table)this.fTableBot.widget, 8, 1);
        ImageHelper afterFilter = ImageHelper.grabImage(cellBounds);
        this.fTableBot.pressShortcut(new KeyStroke[]{Keystrokes.DELETE});
        ImageHelper afterClear = ImageHelper.waitForNewImage(cellBounds, afterFilter);
        List<RGB> beforeLine = before.getPixelRow(2);
        List<RGB> afterSearchLine = afterSearch.getPixelRow(2);
        List<RGB> afterFilterLine = afterFilter.getPixelRow(2);
        List<RGB> afterClearLine = afterClear.getPixelRow(2);
        Assert.assertEquals((long)beforeLine.size(), (long)afterSearchLine.size());
        Assert.assertEquals((long)beforeLine.size(), (long)afterFilterLine.size());
        Assert.assertEquals((long)beforeLine.size(), (long)afterClearLine.size());
        int i = 0;
        while (i < beforeLine.size()) {
            RGB beforePixel = beforeLine.get(i);
            RGB afterSearchPixel = afterSearchLine.get(i);
            RGB afterFilterPixel = afterFilterLine.get(i);
            RGB afterClearPixel = afterClearLine.get(i);
            Assert.assertEquals((Object)afterSearchPixel, (Object)afterFilterPixel);
            Assert.assertEquals((Object)beforePixel, (Object)afterClearPixel);
            if (!afterSearchPixel.equals((Object)fHighlight)) {
                Assert.assertEquals((Object)beforePixel, (Object)afterSearchPixel);
            } else {
                Assert.assertNotEquals((Object)fHighlight, (Object)beforePixel);
            }
            ++i;
        }
        Assert.assertEquals(afterSearchLine, afterFilterLine);
        Assert.assertEquals(beforeLine, afterClearLine);
        Assert.assertNotEquals(afterSearchLine, beforeLine);
    }

    @Test
    public void testPreference() {
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        colorRegistry.put(HIGHLIGHT_COLOR_DEFINITION_ID, GREEN);
        Rectangle cellBounds = SWTBotUtils.getCellBounds((Table)this.fTableBot.widget, 8, 2);
        ImageHelper before = ImageHelper.grabImage(cellBounds);
        Multiset<RGB> colorBefore = before.getHistogram();
        this.fTableBot.click(0, 2);
        fBot.text().typeText("HostF\n", 100);
        this.fTableBot.select(new int[]{7});
        Multiset<RGB> colorAfter = ImageHelper.waitForNewImage(cellBounds, before).getHistogram();
        Assert.assertTrue((boolean)colorBefore.contains((Object)this.fBackground));
        Assert.assertTrue((boolean)colorBefore.contains((Object)this.fForeground));
        Assert.assertFalse((boolean)colorBefore.contains((Object)fHighlight));
        Assert.assertFalse((boolean)colorBefore.contains((Object)EXPECTED_GREEN));
        Assert.assertTrue((boolean)colorAfter.contains((Object)this.fBackground));
        Assert.assertTrue((boolean)colorAfter.contains((Object)this.fForeground));
        Assert.assertFalse((boolean)colorAfter.contains((Object)fHighlight));
        Assert.assertTrue((boolean)colorAfter.contains((Object)EXPECTED_GREEN));
        Assert.assertTrue((colorAfter.count((Object)this.fBackground) < colorBefore.count((Object)this.fBackground) ? 1 : 0) != 0);
        Assert.assertTrue((colorAfter.count((Object)EXPECTED_GREEN) > colorBefore.count((Object)EXPECTED_GREEN) ? 1 : 0) != 0);
        colorRegistry.put(HIGHLIGHT_COLOR_DEFINITION_ID, fHighlight);
    }

    @Test
    public void testHeaderBar() {
        this.fTableBot.click(0, 1);
        fBot.text().typeText("2");
        fBot.text().pressShortcut(new KeyStroke[]{Keystrokes.CR});
        this.fTableBot.click(0, 6);
        fBot.text().typeText("F");
        fBot.text().pressShortcut(new KeyStroke[]{Keystrokes.CTRL, Keystrokes.CR});
        fBot.waitUntil(ConditionHelpers.isTableCellFilled(this.fTableBot, "2/22", 1, 1));
        fBot.waitUntil(ConditionHelpers.isTableCellFilled(this.fTableBot, "Message F", 3, 6));
        fBot.clabel("Timestamp matches \"2\"");
        fBot.clabel("Message matches \"F\"");
        this.waitForHighlightState(3, 1, true);
        this.waitForHighlightState(3, 6, true);
        this.fTableBot.pressShortcut(new KeyStroke[]{Keystrokes.DELETE});
        this.waitForHighlightState(3, 1, false);
        this.waitForHighlightState(3, 6, false);
        SWTBotCLabel filterCLabel = fBot.clabel("Message matches \"F\"");
        SWTBotCanvas filterCanvas = new SWTBotCanvas((Canvas)filterCLabel.widget);
        filterCanvas.click();
        this.waitForHighlightState(3, 1, false);
        this.waitForHighlightState(3, 6, true);
        Rectangle imageBounds = filterCLabel.image().getBounds();
        filterCanvas.click(((CLabel)filterCLabel.widget).getLeftMargin() + imageBounds.width / 2, ((CLabel)filterCLabel.widget).getTopMargin() + imageBounds.height / 2);
        fBot.waitUntil(ConditionHelpers.isTableCellFilled(this.fTableBot, "5/22", 1, 1));
    }

    private void waitForHighlightState(final int row, final int column, final boolean highlight) {
        fBot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                Rectangle cellBounds = SWTBotUtils.getCellBounds((Table)((FilterColorEditorTest)FilterColorEditorTest.this).fTableBot.widget, row, column);
                ImageHelper imageHelper = ImageHelper.grabImage(cellBounds);
                return imageHelper.getHistogram().contains((Object)fHighlight) == highlight;
            }

            public String getFailureMessage() {
                return String.format("Cell (%d, %d) did not have highlight state: %s", row, column, Boolean.toString(highlight));
            }
        });
    }
}

