/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.project.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfNavigatorContentProvider;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelPreferences;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TmfProjectRegistryTest {
    private static final String SOME_PROJECT_NAME = "SomeProject";
    private static final String NEW_PROJECT_NAME = "SomeProject2";
    private static final String TRACING_PROJECT_NAME = "SomeTracingProject";
    private static final String SOME_OTHER_PROJECT_NAME = "SomeOtherProject";
    private static final String TRACES_LABEL_TEXT = "Traces [0]";
    private static final String EXPERIMENTS_LABEL_TEXT = "Experiments [0]";
    private static final String TRACING_NATURE_TRACES_PATH = new Path("Traces").toOSString();
    private static final String TRACING_NATURE_EXPERIMENTS_PATH = new Path("Experiments").toOSString();
    private static final String TRACING_NATURE_SUPPL_PATH = new Path(".tracing").toOSString();
    private static final String HIDDEN_TRACECOMPASS_DIRECTORY = ".tracecompass";
    private static final String SHADOW_PROJECT_NAME = ".tracecompass-SomeProject";
    private static final String NEW_SHADOW_PROJECT_NAME = ".tracecompass-SomeProject2";
    private static IWorkspaceRoot fWorkspaceRoot;
    private static IProject fSomeProject;
    private static IProject fShadowSomeProject;
    private static IProject fSomeOtherProject;

    @BeforeClass
    public static void init() throws CoreException {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        fWorkspaceRoot = workspace.getRoot();
        fSomeProject = fWorkspaceRoot.getProject(SOME_PROJECT_NAME);
        fSomeProject.create((IProgressMonitor)progressMonitor);
        fSomeProject.open((IProgressMonitor)progressMonitor);
        IProjectDescription description = fSomeProject.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.cdt.core.cnature"});
        fSomeProject.setDescription(description, null);
        fSomeProject.open((IProgressMonitor)progressMonitor);
        fShadowSomeProject = fWorkspaceRoot.getProject(SHADOW_PROJECT_NAME);
        fSomeOtherProject = fWorkspaceRoot.getProject(SOME_OTHER_PROJECT_NAME);
        fSomeOtherProject.create((IProgressMonitor)progressMonitor);
        fSomeOtherProject.open((IProgressMonitor)progressMonitor);
    }

    @AfterClass
    public static void tearDown() throws CoreException {
        if (fSomeProject != null) {
            fSomeProject.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (fSomeOtherProject != null) {
            fSomeOtherProject.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void testAddingTracingNature() throws Exception {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IProjectDescription desc = fSomeProject.getDescription();
        Assert.assertFalse((boolean)desc.hasNature("org.eclipse.linuxtools.tmf.project.nature"));
        TmfProjectRegistry.addTracingNature((IProject)fSomeProject, (IProgressMonitor)progressMonitor);
        desc = fSomeProject.getDescription();
        Assert.assertTrue((boolean)desc.hasNature("org.eclipse.linuxtools.tmf.project.nature"));
        WaitUtils.waitUntil(project -> project.exists(), fShadowSomeProject, "Shadow project did not get created");
        IFolder hiddenTcFile = fSomeProject.getFolder(HIDDEN_TRACECOMPASS_DIRECTORY);
        Assert.assertTrue((boolean)hiddenTcFile.exists());
        TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)fSomeProject, (boolean)true);
        TmfProjectElement projectElement2 = TmfProjectRegistry.getProject((IProject)fShadowSomeProject, (boolean)true);
        Assert.assertEquals((Object)projectElement2, (Object)projectElement);
        Assert.assertEquals((Object)TmfProjectModelPreferences.getProjectModelLabel(), (Object)projectElement.getLabelText());
        Assert.assertEquals((Object)TmfProjectModelPreferences.getProjectModelIcon(), (Object)projectElement.getIcon());
        IFolder supplFolder = projectElement.getSupplementaryFolder();
        IPath path = supplFolder.getProjectRelativePath();
        Assert.assertEquals((Object)TRACING_NATURE_SUPPL_PATH, (Object)path.toOSString());
        TmfNavigatorContentProvider contentProvider = new TmfNavigatorContentProvider();
        Assert.assertEquals((Object)fShadowSomeProject.getParent(), (Object)contentProvider.getParent((Object)fSomeProject));
        Assert.assertEquals((Object)fSomeProject, (Object)contentProvider.getParent((Object)projectElement));
        Object[] children = contentProvider.getChildren((Object)fSomeProject);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals((Object)projectElement, (Object)children[0]);
        fSomeProject.close((IProgressMonitor)progressMonitor);
        WaitUtils.waitUntil(project -> !project.exists(), fShadowSomeProject, "Shadow project did not get deleted");
        fSomeProject.open((IProgressMonitor)progressMonitor);
        WaitUtils.waitUntil(project -> project.isOpen(), fShadowSomeProject, "Shadow project did not get opened");
        TmfTraceFolder traceFolder = projectElement.getTracesFolder();
        Assert.assertNotNull((Object)traceFolder);
        String name = traceFolder.getLabelText();
        Assert.assertEquals((Object)TRACES_LABEL_TEXT, (Object)name);
        path = traceFolder.getResource().getProjectRelativePath();
        Assert.assertEquals((Object)TRACING_NATURE_TRACES_PATH, (Object)path.toOSString());
        IFile file = traceFolder.getResource().getFile("trace");
        File tmpFile = file.getLocation().toFile();
        tmpFile.createNewFile();
        traceFolder.getResource().refreshLocal(0, (IProgressMonitor)progressMonitor);
        traceFolder.refresh();
        Assert.assertEquals((Object)projectElement, (Object)contentProvider.getParent((Object)traceFolder));
        TmfExperimentFolder expFolder = projectElement.getExperimentsFolder();
        Assert.assertNotNull((Object)expFolder);
        name = expFolder.getLabelText();
        Assert.assertEquals((Object)EXPERIMENTS_LABEL_TEXT, (Object)name);
        path = expFolder.getResource().getProjectRelativePath();
        Assert.assertEquals((Object)TRACING_NATURE_EXPERIMENTS_PATH, (Object)path.toOSString());
        IFolder folder = expFolder.getResource().getFolder("exp");
        folder.create(true, true, (IProgressMonitor)progressMonitor);
        expFolder.getResource().refreshLocal(0, (IProgressMonitor)progressMonitor);
        expFolder.refresh();
        Assert.assertEquals((Object)projectElement, (Object)contentProvider.getParent((Object)expFolder));
        children = contentProvider.getChildren((Object)projectElement);
        Assert.assertEquals((long)2L, (long)children.length);
        ArrayList<Object> childrenList = new ArrayList<Object>();
        childrenList.addAll(Arrays.asList(children[0], children[1]));
        Assert.assertTrue((boolean)childrenList.contains(expFolder));
        Assert.assertTrue((boolean)childrenList.contains(traceFolder));
        traceFolder.getResource().delete(true, (IProgressMonitor)progressMonitor);
        expFolder.getResource().delete(true, (IProgressMonitor)progressMonitor);
        fSomeProject.refreshLocal(2, (IProgressMonitor)progressMonitor);
        projectElement.refresh();
        traceFolder = projectElement.getTracesFolder();
        Assert.assertNotNull((Object)traceFolder);
        Assert.assertFalse((boolean)traceFolder.getResource().exists());
        expFolder = projectElement.getExperimentsFolder();
        Assert.assertNotNull((Object)expFolder);
        Assert.assertFalse((boolean)expFolder.getResource().exists());
        TmfProjectRegistry.addTracingNature((IProject)fSomeProject, (IProgressMonitor)progressMonitor);
        projectElement.refresh();
        traceFolder = projectElement.getTracesFolder();
        Assert.assertNotNull((Object)traceFolder);
        Assert.assertTrue((boolean)traceFolder.getResource().exists());
        expFolder = projectElement.getExperimentsFolder();
        Assert.assertNotNull((Object)expFolder);
        Assert.assertTrue((boolean)expFolder.getResource().exists());
        fShadowSomeProject.close((IProgressMonitor)progressMonitor);
        children = contentProvider.getChildren((Object)fSomeProject);
        Assert.assertEquals((long)0L, (long)children.length);
        fShadowSomeProject.open((IProgressMonitor)progressMonitor);
        children = contentProvider.getChildren((Object)fSomeProject);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals((Object)projectElement, (Object)children[0]);
        fShadowSomeProject.delete(true, (IProgressMonitor)progressMonitor);
        children = contentProvider.getChildren((Object)fSomeProject);
        Assert.assertEquals((long)0L, (long)children.length);
        TmfProjectRegistry.addTracingNature((IProject)fSomeProject, (IProgressMonitor)progressMonitor);
        projectElement.refresh();
        Assert.assertEquals((Object)fShadowSomeProject.getParent(), (Object)contentProvider.getParent((Object)fSomeProject));
        Assert.assertEquals((Object)fSomeProject, (Object)contentProvider.getParent((Object)projectElement));
        children = contentProvider.getChildren((Object)fSomeProject);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals((Object)projectElement, (Object)children[0]);
        fSomeProject.move((IPath)new Path(NEW_PROJECT_NAME), true, (IProgressMonitor)progressMonitor);
        IProject shadowProject = fWorkspaceRoot.getProject(NEW_SHADOW_PROJECT_NAME);
        WaitUtils.waitUntil(project -> project.exists(), shadowProject, "Shadow project did get moved");
        IProject newProject = fWorkspaceRoot.getProject(NEW_PROJECT_NAME);
        newProject.delete(false, true, (IProgressMonitor)progressMonitor);
        shadowProject = fWorkspaceRoot.getProject(NEW_SHADOW_PROJECT_NAME);
        WaitUtils.waitUntil(project -> !project.exists(), shadowProject, "Shadow project did not get deleted");
    }

    @Test
    public void testAddingTracingNatureNotAllowed() throws Exception {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IProjectDescription desc = fSomeOtherProject.getDescription();
        Assert.assertFalse((boolean)desc.hasNature("org.eclipse.linuxtools.tmf.project.nature"));
        TmfProjectRegistry.addTracingNature((IProject)fSomeOtherProject, (IProgressMonitor)progressMonitor);
        desc = fSomeOtherProject.getDescription();
        Assert.assertFalse((boolean)desc.hasNature("org.eclipse.linuxtools.tmf.project.nature"));
        IFile hiddenTcFile = fSomeOtherProject.getFile(HIDDEN_TRACECOMPASS_DIRECTORY);
        Assert.assertFalse((boolean)hiddenTcFile.exists());
    }

    @Test
    public void testCreateTracingProject() throws Exception {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IProject project = TmfProjectRegistry.createProject((String)TRACING_PROJECT_NAME, null, (IProgressMonitor)progressMonitor);
        IProjectDescription desc = project.getDescription();
        Assert.assertTrue((boolean)desc.hasNature("org.eclipse.linuxtools.tmf.project.nature"));
        TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        IFolder supplFolder = projectElement.getSupplementaryFolder();
        IPath path = supplFolder.getProjectRelativePath();
        Assert.assertEquals((Object)TRACING_NATURE_SUPPL_PATH, (Object)path.toOSString());
        TmfNavigatorContentProvider contentProvider = new TmfNavigatorContentProvider();
        Assert.assertEquals((Object)project.getParent(), (Object)contentProvider.getParent((Object)project));
        Object[] children = contentProvider.getChildren((Object)project);
        Assert.assertEquals((long)2L, (long)children.length);
        ArrayList<Object> childrenList = new ArrayList<Object>();
        childrenList.addAll(Arrays.asList(children[0], children[1]));
        TmfTraceFolder traceFolder = projectElement.getTracesFolder();
        Assert.assertNotNull((Object)traceFolder);
        String name = traceFolder.getLabelText();
        Assert.assertEquals((Object)TRACES_LABEL_TEXT, (Object)name);
        path = traceFolder.getResource().getProjectRelativePath();
        Assert.assertEquals((Object)TRACING_NATURE_TRACES_PATH, (Object)path.toOSString());
        IFile file = traceFolder.getResource().getFile("trace");
        File tmpFile = file.getLocation().toFile();
        tmpFile.createNewFile();
        traceFolder.getResource().refreshLocal(0, (IProgressMonitor)progressMonitor);
        traceFolder.refresh();
        Assert.assertEquals((Object)project, (Object)contentProvider.getParent((Object)traceFolder));
        TmfExperimentFolder expFolder = projectElement.getExperimentsFolder();
        Assert.assertNotNull((Object)expFolder);
        name = expFolder.getLabelText();
        Assert.assertEquals((Object)EXPERIMENTS_LABEL_TEXT, (Object)name);
        path = expFolder.getResource().getProjectRelativePath();
        Assert.assertEquals((Object)TRACING_NATURE_EXPERIMENTS_PATH, (Object)path.toOSString());
        IFolder folder = expFolder.getResource().getFolder("exp");
        folder.create(true, true, (IProgressMonitor)progressMonitor);
        expFolder.getResource().refreshLocal(0, (IProgressMonitor)progressMonitor);
        expFolder.refresh();
        Assert.assertEquals((Object)project, (Object)contentProvider.getParent((Object)expFolder));
        Assert.assertTrue((boolean)childrenList.contains(expFolder));
        Assert.assertTrue((boolean)childrenList.contains(traceFolder));
        traceFolder.getResource().delete(true, (IProgressMonitor)progressMonitor);
        expFolder.getResource().delete(true, (IProgressMonitor)progressMonitor);
        projectElement.refresh();
        traceFolder = projectElement.getTracesFolder();
        Assert.assertNotNull((Object)traceFolder);
        Assert.assertFalse((boolean)traceFolder.getResource().exists());
        expFolder = projectElement.getExperimentsFolder();
        Assert.assertNotNull((Object)expFolder);
        Assert.assertFalse((boolean)expFolder.getResource().exists());
    }
}

