/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalCompoundStatementExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;

public class CPPASTCompoundStatementExpression
extends ASTNode
implements IGNUASTCompoundStatementExpression,
ICPPASTExpression {
    private IASTCompoundStatement fStatement;
    private ICPPEvaluation fEval;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTCompoundStatementExpression() {
    }

    public CPPASTCompoundStatementExpression(IASTCompoundStatement statement) {
        this.setCompoundStatement(statement);
    }

    @Override
    public CPPASTCompoundStatementExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTCompoundStatementExpression copy(IASTNode.CopyStyle style) {
        CPPASTCompoundStatementExpression copy = new CPPASTCompoundStatementExpression(this.fStatement == null ? null : this.fStatement.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTCompoundStatement getCompoundStatement() {
        return this.fStatement;
    }

    @Override
    public void setCompoundStatement(IASTCompoundStatement statement) {
        this.assertNotFrozen();
        this.fStatement = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(STATEMENT);
        }
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEval == null) {
            IASTStatement st;
            IASTStatement[] statements;
            if (this.fStatement != null && (statements = this.fStatement.getStatements()).length > 0 && (st = statements[statements.length - 1]) instanceof IASTExpressionStatement) {
                IASTExpressionStatement exprStmt = (IASTExpressionStatement)st;
                ICPPASTExpression expr = (ICPPASTExpression)exprStmt.getExpression();
                this.fEval = new EvalCompoundStatementExpression(expr.getEvaluation(), this);
            }
            if (this.fEval == null) {
                this.fEval = EvalFixed.INCOMPLETE;
            }
        }
        return this.fEval;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fStatement != null && !this.fStatement.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTCompoundStatementExpression.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getType(this);
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }
}

