/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathModule;
import org.eclipse.tracecompass.analysis.graph.core.dataprovider.CriticalPathEntry;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.CriticalPathLegend;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.CriticalPathPresentationProvider;
import org.eclipse.tracecompass.internal.analysis.graph.ui.criticalpath.view.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeLinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class CriticalPathView
extends BaseDataProviderTimeGraphView {
    public static final String ID = "org.eclipse.linuxtools.tmf.analysis.graph.ui.criticalpath.view.criticalpathview";
    private static final double NANOINV = 1.0E-8;
    private static final String COLUMN_PROCESS = Messages.getMessage(Messages.CriticalFlowView_columnProcess);
    private static final String COLUMN_ELAPSED = Messages.getMessage(Messages.CriticalFlowView_columnElapsed);
    private static final String COLUMN_PERCENT = Messages.getMessage(Messages.CriticalFlowView_columnPercent);
    private static final String[] COLUMN_NAMES = new String[]{COLUMN_PROCESS, COLUMN_ELAPSED, COLUMN_PERCENT};
    private static final String[] FILTER_COLUMN_NAMES = new String[]{COLUMN_PROCESS};

    public CriticalPathView() {
        super(ID, (TimeGraphPresentationProvider)new CriticalPathPresentationProvider(), "org.eclipse.tracecompass.analysis.graph.core.dataprovider.CriticalPathDataProvider");
        this.setTreeColumns(COLUMN_NAMES);
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setTreeLabelProvider(new CriticalPathTreeLabelProvider());
        this.setEntryComparator(new CriticalPathEntryComparator());
        this.setLegendProvider((shell, presentationProvider) -> {
            int n = new CriticalPathLegend(shell, presentationProvider).open();
        });
    }

    protected List<ITimeEvent> createTimeEvents(TimeGraphEntry entry, List<ITimeGraphState> values) {
        return Lists.transform(values, state -> this.createTimeEvent(entry, (ITimeGraphState)state));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected List<ILinkEvent> getLinkList(long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        @NonNull List traceEntries = this.getEntryList(this.getTrace());
        if (traceEntries == null) {
            return Collections.emptyList();
        }
        ArrayList<@NonNull ILinkEvent> linkList = new ArrayList<ILinkEvent>();
        TimeQueryFilter queryFilter = new TimeQueryFilter(startTime, endTime, 2);
        HashBasedTable table = HashBasedTable.create();
        for (BaseDataProviderTimeGraphView.TraceEntry traceEntry : Iterables.filter((Iterable)traceEntries, BaseDataProviderTimeGraphView.TraceEntry.class)) {
            for (TimeGraphEntry entry : Utils.flatten((TimeGraphEntry)traceEntry)) {
                table.put((Object)traceEntry.getProvider(), (Object)entry.getModel().getId(), (Object)entry);
            }
        }
        for (Map.Entry entry : table.rowMap().entrySet()) {
            ITimeGraphDataProvider provider = (ITimeGraphDataProvider)entry.getKey();
            Map map = (Map)entry.getValue();
            TmfModelResponse response = provider.fetchArrows(queryFilter, monitor);
            List model = (List)response.getModel();
            if (monitor.isCanceled()) {
                return null;
            }
            if (model == null) continue;
            for (ITimeGraphArrow arrow : model) {
                ITimeGraphEntry src = (ITimeGraphEntry)map.get(arrow.getSourceId());
                ITimeGraphEntry dst = (ITimeGraphEntry)map.get(arrow.getDestinationId());
                if (src == null || dst == null) continue;
                linkList.add((ILinkEvent)new TimeLinkEvent(src, dst, arrow.getStartTime(), arrow.getDuration(), arrow.getValue()));
            }
        }
        return linkList;
    }

    @TmfSignalHandler
    public void analysisStarted(TmfStartAnalysisSignal signal) {
        IAnalysisModule analysis = signal.getAnalysisModule();
        if (analysis instanceof CriticalPathModule) {
            CriticalPathModule criticalPath = (CriticalPathModule)analysis;
            Collection traces = TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)this.getTrace());
            if (traces.contains(criticalPath.getTrace())) {
                this.rebuild();
            } else {
                traces.forEach(arg_0 -> ((CriticalPathView)this).resetView(arg_0));
            }
        }
    }

    protected void fillLocalToolBar(@Nullable IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        if (manager == null) {
            return;
        }
        Action followArrowBwdAction = this.getTimeGraphViewer().getFollowArrowBwdAction();
        followArrowBwdAction.setText(Messages.CriticalPathView_followArrowBwdText);
        followArrowBwdAction.setToolTipText(Messages.CriticalPathView_followArrowBwdText);
        manager.appendToGroup("additions", (IAction)followArrowBwdAction);
        Action followArrowFwdAction = this.getTimeGraphViewer().getFollowArrowFwdAction();
        followArrowFwdAction.setText(Messages.CriticalPathView_followArrowFwdText);
        followArrowFwdAction.setToolTipText(Messages.CriticalPathView_followArrowFwdText);
        manager.appendToGroup("additions", (IAction)followArrowFwdAction);
    }

    protected Iterable<ITmfTrace> getTracesToBuild(@Nullable ITmfTrace trace) {
        return trace != null ? Collections.singleton(trace) : Collections.emptyList();
    }

    private class CriticalPathEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private CriticalPathEntryComparator() {
        }

        @Override
        public int compare(@Nullable ITimeGraphEntry o1, @Nullable ITimeGraphEntry o2) {
            if (o1 instanceof TimeGraphEntry && o2 instanceof TimeGraphEntry) {
                ITimeGraphEntryModel model1 = ((TimeGraphEntry)o1).getModel();
                ITimeGraphEntryModel model2 = ((TimeGraphEntry)o2).getModel();
                if (model1 instanceof CriticalPathEntry && model2 instanceof CriticalPathEntry) {
                    return Long.compare(((CriticalPathEntry)model2).getSum(), ((CriticalPathEntry)model1).getSum());
                }
            }
            return 0;
        }
    }

    private class CriticalPathTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private CriticalPathTreeLabelProvider() {
        }

        public String getColumnText(@Nullable Object element, int columnIndex) {
            if (!(element instanceof TimeGraphEntry)) {
                return "";
            }
            TimeGraphEntry entry = (TimeGraphEntry)element;
            ITimeGraphEntryModel model = entry.getModel();
            if (columnIndex == 0) {
                return entry.getName();
            }
            if (columnIndex == 1 && model instanceof CriticalPathEntry) {
                return String.format("%.9f", (double)((CriticalPathEntry)model).getSum().longValue() * 1.0E-8);
            }
            if (columnIndex == 2 && model instanceof CriticalPathEntry) {
                double percent = ((CriticalPathEntry)model).getPercent();
                return String.format("%.2f", percent * 100.0);
            }
            return "";
        }
    }
}

