/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.editors.ITmfEventsEditorConstants;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOnDemandAnalysesElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfReportsElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTracesFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfViewsElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public abstract class TmfCommonProjectElement
extends TmfProjectModelElement {
    private static final String BOOKMARKS_HIDDEN_FILE = ".bookmarks";
    private TmfViewsElement fViewsElement = null;
    private TmfOnDemandAnalysesElement fOnDemandAnalysesElement = null;
    private TmfReportsElement fReportsElement = null;
    private String fTraceTypeId = null;

    public TmfCommonProjectElement(String name, IResource resource, TmfProjectModelElement parent) {
        super(name, resource, parent);
        this.refreshTraceType();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void refreshChildren() {
        IPath tracePath = this.getResource().getFullPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (this.getParent() instanceof TmfExperimentElement) {
            return;
        }
        if (TmfTraceType.getTraceType((String)this.getTraceType()) == null) {
            if (this.fViewsElement != null) {
                this.removeChild(this.fViewsElement);
                this.fViewsElement.dispose();
                this.fViewsElement = null;
            }
            if (this.fOnDemandAnalysesElement != null) {
                this.removeChild(this.fOnDemandAnalysesElement);
                this.fOnDemandAnalysesElement.dispose();
                this.fOnDemandAnalysesElement = null;
            }
            if (this.fReportsElement != null) {
                this.removeChild(this.fReportsElement);
                this.fReportsElement.dispose();
                this.fReportsElement = null;
            }
            return;
        }
        if (this.fViewsElement == null) {
            IFolder viewsNodeRes = root.getFolder(tracePath.append(".views"));
            this.fViewsElement = new TmfViewsElement((IResource)viewsNodeRes, this);
            this.addChild(this.fViewsElement);
        }
        this.fViewsElement.refreshChildren();
        if (this.fOnDemandAnalysesElement == null) {
            IFolder analysesNodeRes = root.getFolder(tracePath.append(".ondemand-analyses"));
            this.fOnDemandAnalysesElement = new TmfOnDemandAnalysesElement((IResource)analysesNodeRes, this);
            this.addChild(this.fOnDemandAnalysesElement);
        }
        this.fOnDemandAnalysesElement.refreshChildren();
        if (this.fReportsElement == null) {
            IFolder reportsNodeRes = root.getFolder(tracePath.append(".reports"));
            this.fReportsElement = new TmfReportsElement((IResource)reportsNodeRes, this);
            this.addChild(this.fReportsElement);
        }
        this.fReportsElement.refreshChildren();
    }

    @Override
    public Image getIcon() {
        Image image;
        Bundle bundle;
        String name;
        String iconAttr;
        String traceType = this.getTraceType();
        if (traceType == null || TmfTraceType.getTraceType((String)traceType) == null) {
            Image icon = TmfProjectModelIcons.WORKSPACE_LABEL_PROVIDER.getImage((Object)this.getResource());
            return icon == null ? TmfProjectModelIcons.DEFAULT_TRACE_ICON : icon;
        }
        IConfigurationElement traceUIAttributes = TmfTraceTypeUIUtils.getTraceUIAttributes(traceType, this instanceof TmfTraceElement ? TmfTraceType.TraceElementType.TRACE : TmfTraceType.TraceElementType.EXPERIMENT);
        if (traceUIAttributes != null && (iconAttr = traceUIAttributes.getAttribute("icon")) != null && (name = traceUIAttributes.getContributor().getName()) != null && (bundle = Platform.getBundle((String)name)) != null && (image = TmfProjectModelIcons.loadIcon(bundle, iconAttr)) != null) {
            return image;
        }
        return null;
    }

    protected TmfViewsElement getChildElementViews() {
        return this.fViewsElement;
    }

    public TmfReportsElement getChildElementReports() {
        return this.fReportsElement;
    }

    public String getTraceType() {
        return this.fTraceTypeId;
    }

    public void refreshTraceType() {
        try {
            this.fTraceTypeId = TmfTraceType.getTraceTypeId((IResource)this.getResource());
        }
        catch (CoreException e) {
            Activator.getDefault().logError(NLS.bind((String)Messages.TmfCommonProjectElement_ErrorRefreshingProperty, (Object)this.getName()), e);
        }
    }

    public abstract ITmfTrace instantiateTrace();

    protected String getSupplementaryFolderPath() {
        return String.valueOf(this.getElementPath()) + this.getSuffix();
    }

    public @NonNull String getElementPath() {
        ITmfProjectModelElement parent = this.getParent();
        while (!(parent instanceof TmfTracesFolder || parent instanceof TmfExperimentElement || parent instanceof TmfExperimentFolder)) {
            parent = parent.getParent();
        }
        IPath path = this.getResource().getFullPath().makeRelativeTo(parent.getPath());
        return (String)NonNullUtils.checkNotNull((Object)path.toString());
    }

    public @NonNull String getDestinationPathRelativeToParent(IPath destinationPath) {
        ITmfProjectModelElement parent = this.getParent();
        while (!(parent instanceof TmfTracesFolder || parent instanceof TmfExperimentElement || parent instanceof TmfExperimentFolder)) {
            parent = parent.getParent();
        }
        IPath path = destinationPath.makeRelativeTo(parent.getPath());
        return (String)NonNullUtils.checkNotNull((Object)path.toString());
    }

    protected String getSuffix() {
        return "";
    }

    public List<TmfTraceElement> getTraces() {
        return new ArrayList<TmfTraceElement>();
    }

    public ITmfTrace getTrace() {
        for (ITmfTrace trace : TmfTraceManager.getInstance().getOpenedTraces()) {
            for (ITmfTrace t : TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)trace)) {
                if (!this.getResource().equals((Object)t.getResource())) continue;
                return t;
            }
        }
        return null;
    }

    public IFile createBookmarksFile(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        IFile file = this.getBookmarksFile();
        if (this.getResource() instanceof IFolder) {
            TmfTraceFolder tracesFolder = this.getProject().getTracesFolder();
            if (tracesFolder == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.TmfProject_TracesFolderNotExists));
            }
            return this.createBookmarksFile(tracesFolder.getResource(), "editorInputType.trace", (IProgressMonitor)subMonitor);
        }
        return file;
    }

    @Deprecated
    public IFile createBookmarksFile() throws CoreException {
        return this.createBookmarksFile((IProgressMonitor)new NullProgressMonitor());
    }

    protected IFile createBookmarksFile(IFolder bookmarksFolder, String editorInputType, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IFile file = this.getBookmarksFile();
        if (!file.exists()) {
            IFile bookmarksFile = bookmarksFolder.getFile(BOOKMARKS_HIDDEN_FILE);
            if (!bookmarksFile.exists()) {
                ByteArrayInputStream source = new ByteArrayInputStream(new byte[0]);
                bookmarksFile.create((InputStream)source, 4097, (IProgressMonitor)subMonitor.split(1));
            }
            file.createLink(bookmarksFile.getLocation(), 4352, (IProgressMonitor)subMonitor.split(1));
            file.setPersistentProperty(TmfCommonConstants.TRACETYPE, editorInputType);
        }
        return file;
    }

    @Deprecated
    protected IFile createBookmarksFile(IFolder bookmarksFolder, String editorInputType) throws CoreException {
        return this.createBookmarksFile(bookmarksFolder, editorInputType, (IProgressMonitor)new NullProgressMonitor());
    }

    public abstract String getEditorId();

    public IFile getBookmarksFile() {
        IFolder folder = (IFolder)this.getResource();
        IFile file = folder.getFile(String.valueOf(this.getName()) + '_');
        return file;
    }

    public void closeEditors() {
        IFile file = this.getBookmarksFile();
        FileEditorInput input = new FileEditorInput(file);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = wb.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage wbPage = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = wbPage.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    try {
                        if (editorReference.getEditorInput().equals(input)) {
                            wbPage.closeEditor(editorReference.getEditor(false), false);
                        }
                    }
                    catch (PartInitException e) {
                        Activator.getDefault().logError(NLS.bind((String)Messages.TmfCommonProjectElement_ErrorClosingEditor, (Object)this.getName()), e);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public abstract String getTypeName();

    public IResource copy(String newName, boolean copySuppFiles) {
        return this.copy(newName, copySuppFiles, true);
    }

    public IResource copy(String newName, boolean copySuppFiles, boolean copyAsLink) {
        IPath newPath = this.getParent().getResource().getFullPath().addTrailingSeparator().append(newName);
        return this.copy(copySuppFiles, copyAsLink, newPath);
    }

    public IResource copy(boolean copySuppFiles, boolean copyAsLink, IPath destinationPath) {
        if (copySuppFiles) {
            String newElementPath = this.getDestinationPathRelativeToParent(destinationPath);
            this.copySupplementaryFolder(newElementPath);
        }
        try {
            int flags = 1;
            if (copyAsLink) {
                flags |= 0x20;
            }
            this.getResource().copy(destinationPath, flags, null);
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource trace = workspaceRoot.findMember(destinationPath);
            if (trace instanceof IFolder) {
                IFolder folderTrace = (IFolder)trace;
                IResource[] iResourceArray = folderTrace.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    String traceTypeId = TmfTraceType.getTraceTypeId((IResource)member);
                    if (ITmfEventsEditorConstants.TRACE_INPUT_TYPE_CONSTANTS.contains((Object)traceTypeId) || ITmfEventsEditorConstants.EXPERIMENT_INPUT_TYPE_CONSTANTS.contains((Object)traceTypeId)) {
                        member.delete(true, null);
                    }
                    ++n2;
                }
            }
            return trace;
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error copying " + this.getName(), e);
            return null;
        }
    }

    public List<@NonNull TmfAnalysisElement> getAvailableAnalysis() {
        TmfViewsElement viewsElement = this.getChildElementViews();
        if (viewsElement != null) {
            return viewsElement.getChildren().stream().map(elem -> (TmfAnalysisElement)elem).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    public List<TmfAnalysisElement> getAvailableChildrenAnalyses() {
        return Collections.EMPTY_LIST;
    }

    public void deleteSupplementaryFolder() {
        IFolder supplFolder = this.getTraceSupplementaryFolder(this.getSupplementaryFolderPath());
        try {
            TmfCommonProjectElement.deleteFolder(supplFolder);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error deleting supplementary folder " + supplFolder, e);
        }
    }

    private static void deleteFolder(IFolder folder) throws CoreException {
        IContainer parent;
        if (folder.exists()) {
            folder.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        if ((parent = folder.getParent()) instanceof IFolder && (!parent.exists() || parent.members().length == 0)) {
            TmfCommonProjectElement.deleteFolder((IFolder)parent);
        }
    }

    public void renameSupplementaryFolder(String newElementPath) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.getSupplementaryFolderPath());
        try {
            if (oldSupplFolder.exists()) {
                IFolder newSupplFolder = this.prepareTraceSupplementaryFolder(String.valueOf(newElementPath) + this.getSuffix(), false);
                oldSupplFolder.move(newSupplFolder.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            TmfCommonProjectElement.deleteFolder(oldSupplFolder);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error renaming supplementary folder " + oldSupplFolder, e);
        }
    }

    public void copySupplementaryFolder(String newElementPath) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.getSupplementaryFolderPath());
        if (oldSupplFolder.exists()) {
            try {
                IFolder newSupplFolder = this.prepareTraceSupplementaryFolder(String.valueOf(newElementPath) + this.getSuffix(), false);
                oldSupplFolder.copy(newSupplFolder.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error renaming supplementary folder " + oldSupplFolder, e);
            }
        }
    }

    public void copySupplementaryFolder(IFolder destination) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.getSupplementaryFolderPath());
        if (oldSupplFolder.exists()) {
            try {
                TraceUtils.createFolder((IFolder)destination.getParent(), (IProgressMonitor)new NullProgressMonitor());
                oldSupplFolder.copy(destination.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error copying supplementary folder " + oldSupplFolder, e);
            }
        }
    }

    public void refreshSupplementaryFolder(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IFolder supplFolder = this.createSupplementaryFolder((IProgressMonitor)subMonitor.split(1));
        try {
            supplFolder.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error refreshing supplementary folder " + supplFolder, e);
        }
    }

    public void refreshSupplementaryFolder() {
        this.refreshSupplementaryFolder((IProgressMonitor)new NullProgressMonitor());
    }

    public boolean hasSupplementaryResources() {
        IResource[] resources = this.getSupplementaryResources();
        return resources.length > 0;
    }

    public IResource[] getSupplementaryResources() {
        IFolder supplFolder = this.getTraceSupplementaryFolder(this.getSupplementaryFolderPath());
        if (supplFolder.exists()) {
            try {
                return supplFolder.members();
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting supplementary folder " + supplFolder, e);
            }
        }
        return new IResource[0];
    }

    public void deleteSupplementaryResources(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            try {
                resources[i].delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting supplementary resource " + resources[i], e);
            }
            ++i;
        }
    }

    public void deleteSupplementaryResources() {
        this.deleteSupplementaryResources(this.getSupplementaryResources());
    }

    public IFolder prepareSupplementaryFolder(IProgressMonitor monitor) {
        return this.prepareTraceSupplementaryFolder(this.getSupplementaryFolderPath(), true, monitor);
    }

    private IFolder createSupplementaryFolder(IProgressMonitor monitor) {
        IFolder supplFolder = this.prepareTraceSupplementaryFolder(this.getSupplementaryFolderPath(), true, monitor);
        try {
            this.getResource().setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, supplFolder.getLocation().toOSString());
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error setting persistant property " + TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, e);
        }
        return supplFolder;
    }

    @Deprecated
    public void traceOpened(TmfTraceOpenedSignal signal) {
    }
}

